/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.extclassgenerator;

import ch.rasc.extclassgenerator.ModelValidation;
import ch.rasc.extclassgenerator.ModelValidationParameter;

public enum ModelValidationType {
    GENERIC(false){

        @Override
        public boolean isValid(ModelValidation modelValidationAnnotation) {
            return ModelValidationType.parameterExists(modelValidationAnnotation.parameters(), "type");
        }
    }
    ,
    CREDITCARDNUMBER(false){

        @Override
        public boolean isValid(ModelValidation modelValidationAnnotation) {
            return true;
        }
    }
    ,
    DIGITS(false){

        @Override
        public boolean isValid(ModelValidation modelValidationAnnotation) {
            ModelValidationParameter[] parameters = modelValidationAnnotation.parameters();
            return parameters != null && parameters.length == 2 && ModelValidationType.parameterExists(parameters, "integer") && ModelValidationType.parameterExists(parameters, "fraction") && parameters[0].value().matches("\\d+") && parameters[1].value().matches("\\d+");
        }
    }
    ,
    EMAIL(true){

        @Override
        public boolean isValid(ModelValidation modelValidationAnnotation) {
            return true;
        }
    }
    ,
    FORMAT(true){

        @Override
        public boolean isValid(ModelValidation modelValidationAnnotation) {
            ModelValidationParameter[] parameters = modelValidationAnnotation.parameters();
            return parameters != null && parameters.length == 1 && parameters[0].name().equals("matcher") && !parameters[0].value().trim().isEmpty();
        }
    }
    ,
    FUTURE(false){

        @Override
        public boolean isValid(ModelValidation modelValidationAnnotation) {
            return true;
        }
    }
    ,
    INCLUSION(true){

        @Override
        public boolean isValid(ModelValidation modelValidationAnnotation) {
            if (modelValidationAnnotation.exclusionOrInclusionList().length > 0) {
                return true;
            }
            ModelValidationParameter[] parameters = modelValidationAnnotation.parameters();
            return parameters != null && parameters.length == 1 && parameters[0].name().equals("list");
        }
    }
    ,
    EXCLUSION(true){

        @Override
        public boolean isValid(ModelValidation modelValidationAnnotation) {
            if (modelValidationAnnotation.exclusionOrInclusionList().length > 0) {
                return true;
            }
            ModelValidationParameter[] parameters = modelValidationAnnotation.parameters();
            return parameters != null && parameters.length == 1 && parameters[0].name().equals("list");
        }
    }
    ,
    LENGTH(true){

        @Override
        public boolean isValid(ModelValidation modelValidationAnnotation) {
            ModelValidationParameter[] parameters = modelValidationAnnotation.parameters();
            if (parameters != null && (parameters.length == 1 || parameters.length == 2) && (ModelValidationType.parameterExists(parameters, "min") || ModelValidationType.parameterExists(parameters, "max"))) {
                if (parameters.length == 1) {
                    return parameters[0].value().matches("\\d+");
                }
                return parameters[0].value().matches("\\d+") && parameters[1].value().matches("\\d+");
            }
            return false;
        }
    }
    ,
    NOTBLANK(false){

        @Override
        public boolean isValid(ModelValidation modelValidationAnnotation) {
            return true;
        }
    }
    ,
    PAST(false){

        @Override
        public boolean isValid(ModelValidation modelValidationAnnotation) {
            return true;
        }
    }
    ,
    PRESENCE(true){

        @Override
        public boolean isValid(ModelValidation modelValidationAnnotation) {
            return true;
        }
    }
    ,
    RANGE(false){

        @Override
        public boolean isValid(ModelValidation modelValidationAnnotation) {
            ModelValidationParameter[] parameters = modelValidationAnnotation.parameters();
            if (parameters != null && (parameters.length == 1 || parameters.length == 2) && (ModelValidationType.parameterExists(parameters, "min") || ModelValidationType.parameterExists(parameters, "max"))) {
                if (parameters.length == 1) {
                    return parameters[0].value().matches("\\d+(\\.\\d+)?");
                }
                return parameters[0].value().matches("\\d+(\\.\\d+)?") && parameters[1].value().matches("\\d+(\\.\\d+)?");
            }
            return false;
        }
    };

    private boolean builtin;

    private ModelValidationType(boolean builtin) {
        this.builtin = builtin;
    }

    public boolean isBuiltin() {
        return this.builtin;
    }

    public abstract boolean isValid(ModelValidation var1);

    private static boolean parameterExists(ModelValidationParameter[] parameters, String parameterName) {
        for (ModelValidationParameter parameter : parameters) {
            if (!parameterName.equals(parameter.name())) continue;
            return true;
        }
        return false;
    }
}

