/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.embeddedtc;

import ch.rasc.embeddedtc.ListContextsServlet;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.LogManager;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Server;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.WebResourceSet;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.AprLifecycleListener;
import org.apache.catalina.core.JreMemoryLeakPreventionListener;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.core.ThreadLocalLeakPreventionListener;
import org.apache.catalina.mbeans.GlobalResourcesLifecycleListener;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.startup.CatalinaProperties;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.webresources.DirResourceSet;
import org.apache.catalina.webresources.StandardRoot;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.descriptor.web.ApplicationParameter;
import org.apache.tomcat.util.descriptor.web.ContextEnvironment;
import org.apache.tomcat.util.descriptor.web.ContextResource;

public class EmbeddedTomcat {
    private static final Log log = LogFactory.getLog(EmbeddedTomcat.class);
    private String contextPath;
    private Integer httpPort;
    private Integer shutdownPort;
    private int secondsToWaitBeforePortBecomesAvailable;
    public int maxPostSize = 0x200000;
    private int httpsPort;
    private String keyStoreFile;
    private String keyAlias;
    private String keyStorePass;
    private String sslProtocol;
    private String tempDirectory;
    private String contextDirectory;
    private String skipJarsDefaultJarScanner;
    private String skipJarsContextConfig;
    private String skipJarsTldConfig;
    private boolean privileged;
    private boolean silent;
    private boolean addDefaultListeners = false;
    private boolean useNio2 = false;
    private int compressionMinSize = -1;
    private String compressableMimeType;
    private boolean enableNaming = false;
    private final List<ContextEnvironment> contextEnvironments;
    private final List<ContextResource> contextResources;
    private final List<ApplicationParameter> contextInitializationParameters;
    private URL contextFileURL;
    private Tomcat tomcat = null;

    public static void main(String[] args) {
        new EmbeddedTomcat().startAndWait();
    }

    public static EmbeddedTomcat create() {
        return new EmbeddedTomcat();
    }

    public EmbeddedTomcat() {
        this("", 8080);
    }

    public EmbeddedTomcat(int port) {
        this("", port);
    }

    public EmbeddedTomcat(String contextPath) {
        this(contextPath, 8080);
    }

    public EmbeddedTomcat(String contextPath, int httpPort) {
        this(contextPath, httpPort, 0);
    }

    public EmbeddedTomcat(String contextPath, int httpPort, int httpsPort) {
        this.setContextPath(contextPath);
        this.setHttpPort(httpPort);
        this.setShutdownPort(httpPort + 1000);
        this.setHttpsPort(httpsPort);
        this.setSecondsToWaitBeforePortBecomesAvailable(10);
        this.setPrivileged(false);
        this.setSilent(false);
        this.setContextDirectory(null);
        this.tempDirectory = null;
        this.contextEnvironments = new ArrayList<ContextEnvironment>();
        this.contextResources = new ArrayList<ContextResource>();
        this.contextInitializationParameters = new ArrayList<ApplicationParameter>();
    }

    @Deprecated
    public EmbeddedTomcat setPort(int port) {
        return this.setHttpPort(port);
    }

    public EmbeddedTomcat setHttpPort(int httpPort) {
        this.httpPort = httpPort;
        return this;
    }

    public EmbeddedTomcat setMaxPostSize(int maxPostSize) {
        this.maxPostSize = maxPostSize;
        return this;
    }

    public EmbeddedTomcat setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
        return this;
    }

    public EmbeddedTomcat setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
        return this;
    }

    public EmbeddedTomcat setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
        return this;
    }

    public EmbeddedTomcat setKeyStorePass(String keyStorePass) {
        this.keyStorePass = keyStorePass;
        return this;
    }

    public EmbeddedTomcat setContextPath(String contextPath) {
        if (contextPath == null || !contextPath.equals("") && !contextPath.startsWith("/")) {
            throw new IllegalArgumentException("contextPath must be the empty string \"\" or a path starting with /");
        }
        this.contextPath = contextPath;
        return this;
    }

    public EmbeddedTomcat setContextDirectory(String contextDirectory) {
        this.contextDirectory = contextDirectory;
        return this;
    }

    public EmbeddedTomcat skipJarsDefaultJarScanner(String skipJars) {
        this.skipJarsDefaultJarScanner = skipJars;
        return this;
    }

    public EmbeddedTomcat skipJarsContextConfig(String skipJars) {
        this.skipJarsContextConfig = skipJars;
        return this;
    }

    public EmbeddedTomcat skipJarsTldConfig(String skipJars) {
        this.skipJarsTldConfig = skipJars;
        return this;
    }

    public EmbeddedTomcat setTempDirectory(File tempDirectory) {
        this.tempDirectory = tempDirectory.getAbsolutePath();
        return this;
    }

    public EmbeddedTomcat setTempDirectoryName(String name) {
        this.tempDirectory = new File(".", "target/" + name).getAbsolutePath();
        return this;
    }

    public EmbeddedTomcat dontAddShutdownHook() {
        this.shutdownPort = null;
        return this;
    }

    public EmbeddedTomcat setSecondsToWaitBeforePortBecomesAvailable(int seconds) {
        this.secondsToWaitBeforePortBecomesAvailable = seconds;
        return this;
    }

    public EmbeddedTomcat setShutdownPort(int shutdownPort) {
        this.shutdownPort = shutdownPort;
        return this;
    }

    public EmbeddedTomcat setPrivileged(boolean privileged) {
        this.privileged = privileged;
        return this;
    }

    public EmbeddedTomcat useNio2() {
        this.useNio2 = true;
        return this;
    }

    public EmbeddedTomcat enableCompression(int compressionMinSize, String compressableMimeType) {
        this.compressionMinSize = compressionMinSize;
        this.compressableMimeType = compressableMimeType;
        return this;
    }

    public EmbeddedTomcat enableNaming() {
        this.enableNaming = true;
        return this;
    }

    public EmbeddedTomcat addDefaultListeners() {
        this.addDefaultListeners = true;
        return this;
    }

    public EmbeddedTomcat setSilent(boolean silent) {
        this.silent = silent;
        return this;
    }

    public EmbeddedTomcat addContextEnvironment(ContextEnvironment env) {
        this.contextEnvironments.add(env);
        return this;
    }

    public EmbeddedTomcat addContextResource(ContextResource res) {
        this.contextResources.add(res);
        return this;
    }

    public EmbeddedTomcat addContextInitializationParameter(String name, String value) {
        ApplicationParameter parameter = new ApplicationParameter();
        parameter.setName(name);
        parameter.setValue(value);
        this.contextInitializationParameters.add(parameter);
        return this;
    }

    public EmbeddedTomcat addContextEnvironment(String name, String value, String type) {
        ContextEnvironment env = new ContextEnvironment();
        env.setType(type);
        env.setName(name);
        env.setValue(value);
        this.addContextEnvironment(env);
        return this;
    }

    public EmbeddedTomcat addContextEnvironmentString(String name, String value) {
        this.addContextEnvironment(name, value, "java.lang.String");
        return this;
    }

    public EmbeddedTomcat setContextFile(URL contextFileURL) {
        this.contextFileURL = contextFileURL;
        return this;
    }

    public EmbeddedTomcat setContextFile(String contextFile) {
        try {
            this.contextFileURL = new File(contextFile).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public void start() {
        this.start(false);
    }

    public void startAndWait() {
        this.start(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(boolean await) {
        Context ctx;
        String contextDir;
        this.sendShutdownCommand();
        try {
            ServerSocket srv = new ServerSocket(this.httpPort);
            Throwable throwable = null;
            if (srv != null) {
                if (throwable != null) {
                    try {
                        srv.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                } else {
                    srv.close();
                }
            }
        }
        catch (IOException e) {
            log.error((Object)("PORT " + this.httpPort + " ALREADY IN USE"));
            return;
        }
        CatalinaProperties.getProperty((String)"dummy");
        EmbeddedTomcat.appendSkipJars("tomcat.util.scan.DefaultJarScanner.jarsToSkip", this.skipJarsDefaultJarScanner);
        EmbeddedTomcat.appendSkipJars("org.apache.catalina.startup.ContextConfig.jarsToSkip", this.skipJarsContextConfig);
        EmbeddedTomcat.appendSkipJars("org.apache.catalina.startup.TldConfig.jarsToSkip", this.skipJarsTldConfig);
        this.tomcat = new Tomcat();
        if (this.tempDirectory == null) {
            this.tempDirectory = new File(".", "/target/tomcat." + this.httpPort).getAbsolutePath();
        }
        this.tomcat.setBaseDir(this.tempDirectory);
        if (this.silent) {
            this.tomcat.setSilent(true);
        }
        if (this.addDefaultListeners) {
            this.tomcat.getServer().addLifecycleListener((LifecycleListener)new AprLifecycleListener());
        }
        if (this.useNio2) {
            Connector connector = new Connector("org.apache.coyote.http11.Http11Nio2Protocol");
            connector.setPort(this.httpPort.intValue());
            connector.setURIEncoding("UTF-8");
            connector.setMaxPostSize(this.maxPostSize);
            this.tomcat.setConnector(connector);
            this.tomcat.getService().addConnector(connector);
        } else {
            this.tomcat.setPort(this.httpPort.intValue());
            this.tomcat.getConnector().setURIEncoding("UTF-8");
            this.tomcat.getConnector().setMaxPostSize(this.maxPostSize);
        }
        if (this.compressionMinSize >= 0) {
            this.tomcat.getConnector().setProperty("compression", String.valueOf(this.compressionMinSize));
            this.tomcat.getConnector().setProperty("compressableMimeType", this.compressableMimeType);
        }
        if (this.httpsPort != 0) {
            Connector httpsConnector = this.useNio2 ? new Connector("org.apache.coyote.http11.Http11Nio2Protocol") : new Connector("HTTP/1.1");
            httpsConnector.setSecure(true);
            httpsConnector.setPort(this.httpsPort);
            httpsConnector.setMaxPostSize(this.maxPostSize);
            httpsConnector.setScheme("https");
            httpsConnector.setURIEncoding("UTF-8");
            httpsConnector.setProperty("SSLEnabled", "true");
            httpsConnector.setProperty("keyAlias", this.keyAlias);
            httpsConnector.setProperty("keystoreFile", this.keyStoreFile);
            httpsConnector.setProperty("keystorePass", this.keyStorePass);
            httpsConnector.setProperty("sslProtocol", this.sslProtocol);
            if (this.compressionMinSize >= 0) {
                httpsConnector.setProperty("compression", String.valueOf(this.compressionMinSize));
                httpsConnector.setProperty("compressableMimeType", this.compressableMimeType);
            }
            this.tomcat.getEngine().setDefaultHost("localhost");
            this.tomcat.getService().addConnector(httpsConnector);
        }
        if (this.shutdownPort != null) {
            this.tomcat.getServer().setPort(this.shutdownPort.intValue());
        }
        if ((contextDir = this.contextDirectory) == null) {
            contextDir = new File(".").getAbsolutePath() + "/src/main/webapp";
        }
        try {
            if (!this.contextPath.equals("")) {
                File rootCtxDir = new File("./target/tcroot");
                if (!rootCtxDir.exists()) {
                    rootCtxDir.mkdirs();
                }
                Context rootCtx = this.tomcat.addWebapp("", rootCtxDir.getAbsolutePath());
                rootCtx.setPrivileged(true);
                Tomcat.addServlet((Context)rootCtx, (String)"listContexts", (Servlet)new ListContextsServlet(rootCtx)).addMapping("/");
            }
            ctx = this.tomcat.addWebapp(this.contextPath, contextDir);
            StandardRoot resourceRoot = new StandardRoot(ctx);
            DirResourceSet dirResource = new DirResourceSet((WebResourceRoot)resourceRoot, "/WEB-INF/classes", "./target/classes", "/");
            resourceRoot.addPreResources((WebResourceSet)dirResource);
            ctx.setResources((WebResourceRoot)resourceRoot);
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        if (this.privileged) {
            ctx.setPrivileged(true);
        }
        if (this.enableNaming || !this.contextEnvironments.isEmpty() || !this.contextResources.isEmpty() || this.contextFileURL != null) {
            this.tomcat.enableNaming();
            if (this.addDefaultListeners) {
                this.tomcat.getServer().addLifecycleListener((LifecycleListener)new GlobalResourcesLifecycleListener());
            }
        }
        if (this.addDefaultListeners) {
            Server server = this.tomcat.getServer();
            server.addLifecycleListener((LifecycleListener)new JreMemoryLeakPreventionListener());
            server.addLifecycleListener((LifecycleListener)new ThreadLocalLeakPreventionListener());
        }
        for (ContextEnvironment env : this.contextEnvironments) {
            ctx.getNamingResources().addEnvironment(env);
        }
        for (ContextResource res : this.contextResources) {
            ctx.getNamingResources().addResource(res);
        }
        for (ApplicationParameter param : this.contextInitializationParameters) {
            ctx.addApplicationParameter(param);
        }
        if (this.contextFileURL != null) {
            ctx.setConfigFile(this.contextFileURL);
        }
        ctx.addLifecycleListener(new LifecycleListener(){

            public void lifecycleEvent(LifecycleEvent event) {
                if (event.getLifecycle().getState() == LifecycleState.FAILED) {
                    ((StandardServer)EmbeddedTomcat.this.tomcat.getServer()).stopAwait();
                }
            }
        });
        try {
            this.tomcat.start();
        }
        catch (LifecycleException e) {
            throw new RuntimeException(e);
        }
        ((StandardManager)ctx.getManager()).setPathname(null);
        EmbeddedTomcat.installSlf4jBridge();
        if (await) {
            this.tomcat.getServer().await();
            this.stop();
        }
    }

    public void stop() {
        if (this.tomcat != null) {
            try {
                this.tomcat.stop();
            }
            catch (LifecycleException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void appendSkipJars(String systemPropertyKey, String skipJars) {
        if (skipJars != null && !skipJars.trim().isEmpty()) {
            String oldValue = System.getProperty(systemPropertyKey);
            String newValue = oldValue != null && !oldValue.trim().isEmpty() ? oldValue + "," + skipJars : skipJars;
            System.setProperty(systemPropertyKey, newValue);
        }
    }

    private void sendShutdownCommand() {
        if (this.shutdownPort != null) {
            try (Socket socket = new Socket("localhost", (int)this.shutdownPort);
                 OutputStream stream = socket.getOutputStream();){
                for (int i = 0; i < "SHUTDOWN".length(); ++i) {
                    stream.write("SHUTDOWN".charAt(i));
                }
                stream.flush();
            }
            catch (UnknownHostException e) {
                if (!this.silent) {
                    log.debug((Object)e);
                }
                return;
            }
            catch (IOException e) {
                if (!this.silent) {
                    log.debug((Object)e);
                }
                return;
            }
            for (int count = 0; count < this.secondsToWaitBeforePortBecomesAvailable * 2; ++count) {
                try {
                    ServerSocket srv = new ServerSocket(this.httpPort);
                    Throwable throwable = null;
                    if (srv != null) {
                        if (throwable != null) {
                            try {
                                srv.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            srv.close();
                        }
                    }
                    return;
                }
                catch (IOException e) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(500L);
                        continue;
                    }
                    catch (InterruptedException e2) {
                        return;
                    }
                }
            }
        }
    }

    private static void installSlf4jBridge() {
        try {
            Class<?> clazz = Class.forName("org.slf4j.bridge.SLF4JBridgeHandler");
            LogManager.getLogManager().reset();
            Method method = clazz.getMethod("install", new Class[0]);
            method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

