/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.embeddedtc;

import ch.rasc.embeddedtc.ContextConfig;
import ch.rasc.embeddedtc.TargetClassesContext;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.LogManager;
import javax.naming.directory.DirContext;
import javax.servlet.ServletException;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.AprLifecycleListener;
import org.apache.catalina.core.JasperListener;
import org.apache.catalina.core.JreMemoryLeakPreventionListener;
import org.apache.catalina.core.ThreadLocalLeakPreventionListener;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.mbeans.GlobalResourcesLifecycleListener;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.startup.CatalinaProperties;
import org.apache.catalina.startup.Tomcat;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.xml.sax.SAXException;

public class EmbeddedTomcat {
    private static final Log log = LogFactory.getLog(EmbeddedTomcat.class);
    private static final String SHUTDOWN_COMMAND = "EMBEDDED_TC_SHUTDOWN";
    private String contextPath;
    private Integer port;
    private Integer shutdownPort;
    private int secondsToWaitBeforePortBecomesAvailable;
    private String tempDirectory;
    private String contextDirectory;
    private String skipJarsDefaultJarScanner;
    private String skipJarsContextConfig;
    private String skipJarsTldConfig;
    private boolean removeDefaultServlet;
    private boolean privileged;
    private boolean silent;
    private boolean addDefaultListeners = false;
    private boolean useNio = false;
    private boolean enableNaming = false;
    private final List<ContextEnvironment> contextEnvironments;
    private final List<ContextResource> contextResources;
    private Tomcat tomcat = null;

    public static void main(String[] args) {
        new EmbeddedTomcat().startAndWait();
    }

    public static EmbeddedTomcat create() {
        return new EmbeddedTomcat();
    }

    public EmbeddedTomcat() {
        this("/", 8080);
    }

    public EmbeddedTomcat(int port) {
        this("/", port);
    }

    public EmbeddedTomcat(String contextPath) {
        this(contextPath, 8080);
    }

    public EmbeddedTomcat(String contextPath, int port) {
        this.setContextPath(contextPath);
        this.setPort(port);
        this.setShutdownPort(port + 1000);
        this.setSecondsToWaitBeforePortBecomesAvailable(10);
        this.setPrivileged(false);
        this.setSilent(false);
        this.setContextDirectory(null);
        this.tempDirectory = null;
        this.contextEnvironments = new ArrayList<ContextEnvironment>();
        this.contextResources = new ArrayList<ContextResource>();
        this.removeDefaultServlet = false;
    }

    public EmbeddedTomcat setPort(int port) {
        this.port = port;
        return this;
    }

    public EmbeddedTomcat setContextPath(String contextPath) {
        if (contextPath != null && !contextPath.startsWith("/")) {
            throw new IllegalArgumentException("contextPath does not start with /");
        }
        this.contextPath = contextPath;
        return this;
    }

    public EmbeddedTomcat setContextDirectory(String contextDirectory) {
        this.contextDirectory = contextDirectory;
        return this;
    }

    public EmbeddedTomcat skipJarsDefaultJarScanner(String skipJars) {
        this.skipJarsDefaultJarScanner = skipJars;
        return this;
    }

    public EmbeddedTomcat skipJarsContextConfig(String skipJars) {
        this.skipJarsContextConfig = skipJars;
        return this;
    }

    public EmbeddedTomcat skipJarsTldConfig(String skipJars) {
        this.skipJarsTldConfig = skipJars;
        return this;
    }

    public EmbeddedTomcat setTempDirectory(File tempDirectory) {
        this.tempDirectory = tempDirectory.getAbsolutePath();
        return this;
    }

    public EmbeddedTomcat setTempDirectoryName(String name) {
        this.tempDirectory = new File(".", "target/" + name).getAbsolutePath();
        return this;
    }

    public EmbeddedTomcat removeDefaultServlet() {
        this.removeDefaultServlet = true;
        return this;
    }

    public EmbeddedTomcat dontAddShutdownHook() {
        this.shutdownPort = null;
        return this;
    }

    public EmbeddedTomcat setSecondsToWaitBeforePortBecomesAvailable(int seconds) {
        this.secondsToWaitBeforePortBecomesAvailable = seconds;
        return this;
    }

    public EmbeddedTomcat setShutdownPort(int shutdownPort) {
        this.shutdownPort = shutdownPort;
        return this;
    }

    public EmbeddedTomcat setPrivileged(boolean privileged) {
        this.privileged = privileged;
        return this;
    }

    public EmbeddedTomcat useNio() {
        this.useNio = true;
        return this;
    }

    public EmbeddedTomcat enableNaming() {
        this.enableNaming = true;
        return this;
    }

    public EmbeddedTomcat addDefaultListeners() {
        this.addDefaultListeners = true;
        return this;
    }

    public EmbeddedTomcat setSilent(boolean silent) {
        this.silent = silent;
        return this;
    }

    public EmbeddedTomcat addContextEnvironment(ContextEnvironment env) {
        this.contextEnvironments.add(env);
        return this;
    }

    public EmbeddedTomcat addContextResource(ContextResource res) {
        this.contextResources.add(res);
        return this;
    }

    public EmbeddedTomcat addContextEnvironment(String name, String value, String type) {
        ContextEnvironment env = new ContextEnvironment();
        env.setType(type);
        env.setName(name);
        env.setValue(value);
        this.addContextEnvironment(env);
        return this;
    }

    public EmbeddedTomcat addContextEnvironmentString(String name, String value) {
        this.addContextEnvironment(name, value, "java.lang.String");
        return this;
    }

    public EmbeddedTomcat addContextEnvironmentAndResourceFromFile(File contextFile) {
        try {
            ContextConfig cc = (ContextConfig)ContextConfig.createDigester().parse(contextFile);
            if (cc != null) {
                this.contextEnvironments.addAll(cc.getEnvironments());
                this.contextResources.addAll(cc.getResources());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public EmbeddedTomcat addContextEnvironmentAndResourceFromFile(String contextFile) {
        this.addContextEnvironmentAndResourceFromFile(new File(contextFile));
        return this;
    }

    public void start() {
        this.start(false);
    }

    public void startAndWait() {
        this.start(true);
    }

    private void start(boolean await) {
        Context ctx;
        String contextDir;
        this.sendShutdownCommand();
        try {
            ServerSocket srv = new ServerSocket(this.port);
            srv.close();
        }
        catch (IOException e) {
            log.error((Object)("PORT " + this.port + " ALREADY IN USE"));
            return;
        }
        CatalinaProperties.getProperty((String)"dummy");
        EmbeddedTomcat.appendSkipJars("tomcat.util.scan.DefaultJarScanner.jarsToSkip", this.skipJarsDefaultJarScanner);
        EmbeddedTomcat.appendSkipJars("org.apache.catalina.startup.ContextConfig.jarsToSkip", this.skipJarsContextConfig);
        EmbeddedTomcat.appendSkipJars("org.apache.catalina.startup.TldConfig.jarsToSkip", this.skipJarsTldConfig);
        this.tomcat = new Tomcat();
        if (this.tempDirectory == null) {
            this.tempDirectory = new File(".", "/target/tomcat." + this.port).getAbsolutePath();
        }
        this.tomcat.setBaseDir(this.tempDirectory);
        if (this.silent) {
            this.tomcat.setSilent(true);
        }
        if (this.addDefaultListeners) {
            this.tomcat.getServer().addLifecycleListener((LifecycleListener)new AprLifecycleListener());
        }
        if (this.useNio) {
            Connector connector = new Connector("org.apache.coyote.http11.Http11NioProtocol");
            connector.setPort(this.port.intValue());
            connector.setURIEncoding("UTF-8");
            this.tomcat.setConnector(connector);
            this.tomcat.getService().addConnector(connector);
        } else {
            this.tomcat.setPort(this.port.intValue());
            this.tomcat.getConnector().setURIEncoding("UTF-8");
        }
        if (this.shutdownPort != null) {
            this.tomcat.getServer().setPort(this.shutdownPort.intValue());
            this.tomcat.getServer().setShutdown(SHUTDOWN_COMMAND);
        }
        if ((contextDir = this.contextDirectory) == null) {
            contextDir = new File(".").getAbsolutePath() + "/src/main/webapp";
        }
        try {
            ctx = this.tomcat.addWebapp(this.contextPath, contextDir);
            ctx.setResources((DirContext)((Object)new TargetClassesContext()));
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        if (this.privileged) {
            ctx.setPrivileged(true);
        }
        if (this.enableNaming || !this.contextEnvironments.isEmpty() || !this.contextResources.isEmpty()) {
            this.tomcat.enableNaming();
            if (this.addDefaultListeners) {
                this.tomcat.getServer().addLifecycleListener((LifecycleListener)new GlobalResourcesLifecycleListener());
            }
        }
        if (this.addDefaultListeners) {
            Server server = this.tomcat.getServer();
            server.addLifecycleListener((LifecycleListener)new JasperListener());
            server.addLifecycleListener((LifecycleListener)new JreMemoryLeakPreventionListener());
            server.addLifecycleListener((LifecycleListener)new ThreadLocalLeakPreventionListener());
        }
        for (ContextEnvironment env : this.contextEnvironments) {
            ctx.getNamingResources().addEnvironment(env);
        }
        for (ContextResource res : this.contextResources) {
            ctx.getNamingResources().addResource(res);
        }
        if (this.removeDefaultServlet) {
            ctx.addLifecycleListener(new LifecycleListener(){

                public void lifecycleEvent(LifecycleEvent event) {
                    if ("before_start".equals(event.getType())) {
                        ctx.removeServletMapping("/");
                    }
                }
            });
        }
        try {
            this.tomcat.start();
        }
        catch (LifecycleException e) {
            throw new RuntimeException(e);
        }
        ((StandardManager)ctx.getManager()).setPathname("");
        EmbeddedTomcat.installSlf4jBridge();
        if (await) {
            this.tomcat.getServer().await();
        }
    }

    public void stop() {
        if (this.tomcat != null) {
            try {
                this.tomcat.stop();
            }
            catch (LifecycleException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void appendSkipJars(String systemPropertyKey, String skipJars) {
        if (skipJars != null && !skipJars.trim().isEmpty()) {
            String oldValue = System.getProperty(systemPropertyKey);
            String newValue = oldValue != null && !oldValue.trim().isEmpty() ? oldValue + "," + skipJars : skipJars;
            System.setProperty(systemPropertyKey, newValue);
        }
    }

    private void sendShutdownCommand() {
        if (this.shutdownPort != null) {
            try {
                Socket socket = new Socket("localhost", (int)this.shutdownPort);
                OutputStream stream = socket.getOutputStream();
                for (int i = 0; i < SHUTDOWN_COMMAND.length(); ++i) {
                    stream.write(SHUTDOWN_COMMAND.charAt(i));
                }
                stream.flush();
                stream.close();
                socket.close();
            }
            catch (UnknownHostException e) {
                if (!this.silent) {
                    log.debug((Object)e);
                }
                return;
            }
            catch (IOException e) {
                if (!this.silent) {
                    log.debug((Object)e);
                }
                return;
            }
            for (int count = 0; count < this.secondsToWaitBeforePortBecomesAvailable * 2; ++count) {
                try {
                    ServerSocket srv = new ServerSocket(this.port);
                    srv.close();
                    return;
                }
                catch (IOException e) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(500L);
                        continue;
                    }
                    catch (InterruptedException e2) {
                        return;
                    }
                }
            }
        }
    }

    private static void installSlf4jBridge() {
        try {
            Class<?> clazz = Class.forName("org.slf4j.bridge.SLF4JBridgeHandler");
            LogManager.getLogManager().reset();
            Method method = clazz.getMethod("install", new Class[0]);
            method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

