/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.embeddedtc.plugin;

import ch.rasc.embeddedtc.runner.Runner;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.util.artifact.DefaultArtifact;

@Mojo(name="package-tcwar", defaultPhase=LifecyclePhase.PACKAGE)
public class PackageTcWarMojo
extends AbstractMojo {
    @Component
    private MavenProject project;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", required=true, readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${plugin.artifacts}", required=true)
    private List<org.apache.maven.artifact.Artifact> pluginArtifacts;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private String buildDirectory;
    @Parameter(defaultValue="${project.artifactId}-${project.version}-embeddedtc.jar", required=true)
    private String finalName;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> projectRepos;
    @Parameter(required=false)
    private String includeTcNativeWin32;
    @Parameter(required=false)
    private String includeTcNativeWin64;
    @Parameter(defaultValue="true", required=true)
    private boolean includeJSPSupport;
    @Parameter
    private List<Dependency> extraDependencies;
    @Parameter
    private List<Dependency> extraWars;
    @Parameter
    private List<Resource> extraResources;

    public void execute() throws MojoExecutionException {
        Path warExecFile = Paths.get(this.buildDirectory, this.finalName);
        try {
            Files.deleteIfExists(warExecFile);
            Files.createDirectories(warExecFile.getParent(), new FileAttribute[0]);
            try (OutputStream os = Files.newOutputStream(warExecFile, new OpenOption[0]);
                 ArchiveOutputStream aos = new ArchiveStreamFactory().createArchiveOutputStream("jar", os);){
                String[] runnerClasses;
                File projectArtifact;
                if ("war".equalsIgnoreCase(this.project.getPackaging()) && (projectArtifact = this.project.getArtifact().getFile()) != null && Files.exists(projectArtifact.toPath(), new LinkOption[0])) {
                    aos.putArchiveEntry((ArchiveEntry)new JarArchiveEntry(projectArtifact.getName()));
                    try (InputStream is = Files.newInputStream(projectArtifact.toPath(), new OpenOption[0]);){
                        IOUtils.copy((InputStream)is, (OutputStream)aos);
                    }
                    aos.closeArchiveEntry();
                }
                if (this.extraWars != null) {
                    for (Dependency extraWarDependency : this.extraWars) {
                        ArtifactResult result;
                        ArtifactRequest request = new ArtifactRequest();
                        request.setArtifact((Artifact)new DefaultArtifact(extraWarDependency.getGroupId(), extraWarDependency.getArtifactId(), extraWarDependency.getType(), extraWarDependency.getVersion()));
                        request.setRepositories(this.projectRepos);
                        try {
                            result = this.repoSystem.resolveArtifact(this.repoSession, request);
                        }
                        catch (ArtifactResolutionException e) {
                            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
                        }
                        File extraWarFile = result.getArtifact().getFile();
                        aos.putArchiveEntry((ArchiveEntry)new JarArchiveEntry(extraWarFile.getName()));
                        try (InputStream is = Files.newInputStream(extraWarFile.toPath(), new OpenOption[0]);){
                            IOUtils.copy((InputStream)is, (OutputStream)aos);
                        }
                        aos.closeArchiveEntry();
                    }
                }
                if (this.extraResources != null) {
                    for (Resource extraResource : this.extraResources) {
                        DirectoryScanner directoryScanner = new DirectoryScanner();
                        directoryScanner.setBasedir(extraResource.getDirectory());
                        directoryScanner.setExcludes(extraResource.getExcludes().toArray(new String[extraResource.getExcludes().size()]));
                        if (!extraResource.getIncludes().isEmpty()) {
                            directoryScanner.setIncludes(extraResource.getIncludes().toArray(new String[extraResource.getIncludes().size()]));
                        } else {
                            directoryScanner.setIncludes(new String[]{"**"});
                        }
                        directoryScanner.scan();
                        for (String includeFile : directoryScanner.getIncludedFiles()) {
                            aos.putArchiveEntry((ArchiveEntry)new JarArchiveEntry("extra/" + includeFile));
                            Path extraFile = Paths.get(extraResource.getDirectory(), includeFile);
                            try (InputStream is = Files.newInputStream(extraFile, new OpenOption[0]);){
                                IOUtils.copy((InputStream)is, (OutputStream)aos);
                            }
                            aos.closeArchiveEntry();
                        }
                    }
                }
                HashSet<String> includeArtifacts = new HashSet<String>();
                includeArtifacts.add("org.apache.tomcat:tomcat-jdbc");
                includeArtifacts.add("org.apache.tomcat.embed:tomcat-embed-core");
                includeArtifacts.add("org.apache.tomcat.embed:tomcat-embed-logging-juli");
                includeArtifacts.add("org.yaml:snakeyaml");
                includeArtifacts.add("com.beust:jcommander");
                if (this.includeJSPSupport) {
                    includeArtifacts.add("org.apache.tomcat.embed:tomcat-embed-jasper");
                    includeArtifacts.add("org.eclipse.jdt.core.compiler:ecj");
                }
                for (org.apache.maven.artifact.Artifact pluginArtifact : this.pluginArtifacts) {
                    String artifactName = pluginArtifact.getGroupId() + ":" + pluginArtifact.getArtifactId();
                    if (!includeArtifacts.contains(artifactName)) continue;
                    JarFile jarFile = new JarFile(pluginArtifact.getFile());
                    Throwable i$ = null;
                    try {
                        PackageTcWarMojo.extractJarToArchive(jarFile, aos);
                    }
                    catch (Throwable x2) {
                        i$ = x2;
                        throw x2;
                    }
                    finally {
                        if (jarFile == null) continue;
                        if (i$ != null) {
                            try {
                                jarFile.close();
                            }
                            catch (Throwable x2) {
                                i$.addSuppressed(x2);
                            }
                            continue;
                        }
                        jarFile.close();
                    }
                }
                if (this.extraDependencies != null) {
                    for (Dependency dependency : this.extraDependencies) {
                        ArtifactResult result;
                        ArtifactRequest request = new ArtifactRequest();
                        request.setArtifact((Artifact)new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getType(), dependency.getVersion()));
                        request.setRepositories(this.projectRepos);
                        try {
                            result = this.repoSystem.resolveArtifact(this.repoSession, request);
                        }
                        catch (ArtifactResolutionException e) {
                            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
                        }
                        JarFile jarFile = new JarFile(result.getArtifact().getFile());
                        Throwable x2 = null;
                        try {
                            PackageTcWarMojo.extractJarToArchive(jarFile, aos);
                        }
                        catch (Throwable x22) {
                            x2 = x22;
                            throw x22;
                        }
                        finally {
                            if (jarFile == null) continue;
                            if (x2 != null) {
                                try {
                                    jarFile.close();
                                }
                                catch (Throwable x22) {
                                    x2.addSuppressed(x22);
                                }
                                continue;
                            }
                            jarFile.close();
                        }
                    }
                }
                if (this.includeJSPSupport) {
                    this.addFile(aos, "/conf/web.xml", "conf/web.xml");
                } else {
                    this.addFile(aos, "/conf/web_wo_jsp.xml", "conf/web.xml");
                }
                this.addFile(aos, "/conf/logging.properties", "conf/logging.properties");
                if (this.includeTcNativeWin32 != null) {
                    aos.putArchiveEntry((ArchiveEntry)new JarArchiveEntry("tcnative-1.dll.32"));
                    Files.copy(Paths.get(this.includeTcNativeWin32, new String[0]), (OutputStream)aos);
                    aos.closeArchiveEntry();
                }
                if (this.includeTcNativeWin64 != null) {
                    aos.putArchiveEntry((ArchiveEntry)new JarArchiveEntry("tcnative-1.dll.64"));
                    Files.copy(Paths.get(this.includeTcNativeWin64, new String[0]), (OutputStream)aos);
                    aos.closeArchiveEntry();
                }
                for (String rc : runnerClasses = new String[]{"ch.rasc.embeddedtc.runner.CheckConfig$CheckConfigOptions", "ch.rasc.embeddedtc.runner.CheckConfig", "ch.rasc.embeddedtc.runner.Config", "ch.rasc.embeddedtc.runner.Shutdown", "ch.rasc.embeddedtc.runner.Context", "ch.rasc.embeddedtc.runner.DeleteDirectory", "ch.rasc.embeddedtc.runner.ObfuscateUtil$ObfuscateOptions", "ch.rasc.embeddedtc.runner.ObfuscateUtil", "ch.rasc.embeddedtc.runner.Runner$1", "ch.rasc.embeddedtc.runner.Runner$2", "ch.rasc.embeddedtc.runner.Runner$StartOptions", "ch.rasc.embeddedtc.runner.Runner$StopOptions", "ch.rasc.embeddedtc.runner.Runner$RunnerShutdownHook", "ch.rasc.embeddedtc.runner.Runner"}) {
                    String classAsPath = rc.replace('.', '/') + ".class";
                    try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/" + classAsPath);){
                        aos.putArchiveEntry((ArchiveEntry)new JarArchiveEntry(classAsPath));
                        IOUtils.copy((InputStream)is, (OutputStream)aos);
                        aos.closeArchiveEntry();
                    }
                }
                Manifest manifest = new Manifest();
                Manifest.Attribute mainClassAtt = new Manifest.Attribute();
                mainClassAtt.setName("Main-Class");
                mainClassAtt.setValue(Runner.class.getName());
                manifest.addConfiguredAttribute(mainClassAtt);
                aos.putArchiveEntry((ArchiveEntry)new JarArchiveEntry("META-INF/MANIFEST.MF"));
                manifest.write((OutputStream)aos);
                aos.closeArchiveEntry();
                aos.putArchiveEntry((ArchiveEntry)new JarArchiveEntry("WAR_TIMESTAMP"));
                aos.write(String.valueOf(System.currentTimeMillis()).getBytes(StandardCharsets.UTF_8));
                aos.closeArchiveEntry();
            }
        }
        catch (IOException | ArchiveException | ManifestException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void addFile(ArchiveOutputStream aos, String from, String to) throws IOException {
        aos.putArchiveEntry((ArchiveEntry)new JarArchiveEntry(to));
        IOUtils.copy((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(from), (OutputStream)aos);
        aos.closeArchiveEntry();
    }

    private static void extractJarToArchive(JarFile file, ArchiveOutputStream aos) throws IOException {
        Enumeration<JarEntry> entries = file.entries();
        while (entries.hasMoreElements()) {
            JarEntry j = entries.nextElement();
            if ("META-INF/MANIFEST.MF".equals(j.getName())) continue;
            aos.putArchiveEntry((ArchiveEntry)new JarArchiveEntry(j.getName()));
            IOUtils.copy((InputStream)file.getInputStream(j), (OutputStream)aos);
            aos.closeArchiveEntry();
        }
    }
}

