/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.embeddedtc.runner;

import ch.rasc.embeddedtc.runner.Context;
import ch.rasc.embeddedtc.runner.Runner;
import ch.rasc.embeddedtc.runner.Shutdown;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Connector;
import org.apache.tomcat.util.IntrospectionUtils;

public class Config {
    private String extractDirectory = "tc";
    private Shutdown shutdown;
    private boolean silent = false;
    private boolean useShutdownHook = false;
    private String jvmRoute;
    private List<Map<String, Object>> valves = Collections.emptyList();
    private Map<String, Object> valve;
    private Set<String> listeners = new HashSet<String>(Arrays.asList("org.apache.catalina.core.AprLifecycleListener"));
    private Map<String, Object> systemProperties = Collections.emptyMap();
    private Map<String, Object> connector;
    private List<Map<String, Object>> connectors = Collections.emptyList();
    private Context context;
    private List<Context> contexts = Collections.emptyList();
    private Path myJarDirectory;
    private static final String CONNECTOR_PROTOCOL = "protocol";
    private static final String CONNECTOR_PORT = "port";
    private static final String CONNECTOR_URIENCODING = "URIEncoding";
    private static final String VALVE_CLASSNAME = "className";

    public String getJvmRoute() {
        return this.jvmRoute;
    }

    public void setJvmRoute(String jvmRoute) {
        this.jvmRoute = jvmRoute;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public boolean isUseShutdownHook() {
        return this.useShutdownHook;
    }

    public void setUseShutdownHook(boolean useShutdownHook) {
        this.useShutdownHook = useShutdownHook;
    }

    public Set<String> getListeners() {
        return this.listeners;
    }

    public void setListeners(Set<String> listeners) {
        this.listeners = listeners;
    }

    public void setConnectors(List<Map<String, Object>> connectors) {
        this.connectors = connectors;
    }

    public void setConnector(Map<String, Object> connector) {
        this.connector = connector;
    }

    public void setValves(List<Map<String, Object>> valves) {
        this.valves = valves;
    }

    public void setValve(Map<String, Object> valve) {
        this.valve = valve;
    }

    public List<Context> getContexts() {
        if (this.context != null) {
            if (this.contexts.isEmpty()) {
                return Collections.singletonList(this.context);
            }
            ArrayList<Context> combinedContexts = new ArrayList<Context>(this.contexts);
            combinedContexts.add(this.context);
            return combinedContexts;
        }
        return this.contexts;
    }

    public void setContexts(List<Context> contexts) {
        this.contexts = contexts;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Map<String, Object> getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(Map<String, Object> systemProperties) {
        this.systemProperties = systemProperties;
    }

    public String getExtractDirectory() {
        return this.extractDirectory;
    }

    public void setExtractDirectory(String extractDirectory) {
        this.extractDirectory = extractDirectory;
    }

    public Shutdown getShutdown() {
        return this.shutdown;
    }

    public void setShutdown(Shutdown shutdown) {
        this.shutdown = shutdown;
    }

    public Path getMyJarDirectory() {
        return this.myJarDirectory;
    }

    public void setMyJarDirectory(Path myJarDirectory) {
        this.myJarDirectory = myJarDirectory;
    }

    public List<Connector> createConnectorObjects() throws Exception {
        ArrayList<Connector> conObjects = new ArrayList<Connector>();
        if (this.connector != null) {
            if (this.connectors.isEmpty()) {
                this.setConnectors(Collections.singletonList(this.connector));
            } else {
                this.connectors.add(this.connector);
            }
        }
        for (Map<String, Object> con : this.connectors) {
            Config.replaceVariables(con);
            Object protocol = con.get(CONNECTOR_PROTOCOL);
            if (protocol == null) {
                protocol = "HTTP/1.1";
            }
            Connector tcConnector = new Connector(protocol.toString());
            if (!con.containsKey(CONNECTOR_PORT)) {
                con.put(CONNECTOR_PORT, 8080);
            }
            if (!con.containsKey(CONNECTOR_URIENCODING)) {
                con.put(CONNECTOR_URIENCODING, "UTF-8");
            }
            for (Map.Entry<String, Object> entry : con.entrySet()) {
                if (entry.getKey().equals(CONNECTOR_PROTOCOL)) continue;
                IntrospectionUtils.setProperty((Object)tcConnector, (String)entry.getKey(), (String)entry.getValue().toString());
            }
            conObjects.add(tcConnector);
        }
        return conObjects;
    }

    private static void replaceVariables(Map<String, Object> con) {
        for (Map.Entry<String, Object> entry : con.entrySet()) {
            String value = entry.getValue().toString().trim();
            if (!value.startsWith("${") || !value.endsWith("}")) continue;
            String var = value.substring(2, value.length() - 1);
            String systemProperty = System.getProperty(var);
            if (systemProperty != null) {
                entry.setValue(systemProperty);
                continue;
            }
            String environmentVariable = System.getenv(var);
            if (environmentVariable == null) continue;
            entry.setValue(environmentVariable);
        }
    }

    public List<Valve> createValveObjects() {
        ArrayList<Valve> valveObjects = new ArrayList<Valve>();
        if (this.valve != null) {
            if (this.valves.isEmpty()) {
                this.setValves(Collections.singletonList(this.valve));
            } else {
                this.valves.add(this.valve);
            }
        }
        for (Map<String, Object> v : this.valves) {
            Valve valveObject;
            String className = (String)v.get(VALVE_CLASSNAME);
            if (className == null) {
                Runner.getLogger().warn((Object)"Missing className option in valve configuration");
                continue;
            }
            Class<?> valveClass = null;
            try {
                valveClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                Runner.getLogger().warn((Object)("Valve className '" + className + "' not found"));
                continue;
            }
            try {
                valveObject = (Valve)valveClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                Runner.getLogger().warn((Object)("Instantiation of class '" + className + "' failed: " + e.getMessage()));
                continue;
            }
            for (Map.Entry<String, Object> entry : v.entrySet()) {
                if (entry.getKey().equals(VALVE_CLASSNAME)) continue;
                IntrospectionUtils.setProperty((Object)valveObject, (String)entry.getKey(), (String)entry.getValue().toString());
            }
            valveObjects.add(valveObject);
        }
        return valveObjects;
    }

    public boolean isEnableNaming() {
        for (Context ctx : this.getContexts()) {
            if (!ctx.hasEnvironmentsOrResources() && ctx.getContextFile() == null) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "Config [jvmRoute=" + this.jvmRoute + ", silent=" + this.silent + ", listeners=" + this.listeners + ", systemProperties=" + this.systemProperties + ", connectors=" + this.connectors + ", context=" + this.context + ", contexts=" + this.contexts + "]";
    }
}

