/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.embeddedtc.runner;

import ch.rasc.embeddedtc.runner.Config;
import ch.rasc.embeddedtc.runner.Runner;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.yaml.snakeyaml.Yaml;

public class CheckConfig {
    public static void check(CheckConfigOptions checkConfigOptions) {
        block18: {
            try {
                Path configFile;
                String pathToConfigFile = checkConfigOptions.configFile != null && !checkConfigOptions.configFile.isEmpty() ? checkConfigOptions.configFile.get(0) : null;
                URL url = Runner.class.getProtectionDomain().getCodeSource().getLocation();
                Path myJar = Paths.get(url.toURI());
                Path myJarDir = myJar.getParent();
                if (pathToConfigFile != null) {
                    configFile = Paths.get(pathToConfigFile, new String[0]);
                    if (!configFile.isAbsolute()) {
                        configFile = myJarDir.resolve(pathToConfigFile);
                    }
                } else {
                    configFile = myJarDir.resolve("config.yaml");
                }
                if (Files.exists(configFile, new LinkOption[0])) {
                    try (InputStream is = Files.newInputStream(configFile, new OpenOption[0]);){
                        Yaml yaml = new Yaml();
                        Config config = (Config)yaml.loadAs(is, Config.class);
                        System.out.printf("Config file %s is OK", configFile);
                        break block18;
                    }
                }
                System.out.printf("Config file %s does not exists\n", configFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Parameters(commandDescription="Checks the config file")
    static class CheckConfigOptions {
        @Parameter(required=false, arity=1, description="absolutePathToConfigFile")
        List<String> configFile;

        CheckConfigOptions() {
        }
    }
}

