/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.embeddedtc.runner;

import ch.rasc.embeddedtc.runner.CheckConfig;
import ch.rasc.embeddedtc.runner.Config;
import ch.rasc.embeddedtc.runner.Context;
import ch.rasc.embeddedtc.runner.DeleteDirectory;
import ch.rasc.embeddedtc.runner.ObfuscateUtil;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletException;
import org.apache.catalina.Container;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.deploy.ApplicationParameter;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.Tomcat;
import org.yaml.snakeyaml.Yaml;

public class Runner {
    public static final String TIMESTAMP_FILENAME = "WAR_TIMESTAMP";
    public static final String EXTRA_RESOURCES_DIR = "extra";
    private static Tomcat tomcat;

    public static void start(String ... args) throws Exception {
        Runner.main(args);
    }

    public static void stop(String ... args) throws LifecycleException {
        tomcat.stop();
    }

    public static void main(String ... args) throws Exception {
        String[] arguments;
        if (args.length == 0) {
            arguments = new String[]{"start"};
        } else if ("obfuscate".equals(args[0]) || "start".equals(args[0]) || "checkConfig".equals(args[0])) {
            arguments = args;
        } else {
            ArrayList<String> argumentsList = new ArrayList<String>(Arrays.asList(args));
            argumentsList.add(0, "start");
            arguments = argumentsList.toArray(new String[argumentsList.size()]);
        }
        JCommander commander = new JCommander();
        ObfuscateUtil.ObfuscateOptions obfuscateOptions = new ObfuscateUtil.ObfuscateOptions();
        commander.addCommand("obfuscate", (Object)obfuscateOptions);
        StartOptions startOptions = new StartOptions();
        commander.addCommand("start", (Object)startOptions);
        CheckConfig.CheckConfigOptions checkConfigOptions = new CheckConfig.CheckConfigOptions();
        commander.addCommand("checkConfig", (Object)checkConfigOptions);
        commander.parse(arguments);
        switch (commander.getParsedCommand()) {
            case "start": {
                Runner.startTc(startOptions);
                break;
            }
            case "obfuscate": {
                ObfuscateUtil.obfuscate(obfuscateOptions);
                break;
            }
            case "checkConfig": {
                CheckConfig.check(checkConfigOptions);
                break;
            }
            default: {
                commander.usage();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private static void startTc(StartOptions startOptions) throws URISyntaxException, IOException, Exception, ServletException, LifecycleException {
        myJarLocationURL = Runner.class.getProtectionDomain().getCodeSource().getLocation();
        myJar = Paths.get(myJarLocationURL.toURI());
        myJarDir = myJar.getParent();
        v0 = pathToConfigFile = StartOptions.access$100(startOptions) != null && StartOptions.access$100(startOptions).isEmpty() == false ? (String)StartOptions.access$100(startOptions).get(0) : null;
        if (pathToConfigFile != null) {
            configFile = Paths.get(pathToConfigFile, new String[0]);
            if (!configFile.isAbsolute()) {
                configFile = myJarDir.resolve(pathToConfigFile);
            }
        } else {
            configFile = myJarDir.resolve("config.yaml");
        }
        if (Files.exists(configFile, new LinkOption[0])) {
            is = Files.newInputStream(configFile, new OpenOption[0]);
            var8_7 = null;
            try {
                yaml = new Yaml();
                config = (Config)yaml.loadAs(is, Config.class);
            }
            catch (Throwable x2) {
                var8_7 = x2;
                throw x2;
            }
            finally {
                if (is != null) {
                    if (var8_7 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable x2) {
                            var8_7.addSuppressed(x2);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        } else {
            config = new Config();
        }
        for (Map.Entry<String, Object> entry : config.getSystemProperties().entrySet()) {
            value = entry.getValue().toString();
            value = ObfuscateUtil.toPlaintext(value, StartOptions.access$200(startOptions));
            System.setProperty(entry.getKey(), value);
        }
        configuredPathToExtractDir = Paths.get(config.getExtractDirectory(), new String[0]);
        extractDir = configuredPathToExtractDir.isAbsolute() == false ? myJarDir.resolve(configuredPathToExtractDir) : configuredPathToExtractDir;
        extractWar = true;
        if (Files.exists(extractDir, new LinkOption[0]) && !StartOptions.access$300(startOptions) && Files.exists(timestampFile = extractDir.resolve("WAR_TIMESTAMP"), new LinkOption[0])) {
            extractTimestampBytes = Files.readAllBytes(timestampFile);
            extractTimestamp = new String(extractTimestampBytes, StandardCharsets.UTF_8);
            timestamp = null;
            is = Runner.class.getResourceAsStream("/WAR_TIMESTAMP");
            var15_21 = null;
            try {
                bos = new ByteArrayOutputStream();
                var17_25 = null;
                try {
                    Runner.copy(is, bos);
                    timestamp = new String(bos.toByteArray(), StandardCharsets.UTF_8);
                }
                catch (Throwable x2) {
                    var17_25 = x2;
                    throw x2;
                }
                finally {
                    if (bos != null) {
                        if (var17_25 != null) {
                            try {
                                bos.close();
                            }
                            catch (Throwable x2) {
                                var17_25.addSuppressed(x2);
                            }
                        } else {
                            bos.close();
                        }
                    }
                }
            }
            catch (Throwable x2) {
                var15_21 = x2;
                throw x2;
            }
            finally {
                if (is != null) {
                    if (var15_21 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable x2) {
                            var15_21.addSuppressed(x2);
                        }
                    } else {
                        is.close();
                    }
                }
            }
            if (Long.valueOf(timestamp) <= Long.valueOf(extractTimestamp)) {
                extractWar = false;
            }
        }
        isWin = System.getProperty("os.name").toLowerCase().contains("win");
        loggingPropertyFile = extractDir.resolve("logging.properties");
        loggingDir = extractDir.resolve("logs");
        tempDir = extractDir.resolve("temp");
        defaultWebxmlFile = extractDir.resolve("web.xml");
        if (extractWar || StartOptions.access$300(startOptions)) {
            if (Files.exists(extractDir, new LinkOption[0])) {
                Files.walkFileTree(extractDir, new DeleteDirectory());
            }
            Files.createDirectories(extractDir, new FileAttribute[0]);
            Files.createDirectory(tempDir, new FileAttribute[0]);
            Files.createDirectory(loggingDir, new FileAttribute[0]);
            src = Runner.class.getProtectionDomain().getCodeSource();
            warList = new ArrayList<String>();
            extraList = new ArrayList<E>();
            if (src != null) {
                jar = src.getLocation();
                zip = new ZipInputStream(jar.openStream());
                ze = null;
                extraDirName = "extra/";
                while ((ze = zip.getNextEntry()) != null) {
                    entryName = ze.getName();
                    if (entryName.startsWith(extraDirName)) {
                        extraList.add(entryName);
                        continue;
                    }
                    if (!entryName.endsWith(".war")) continue;
                    warList.add((String)entryName);
                }
            }
            for (Object war : warList) {
                warFile = extractDir.resolve((String)war);
                is = Runner.class.getResourceAsStream("/" + (String)war);
                entryName = null;
                try {
                    Files.copy(is, warFile, new CopyOption[0]);
                }
                catch (Throwable x2) {
                    entryName = x2;
                    throw x2;
                }
                finally {
                    if (is == null) continue;
                    if (entryName != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable x2) {
                            entryName.addSuppressed(x2);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            is = Runner.class.getResourceAsStream("/conf/web.xml");
            war = null;
            try {
                Files.copy(is, defaultWebxmlFile, new CopyOption[0]);
            }
            catch (Throwable x2) {
                war = x2;
                throw x2;
            }
            finally {
                if (is != null) {
                    if (war != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable x2) {
                            war.addSuppressed(x2);
                        }
                    } else {
                        is.close();
                    }
                }
            }
            is = Runner.class.getResourceAsStream("/conf/logging.properties");
            war = null;
            try {
                Files.copy(is, loggingPropertyFile, new CopyOption[0]);
            }
            catch (Throwable x2) {
                war = x2;
                throw x2;
            }
            finally {
                if (is != null) {
                    if (war != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable x2) {
                            war.addSuppressed(x2);
                        }
                    } else {
                        is.close();
                    }
                }
            }
            if (!extraList.isEmpty()) {
                i$ = extraList.iterator();
                while (i$.hasNext()) {
                    extra = (String)i$.next();
                    extraFile = extractDir.resolve(extra);
                    Files.createDirectories(extraFile.getParent(), new FileAttribute[0]);
                    is = Runner.class.getResourceAsStream("/" + extra);
                    entryName = null;
                    try {
                        Files.copy(is, (Path)extraFile, new CopyOption[0]);
                    }
                    catch (Throwable x2) {
                        entryName = x2;
                        throw x2;
                    }
                    finally {
                        if (is != null) {
                            if (entryName != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable x2) {
                                    entryName.addSuppressed(x2);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                    System.setProperty("EXTRA_RESOURCES_DIR", extractDir.resolve("extra").toAbsolutePath().toString());
                }
            }
            timestampFile = extractDir.resolve("WAR_TIMESTAMP");
            is = Runner.class.getResourceAsStream("/WAR_TIMESTAMP");
            extraFile = null;
            try {
                Files.copy(is, timestampFile, new CopyOption[0]);
            }
            catch (Throwable x2) {
                extraFile = x2;
                throw x2;
            }
            finally {
                if (is != null) {
                    if (extraFile != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable x2) {
                            extraFile.addSuppressed(x2);
                        }
                    } else {
                        is.close();
                    }
                }
            }
            if (isWin) {
                if (System.getProperty("os.arch").contains("64")) {
                    is = Runner.class.getResourceAsStream("/tcnative-1.dll.64");
                    extraFile = null;
                    try {
                        if (is == null) ** GOTO lbl280
                        Files.copy(is, extractDir.resolve("tcnative-1.dll"), new CopyOption[0]);
                    }
                    catch (Throwable x2) {
                        extraFile = x2;
                        throw x2;
                    }
                    finally {
                        if (is != null) {
                            if (extraFile != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable x2) {
                                    extraFile.addSuppressed(x2);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                } else {
                    is = Runner.class.getResourceAsStream("/tcnative-1.dll.32");
                    extraFile = null;
                    try {
                        if (is != null) {
                            Files.copy(is, extractDir.resolve("tcnative-1.dll"), new CopyOption[0]);
                        }
                    }
                    catch (Throwable x2) {
                        extraFile = x2;
                        throw x2;
                    }
                    finally {
                        if (is != null) {
                            if (extraFile != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable x2) {
                                    extraFile.addSuppressed(x2);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                }
            }
        }
        if (isWin) {
            libraryPath = System.getProperty("java.library.path");
            libraryPath = extractDir.toString() + ";" + libraryPath;
            System.setProperty("java.library.path", libraryPath);
            fieldSysPath = ClassLoader.class.getDeclaredField("sys_paths");
            fieldSysPath.setAccessible(true);
            fieldSysPath.set(null, null);
        }
        absolutePathsToEmbeddedWars = new ArrayList<String>();
        wars = Files.newDirectoryStream(extractDir, "*.war");
        extraList = null;
        try {
            for (Object war : wars) {
                absolutePathsToEmbeddedWars.add(war.toAbsolutePath().toString());
            }
        }
        catch (Throwable x2) {
            extraList = x2;
            throw x2;
        }
        finally {
            if (wars != null) {
                if (extraList != null) {
                    try {
                        wars.close();
                    }
                    catch (Throwable x2) {
                        extraList.addSuppressed(x2);
                    }
                } else {
                    wars.close();
                }
            }
        }
        System.setProperty("java.io.tmpdir", tempDir.toAbsolutePath().toString());
        System.setProperty("log.dir", loggingDir.toAbsolutePath().toString());
        System.setProperty("java.util.logging.config.file", loggingPropertyFile.toAbsolutePath().toString());
        System.setProperty("java.util.logging.manager", "org.apache.juli.ClassLoaderLogManager");
        connectors = config.createConnectorObjects();
        for (Connector connector : connectors) {
            try {
                srv = new ServerSocket(connector.getPort());
                extraFile = null;
                if (srv == null) continue;
                if (extraFile != null) {
                    try {
                        srv.close();
                    }
                    catch (Throwable x2) {
                        extraFile.addSuppressed(x2);
                    }
                    continue;
                }
                srv.close();
            }
            catch (IOException e) {
                msg = "PORT " + connector.getPort() + " ALREADY IN USE";
                System.err.println(msg);
                Runner.getLogger().severe(msg);
                return;
            }
        }
        Runner.tomcat = new Tomcat(){

            public org.apache.catalina.Context addWebapp(Host host, String url, String name, String path) {
                String base = "org.apache.catalina.core.ContainerBase.[default].[";
                base = host == null ? base + this.getHost().getName() : base + host.getName();
                base = base + "].[";
                base = base + url;
                base = base + "]";
                if (config.isSilent()) {
                    Logger.getLogger(base).setLevel(Level.WARNING);
                } else {
                    Logger.getLogger(base).setLevel(Level.INFO);
                }
                StandardContext ctx = new StandardContext();
                ctx.setName(name);
                ctx.setPath(url);
                ctx.setDocBase(path);
                ContextConfig ctxCfg = new ContextConfig();
                ctx.addLifecycleListener((LifecycleListener)ctxCfg);
                ctxCfg.setDefaultWebXml(defaultWebxmlFile.toAbsolutePath().toString());
                this.getHost().addChild((Container)ctx);
                return ctx;
            }
        };
        Runner.tomcat.setBaseDir(extractDir.toAbsolutePath().toString());
        Runner.tomcat.setSilent(config.isSilent());
        for (String s : new String[]{"org.apache.coyote.http11.Http11NioProtocol", "org.apache.tomcat.util.net.NioSelectorPool", Runner.class.getName()}) {
            if (config.isSilent()) {
                Logger.getLogger(s).setLevel(Level.WARNING);
                continue;
            }
            Logger.getLogger(s).setLevel(Level.INFO);
        }
        Runner.tomcat.getHost();
        for (String listenerClassName : config.getListeners()) {
            listener = Class.forName(listenerClassName);
            Runner.tomcat.getServer().addLifecycleListener((LifecycleListener)listener.newInstance());
        }
        for (Connector connector : connectors) {
            Runner.tomcat.setConnector(connector);
            Runner.tomcat.getService().addConnector(connector);
        }
        if (config.getJvmRoute() != null && !config.getJvmRoute().isEmpty()) {
            Runner.tomcat.getEngine().setJvmRoute(config.getJvmRoute());
        }
        for (Valve valve : config.createValveObjects()) {
            Runner.tomcat.getHost().getPipeline().addValve(valve);
        }
        if (config.isEnableNaming()) {
            Runner.tomcat.enableNaming();
        }
        if (config.getContexts().isEmpty()) {
            ctx = new Context();
            ctx.setContextPath("");
            ctx.setEmbeddedWar((String)absolutePathsToEmbeddedWars.iterator().next());
            config.setContexts(Collections.singletonList(ctx));
        }
        contextsWithoutSessionPersistence = new ArrayList<org.apache.catalina.Context>();
        for (Context configuredContext : config.getContexts()) {
            configuredContext.decryptPasswords(StartOptions.access$200(startOptions));
            contextPath = configuredContext.getContextPath();
            if (contextPath == null) {
                contextPath = "";
            }
            warPath = null;
            if (configuredContext.getEmbeddedWar() != null) {
                if (configuredContext.getEmbeddedWar().contains("*")) {
                    regex = ".*?" + configuredContext.getEmbeddedWar().replace("\\", "\\\\").replace(".", "\\.").replace("*", ".*?") + "$";
                    pattern = Pattern.compile(regex);
                    for (String warAbsolutePath : absolutePathsToEmbeddedWars) {
                        matcher = pattern.matcher(warAbsolutePath);
                        if (!matcher.matches()) continue;
                        warPath = warAbsolutePath;
                        break;
                    }
                } else {
                    warPath = configuredContext.getEmbeddedWar();
                }
                if (warPath == null) {
                    warPath = (String)absolutePathsToEmbeddedWars.iterator().next();
                }
            } else {
                warPath = configuredContext.getExternalWar() != null ? ((externWarPath = Paths.get(configuredContext.getExternalWar(), new String[0])).isAbsolute() ? configuredContext.getExternalWar() : myJarDir.resolve(configuredContext.getExternalWar()).toString()) : (String)absolutePathsToEmbeddedWars.iterator().next();
            }
            ctx = Runner.tomcat.addWebapp(contextPath, warPath);
            ctx.setSwallowOutput(true);
            for (ContextEnvironment env : configuredContext.getEnvironments()) {
                ctx.getNamingResources().addEnvironment(env);
            }
            for (ContextResource res : configuredContext.createContextResourceObjects()) {
                ctx.getNamingResources().addResource(res);
            }
            for (ApplicationParameter param : configuredContext.getParameters()) {
                ctx.addApplicationParameter(param);
            }
            if (configuredContext.getContextFile() != null) {
                contextFilePath = Paths.get(configuredContext.getContextFile(), new String[0]);
                if (Files.exists(contextFilePath, new LinkOption[0])) {
                    try {
                        contextFileURL = contextFilePath.toUri().toURL();
                        ctx.setConfigFile(contextFileURL);
                    }
                    catch (Exception e) {
                        Runner.getLogger().severe("Problem with the context file: " + e.getMessage());
                    }
                }
            } else {
                contextFileURL = Runner.getContextXml(warPath);
                if (contextFileURL != null) {
                    ctx.setConfigFile(contextFileURL);
                }
            }
            ctx.addLifecycleListener(new LifecycleListener(){

                public void lifecycleEvent(LifecycleEvent event) {
                    if (event.getLifecycle().getState() == LifecycleState.FAILED) {
                        ((StandardServer)tomcat.getServer()).stopAwait();
                    }
                }
            });
            if (configuredContext.isSessionPersistence()) continue;
            contextsWithoutSessionPersistence.add(ctx);
        }
        Runner.tomcat.start();
        for (org.apache.catalina.Context ctx : contextsWithoutSessionPersistence) {
            ((StandardManager)ctx.getManager()).setPathname(null);
        }
        Runner.tomcat.getServer().await();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static URL getContextXml(String warPath) throws IOException {
        String urlStr = "jar:file:" + warPath + "!/META-INF/context.xml";
        URL url = new URL(urlStr);
        try (InputStream is = url.openConnection().getInputStream();){
            if (is == null) return null;
            URL uRL = url;
            return uRL;
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public static Logger getLogger() {
        return Logger.getLogger(Runner.class.getName());
    }

    private static void copy(InputStream source, OutputStream sink) throws IOException {
        int n;
        byte[] buf = new byte[8192];
        while ((n = source.read(buf)) > 0) {
            sink.write(buf, 0, n);
        }
    }

    @Parameters(commandDescription="Starts the Tomcat")
    private static class StartOptions {
        @Parameter(required=false, arity=1, description="absolutePathToConfigFile")
        private List<String> configFile;
        @Parameter(names={"-p", "--password"}, description="The password")
        private String password;
        @Parameter(names={"-c", "--clean"}, description="Force deletion of extraction directory at startup")
        private boolean clean;

        private StartOptions() {
        }

        static /* synthetic */ List access$100(StartOptions x0) {
            return x0.configFile;
        }

        static /* synthetic */ String access$200(StartOptions x0) {
            return x0.password;
        }

        static /* synthetic */ boolean access$300(StartOptions x0) {
            return x0.clean;
        }
    }
}

