/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.darksky;

import ch.rasc.darksky.json.JacksonJsonConverter;
import ch.rasc.darksky.json.JsonConverter;
import ch.rasc.darksky.model.DsBlock;
import ch.rasc.darksky.model.DsForecastRequest;
import ch.rasc.darksky.model.DsLanguage;
import ch.rasc.darksky.model.DsResponse;
import ch.rasc.darksky.model.DsTimeMachineRequest;
import ch.rasc.darksky.model.DsUnit;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class DsClient {
    private final String apiKey;
    private final JsonConverter jsonConverter;
    private final OkHttpClient httpClient;
    private Integer apiCalls;
    private String responseTime;

    public DsClient(String apiKey) {
        this(apiKey, new JacksonJsonConverter(), new OkHttpClient());
    }

    public DsClient(String apiKey, OkHttpClient httpClient) {
        this(apiKey, new JacksonJsonConverter(), httpClient);
    }

    public DsClient(String apiKey, JsonConverter jsonConverter) {
        this(apiKey, jsonConverter, new OkHttpClient());
    }

    public DsClient(String apiKey, JsonConverter jsonConverter, OkHttpClient httpClient) {
        this.apiKey = apiKey;
        this.jsonConverter = jsonConverter;
        this.httpClient = httpClient;
    }

    @Nullable
    public DsResponse sendForecastRequest(DsForecastRequest request) throws IOException {
        DsLanguage language;
        Boolean extendHourly;
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder().scheme("https").host("api.darksky.net").addPathSegment("forecast").addPathSegment(this.apiKey).addPathSegment(request.latitude() + "," + request.longitude());
        DsUnit unit = request.unit();
        if (unit != null && unit != DsUnit.US) {
            urlBuilder.addQueryParameter("units", unit.getJsonValue());
        }
        if ((extendHourly = request.extendHourly()) != null && extendHourly.booleanValue()) {
            urlBuilder.addQueryParameter("extend", "hourly");
        }
        if ((language = request.language()) != null && language != DsLanguage.EN) {
            urlBuilder.addQueryParameter("lang", language.name().toLowerCase().replace('_', '-'));
        }
        EnumSet<DsBlock> exclude = EnumSet.noneOf(DsBlock.class);
        Set<DsBlock> include = request.includeBlocks();
        if (!include.isEmpty()) {
            for (DsBlock block : DsBlock.values()) {
                if (include.contains((Object)block)) continue;
                exclude.add(block);
            }
        }
        if (!request.excludeBlocks().isEmpty()) {
            exclude.addAll(request.excludeBlocks());
            if (exclude.size() == DsBlock.values().length) {
                return null;
            }
        }
        if (!exclude.isEmpty()) {
            urlBuilder.addQueryParameter("exclude", exclude.stream().map(DsBlock::getJsonValue).collect(Collectors.joining(",")));
        }
        Request getRequest = new Request.Builder().get().url(urlBuilder.build()).build();
        try (Response response = this.httpClient.newCall(getRequest).execute();
             ResponseBody body = response.body();){
            String apiCallsString = response.header("X-Forecast-API-Calls");
            if (apiCallsString != null && apiCallsString.trim().length() > 0) {
                this.apiCalls = Integer.valueOf(apiCallsString);
            }
            this.responseTime = response.header("X-Response-Time");
            if (body != null) {
                String jsonData = body.string();
                DsResponse dsResponse = this.jsonConverter.deserialize(jsonData);
                return dsResponse;
            }
        }
        return null;
    }

    @Nullable
    public DsResponse sendTimeMachineRequest(DsTimeMachineRequest request) throws IOException {
        DsLanguage language;
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder().scheme("https").host("api.darksky.net").addPathSegment("forecast").addPathSegment(this.apiKey).addPathSegment(request.latitude() + "," + request.longitude() + "," + request.time());
        DsUnit unit = request.unit();
        if (unit != null && unit != DsUnit.US) {
            urlBuilder.addQueryParameter("units", unit.getJsonValue());
        }
        if ((language = request.language()) != null && language != DsLanguage.EN) {
            urlBuilder.addQueryParameter("lang", language.name().toLowerCase().replace('_', '-'));
        }
        EnumSet<DsBlock> exclude = EnumSet.noneOf(DsBlock.class);
        Set<DsBlock> include = request.includeBlocks();
        if (!include.isEmpty()) {
            for (DsBlock block : DsBlock.values()) {
                if (include.contains((Object)block)) continue;
                exclude.add(block);
            }
        }
        if (!request.excludeBlocks().isEmpty()) {
            exclude.addAll(request.excludeBlocks());
            if (exclude.size() == DsBlock.values().length) {
                return null;
            }
        }
        if (!exclude.isEmpty()) {
            urlBuilder.addQueryParameter("exclude", exclude.stream().map(DsBlock::getJsonValue).collect(Collectors.joining(",")));
        }
        Request getRequest = new Request.Builder().get().url(urlBuilder.build()).build();
        try (Response response = this.httpClient.newCall(getRequest).execute();
             ResponseBody body = response.body();){
            String apiCallsString = response.header("X-Forecast-API-Calls");
            if (apiCallsString != null && apiCallsString.trim().length() > 0) {
                this.apiCalls = Integer.valueOf(apiCallsString);
            }
            this.responseTime = response.header("X-Response-Time");
            if (body != null) {
                String jsonData = body.string();
                DsResponse dsResponse = this.jsonConverter.deserialize(jsonData);
                return dsResponse;
            }
        }
        return null;
    }

    public Integer apiCalls() {
        return this.apiCalls;
    }

    public String responseTime() {
        return this.responseTime;
    }
}

