package ch.rasc.darksky.model;

import ch.rasc.darksky.converter.DsUnitDeserializer;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DsFlag}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDsFlag.builder()}.
 */
@Generated(from = "DsFlag", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableDsFlag implements DsFlag {
  private final @Nullable Object darkskyUnavailable;
  private final @Nullable BigDecimal nearestStation;
  private final List<String> sources;
  private final @Nullable DsUnit units;

  private ImmutableDsFlag(
      @Nullable Object darkskyUnavailable,
      @Nullable BigDecimal nearestStation,
      List<String> sources,
      @Nullable DsUnit units) {
    this.darkskyUnavailable = darkskyUnavailable;
    this.nearestStation = nearestStation;
    this.sources = sources;
    this.units = units;
  }

  /**
   * The presence of this property indicates that the Dark Sky data source supports the
   * given location, but a temporary error (such as a radar station being down for
   * maintenance) has made the data unavailable.
   */
  @JsonProperty("darksky-unavailable")
  @Override
  public @Nullable Object darkskyUnavailable() {
    return darkskyUnavailable;
  }

  /**
   * The distance to the nearest weather station that contributed data to this response.
   * Note, however, that many other stations may have also been used; this value is
   * primarily for debugging purposes. This property's value is in miles (if US units
   * are selected) or kilometers (if SI units are selected).
   */
  @JsonProperty("nearest-station")
  @Override
  public @Nullable BigDecimal nearestStation() {
    return nearestStation;
  }

  /**
   * This property contains a list of IDs for each
   * <a href="https://darksky.net/dev/docs/sources">data source</a> utilized in
   * servicing this request.
   */
  @JsonProperty("sources")
  @Override
  public List<String> sources() {
    return sources;
  }

  /**
   * Indicates the units which were used for the data in this request.
   */
  @JsonProperty("units")
  @JsonDeserialize(using = DsUnitDeserializer.class)
  @Override
  public @Nullable DsUnit units() {
    return units;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsFlag#darkskyUnavailable() darkskyUnavailable} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for darkskyUnavailable (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsFlag withDarkskyUnavailable(@Nullable Object value) {
    if (this.darkskyUnavailable == value) return this;
    return new ImmutableDsFlag(value, this.nearestStation, this.sources, this.units);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsFlag#nearestStation() nearestStation} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nearestStation (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsFlag withNearestStation(@Nullable BigDecimal value) {
    if (Objects.equals(this.nearestStation, value)) return this;
    return new ImmutableDsFlag(this.darkskyUnavailable, value, this.sources, this.units);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DsFlag#sources() sources}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDsFlag withSources(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableDsFlag(this.darkskyUnavailable, this.nearestStation, newValue, this.units);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DsFlag#sources() sources}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of sources elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDsFlag withSources(Iterable<String> elements) {
    if (this.sources == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableDsFlag(this.darkskyUnavailable, this.nearestStation, newValue, this.units);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsFlag#units() units} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for units (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsFlag withUnits(@Nullable DsUnit value) {
    if (this.units == value) return this;
    if (Objects.equals(this.units, value)) return this;
    return new ImmutableDsFlag(this.darkskyUnavailable, this.nearestStation, this.sources, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDsFlag} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDsFlag
        && equalTo((ImmutableDsFlag) another);
  }

  private boolean equalTo(ImmutableDsFlag another) {
    return Objects.equals(darkskyUnavailable, another.darkskyUnavailable)
        && Objects.equals(nearestStation, another.nearestStation)
        && sources.equals(another.sources)
        && Objects.equals(units, another.units);
  }

  /**
   * Computes a hash code from attributes: {@code darkskyUnavailable}, {@code nearestStation}, {@code sources}, {@code units}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(darkskyUnavailable);
    h += (h << 5) + Objects.hashCode(nearestStation);
    h += (h << 5) + sources.hashCode();
    h += (h << 5) + Objects.hashCode(units);
    return h;
  }

  /**
   * Prints the immutable value {@code DsFlag} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DsFlag{"
        + "darkskyUnavailable=" + darkskyUnavailable
        + ", nearestStation=" + nearestStation
        + ", sources=" + sources
        + ", units=" + units
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DsFlag", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DsFlag {
    @Nullable Object darkskyUnavailable;
    @Nullable BigDecimal nearestStation;
    @Nullable List<String> sources = Collections.emptyList();
    @Nullable DsUnit units;
    @JsonProperty("darksky-unavailable")
    public void setDarkskyUnavailable(@Nullable Object darkskyUnavailable) {
      this.darkskyUnavailable = darkskyUnavailable;
    }
    @JsonProperty("nearest-station")
    public void setNearestStation(@Nullable BigDecimal nearestStation) {
      this.nearestStation = nearestStation;
    }
    @JsonProperty("sources")
    public void setSources(List<String> sources) {
      this.sources = sources;
    }
    @JsonProperty("units")
    @JsonDeserialize(using = DsUnitDeserializer.class)
    public void setUnits(@Nullable DsUnit units) {
      this.units = units;
    }
    @Override
    public Object darkskyUnavailable() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal nearestStation() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> sources() { throw new UnsupportedOperationException(); }
    @Override
    public DsUnit units() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDsFlag fromJson(Json json) {
    ImmutableDsFlag.Builder builder = ImmutableDsFlag.builder();
    if (json.darkskyUnavailable != null) {
      builder.darkskyUnavailable(json.darkskyUnavailable);
    }
    if (json.nearestStation != null) {
      builder.nearestStation(json.nearestStation);
    }
    if (json.sources != null) {
      builder.addAllSources(json.sources);
    }
    if (json.units != null) {
      builder.units(json.units);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DsFlag} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DsFlag instance
   */
  public static ImmutableDsFlag copyOf(DsFlag instance) {
    if (instance instanceof ImmutableDsFlag) {
      return (ImmutableDsFlag) instance;
    }
    return ImmutableDsFlag.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDsFlag ImmutableDsFlag}.
   * <pre>
   * ImmutableDsFlag.builder()
   *    .darkskyUnavailable(Object | null) // nullable {@link DsFlag#darkskyUnavailable() darkskyUnavailable}
   *    .nearestStation(java.math.BigDecimal | null) // nullable {@link DsFlag#nearestStation() nearestStation}
   *    .addSources|addAllSources(String) // {@link DsFlag#sources() sources} elements
   *    .units(ch.rasc.darksky.model.DsUnit | null) // nullable {@link DsFlag#units() units}
   *    .build();
   * </pre>
   * @return A new ImmutableDsFlag builder
   */
  public static ImmutableDsFlag.Builder builder() {
    return new ImmutableDsFlag.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDsFlag ImmutableDsFlag}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DsFlag", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Object darkskyUnavailable;
    private @Nullable BigDecimal nearestStation;
    private List<String> sources = new ArrayList<String>();
    private @Nullable DsUnit units;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DsFlag} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DsFlag instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Object darkskyUnavailableValue = instance.darkskyUnavailable();
      if (darkskyUnavailableValue != null) {
        darkskyUnavailable(darkskyUnavailableValue);
      }
      @Nullable BigDecimal nearestStationValue = instance.nearestStation();
      if (nearestStationValue != null) {
        nearestStation(nearestStationValue);
      }
      addAllSources(instance.sources());
      @Nullable DsUnit unitsValue = instance.units();
      if (unitsValue != null) {
        units(unitsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DsFlag#darkskyUnavailable() darkskyUnavailable} attribute.
     * @param darkskyUnavailable The value for darkskyUnavailable (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("darksky-unavailable")
    public final Builder darkskyUnavailable(@Nullable Object darkskyUnavailable) {
      this.darkskyUnavailable = darkskyUnavailable;
      return this;
    }

    /**
     * Initializes the value for the {@link DsFlag#nearestStation() nearestStation} attribute.
     * @param nearestStation The value for nearestStation (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("nearest-station")
    public final Builder nearestStation(@Nullable BigDecimal nearestStation) {
      this.nearestStation = nearestStation;
      return this;
    }

    /**
     * Adds one element to {@link DsFlag#sources() sources} list.
     * @param element A sources element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSources(String element) {
      this.sources.add(Objects.requireNonNull(element, "sources element"));
      return this;
    }

    /**
     * Adds elements to {@link DsFlag#sources() sources} list.
     * @param elements An array of sources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSources(String... elements) {
      for (String element : elements) {
        this.sources.add(Objects.requireNonNull(element, "sources element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DsFlag#sources() sources} list.
     * @param elements An iterable of sources elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("sources")
    public final Builder sources(Iterable<String> elements) {
      this.sources.clear();
      return addAllSources(elements);
    }

    /**
     * Adds elements to {@link DsFlag#sources() sources} list.
     * @param elements An iterable of sources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSources(Iterable<String> elements) {
      for (String element : elements) {
        this.sources.add(Objects.requireNonNull(element, "sources element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DsFlag#units() units} attribute.
     * @param units The value for units (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("units")
    @JsonDeserialize(using = DsUnitDeserializer.class)
    public final Builder units(@Nullable DsUnit units) {
      this.units = units;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDsFlag ImmutableDsFlag}.
     * @return An immutable instance of DsFlag
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDsFlag build() {
      return new ImmutableDsFlag(darkskyUnavailable, nearestStation, createUnmodifiableList(true, sources), units);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
