package ch.rasc.darksky.model;

import ch.rasc.darksky.converter.DsIconDeserializer;
import ch.rasc.darksky.converter.DsPrecipTypeDeserializer;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DsDataPoint}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDsDataPoint.builder()}.
 */
@Generated(from = "DsDataPoint", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableDsDataPoint extends DsDataPoint {
  private final @Nullable BigDecimal apparentTemperature;
  private final @Nullable BigDecimal apparentTemperatureHigh;
  private final @Nullable Long apparentTemperatureHighTime;
  private final @Nullable BigDecimal apparentTemperatureLow;
  private final @Nullable Long apparentTemperatureLowTime;
  private final @Nullable BigDecimal apparentTemperatureMax;
  private final @Nullable Long apparentTemperatureMaxTime;
  private final @Nullable BigDecimal apparentTemperatureMin;
  private final @Nullable Long apparentTemperatureMinTime;
  private final @Nullable BigDecimal cloudCover;
  private final @Nullable BigDecimal dewPoint;
  private final @Nullable BigDecimal humidity;
  private final @Nullable DsIcon icon;
  private final @Nullable BigDecimal moonPhase;
  private final @Nullable BigDecimal nearestStormBearing;
  private final @Nullable BigDecimal nearestStormDistance;
  private final @Nullable BigDecimal ozone;
  private final @Nullable BigDecimal precipAccumulation;
  private final @Nullable BigDecimal precipIntensity;
  private final @Nullable BigDecimal precipIntensityError;
  private final @Nullable BigDecimal precipIntensityMax;
  private final @Nullable Long precipIntensityMaxTime;
  private final @Nullable BigDecimal precipProbability;
  private final @Nullable DsPrecipType precipType;
  private final @Nullable BigDecimal pressure;
  private final @Nullable String summary;
  private final @Nullable Long sunriseTime;
  private final @Nullable Long sunsetTime;
  private final @Nullable BigDecimal temperature;
  private final @Nullable BigDecimal temperatureHigh;
  private final @Nullable Long temperatureHighTime;
  private final @Nullable BigDecimal temperatureLow;
  private final @Nullable Long temperatureLowTime;
  private final @Nullable BigDecimal temperatureMax;
  private final @Nullable Long temperatureMaxTime;
  private final @Nullable BigDecimal temperatureMin;
  private final @Nullable Long temperatureMinTime;
  private final long time;
  private final @Nullable Integer uvIndex;
  private final @Nullable Long uvIndexTime;
  private final @Nullable BigDecimal visibility;
  private final @Nullable BigDecimal windBearing;
  private final @Nullable BigDecimal windGust;
  private final @Nullable Long windGustTime;
  private final @Nullable BigDecimal windSpeed;

  private ImmutableDsDataPoint(
      @Nullable BigDecimal apparentTemperature,
      @Nullable BigDecimal apparentTemperatureHigh,
      @Nullable Long apparentTemperatureHighTime,
      @Nullable BigDecimal apparentTemperatureLow,
      @Nullable Long apparentTemperatureLowTime,
      @Nullable BigDecimal apparentTemperatureMax,
      @Nullable Long apparentTemperatureMaxTime,
      @Nullable BigDecimal apparentTemperatureMin,
      @Nullable Long apparentTemperatureMinTime,
      @Nullable BigDecimal cloudCover,
      @Nullable BigDecimal dewPoint,
      @Nullable BigDecimal humidity,
      @Nullable DsIcon icon,
      @Nullable BigDecimal moonPhase,
      @Nullable BigDecimal nearestStormBearing,
      @Nullable BigDecimal nearestStormDistance,
      @Nullable BigDecimal ozone,
      @Nullable BigDecimal precipAccumulation,
      @Nullable BigDecimal precipIntensity,
      @Nullable BigDecimal precipIntensityError,
      @Nullable BigDecimal precipIntensityMax,
      @Nullable Long precipIntensityMaxTime,
      @Nullable BigDecimal precipProbability,
      @Nullable DsPrecipType precipType,
      @Nullable BigDecimal pressure,
      @Nullable String summary,
      @Nullable Long sunriseTime,
      @Nullable Long sunsetTime,
      @Nullable BigDecimal temperature,
      @Nullable BigDecimal temperatureHigh,
      @Nullable Long temperatureHighTime,
      @Nullable BigDecimal temperatureLow,
      @Nullable Long temperatureLowTime,
      @Nullable BigDecimal temperatureMax,
      @Nullable Long temperatureMaxTime,
      @Nullable BigDecimal temperatureMin,
      @Nullable Long temperatureMinTime,
      long time,
      @Nullable Integer uvIndex,
      @Nullable Long uvIndexTime,
      @Nullable BigDecimal visibility,
      @Nullable BigDecimal windBearing,
      @Nullable BigDecimal windGust,
      @Nullable Long windGustTime,
      @Nullable BigDecimal windSpeed) {
    this.apparentTemperature = apparentTemperature;
    this.apparentTemperatureHigh = apparentTemperatureHigh;
    this.apparentTemperatureHighTime = apparentTemperatureHighTime;
    this.apparentTemperatureLow = apparentTemperatureLow;
    this.apparentTemperatureLowTime = apparentTemperatureLowTime;
    this.apparentTemperatureMax = apparentTemperatureMax;
    this.apparentTemperatureMaxTime = apparentTemperatureMaxTime;
    this.apparentTemperatureMin = apparentTemperatureMin;
    this.apparentTemperatureMinTime = apparentTemperatureMinTime;
    this.cloudCover = cloudCover;
    this.dewPoint = dewPoint;
    this.humidity = humidity;
    this.icon = icon;
    this.moonPhase = moonPhase;
    this.nearestStormBearing = nearestStormBearing;
    this.nearestStormDistance = nearestStormDistance;
    this.ozone = ozone;
    this.precipAccumulation = precipAccumulation;
    this.precipIntensity = precipIntensity;
    this.precipIntensityError = precipIntensityError;
    this.precipIntensityMax = precipIntensityMax;
    this.precipIntensityMaxTime = precipIntensityMaxTime;
    this.precipProbability = precipProbability;
    this.precipType = precipType;
    this.pressure = pressure;
    this.summary = summary;
    this.sunriseTime = sunriseTime;
    this.sunsetTime = sunsetTime;
    this.temperature = temperature;
    this.temperatureHigh = temperatureHigh;
    this.temperatureHighTime = temperatureHighTime;
    this.temperatureLow = temperatureLow;
    this.temperatureLowTime = temperatureLowTime;
    this.temperatureMax = temperatureMax;
    this.temperatureMaxTime = temperatureMaxTime;
    this.temperatureMin = temperatureMin;
    this.temperatureMinTime = temperatureMinTime;
    this.time = time;
    this.uvIndex = uvIndex;
    this.uvIndexTime = uvIndexTime;
    this.visibility = visibility;
    this.windBearing = windBearing;
    this.windGust = windGust;
    this.windGustTime = windGustTime;
    this.windSpeed = windSpeed;
  }

  /**
   * The apparent (or "feels like") temperature in degrees Fahrenheit.
   * <p>
   * Only on {@link DsResponse#hourly()} and {@link DsResponse#currently()}
   */
  @JsonProperty("apparentTemperature")
  @Override
  public @Nullable BigDecimal apparentTemperature() {
    return apparentTemperature;
  }

  /**
   * The daytime high apparent temperature.
   * <p>
   * Only on {@link DsResponse#daily()}
   */
  @JsonProperty("apparentTemperatureHigh")
  @Override
  public @Nullable BigDecimal apparentTemperatureHigh() {
    return apparentTemperatureHigh;
  }

  /**
   * The UNIX time representing when {@link #apparentTemperatureHigh()} occurs.
   * <p>
   * Only on {@link DsResponse#daily()}
   */
  @JsonProperty("apparentTemperatureHighTime")
  @Override
  public @Nullable Long apparentTemperatureHighTime() {
    return apparentTemperatureHighTime;
  }

  /**
   * The overnight low apparent temperature.
   * <p>
   * Only on {@link DsResponse#daily()}
   */
  @JsonProperty("apparentTemperatureLow")
  @Override
  public @Nullable BigDecimal apparentTemperatureLow() {
    return apparentTemperatureLow;
  }

  /**
   * The UNIX time representing when {@link #apparentTemperatureLow()} occurs.
   * <p>
   * Only on {@link DsResponse#daily()}
   */
  @JsonProperty("apparentTemperatureLowTime")
  @Override
  public @Nullable Long apparentTemperatureLowTime() {
    return apparentTemperatureLowTime;
  }

  /**
   * The maximum apparent temperature during a given date.
   * <p>
   * Only on {@link DsResponse#daily()}
   */
  @JsonProperty("apparentTemperatureMax")
  @Override
  public @Nullable BigDecimal apparentTemperatureMax() {
    return apparentTemperatureMax;
  }

  /**
   * The UNIX time representing when {@link #apparentTemperatureMax()} occurs.
   * <p>
   * Only on {@link DsResponse#daily()}
   */
  @JsonProperty("apparentTemperatureMaxTime")
  @Override
  public @Nullable Long apparentTemperatureMaxTime() {
    return apparentTemperatureMaxTime;
  }

  /**
   * The minimum apparent temperature during a given date.
   * <p>
   * Only on {@link DsResponse#daily()}
   */
  @JsonProperty("apparentTemperatureMin")
  @Override
  public @Nullable BigDecimal apparentTemperatureMin() {
    return apparentTemperatureMin;
  }

  /**
   * The UNIX time representing when {@link #apparentTemperatureMin()} occurs.
   * <p>
   * Only on {@link DsResponse#daily()}
   */
  @JsonProperty("apparentTemperatureMinTime")
  @Override
  public @Nullable Long apparentTemperatureMinTime() {
    return apparentTemperatureMinTime;
  }

  /**
   * The percentage of sky occluded by clouds, between 0 and 1, inclusive.
   */
  @JsonProperty("cloudCover")
  @Override
  public @Nullable BigDecimal cloudCover() {
    return cloudCover;
  }

  /**
   * The dew point in degrees Fahrenheit.
   */
  @JsonProperty("dewPoint")
  @Override
  public @Nullable BigDecimal dewPoint() {
    return dewPoint;
  }

  /**
   * The relative humidity, between 0 and 1, inclusive.
   */
  @JsonProperty("humidity")
  @Override
  public @Nullable BigDecimal humidity() {
    return humidity;
  }

  /**
   * A machine-readable text summary of this data point, suitable for selecting an icon
   * for display.
   */
  @JsonProperty("icon")
  @JsonDeserialize(using = DsIconDeserializer.class)
  @Override
  public @Nullable DsIcon icon() {
    return icon;
  }

  /**
   * The fractional part of the lunation number during the given day: a value of 0
   * corresponds to a new moon, 0.25 to a first quarter moon, 0.5 to a full moon, and
   * 0.75 to a last quarter moon. (The ranges in between these represent waxing
   * crescent, waxing gibbous, waning gibbous, and waning crescent moons, respectively.)
   * <p>
   * Only on {@link DsResponse#daily()}
   */
  @JsonProperty("moonPhase")
  @Override
  public @Nullable BigDecimal moonPhase() {
    return moonPhase;
  }

  /**
   * The approximate direction of the nearest storm in degrees, with true north at 0°
   * and progressing clockwise. (If {@link #nearestStormDistance()} is zero, then this
   * value will not be defined.)
   * <p>
   * Only on {@link DsResponse#currently()}
   */
  @JsonProperty("nearestStormBearing")
  @Override
  public @Nullable BigDecimal nearestStormBearing() {
    return nearestStormBearing;
  }

  /**
   * The approximate distance to the nearest storm in miles. (A storm distance of 0
   * doesn't necessarily refer to a storm at the requested location, but rather a storm
   * in the vicinity of that location.)
   * <p>
   * Only on {@link DsResponse#currently()}
   */
  @JsonProperty("nearestStormDistance")
  @Override
  public @Nullable BigDecimal nearestStormDistance() {
    return nearestStormDistance;
  }

  /**
   * The columnar density of total atmospheric ozone at the given time in Dobson units.
   */
  @JsonProperty("ozone")
  @Override
  public @Nullable BigDecimal ozone() {
    return ozone;
  }

  /**
   * The amount of snowfall accumulation expected to occur (over the hour or day,
   * respectively), in inches. (If no snowfall is expected, this property will not be
   * defined.)
   * <p>
   * Only on {@link DsResponse#hourly()}, {@link DsResponse#currently()} and
   * {@link DsResponse#daily()}
   */
  @JsonProperty("precipAccumulation")
  @Override
  public @Nullable BigDecimal precipAccumulation() {
    return precipAccumulation;
  }

  /**
   * The intensity (in inches of liquid water per hour) of precipitation occurring at
   * the given time. This value is conditional on probability (that is, assuming any
   * precipitation occurs at all).
   */
  @JsonProperty("precipIntensity")
  @Override
  public @Nullable BigDecimal precipIntensity() {
    return precipIntensity;
  }

  /**
   * The standard deviation of the distribution of {@link #precipIntensity()}. (We only
   * return this property when the full distribution, and not merely the expected mean,
   * can be estimated with accuracy.)
   */
  @JsonProperty("precipIntensityError")
  @Override
  public @Nullable BigDecimal precipIntensityError() {
    return precipIntensityError;
  }

  /**
   * The maximum value of {@link #precipIntensity()} during a given day.
   * <p>
   * Only on {@link DsResponse#daily()}
   */
  @JsonProperty("precipIntensityMax")
  @Override
  public @Nullable BigDecimal precipIntensityMax() {
    return precipIntensityMax;
  }

  /**
   * The UNIX time of when {@link #precipIntensityMax()} occurs.
   * <p>
   * Only on {@link DsResponse#daily()}
   */
  @JsonProperty("precipIntensityMaxTime")
  @Override
  public @Nullable Long precipIntensityMaxTime() {
    return precipIntensityMaxTime;
  }

  /**
   * The probability of precipitation occurring, between 0 and 1, inclusive.
   */
  @JsonProperty("precipProbability")
  @Override
  public @Nullable BigDecimal precipProbability() {
    return precipProbability;
  }

  /**
   * The type of precipitation occurring at the given time. (If
   * {@link #precipIntensity()} is zero, then this property will not be defined.
   * Additionally, due to the lack of data in our sources, historical precipType
   * information is usually estimated, rather than observed.)
   */
  @JsonProperty("precipType")
  @JsonDeserialize(using = DsPrecipTypeDeserializer.class)
  @Override
  public @Nullable DsPrecipType precipType() {
    return precipType;
  }

  /**
   * The sea-level air pressure in millibars.
   */
  @JsonProperty("pressure")
  @Override
  public @Nullable BigDecimal pressure() {
    return pressure;
  }

  /**
   * A human-readable text summary of this data point. (This property has millions of
   * possible values, so don't use it for automated purposes: use {@link #icon()}
   * instead!)
   */
  @JsonProperty("summary")
  @Override
  public @Nullable String summary() {
    return summary;
  }

  /**
   * The UNIX time of when the sun will rise during a given day.
   * <p>
   * Only on {@link DsResponse#daily()}
   */
  @JsonProperty("sunriseTime")
  @Override
  public @Nullable Long sunriseTime() {
    return sunriseTime;
  }

  /**
   * The UNIX time of when the sun will set during a given day.
   * <p>
   * Only on {@link DsResponse#daily()}
   */
  @JsonProperty("sunsetTime")
  @Override
  public @Nullable Long sunsetTime() {
    return sunsetTime;
  }

  /**
   * The air temperature in degrees Fahrenheit.
   * <p>
   * Only on {@link DsResponse#hourly()} and {@link DsResponse#currently()}
   */
  @JsonProperty("temperature")
  @Override
  public @Nullable BigDecimal temperature() {
    return temperature;
  }

  /**
   * The daytime high temperature.
   * <p>
   * Only on {@link DsResponse#daily()}
   */
  @JsonProperty("temperatureHigh")
  @Override
  public @Nullable BigDecimal temperatureHigh() {
    return temperatureHigh;
  }

  /**
   * The UNIX time representing when {@link #temperatureHigh()} occurs.
   * <p>
   * Only on {@link DsResponse#daily()}
   */
  @JsonProperty("temperatureHighTime")
  @Override
  public @Nullable Long temperatureHighTime() {
    return temperatureHighTime;
  }

  /**
   * The overnight low temperature.
   * <p>
   * Only on {@link DsResponse#daily()}
   */
  @JsonProperty("temperatureLow")
  @Override
  public @Nullable BigDecimal temperatureLow() {
    return temperatureLow;
  }

  /**
   * The UNIX time representing when {@link #temperatureLow()} occurs.
   * <p>
   * Only on {@link DsResponse#daily()}
   */
  @JsonProperty("temperatureLowTime")
  @Override
  public @Nullable Long temperatureLowTime() {
    return temperatureLowTime;
  }

  /**
   * The maximum temperature during a given date.
   * <p>
   * Only on {@link DsResponse#daily()}
   */
  @JsonProperty("temperatureMax")
  @Override
  public @Nullable BigDecimal temperatureMax() {
    return temperatureMax;
  }

  /**
   * The UNIX time representing when {@link #temperatureMax()} occurs.
   * <p>
   * Only on {@link DsResponse#daily()}
   */
  @JsonProperty("temperatureMaxTime")
  @Override
  public @Nullable Long temperatureMaxTime() {
    return temperatureMaxTime;
  }

  /**
   * The minimum temperature during a given date.
   * <p>
   * Only on {@link DsResponse#daily()}
   */
  @JsonProperty("temperatureMin")
  @Override
  public @Nullable BigDecimal temperatureMin() {
    return temperatureMin;
  }

  /**
   * The UNIX time representing when {@link #temperatureMin()} occurs.
   * <p>
   * Only on {@link DsResponse#daily()}
   */
  @JsonProperty("temperatureMinTime")
  @Override
  public @Nullable Long temperatureMinTime() {
    return temperatureMinTime;
  }

  /**
   * The UNIX time at which this data point begins. {@link DsResponse#minutely()} data
   * point are always aligned to the top of the minute, {@link DsResponse#hourly()} data
   * point objects to the top of the hour, {@link DsResponse#daily()} data point objects
   * to midnight of the day, and {@link DsResponse#currently()} data point object to the
   * point of time provided all according to the local time zone.
   */
  @JsonProperty("time")
  @Override
  public long time() {
    return time;
  }

  /**
   * The UV index.
   */
  @JsonProperty("uvIndex")
  @Override
  public @Nullable Integer uvIndex() {
    return uvIndex;
  }

  /**
   * The UNIX time of when the maximum {@link #uvIndex()} occurs during a given day.
   * <p>
   * Only on {@link DsResponse#daily()}
   */
  @JsonProperty("uvIndexTime")
  @Override
  public @Nullable Long uvIndexTime() {
    return uvIndexTime;
  }

  /**
   * The average visibility in miles, capped at 10 miles.
   */
  @JsonProperty("visibility")
  @Override
  public @Nullable BigDecimal visibility() {
    return visibility;
  }

  /**
   * The direction that the wind is coming from in degrees, with true north at 0° and
   * progressing clockwise. (If {@link #windSpeed()} is zero, then this value will not
   * be defined.)
   */
  @JsonProperty("windBearing")
  @Override
  public @Nullable BigDecimal windBearing() {
    return windBearing;
  }

  /**
   * The wind gust speed in miles per hour.
   */
  @JsonProperty("windGust")
  @Override
  public @Nullable BigDecimal windGust() {
    return windGust;
  }

  /**
   * The time at which the maximum wind gust speed occurs during the day.
   * <p>
   * Only on {@link DsResponse#daily()}
   */
  @JsonProperty("windGustTime")
  @Override
  public @Nullable Long windGustTime() {
    return windGustTime;
  }

  /**
   * The wind speed in miles per hour.
   */
  @JsonProperty("windSpeed")
  @Override
  public @Nullable BigDecimal windSpeed() {
    return windSpeed;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#apparentTemperature() apparentTemperature} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for apparentTemperature (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withApparentTemperature(@Nullable BigDecimal value) {
    if (Objects.equals(this.apparentTemperature, value)) return this;
    return new ImmutableDsDataPoint(
        value,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#apparentTemperatureHigh() apparentTemperatureHigh} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for apparentTemperatureHigh (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withApparentTemperatureHigh(@Nullable BigDecimal value) {
    if (Objects.equals(this.apparentTemperatureHigh, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        value,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#apparentTemperatureHighTime() apparentTemperatureHighTime} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for apparentTemperatureHighTime (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withApparentTemperatureHighTime(@Nullable Long value) {
    if (Objects.equals(this.apparentTemperatureHighTime, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        value,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#apparentTemperatureLow() apparentTemperatureLow} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for apparentTemperatureLow (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withApparentTemperatureLow(@Nullable BigDecimal value) {
    if (Objects.equals(this.apparentTemperatureLow, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        value,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#apparentTemperatureLowTime() apparentTemperatureLowTime} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for apparentTemperatureLowTime (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withApparentTemperatureLowTime(@Nullable Long value) {
    if (Objects.equals(this.apparentTemperatureLowTime, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        value,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#apparentTemperatureMax() apparentTemperatureMax} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for apparentTemperatureMax (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withApparentTemperatureMax(@Nullable BigDecimal value) {
    if (Objects.equals(this.apparentTemperatureMax, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        value,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#apparentTemperatureMaxTime() apparentTemperatureMaxTime} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for apparentTemperatureMaxTime (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withApparentTemperatureMaxTime(@Nullable Long value) {
    if (Objects.equals(this.apparentTemperatureMaxTime, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        value,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#apparentTemperatureMin() apparentTemperatureMin} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for apparentTemperatureMin (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withApparentTemperatureMin(@Nullable BigDecimal value) {
    if (Objects.equals(this.apparentTemperatureMin, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        value,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#apparentTemperatureMinTime() apparentTemperatureMinTime} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for apparentTemperatureMinTime (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withApparentTemperatureMinTime(@Nullable Long value) {
    if (Objects.equals(this.apparentTemperatureMinTime, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        value,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#cloudCover() cloudCover} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cloudCover (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withCloudCover(@Nullable BigDecimal value) {
    if (Objects.equals(this.cloudCover, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        value,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#dewPoint() dewPoint} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dewPoint (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withDewPoint(@Nullable BigDecimal value) {
    if (Objects.equals(this.dewPoint, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        value,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#humidity() humidity} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for humidity (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withHumidity(@Nullable BigDecimal value) {
    if (Objects.equals(this.humidity, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        value,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#icon() icon} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for icon (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withIcon(@Nullable DsIcon value) {
    if (this.icon == value) return this;
    if (Objects.equals(this.icon, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        value,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#moonPhase() moonPhase} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for moonPhase (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withMoonPhase(@Nullable BigDecimal value) {
    if (Objects.equals(this.moonPhase, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        value,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#nearestStormBearing() nearestStormBearing} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nearestStormBearing (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withNearestStormBearing(@Nullable BigDecimal value) {
    if (Objects.equals(this.nearestStormBearing, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        value,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#nearestStormDistance() nearestStormDistance} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nearestStormDistance (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withNearestStormDistance(@Nullable BigDecimal value) {
    if (Objects.equals(this.nearestStormDistance, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        value,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#ozone() ozone} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ozone (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withOzone(@Nullable BigDecimal value) {
    if (Objects.equals(this.ozone, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        value,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#precipAccumulation() precipAccumulation} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for precipAccumulation (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withPrecipAccumulation(@Nullable BigDecimal value) {
    if (Objects.equals(this.precipAccumulation, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        value,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#precipIntensity() precipIntensity} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for precipIntensity (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withPrecipIntensity(@Nullable BigDecimal value) {
    if (Objects.equals(this.precipIntensity, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        value,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#precipIntensityError() precipIntensityError} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for precipIntensityError (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withPrecipIntensityError(@Nullable BigDecimal value) {
    if (Objects.equals(this.precipIntensityError, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        value,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#precipIntensityMax() precipIntensityMax} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for precipIntensityMax (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withPrecipIntensityMax(@Nullable BigDecimal value) {
    if (Objects.equals(this.precipIntensityMax, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        value,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#precipIntensityMaxTime() precipIntensityMaxTime} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for precipIntensityMaxTime (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withPrecipIntensityMaxTime(@Nullable Long value) {
    if (Objects.equals(this.precipIntensityMaxTime, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        value,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#precipProbability() precipProbability} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for precipProbability (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withPrecipProbability(@Nullable BigDecimal value) {
    if (Objects.equals(this.precipProbability, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        value,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#precipType() precipType} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for precipType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withPrecipType(@Nullable DsPrecipType value) {
    if (this.precipType == value) return this;
    if (Objects.equals(this.precipType, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        value,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#pressure() pressure} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pressure (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withPressure(@Nullable BigDecimal value) {
    if (Objects.equals(this.pressure, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        value,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#summary() summary} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for summary (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withSummary(@Nullable String value) {
    if (Objects.equals(this.summary, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        value,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#sunriseTime() sunriseTime} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sunriseTime (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withSunriseTime(@Nullable Long value) {
    if (Objects.equals(this.sunriseTime, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        value,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#sunsetTime() sunsetTime} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sunsetTime (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withSunsetTime(@Nullable Long value) {
    if (Objects.equals(this.sunsetTime, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        value,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#temperature() temperature} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for temperature (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withTemperature(@Nullable BigDecimal value) {
    if (Objects.equals(this.temperature, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        value,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#temperatureHigh() temperatureHigh} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for temperatureHigh (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withTemperatureHigh(@Nullable BigDecimal value) {
    if (Objects.equals(this.temperatureHigh, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        value,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#temperatureHighTime() temperatureHighTime} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for temperatureHighTime (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withTemperatureHighTime(@Nullable Long value) {
    if (Objects.equals(this.temperatureHighTime, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        value,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#temperatureLow() temperatureLow} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for temperatureLow (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withTemperatureLow(@Nullable BigDecimal value) {
    if (Objects.equals(this.temperatureLow, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        value,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#temperatureLowTime() temperatureLowTime} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for temperatureLowTime (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withTemperatureLowTime(@Nullable Long value) {
    if (Objects.equals(this.temperatureLowTime, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        value,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#temperatureMax() temperatureMax} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for temperatureMax (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withTemperatureMax(@Nullable BigDecimal value) {
    if (Objects.equals(this.temperatureMax, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        value,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#temperatureMaxTime() temperatureMaxTime} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for temperatureMaxTime (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withTemperatureMaxTime(@Nullable Long value) {
    if (Objects.equals(this.temperatureMaxTime, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        value,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#temperatureMin() temperatureMin} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for temperatureMin (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withTemperatureMin(@Nullable BigDecimal value) {
    if (Objects.equals(this.temperatureMin, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        value,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#temperatureMinTime() temperatureMinTime} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for temperatureMinTime (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withTemperatureMinTime(@Nullable Long value) {
    if (Objects.equals(this.temperatureMinTime, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        value,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#time() time} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for time
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withTime(long value) {
    if (this.time == value) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        value,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#uvIndex() uvIndex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for uvIndex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withUvIndex(@Nullable Integer value) {
    if (Objects.equals(this.uvIndex, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        value,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#uvIndexTime() uvIndexTime} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for uvIndexTime (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withUvIndexTime(@Nullable Long value) {
    if (Objects.equals(this.uvIndexTime, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        value,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#visibility() visibility} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for visibility (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withVisibility(@Nullable BigDecimal value) {
    if (Objects.equals(this.visibility, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        value,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#windBearing() windBearing} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for windBearing (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withWindBearing(@Nullable BigDecimal value) {
    if (Objects.equals(this.windBearing, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        value,
        this.windGust,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#windGust() windGust} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for windGust (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withWindGust(@Nullable BigDecimal value) {
    if (Objects.equals(this.windGust, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        value,
        this.windGustTime,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#windGustTime() windGustTime} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for windGustTime (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withWindGustTime(@Nullable Long value) {
    if (Objects.equals(this.windGustTime, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        value,
        this.windSpeed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataPoint#windSpeed() windSpeed} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for windSpeed (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataPoint withWindSpeed(@Nullable BigDecimal value) {
    if (Objects.equals(this.windSpeed, value)) return this;
    return new ImmutableDsDataPoint(
        this.apparentTemperature,
        this.apparentTemperatureHigh,
        this.apparentTemperatureHighTime,
        this.apparentTemperatureLow,
        this.apparentTemperatureLowTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.cloudCover,
        this.dewPoint,
        this.humidity,
        this.icon,
        this.moonPhase,
        this.nearestStormBearing,
        this.nearestStormDistance,
        this.ozone,
        this.precipAccumulation,
        this.precipIntensity,
        this.precipIntensityError,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.pressure,
        this.summary,
        this.sunriseTime,
        this.sunsetTime,
        this.temperature,
        this.temperatureHigh,
        this.temperatureHighTime,
        this.temperatureLow,
        this.temperatureLowTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.temperatureMin,
        this.temperatureMinTime,
        this.time,
        this.uvIndex,
        this.uvIndexTime,
        this.visibility,
        this.windBearing,
        this.windGust,
        this.windGustTime,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDsDataPoint} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDsDataPoint
        && equalTo((ImmutableDsDataPoint) another);
  }

  private boolean equalTo(ImmutableDsDataPoint another) {
    return Objects.equals(apparentTemperature, another.apparentTemperature)
        && Objects.equals(apparentTemperatureHigh, another.apparentTemperatureHigh)
        && Objects.equals(apparentTemperatureHighTime, another.apparentTemperatureHighTime)
        && Objects.equals(apparentTemperatureLow, another.apparentTemperatureLow)
        && Objects.equals(apparentTemperatureLowTime, another.apparentTemperatureLowTime)
        && Objects.equals(apparentTemperatureMax, another.apparentTemperatureMax)
        && Objects.equals(apparentTemperatureMaxTime, another.apparentTemperatureMaxTime)
        && Objects.equals(apparentTemperatureMin, another.apparentTemperatureMin)
        && Objects.equals(apparentTemperatureMinTime, another.apparentTemperatureMinTime)
        && Objects.equals(cloudCover, another.cloudCover)
        && Objects.equals(dewPoint, another.dewPoint)
        && Objects.equals(humidity, another.humidity)
        && Objects.equals(icon, another.icon)
        && Objects.equals(moonPhase, another.moonPhase)
        && Objects.equals(nearestStormBearing, another.nearestStormBearing)
        && Objects.equals(nearestStormDistance, another.nearestStormDistance)
        && Objects.equals(ozone, another.ozone)
        && Objects.equals(precipAccumulation, another.precipAccumulation)
        && Objects.equals(precipIntensity, another.precipIntensity)
        && Objects.equals(precipIntensityError, another.precipIntensityError)
        && Objects.equals(precipIntensityMax, another.precipIntensityMax)
        && Objects.equals(precipIntensityMaxTime, another.precipIntensityMaxTime)
        && Objects.equals(precipProbability, another.precipProbability)
        && Objects.equals(precipType, another.precipType)
        && Objects.equals(pressure, another.pressure)
        && Objects.equals(summary, another.summary)
        && Objects.equals(sunriseTime, another.sunriseTime)
        && Objects.equals(sunsetTime, another.sunsetTime)
        && Objects.equals(temperature, another.temperature)
        && Objects.equals(temperatureHigh, another.temperatureHigh)
        && Objects.equals(temperatureHighTime, another.temperatureHighTime)
        && Objects.equals(temperatureLow, another.temperatureLow)
        && Objects.equals(temperatureLowTime, another.temperatureLowTime)
        && Objects.equals(temperatureMax, another.temperatureMax)
        && Objects.equals(temperatureMaxTime, another.temperatureMaxTime)
        && Objects.equals(temperatureMin, another.temperatureMin)
        && Objects.equals(temperatureMinTime, another.temperatureMinTime)
        && time == another.time
        && Objects.equals(uvIndex, another.uvIndex)
        && Objects.equals(uvIndexTime, another.uvIndexTime)
        && Objects.equals(visibility, another.visibility)
        && Objects.equals(windBearing, another.windBearing)
        && Objects.equals(windGust, another.windGust)
        && Objects.equals(windGustTime, another.windGustTime)
        && Objects.equals(windSpeed, another.windSpeed);
  }

  /**
   * Computes a hash code from attributes: {@code apparentTemperature}, {@code apparentTemperatureHigh}, {@code apparentTemperatureHighTime}, {@code apparentTemperatureLow}, {@code apparentTemperatureLowTime}, {@code apparentTemperatureMax}, {@code apparentTemperatureMaxTime}, {@code apparentTemperatureMin}, {@code apparentTemperatureMinTime}, {@code cloudCover}, {@code dewPoint}, {@code humidity}, {@code icon}, {@code moonPhase}, {@code nearestStormBearing}, {@code nearestStormDistance}, {@code ozone}, {@code precipAccumulation}, {@code precipIntensity}, {@code precipIntensityError}, {@code precipIntensityMax}, {@code precipIntensityMaxTime}, {@code precipProbability}, {@code precipType}, {@code pressure}, {@code summary}, {@code sunriseTime}, {@code sunsetTime}, {@code temperature}, {@code temperatureHigh}, {@code temperatureHighTime}, {@code temperatureLow}, {@code temperatureLowTime}, {@code temperatureMax}, {@code temperatureMaxTime}, {@code temperatureMin}, {@code temperatureMinTime}, {@code time}, {@code uvIndex}, {@code uvIndexTime}, {@code visibility}, {@code windBearing}, {@code windGust}, {@code windGustTime}, {@code windSpeed}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(apparentTemperature);
    h += (h << 5) + Objects.hashCode(apparentTemperatureHigh);
    h += (h << 5) + Objects.hashCode(apparentTemperatureHighTime);
    h += (h << 5) + Objects.hashCode(apparentTemperatureLow);
    h += (h << 5) + Objects.hashCode(apparentTemperatureLowTime);
    h += (h << 5) + Objects.hashCode(apparentTemperatureMax);
    h += (h << 5) + Objects.hashCode(apparentTemperatureMaxTime);
    h += (h << 5) + Objects.hashCode(apparentTemperatureMin);
    h += (h << 5) + Objects.hashCode(apparentTemperatureMinTime);
    h += (h << 5) + Objects.hashCode(cloudCover);
    h += (h << 5) + Objects.hashCode(dewPoint);
    h += (h << 5) + Objects.hashCode(humidity);
    h += (h << 5) + Objects.hashCode(icon);
    h += (h << 5) + Objects.hashCode(moonPhase);
    h += (h << 5) + Objects.hashCode(nearestStormBearing);
    h += (h << 5) + Objects.hashCode(nearestStormDistance);
    h += (h << 5) + Objects.hashCode(ozone);
    h += (h << 5) + Objects.hashCode(precipAccumulation);
    h += (h << 5) + Objects.hashCode(precipIntensity);
    h += (h << 5) + Objects.hashCode(precipIntensityError);
    h += (h << 5) + Objects.hashCode(precipIntensityMax);
    h += (h << 5) + Objects.hashCode(precipIntensityMaxTime);
    h += (h << 5) + Objects.hashCode(precipProbability);
    h += (h << 5) + Objects.hashCode(precipType);
    h += (h << 5) + Objects.hashCode(pressure);
    h += (h << 5) + Objects.hashCode(summary);
    h += (h << 5) + Objects.hashCode(sunriseTime);
    h += (h << 5) + Objects.hashCode(sunsetTime);
    h += (h << 5) + Objects.hashCode(temperature);
    h += (h << 5) + Objects.hashCode(temperatureHigh);
    h += (h << 5) + Objects.hashCode(temperatureHighTime);
    h += (h << 5) + Objects.hashCode(temperatureLow);
    h += (h << 5) + Objects.hashCode(temperatureLowTime);
    h += (h << 5) + Objects.hashCode(temperatureMax);
    h += (h << 5) + Objects.hashCode(temperatureMaxTime);
    h += (h << 5) + Objects.hashCode(temperatureMin);
    h += (h << 5) + Objects.hashCode(temperatureMinTime);
    h += (h << 5) + Long.hashCode(time);
    h += (h << 5) + Objects.hashCode(uvIndex);
    h += (h << 5) + Objects.hashCode(uvIndexTime);
    h += (h << 5) + Objects.hashCode(visibility);
    h += (h << 5) + Objects.hashCode(windBearing);
    h += (h << 5) + Objects.hashCode(windGust);
    h += (h << 5) + Objects.hashCode(windGustTime);
    h += (h << 5) + Objects.hashCode(windSpeed);
    return h;
  }

  /**
   * Prints the immutable value {@code DsDataPoint} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DsDataPoint{"
        + "apparentTemperature=" + apparentTemperature
        + ", apparentTemperatureHigh=" + apparentTemperatureHigh
        + ", apparentTemperatureHighTime=" + apparentTemperatureHighTime
        + ", apparentTemperatureLow=" + apparentTemperatureLow
        + ", apparentTemperatureLowTime=" + apparentTemperatureLowTime
        + ", apparentTemperatureMax=" + apparentTemperatureMax
        + ", apparentTemperatureMaxTime=" + apparentTemperatureMaxTime
        + ", apparentTemperatureMin=" + apparentTemperatureMin
        + ", apparentTemperatureMinTime=" + apparentTemperatureMinTime
        + ", cloudCover=" + cloudCover
        + ", dewPoint=" + dewPoint
        + ", humidity=" + humidity
        + ", icon=" + icon
        + ", moonPhase=" + moonPhase
        + ", nearestStormBearing=" + nearestStormBearing
        + ", nearestStormDistance=" + nearestStormDistance
        + ", ozone=" + ozone
        + ", precipAccumulation=" + precipAccumulation
        + ", precipIntensity=" + precipIntensity
        + ", precipIntensityError=" + precipIntensityError
        + ", precipIntensityMax=" + precipIntensityMax
        + ", precipIntensityMaxTime=" + precipIntensityMaxTime
        + ", precipProbability=" + precipProbability
        + ", precipType=" + precipType
        + ", pressure=" + pressure
        + ", summary=" + summary
        + ", sunriseTime=" + sunriseTime
        + ", sunsetTime=" + sunsetTime
        + ", temperature=" + temperature
        + ", temperatureHigh=" + temperatureHigh
        + ", temperatureHighTime=" + temperatureHighTime
        + ", temperatureLow=" + temperatureLow
        + ", temperatureLowTime=" + temperatureLowTime
        + ", temperatureMax=" + temperatureMax
        + ", temperatureMaxTime=" + temperatureMaxTime
        + ", temperatureMin=" + temperatureMin
        + ", temperatureMinTime=" + temperatureMinTime
        + ", time=" + time
        + ", uvIndex=" + uvIndex
        + ", uvIndexTime=" + uvIndexTime
        + ", visibility=" + visibility
        + ", windBearing=" + windBearing
        + ", windGust=" + windGust
        + ", windGustTime=" + windGustTime
        + ", windSpeed=" + windSpeed
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DsDataPoint", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends DsDataPoint {
    @Nullable BigDecimal apparentTemperature;
    @Nullable BigDecimal apparentTemperatureHigh;
    @Nullable Long apparentTemperatureHighTime;
    @Nullable BigDecimal apparentTemperatureLow;
    @Nullable Long apparentTemperatureLowTime;
    @Nullable BigDecimal apparentTemperatureMax;
    @Nullable Long apparentTemperatureMaxTime;
    @Nullable BigDecimal apparentTemperatureMin;
    @Nullable Long apparentTemperatureMinTime;
    @Nullable BigDecimal cloudCover;
    @Nullable BigDecimal dewPoint;
    @Nullable BigDecimal humidity;
    @Nullable DsIcon icon;
    @Nullable BigDecimal moonPhase;
    @Nullable BigDecimal nearestStormBearing;
    @Nullable BigDecimal nearestStormDistance;
    @Nullable BigDecimal ozone;
    @Nullable BigDecimal precipAccumulation;
    @Nullable BigDecimal precipIntensity;
    @Nullable BigDecimal precipIntensityError;
    @Nullable BigDecimal precipIntensityMax;
    @Nullable Long precipIntensityMaxTime;
    @Nullable BigDecimal precipProbability;
    @Nullable DsPrecipType precipType;
    @Nullable BigDecimal pressure;
    @Nullable String summary;
    @Nullable Long sunriseTime;
    @Nullable Long sunsetTime;
    @Nullable BigDecimal temperature;
    @Nullable BigDecimal temperatureHigh;
    @Nullable Long temperatureHighTime;
    @Nullable BigDecimal temperatureLow;
    @Nullable Long temperatureLowTime;
    @Nullable BigDecimal temperatureMax;
    @Nullable Long temperatureMaxTime;
    @Nullable BigDecimal temperatureMin;
    @Nullable Long temperatureMinTime;
    long time;
    boolean timeIsSet;
    @Nullable Integer uvIndex;
    @Nullable Long uvIndexTime;
    @Nullable BigDecimal visibility;
    @Nullable BigDecimal windBearing;
    @Nullable BigDecimal windGust;
    @Nullable Long windGustTime;
    @Nullable BigDecimal windSpeed;
    @JsonProperty("apparentTemperature")
    public void setApparentTemperature(@Nullable BigDecimal apparentTemperature) {
      this.apparentTemperature = apparentTemperature;
    }
    @JsonProperty("apparentTemperatureHigh")
    public void setApparentTemperatureHigh(@Nullable BigDecimal apparentTemperatureHigh) {
      this.apparentTemperatureHigh = apparentTemperatureHigh;
    }
    @JsonProperty("apparentTemperatureHighTime")
    public void setApparentTemperatureHighTime(@Nullable Long apparentTemperatureHighTime) {
      this.apparentTemperatureHighTime = apparentTemperatureHighTime;
    }
    @JsonProperty("apparentTemperatureLow")
    public void setApparentTemperatureLow(@Nullable BigDecimal apparentTemperatureLow) {
      this.apparentTemperatureLow = apparentTemperatureLow;
    }
    @JsonProperty("apparentTemperatureLowTime")
    public void setApparentTemperatureLowTime(@Nullable Long apparentTemperatureLowTime) {
      this.apparentTemperatureLowTime = apparentTemperatureLowTime;
    }
    @JsonProperty("apparentTemperatureMax")
    public void setApparentTemperatureMax(@Nullable BigDecimal apparentTemperatureMax) {
      this.apparentTemperatureMax = apparentTemperatureMax;
    }
    @JsonProperty("apparentTemperatureMaxTime")
    public void setApparentTemperatureMaxTime(@Nullable Long apparentTemperatureMaxTime) {
      this.apparentTemperatureMaxTime = apparentTemperatureMaxTime;
    }
    @JsonProperty("apparentTemperatureMin")
    public void setApparentTemperatureMin(@Nullable BigDecimal apparentTemperatureMin) {
      this.apparentTemperatureMin = apparentTemperatureMin;
    }
    @JsonProperty("apparentTemperatureMinTime")
    public void setApparentTemperatureMinTime(@Nullable Long apparentTemperatureMinTime) {
      this.apparentTemperatureMinTime = apparentTemperatureMinTime;
    }
    @JsonProperty("cloudCover")
    public void setCloudCover(@Nullable BigDecimal cloudCover) {
      this.cloudCover = cloudCover;
    }
    @JsonProperty("dewPoint")
    public void setDewPoint(@Nullable BigDecimal dewPoint) {
      this.dewPoint = dewPoint;
    }
    @JsonProperty("humidity")
    public void setHumidity(@Nullable BigDecimal humidity) {
      this.humidity = humidity;
    }
    @JsonProperty("icon")
    @JsonDeserialize(using = DsIconDeserializer.class)
    public void setIcon(@Nullable DsIcon icon) {
      this.icon = icon;
    }
    @JsonProperty("moonPhase")
    public void setMoonPhase(@Nullable BigDecimal moonPhase) {
      this.moonPhase = moonPhase;
    }
    @JsonProperty("nearestStormBearing")
    public void setNearestStormBearing(@Nullable BigDecimal nearestStormBearing) {
      this.nearestStormBearing = nearestStormBearing;
    }
    @JsonProperty("nearestStormDistance")
    public void setNearestStormDistance(@Nullable BigDecimal nearestStormDistance) {
      this.nearestStormDistance = nearestStormDistance;
    }
    @JsonProperty("ozone")
    public void setOzone(@Nullable BigDecimal ozone) {
      this.ozone = ozone;
    }
    @JsonProperty("precipAccumulation")
    public void setPrecipAccumulation(@Nullable BigDecimal precipAccumulation) {
      this.precipAccumulation = precipAccumulation;
    }
    @JsonProperty("precipIntensity")
    public void setPrecipIntensity(@Nullable BigDecimal precipIntensity) {
      this.precipIntensity = precipIntensity;
    }
    @JsonProperty("precipIntensityError")
    public void setPrecipIntensityError(@Nullable BigDecimal precipIntensityError) {
      this.precipIntensityError = precipIntensityError;
    }
    @JsonProperty("precipIntensityMax")
    public void setPrecipIntensityMax(@Nullable BigDecimal precipIntensityMax) {
      this.precipIntensityMax = precipIntensityMax;
    }
    @JsonProperty("precipIntensityMaxTime")
    public void setPrecipIntensityMaxTime(@Nullable Long precipIntensityMaxTime) {
      this.precipIntensityMaxTime = precipIntensityMaxTime;
    }
    @JsonProperty("precipProbability")
    public void setPrecipProbability(@Nullable BigDecimal precipProbability) {
      this.precipProbability = precipProbability;
    }
    @JsonProperty("precipType")
    @JsonDeserialize(using = DsPrecipTypeDeserializer.class)
    public void setPrecipType(@Nullable DsPrecipType precipType) {
      this.precipType = precipType;
    }
    @JsonProperty("pressure")
    public void setPressure(@Nullable BigDecimal pressure) {
      this.pressure = pressure;
    }
    @JsonProperty("summary")
    public void setSummary(@Nullable String summary) {
      this.summary = summary;
    }
    @JsonProperty("sunriseTime")
    public void setSunriseTime(@Nullable Long sunriseTime) {
      this.sunriseTime = sunriseTime;
    }
    @JsonProperty("sunsetTime")
    public void setSunsetTime(@Nullable Long sunsetTime) {
      this.sunsetTime = sunsetTime;
    }
    @JsonProperty("temperature")
    public void setTemperature(@Nullable BigDecimal temperature) {
      this.temperature = temperature;
    }
    @JsonProperty("temperatureHigh")
    public void setTemperatureHigh(@Nullable BigDecimal temperatureHigh) {
      this.temperatureHigh = temperatureHigh;
    }
    @JsonProperty("temperatureHighTime")
    public void setTemperatureHighTime(@Nullable Long temperatureHighTime) {
      this.temperatureHighTime = temperatureHighTime;
    }
    @JsonProperty("temperatureLow")
    public void setTemperatureLow(@Nullable BigDecimal temperatureLow) {
      this.temperatureLow = temperatureLow;
    }
    @JsonProperty("temperatureLowTime")
    public void setTemperatureLowTime(@Nullable Long temperatureLowTime) {
      this.temperatureLowTime = temperatureLowTime;
    }
    @JsonProperty("temperatureMax")
    public void setTemperatureMax(@Nullable BigDecimal temperatureMax) {
      this.temperatureMax = temperatureMax;
    }
    @JsonProperty("temperatureMaxTime")
    public void setTemperatureMaxTime(@Nullable Long temperatureMaxTime) {
      this.temperatureMaxTime = temperatureMaxTime;
    }
    @JsonProperty("temperatureMin")
    public void setTemperatureMin(@Nullable BigDecimal temperatureMin) {
      this.temperatureMin = temperatureMin;
    }
    @JsonProperty("temperatureMinTime")
    public void setTemperatureMinTime(@Nullable Long temperatureMinTime) {
      this.temperatureMinTime = temperatureMinTime;
    }
    @JsonProperty("time")
    public void setTime(long time) {
      this.time = time;
      this.timeIsSet = true;
    }
    @JsonProperty("uvIndex")
    public void setUvIndex(@Nullable Integer uvIndex) {
      this.uvIndex = uvIndex;
    }
    @JsonProperty("uvIndexTime")
    public void setUvIndexTime(@Nullable Long uvIndexTime) {
      this.uvIndexTime = uvIndexTime;
    }
    @JsonProperty("visibility")
    public void setVisibility(@Nullable BigDecimal visibility) {
      this.visibility = visibility;
    }
    @JsonProperty("windBearing")
    public void setWindBearing(@Nullable BigDecimal windBearing) {
      this.windBearing = windBearing;
    }
    @JsonProperty("windGust")
    public void setWindGust(@Nullable BigDecimal windGust) {
      this.windGust = windGust;
    }
    @JsonProperty("windGustTime")
    public void setWindGustTime(@Nullable Long windGustTime) {
      this.windGustTime = windGustTime;
    }
    @JsonProperty("windSpeed")
    public void setWindSpeed(@Nullable BigDecimal windSpeed) {
      this.windSpeed = windSpeed;
    }
    @Override
    public BigDecimal apparentTemperature() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal apparentTemperatureHigh() { throw new UnsupportedOperationException(); }
    @Override
    public Long apparentTemperatureHighTime() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal apparentTemperatureLow() { throw new UnsupportedOperationException(); }
    @Override
    public Long apparentTemperatureLowTime() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal apparentTemperatureMax() { throw new UnsupportedOperationException(); }
    @Override
    public Long apparentTemperatureMaxTime() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal apparentTemperatureMin() { throw new UnsupportedOperationException(); }
    @Override
    public Long apparentTemperatureMinTime() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal cloudCover() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal dewPoint() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal humidity() { throw new UnsupportedOperationException(); }
    @Override
    public DsIcon icon() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal moonPhase() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal nearestStormBearing() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal nearestStormDistance() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal ozone() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal precipAccumulation() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal precipIntensity() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal precipIntensityError() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal precipIntensityMax() { throw new UnsupportedOperationException(); }
    @Override
    public Long precipIntensityMaxTime() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal precipProbability() { throw new UnsupportedOperationException(); }
    @Override
    public DsPrecipType precipType() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal pressure() { throw new UnsupportedOperationException(); }
    @Override
    public String summary() { throw new UnsupportedOperationException(); }
    @Override
    public Long sunriseTime() { throw new UnsupportedOperationException(); }
    @Override
    public Long sunsetTime() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal temperature() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal temperatureHigh() { throw new UnsupportedOperationException(); }
    @Override
    public Long temperatureHighTime() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal temperatureLow() { throw new UnsupportedOperationException(); }
    @Override
    public Long temperatureLowTime() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal temperatureMax() { throw new UnsupportedOperationException(); }
    @Override
    public Long temperatureMaxTime() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal temperatureMin() { throw new UnsupportedOperationException(); }
    @Override
    public Long temperatureMinTime() { throw new UnsupportedOperationException(); }
    @Override
    public long time() { throw new UnsupportedOperationException(); }
    @Override
    public Integer uvIndex() { throw new UnsupportedOperationException(); }
    @Override
    public Long uvIndexTime() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal visibility() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal windBearing() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal windGust() { throw new UnsupportedOperationException(); }
    @Override
    public Long windGustTime() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal windSpeed() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDsDataPoint fromJson(Json json) {
    ImmutableDsDataPoint.Builder builder = ImmutableDsDataPoint.builder();
    if (json.apparentTemperature != null) {
      builder.apparentTemperature(json.apparentTemperature);
    }
    if (json.apparentTemperatureHigh != null) {
      builder.apparentTemperatureHigh(json.apparentTemperatureHigh);
    }
    if (json.apparentTemperatureHighTime != null) {
      builder.apparentTemperatureHighTime(json.apparentTemperatureHighTime);
    }
    if (json.apparentTemperatureLow != null) {
      builder.apparentTemperatureLow(json.apparentTemperatureLow);
    }
    if (json.apparentTemperatureLowTime != null) {
      builder.apparentTemperatureLowTime(json.apparentTemperatureLowTime);
    }
    if (json.apparentTemperatureMax != null) {
      builder.apparentTemperatureMax(json.apparentTemperatureMax);
    }
    if (json.apparentTemperatureMaxTime != null) {
      builder.apparentTemperatureMaxTime(json.apparentTemperatureMaxTime);
    }
    if (json.apparentTemperatureMin != null) {
      builder.apparentTemperatureMin(json.apparentTemperatureMin);
    }
    if (json.apparentTemperatureMinTime != null) {
      builder.apparentTemperatureMinTime(json.apparentTemperatureMinTime);
    }
    if (json.cloudCover != null) {
      builder.cloudCover(json.cloudCover);
    }
    if (json.dewPoint != null) {
      builder.dewPoint(json.dewPoint);
    }
    if (json.humidity != null) {
      builder.humidity(json.humidity);
    }
    if (json.icon != null) {
      builder.icon(json.icon);
    }
    if (json.moonPhase != null) {
      builder.moonPhase(json.moonPhase);
    }
    if (json.nearestStormBearing != null) {
      builder.nearestStormBearing(json.nearestStormBearing);
    }
    if (json.nearestStormDistance != null) {
      builder.nearestStormDistance(json.nearestStormDistance);
    }
    if (json.ozone != null) {
      builder.ozone(json.ozone);
    }
    if (json.precipAccumulation != null) {
      builder.precipAccumulation(json.precipAccumulation);
    }
    if (json.precipIntensity != null) {
      builder.precipIntensity(json.precipIntensity);
    }
    if (json.precipIntensityError != null) {
      builder.precipIntensityError(json.precipIntensityError);
    }
    if (json.precipIntensityMax != null) {
      builder.precipIntensityMax(json.precipIntensityMax);
    }
    if (json.precipIntensityMaxTime != null) {
      builder.precipIntensityMaxTime(json.precipIntensityMaxTime);
    }
    if (json.precipProbability != null) {
      builder.precipProbability(json.precipProbability);
    }
    if (json.precipType != null) {
      builder.precipType(json.precipType);
    }
    if (json.pressure != null) {
      builder.pressure(json.pressure);
    }
    if (json.summary != null) {
      builder.summary(json.summary);
    }
    if (json.sunriseTime != null) {
      builder.sunriseTime(json.sunriseTime);
    }
    if (json.sunsetTime != null) {
      builder.sunsetTime(json.sunsetTime);
    }
    if (json.temperature != null) {
      builder.temperature(json.temperature);
    }
    if (json.temperatureHigh != null) {
      builder.temperatureHigh(json.temperatureHigh);
    }
    if (json.temperatureHighTime != null) {
      builder.temperatureHighTime(json.temperatureHighTime);
    }
    if (json.temperatureLow != null) {
      builder.temperatureLow(json.temperatureLow);
    }
    if (json.temperatureLowTime != null) {
      builder.temperatureLowTime(json.temperatureLowTime);
    }
    if (json.temperatureMax != null) {
      builder.temperatureMax(json.temperatureMax);
    }
    if (json.temperatureMaxTime != null) {
      builder.temperatureMaxTime(json.temperatureMaxTime);
    }
    if (json.temperatureMin != null) {
      builder.temperatureMin(json.temperatureMin);
    }
    if (json.temperatureMinTime != null) {
      builder.temperatureMinTime(json.temperatureMinTime);
    }
    if (json.timeIsSet) {
      builder.time(json.time);
    }
    if (json.uvIndex != null) {
      builder.uvIndex(json.uvIndex);
    }
    if (json.uvIndexTime != null) {
      builder.uvIndexTime(json.uvIndexTime);
    }
    if (json.visibility != null) {
      builder.visibility(json.visibility);
    }
    if (json.windBearing != null) {
      builder.windBearing(json.windBearing);
    }
    if (json.windGust != null) {
      builder.windGust(json.windGust);
    }
    if (json.windGustTime != null) {
      builder.windGustTime(json.windGustTime);
    }
    if (json.windSpeed != null) {
      builder.windSpeed(json.windSpeed);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DsDataPoint} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DsDataPoint instance
   */
  public static ImmutableDsDataPoint copyOf(DsDataPoint instance) {
    if (instance instanceof ImmutableDsDataPoint) {
      return (ImmutableDsDataPoint) instance;
    }
    return ImmutableDsDataPoint.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDsDataPoint ImmutableDsDataPoint}.
   * <pre>
   * ImmutableDsDataPoint.builder()
   *    .apparentTemperature(java.math.BigDecimal | null) // nullable {@link DsDataPoint#apparentTemperature() apparentTemperature}
   *    .apparentTemperatureHigh(java.math.BigDecimal | null) // nullable {@link DsDataPoint#apparentTemperatureHigh() apparentTemperatureHigh}
   *    .apparentTemperatureHighTime(Long | null) // nullable {@link DsDataPoint#apparentTemperatureHighTime() apparentTemperatureHighTime}
   *    .apparentTemperatureLow(java.math.BigDecimal | null) // nullable {@link DsDataPoint#apparentTemperatureLow() apparentTemperatureLow}
   *    .apparentTemperatureLowTime(Long | null) // nullable {@link DsDataPoint#apparentTemperatureLowTime() apparentTemperatureLowTime}
   *    .apparentTemperatureMax(java.math.BigDecimal | null) // nullable {@link DsDataPoint#apparentTemperatureMax() apparentTemperatureMax}
   *    .apparentTemperatureMaxTime(Long | null) // nullable {@link DsDataPoint#apparentTemperatureMaxTime() apparentTemperatureMaxTime}
   *    .apparentTemperatureMin(java.math.BigDecimal | null) // nullable {@link DsDataPoint#apparentTemperatureMin() apparentTemperatureMin}
   *    .apparentTemperatureMinTime(Long | null) // nullable {@link DsDataPoint#apparentTemperatureMinTime() apparentTemperatureMinTime}
   *    .cloudCover(java.math.BigDecimal | null) // nullable {@link DsDataPoint#cloudCover() cloudCover}
   *    .dewPoint(java.math.BigDecimal | null) // nullable {@link DsDataPoint#dewPoint() dewPoint}
   *    .humidity(java.math.BigDecimal | null) // nullable {@link DsDataPoint#humidity() humidity}
   *    .icon(ch.rasc.darksky.model.DsIcon | null) // nullable {@link DsDataPoint#icon() icon}
   *    .moonPhase(java.math.BigDecimal | null) // nullable {@link DsDataPoint#moonPhase() moonPhase}
   *    .nearestStormBearing(java.math.BigDecimal | null) // nullable {@link DsDataPoint#nearestStormBearing() nearestStormBearing}
   *    .nearestStormDistance(java.math.BigDecimal | null) // nullable {@link DsDataPoint#nearestStormDistance() nearestStormDistance}
   *    .ozone(java.math.BigDecimal | null) // nullable {@link DsDataPoint#ozone() ozone}
   *    .precipAccumulation(java.math.BigDecimal | null) // nullable {@link DsDataPoint#precipAccumulation() precipAccumulation}
   *    .precipIntensity(java.math.BigDecimal | null) // nullable {@link DsDataPoint#precipIntensity() precipIntensity}
   *    .precipIntensityError(java.math.BigDecimal | null) // nullable {@link DsDataPoint#precipIntensityError() precipIntensityError}
   *    .precipIntensityMax(java.math.BigDecimal | null) // nullable {@link DsDataPoint#precipIntensityMax() precipIntensityMax}
   *    .precipIntensityMaxTime(Long | null) // nullable {@link DsDataPoint#precipIntensityMaxTime() precipIntensityMaxTime}
   *    .precipProbability(java.math.BigDecimal | null) // nullable {@link DsDataPoint#precipProbability() precipProbability}
   *    .precipType(ch.rasc.darksky.model.DsPrecipType | null) // nullable {@link DsDataPoint#precipType() precipType}
   *    .pressure(java.math.BigDecimal | null) // nullable {@link DsDataPoint#pressure() pressure}
   *    .summary(String | null) // nullable {@link DsDataPoint#summary() summary}
   *    .sunriseTime(Long | null) // nullable {@link DsDataPoint#sunriseTime() sunriseTime}
   *    .sunsetTime(Long | null) // nullable {@link DsDataPoint#sunsetTime() sunsetTime}
   *    .temperature(java.math.BigDecimal | null) // nullable {@link DsDataPoint#temperature() temperature}
   *    .temperatureHigh(java.math.BigDecimal | null) // nullable {@link DsDataPoint#temperatureHigh() temperatureHigh}
   *    .temperatureHighTime(Long | null) // nullable {@link DsDataPoint#temperatureHighTime() temperatureHighTime}
   *    .temperatureLow(java.math.BigDecimal | null) // nullable {@link DsDataPoint#temperatureLow() temperatureLow}
   *    .temperatureLowTime(Long | null) // nullable {@link DsDataPoint#temperatureLowTime() temperatureLowTime}
   *    .temperatureMax(java.math.BigDecimal | null) // nullable {@link DsDataPoint#temperatureMax() temperatureMax}
   *    .temperatureMaxTime(Long | null) // nullable {@link DsDataPoint#temperatureMaxTime() temperatureMaxTime}
   *    .temperatureMin(java.math.BigDecimal | null) // nullable {@link DsDataPoint#temperatureMin() temperatureMin}
   *    .temperatureMinTime(Long | null) // nullable {@link DsDataPoint#temperatureMinTime() temperatureMinTime}
   *    .time(long) // required {@link DsDataPoint#time() time}
   *    .uvIndex(Integer | null) // nullable {@link DsDataPoint#uvIndex() uvIndex}
   *    .uvIndexTime(Long | null) // nullable {@link DsDataPoint#uvIndexTime() uvIndexTime}
   *    .visibility(java.math.BigDecimal | null) // nullable {@link DsDataPoint#visibility() visibility}
   *    .windBearing(java.math.BigDecimal | null) // nullable {@link DsDataPoint#windBearing() windBearing}
   *    .windGust(java.math.BigDecimal | null) // nullable {@link DsDataPoint#windGust() windGust}
   *    .windGustTime(Long | null) // nullable {@link DsDataPoint#windGustTime() windGustTime}
   *    .windSpeed(java.math.BigDecimal | null) // nullable {@link DsDataPoint#windSpeed() windSpeed}
   *    .build();
   * </pre>
   * @return A new ImmutableDsDataPoint builder
   */
  public static ImmutableDsDataPoint.Builder builder() {
    return new ImmutableDsDataPoint.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDsDataPoint ImmutableDsDataPoint}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DsDataPoint", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TIME = 0x1L;
    private long initBits = 0x1L;

    private @Nullable BigDecimal apparentTemperature;
    private @Nullable BigDecimal apparentTemperatureHigh;
    private @Nullable Long apparentTemperatureHighTime;
    private @Nullable BigDecimal apparentTemperatureLow;
    private @Nullable Long apparentTemperatureLowTime;
    private @Nullable BigDecimal apparentTemperatureMax;
    private @Nullable Long apparentTemperatureMaxTime;
    private @Nullable BigDecimal apparentTemperatureMin;
    private @Nullable Long apparentTemperatureMinTime;
    private @Nullable BigDecimal cloudCover;
    private @Nullable BigDecimal dewPoint;
    private @Nullable BigDecimal humidity;
    private @Nullable DsIcon icon;
    private @Nullable BigDecimal moonPhase;
    private @Nullable BigDecimal nearestStormBearing;
    private @Nullable BigDecimal nearestStormDistance;
    private @Nullable BigDecimal ozone;
    private @Nullable BigDecimal precipAccumulation;
    private @Nullable BigDecimal precipIntensity;
    private @Nullable BigDecimal precipIntensityError;
    private @Nullable BigDecimal precipIntensityMax;
    private @Nullable Long precipIntensityMaxTime;
    private @Nullable BigDecimal precipProbability;
    private @Nullable DsPrecipType precipType;
    private @Nullable BigDecimal pressure;
    private @Nullable String summary;
    private @Nullable Long sunriseTime;
    private @Nullable Long sunsetTime;
    private @Nullable BigDecimal temperature;
    private @Nullable BigDecimal temperatureHigh;
    private @Nullable Long temperatureHighTime;
    private @Nullable BigDecimal temperatureLow;
    private @Nullable Long temperatureLowTime;
    private @Nullable BigDecimal temperatureMax;
    private @Nullable Long temperatureMaxTime;
    private @Nullable BigDecimal temperatureMin;
    private @Nullable Long temperatureMinTime;
    private long time;
    private @Nullable Integer uvIndex;
    private @Nullable Long uvIndexTime;
    private @Nullable BigDecimal visibility;
    private @Nullable BigDecimal windBearing;
    private @Nullable BigDecimal windGust;
    private @Nullable Long windGustTime;
    private @Nullable BigDecimal windSpeed;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DsDataPoint} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DsDataPoint instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable BigDecimal apparentTemperatureValue = instance.apparentTemperature();
      if (apparentTemperatureValue != null) {
        apparentTemperature(apparentTemperatureValue);
      }
      @Nullable BigDecimal apparentTemperatureHighValue = instance.apparentTemperatureHigh();
      if (apparentTemperatureHighValue != null) {
        apparentTemperatureHigh(apparentTemperatureHighValue);
      }
      @Nullable Long apparentTemperatureHighTimeValue = instance.apparentTemperatureHighTime();
      if (apparentTemperatureHighTimeValue != null) {
        apparentTemperatureHighTime(apparentTemperatureHighTimeValue);
      }
      @Nullable BigDecimal apparentTemperatureLowValue = instance.apparentTemperatureLow();
      if (apparentTemperatureLowValue != null) {
        apparentTemperatureLow(apparentTemperatureLowValue);
      }
      @Nullable Long apparentTemperatureLowTimeValue = instance.apparentTemperatureLowTime();
      if (apparentTemperatureLowTimeValue != null) {
        apparentTemperatureLowTime(apparentTemperatureLowTimeValue);
      }
      @Nullable BigDecimal apparentTemperatureMaxValue = instance.apparentTemperatureMax();
      if (apparentTemperatureMaxValue != null) {
        apparentTemperatureMax(apparentTemperatureMaxValue);
      }
      @Nullable Long apparentTemperatureMaxTimeValue = instance.apparentTemperatureMaxTime();
      if (apparentTemperatureMaxTimeValue != null) {
        apparentTemperatureMaxTime(apparentTemperatureMaxTimeValue);
      }
      @Nullable BigDecimal apparentTemperatureMinValue = instance.apparentTemperatureMin();
      if (apparentTemperatureMinValue != null) {
        apparentTemperatureMin(apparentTemperatureMinValue);
      }
      @Nullable Long apparentTemperatureMinTimeValue = instance.apparentTemperatureMinTime();
      if (apparentTemperatureMinTimeValue != null) {
        apparentTemperatureMinTime(apparentTemperatureMinTimeValue);
      }
      @Nullable BigDecimal cloudCoverValue = instance.cloudCover();
      if (cloudCoverValue != null) {
        cloudCover(cloudCoverValue);
      }
      @Nullable BigDecimal dewPointValue = instance.dewPoint();
      if (dewPointValue != null) {
        dewPoint(dewPointValue);
      }
      @Nullable BigDecimal humidityValue = instance.humidity();
      if (humidityValue != null) {
        humidity(humidityValue);
      }
      @Nullable DsIcon iconValue = instance.icon();
      if (iconValue != null) {
        icon(iconValue);
      }
      @Nullable BigDecimal moonPhaseValue = instance.moonPhase();
      if (moonPhaseValue != null) {
        moonPhase(moonPhaseValue);
      }
      @Nullable BigDecimal nearestStormBearingValue = instance.nearestStormBearing();
      if (nearestStormBearingValue != null) {
        nearestStormBearing(nearestStormBearingValue);
      }
      @Nullable BigDecimal nearestStormDistanceValue = instance.nearestStormDistance();
      if (nearestStormDistanceValue != null) {
        nearestStormDistance(nearestStormDistanceValue);
      }
      @Nullable BigDecimal ozoneValue = instance.ozone();
      if (ozoneValue != null) {
        ozone(ozoneValue);
      }
      @Nullable BigDecimal precipAccumulationValue = instance.precipAccumulation();
      if (precipAccumulationValue != null) {
        precipAccumulation(precipAccumulationValue);
      }
      @Nullable BigDecimal precipIntensityValue = instance.precipIntensity();
      if (precipIntensityValue != null) {
        precipIntensity(precipIntensityValue);
      }
      @Nullable BigDecimal precipIntensityErrorValue = instance.precipIntensityError();
      if (precipIntensityErrorValue != null) {
        precipIntensityError(precipIntensityErrorValue);
      }
      @Nullable BigDecimal precipIntensityMaxValue = instance.precipIntensityMax();
      if (precipIntensityMaxValue != null) {
        precipIntensityMax(precipIntensityMaxValue);
      }
      @Nullable Long precipIntensityMaxTimeValue = instance.precipIntensityMaxTime();
      if (precipIntensityMaxTimeValue != null) {
        precipIntensityMaxTime(precipIntensityMaxTimeValue);
      }
      @Nullable BigDecimal precipProbabilityValue = instance.precipProbability();
      if (precipProbabilityValue != null) {
        precipProbability(precipProbabilityValue);
      }
      @Nullable DsPrecipType precipTypeValue = instance.precipType();
      if (precipTypeValue != null) {
        precipType(precipTypeValue);
      }
      @Nullable BigDecimal pressureValue = instance.pressure();
      if (pressureValue != null) {
        pressure(pressureValue);
      }
      @Nullable String summaryValue = instance.summary();
      if (summaryValue != null) {
        summary(summaryValue);
      }
      @Nullable Long sunriseTimeValue = instance.sunriseTime();
      if (sunriseTimeValue != null) {
        sunriseTime(sunriseTimeValue);
      }
      @Nullable Long sunsetTimeValue = instance.sunsetTime();
      if (sunsetTimeValue != null) {
        sunsetTime(sunsetTimeValue);
      }
      @Nullable BigDecimal temperatureValue = instance.temperature();
      if (temperatureValue != null) {
        temperature(temperatureValue);
      }
      @Nullable BigDecimal temperatureHighValue = instance.temperatureHigh();
      if (temperatureHighValue != null) {
        temperatureHigh(temperatureHighValue);
      }
      @Nullable Long temperatureHighTimeValue = instance.temperatureHighTime();
      if (temperatureHighTimeValue != null) {
        temperatureHighTime(temperatureHighTimeValue);
      }
      @Nullable BigDecimal temperatureLowValue = instance.temperatureLow();
      if (temperatureLowValue != null) {
        temperatureLow(temperatureLowValue);
      }
      @Nullable Long temperatureLowTimeValue = instance.temperatureLowTime();
      if (temperatureLowTimeValue != null) {
        temperatureLowTime(temperatureLowTimeValue);
      }
      @Nullable BigDecimal temperatureMaxValue = instance.temperatureMax();
      if (temperatureMaxValue != null) {
        temperatureMax(temperatureMaxValue);
      }
      @Nullable Long temperatureMaxTimeValue = instance.temperatureMaxTime();
      if (temperatureMaxTimeValue != null) {
        temperatureMaxTime(temperatureMaxTimeValue);
      }
      @Nullable BigDecimal temperatureMinValue = instance.temperatureMin();
      if (temperatureMinValue != null) {
        temperatureMin(temperatureMinValue);
      }
      @Nullable Long temperatureMinTimeValue = instance.temperatureMinTime();
      if (temperatureMinTimeValue != null) {
        temperatureMinTime(temperatureMinTimeValue);
      }
      time(instance.time());
      @Nullable Integer uvIndexValue = instance.uvIndex();
      if (uvIndexValue != null) {
        uvIndex(uvIndexValue);
      }
      @Nullable Long uvIndexTimeValue = instance.uvIndexTime();
      if (uvIndexTimeValue != null) {
        uvIndexTime(uvIndexTimeValue);
      }
      @Nullable BigDecimal visibilityValue = instance.visibility();
      if (visibilityValue != null) {
        visibility(visibilityValue);
      }
      @Nullable BigDecimal windBearingValue = instance.windBearing();
      if (windBearingValue != null) {
        windBearing(windBearingValue);
      }
      @Nullable BigDecimal windGustValue = instance.windGust();
      if (windGustValue != null) {
        windGust(windGustValue);
      }
      @Nullable Long windGustTimeValue = instance.windGustTime();
      if (windGustTimeValue != null) {
        windGustTime(windGustTimeValue);
      }
      @Nullable BigDecimal windSpeedValue = instance.windSpeed();
      if (windSpeedValue != null) {
        windSpeed(windSpeedValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#apparentTemperature() apparentTemperature} attribute.
     * @param apparentTemperature The value for apparentTemperature (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("apparentTemperature")
    public final Builder apparentTemperature(@Nullable BigDecimal apparentTemperature) {
      this.apparentTemperature = apparentTemperature;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#apparentTemperatureHigh() apparentTemperatureHigh} attribute.
     * @param apparentTemperatureHigh The value for apparentTemperatureHigh (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("apparentTemperatureHigh")
    public final Builder apparentTemperatureHigh(@Nullable BigDecimal apparentTemperatureHigh) {
      this.apparentTemperatureHigh = apparentTemperatureHigh;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#apparentTemperatureHighTime() apparentTemperatureHighTime} attribute.
     * @param apparentTemperatureHighTime The value for apparentTemperatureHighTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("apparentTemperatureHighTime")
    public final Builder apparentTemperatureHighTime(@Nullable Long apparentTemperatureHighTime) {
      this.apparentTemperatureHighTime = apparentTemperatureHighTime;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#apparentTemperatureLow() apparentTemperatureLow} attribute.
     * @param apparentTemperatureLow The value for apparentTemperatureLow (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("apparentTemperatureLow")
    public final Builder apparentTemperatureLow(@Nullable BigDecimal apparentTemperatureLow) {
      this.apparentTemperatureLow = apparentTemperatureLow;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#apparentTemperatureLowTime() apparentTemperatureLowTime} attribute.
     * @param apparentTemperatureLowTime The value for apparentTemperatureLowTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("apparentTemperatureLowTime")
    public final Builder apparentTemperatureLowTime(@Nullable Long apparentTemperatureLowTime) {
      this.apparentTemperatureLowTime = apparentTemperatureLowTime;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#apparentTemperatureMax() apparentTemperatureMax} attribute.
     * @param apparentTemperatureMax The value for apparentTemperatureMax (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("apparentTemperatureMax")
    public final Builder apparentTemperatureMax(@Nullable BigDecimal apparentTemperatureMax) {
      this.apparentTemperatureMax = apparentTemperatureMax;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#apparentTemperatureMaxTime() apparentTemperatureMaxTime} attribute.
     * @param apparentTemperatureMaxTime The value for apparentTemperatureMaxTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("apparentTemperatureMaxTime")
    public final Builder apparentTemperatureMaxTime(@Nullable Long apparentTemperatureMaxTime) {
      this.apparentTemperatureMaxTime = apparentTemperatureMaxTime;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#apparentTemperatureMin() apparentTemperatureMin} attribute.
     * @param apparentTemperatureMin The value for apparentTemperatureMin (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("apparentTemperatureMin")
    public final Builder apparentTemperatureMin(@Nullable BigDecimal apparentTemperatureMin) {
      this.apparentTemperatureMin = apparentTemperatureMin;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#apparentTemperatureMinTime() apparentTemperatureMinTime} attribute.
     * @param apparentTemperatureMinTime The value for apparentTemperatureMinTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("apparentTemperatureMinTime")
    public final Builder apparentTemperatureMinTime(@Nullable Long apparentTemperatureMinTime) {
      this.apparentTemperatureMinTime = apparentTemperatureMinTime;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#cloudCover() cloudCover} attribute.
     * @param cloudCover The value for cloudCover (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("cloudCover")
    public final Builder cloudCover(@Nullable BigDecimal cloudCover) {
      this.cloudCover = cloudCover;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#dewPoint() dewPoint} attribute.
     * @param dewPoint The value for dewPoint (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("dewPoint")
    public final Builder dewPoint(@Nullable BigDecimal dewPoint) {
      this.dewPoint = dewPoint;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#humidity() humidity} attribute.
     * @param humidity The value for humidity (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("humidity")
    public final Builder humidity(@Nullable BigDecimal humidity) {
      this.humidity = humidity;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#icon() icon} attribute.
     * @param icon The value for icon (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("icon")
    @JsonDeserialize(using = DsIconDeserializer.class)
    public final Builder icon(@Nullable DsIcon icon) {
      this.icon = icon;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#moonPhase() moonPhase} attribute.
     * @param moonPhase The value for moonPhase (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("moonPhase")
    public final Builder moonPhase(@Nullable BigDecimal moonPhase) {
      this.moonPhase = moonPhase;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#nearestStormBearing() nearestStormBearing} attribute.
     * @param nearestStormBearing The value for nearestStormBearing (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("nearestStormBearing")
    public final Builder nearestStormBearing(@Nullable BigDecimal nearestStormBearing) {
      this.nearestStormBearing = nearestStormBearing;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#nearestStormDistance() nearestStormDistance} attribute.
     * @param nearestStormDistance The value for nearestStormDistance (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("nearestStormDistance")
    public final Builder nearestStormDistance(@Nullable BigDecimal nearestStormDistance) {
      this.nearestStormDistance = nearestStormDistance;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#ozone() ozone} attribute.
     * @param ozone The value for ozone (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ozone")
    public final Builder ozone(@Nullable BigDecimal ozone) {
      this.ozone = ozone;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#precipAccumulation() precipAccumulation} attribute.
     * @param precipAccumulation The value for precipAccumulation (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("precipAccumulation")
    public final Builder precipAccumulation(@Nullable BigDecimal precipAccumulation) {
      this.precipAccumulation = precipAccumulation;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#precipIntensity() precipIntensity} attribute.
     * @param precipIntensity The value for precipIntensity (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("precipIntensity")
    public final Builder precipIntensity(@Nullable BigDecimal precipIntensity) {
      this.precipIntensity = precipIntensity;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#precipIntensityError() precipIntensityError} attribute.
     * @param precipIntensityError The value for precipIntensityError (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("precipIntensityError")
    public final Builder precipIntensityError(@Nullable BigDecimal precipIntensityError) {
      this.precipIntensityError = precipIntensityError;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#precipIntensityMax() precipIntensityMax} attribute.
     * @param precipIntensityMax The value for precipIntensityMax (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("precipIntensityMax")
    public final Builder precipIntensityMax(@Nullable BigDecimal precipIntensityMax) {
      this.precipIntensityMax = precipIntensityMax;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#precipIntensityMaxTime() precipIntensityMaxTime} attribute.
     * @param precipIntensityMaxTime The value for precipIntensityMaxTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("precipIntensityMaxTime")
    public final Builder precipIntensityMaxTime(@Nullable Long precipIntensityMaxTime) {
      this.precipIntensityMaxTime = precipIntensityMaxTime;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#precipProbability() precipProbability} attribute.
     * @param precipProbability The value for precipProbability (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("precipProbability")
    public final Builder precipProbability(@Nullable BigDecimal precipProbability) {
      this.precipProbability = precipProbability;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#precipType() precipType} attribute.
     * @param precipType The value for precipType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("precipType")
    @JsonDeserialize(using = DsPrecipTypeDeserializer.class)
    public final Builder precipType(@Nullable DsPrecipType precipType) {
      this.precipType = precipType;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#pressure() pressure} attribute.
     * @param pressure The value for pressure (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("pressure")
    public final Builder pressure(@Nullable BigDecimal pressure) {
      this.pressure = pressure;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#summary() summary} attribute.
     * @param summary The value for summary (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("summary")
    public final Builder summary(@Nullable String summary) {
      this.summary = summary;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#sunriseTime() sunriseTime} attribute.
     * @param sunriseTime The value for sunriseTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("sunriseTime")
    public final Builder sunriseTime(@Nullable Long sunriseTime) {
      this.sunriseTime = sunriseTime;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#sunsetTime() sunsetTime} attribute.
     * @param sunsetTime The value for sunsetTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("sunsetTime")
    public final Builder sunsetTime(@Nullable Long sunsetTime) {
      this.sunsetTime = sunsetTime;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#temperature() temperature} attribute.
     * @param temperature The value for temperature (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("temperature")
    public final Builder temperature(@Nullable BigDecimal temperature) {
      this.temperature = temperature;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#temperatureHigh() temperatureHigh} attribute.
     * @param temperatureHigh The value for temperatureHigh (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("temperatureHigh")
    public final Builder temperatureHigh(@Nullable BigDecimal temperatureHigh) {
      this.temperatureHigh = temperatureHigh;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#temperatureHighTime() temperatureHighTime} attribute.
     * @param temperatureHighTime The value for temperatureHighTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("temperatureHighTime")
    public final Builder temperatureHighTime(@Nullable Long temperatureHighTime) {
      this.temperatureHighTime = temperatureHighTime;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#temperatureLow() temperatureLow} attribute.
     * @param temperatureLow The value for temperatureLow (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("temperatureLow")
    public final Builder temperatureLow(@Nullable BigDecimal temperatureLow) {
      this.temperatureLow = temperatureLow;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#temperatureLowTime() temperatureLowTime} attribute.
     * @param temperatureLowTime The value for temperatureLowTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("temperatureLowTime")
    public final Builder temperatureLowTime(@Nullable Long temperatureLowTime) {
      this.temperatureLowTime = temperatureLowTime;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#temperatureMax() temperatureMax} attribute.
     * @param temperatureMax The value for temperatureMax (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("temperatureMax")
    public final Builder temperatureMax(@Nullable BigDecimal temperatureMax) {
      this.temperatureMax = temperatureMax;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#temperatureMaxTime() temperatureMaxTime} attribute.
     * @param temperatureMaxTime The value for temperatureMaxTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("temperatureMaxTime")
    public final Builder temperatureMaxTime(@Nullable Long temperatureMaxTime) {
      this.temperatureMaxTime = temperatureMaxTime;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#temperatureMin() temperatureMin} attribute.
     * @param temperatureMin The value for temperatureMin (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("temperatureMin")
    public final Builder temperatureMin(@Nullable BigDecimal temperatureMin) {
      this.temperatureMin = temperatureMin;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#temperatureMinTime() temperatureMinTime} attribute.
     * @param temperatureMinTime The value for temperatureMinTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("temperatureMinTime")
    public final Builder temperatureMinTime(@Nullable Long temperatureMinTime) {
      this.temperatureMinTime = temperatureMinTime;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#time() time} attribute.
     * @param time The value for time 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("time")
    public final Builder time(long time) {
      this.time = time;
      initBits &= ~INIT_BIT_TIME;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#uvIndex() uvIndex} attribute.
     * @param uvIndex The value for uvIndex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("uvIndex")
    public final Builder uvIndex(@Nullable Integer uvIndex) {
      this.uvIndex = uvIndex;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#uvIndexTime() uvIndexTime} attribute.
     * @param uvIndexTime The value for uvIndexTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("uvIndexTime")
    public final Builder uvIndexTime(@Nullable Long uvIndexTime) {
      this.uvIndexTime = uvIndexTime;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#visibility() visibility} attribute.
     * @param visibility The value for visibility (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("visibility")
    public final Builder visibility(@Nullable BigDecimal visibility) {
      this.visibility = visibility;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#windBearing() windBearing} attribute.
     * @param windBearing The value for windBearing (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("windBearing")
    public final Builder windBearing(@Nullable BigDecimal windBearing) {
      this.windBearing = windBearing;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#windGust() windGust} attribute.
     * @param windGust The value for windGust (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("windGust")
    public final Builder windGust(@Nullable BigDecimal windGust) {
      this.windGust = windGust;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#windGustTime() windGustTime} attribute.
     * @param windGustTime The value for windGustTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("windGustTime")
    public final Builder windGustTime(@Nullable Long windGustTime) {
      this.windGustTime = windGustTime;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataPoint#windSpeed() windSpeed} attribute.
     * @param windSpeed The value for windSpeed (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("windSpeed")
    public final Builder windSpeed(@Nullable BigDecimal windSpeed) {
      this.windSpeed = windSpeed;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDsDataPoint ImmutableDsDataPoint}.
     * @return An immutable instance of DsDataPoint
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDsDataPoint build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDsDataPoint(
          apparentTemperature,
          apparentTemperatureHigh,
          apparentTemperatureHighTime,
          apparentTemperatureLow,
          apparentTemperatureLowTime,
          apparentTemperatureMax,
          apparentTemperatureMaxTime,
          apparentTemperatureMin,
          apparentTemperatureMinTime,
          cloudCover,
          dewPoint,
          humidity,
          icon,
          moonPhase,
          nearestStormBearing,
          nearestStormDistance,
          ozone,
          precipAccumulation,
          precipIntensity,
          precipIntensityError,
          precipIntensityMax,
          precipIntensityMaxTime,
          precipProbability,
          precipType,
          pressure,
          summary,
          sunriseTime,
          sunsetTime,
          temperature,
          temperatureHigh,
          temperatureHighTime,
          temperatureLow,
          temperatureLowTime,
          temperatureMax,
          temperatureMaxTime,
          temperatureMin,
          temperatureMinTime,
          time,
          uvIndex,
          uvIndexTime,
          visibility,
          windBearing,
          windGust,
          windGustTime,
          windSpeed);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TIME) != 0) attributes.add("time");
      return "Cannot build DsDataPoint, some of required attributes are not set " + attributes;
    }
  }
}
