package ch.rasc.darksky.model;

import ch.rasc.darksky.converter.DsIconDeserializer;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DsDataBlock}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDsDataBlock.builder()}.
 */
@Generated(from = "DsDataBlock", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableDsDataBlock implements DsDataBlock {
  private final @Nullable String summary;
  private final @Nullable DsIcon icon;
  private final List<DsDataPoint> data;

  private ImmutableDsDataBlock(
      @Nullable String summary,
      @Nullable DsIcon icon,
      List<DsDataPoint> data) {
    this.summary = summary;
    this.icon = icon;
    this.data = data;
  }

  /**
   * A human-readable summary of this data block.
   */
  @JsonProperty("summary")
  @Override
  public @Nullable String summary() {
    return summary;
  }

  /**
   * A machine-readable text summary of this data block. (May take on the same values as
   * {@link DsDataPoint#icon()}.)
   */
  @JsonProperty("icon")
  @JsonDeserialize(using = DsIconDeserializer.class)
  @Override
  public @Nullable DsIcon icon() {
    return icon;
  }

  /**
   * A list of {@link DsDataPoint} instances, ordered by time, which together describe
   * the weather conditions at the requested location over time.
   */
  @JsonProperty("data")
  @Override
  public List<DsDataPoint> data() {
    return data;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataBlock#summary() summary} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for summary (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataBlock withSummary(@Nullable String value) {
    if (Objects.equals(this.summary, value)) return this;
    return new ImmutableDsDataBlock(value, this.icon, this.data);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsDataBlock#icon() icon} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for icon (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsDataBlock withIcon(@Nullable DsIcon value) {
    if (this.icon == value) return this;
    if (Objects.equals(this.icon, value)) return this;
    return new ImmutableDsDataBlock(this.summary, value, this.data);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DsDataBlock#data() data}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDsDataBlock withData(DsDataPoint... elements) {
    List<DsDataPoint> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableDsDataBlock(this.summary, this.icon, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DsDataBlock#data() data}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of data elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDsDataBlock withData(Iterable<? extends DsDataPoint> elements) {
    if (this.data == elements) return this;
    List<DsDataPoint> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableDsDataBlock(this.summary, this.icon, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDsDataBlock} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDsDataBlock
        && equalTo((ImmutableDsDataBlock) another);
  }

  private boolean equalTo(ImmutableDsDataBlock another) {
    return Objects.equals(summary, another.summary)
        && Objects.equals(icon, another.icon)
        && data.equals(another.data);
  }

  /**
   * Computes a hash code from attributes: {@code summary}, {@code icon}, {@code data}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(summary);
    h += (h << 5) + Objects.hashCode(icon);
    h += (h << 5) + data.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DsDataBlock} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DsDataBlock{"
        + "summary=" + summary
        + ", icon=" + icon
        + ", data=" + data
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DsDataBlock", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DsDataBlock {
    @Nullable String summary;
    @Nullable DsIcon icon;
    @Nullable List<DsDataPoint> data = Collections.emptyList();
    @JsonProperty("summary")
    public void setSummary(@Nullable String summary) {
      this.summary = summary;
    }
    @JsonProperty("icon")
    @JsonDeserialize(using = DsIconDeserializer.class)
    public void setIcon(@Nullable DsIcon icon) {
      this.icon = icon;
    }
    @JsonProperty("data")
    public void setData(List<DsDataPoint> data) {
      this.data = data;
    }
    @Override
    public String summary() { throw new UnsupportedOperationException(); }
    @Override
    public DsIcon icon() { throw new UnsupportedOperationException(); }
    @Override
    public List<DsDataPoint> data() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDsDataBlock fromJson(Json json) {
    ImmutableDsDataBlock.Builder builder = ImmutableDsDataBlock.builder();
    if (json.summary != null) {
      builder.summary(json.summary);
    }
    if (json.icon != null) {
      builder.icon(json.icon);
    }
    if (json.data != null) {
      builder.addAllData(json.data);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DsDataBlock} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DsDataBlock instance
   */
  public static ImmutableDsDataBlock copyOf(DsDataBlock instance) {
    if (instance instanceof ImmutableDsDataBlock) {
      return (ImmutableDsDataBlock) instance;
    }
    return ImmutableDsDataBlock.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDsDataBlock ImmutableDsDataBlock}.
   * <pre>
   * ImmutableDsDataBlock.builder()
   *    .summary(String | null) // nullable {@link DsDataBlock#summary() summary}
   *    .icon(ch.rasc.darksky.model.DsIcon | null) // nullable {@link DsDataBlock#icon() icon}
   *    .addData|addAllData(ch.rasc.darksky.model.DsDataPoint) // {@link DsDataBlock#data() data} elements
   *    .build();
   * </pre>
   * @return A new ImmutableDsDataBlock builder
   */
  public static ImmutableDsDataBlock.Builder builder() {
    return new ImmutableDsDataBlock.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDsDataBlock ImmutableDsDataBlock}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DsDataBlock", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String summary;
    private @Nullable DsIcon icon;
    private List<DsDataPoint> data = new ArrayList<DsDataPoint>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DsDataBlock} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DsDataBlock instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String summaryValue = instance.summary();
      if (summaryValue != null) {
        summary(summaryValue);
      }
      @Nullable DsIcon iconValue = instance.icon();
      if (iconValue != null) {
        icon(iconValue);
      }
      addAllData(instance.data());
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataBlock#summary() summary} attribute.
     * @param summary The value for summary (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("summary")
    public final Builder summary(@Nullable String summary) {
      this.summary = summary;
      return this;
    }

    /**
     * Initializes the value for the {@link DsDataBlock#icon() icon} attribute.
     * @param icon The value for icon (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("icon")
    @JsonDeserialize(using = DsIconDeserializer.class)
    public final Builder icon(@Nullable DsIcon icon) {
      this.icon = icon;
      return this;
    }

    /**
     * Adds one element to {@link DsDataBlock#data() data} list.
     * @param element A data element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addData(DsDataPoint element) {
      this.data.add(Objects.requireNonNull(element, "data element"));
      return this;
    }

    /**
     * Adds elements to {@link DsDataBlock#data() data} list.
     * @param elements An array of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addData(DsDataPoint... elements) {
      for (DsDataPoint element : elements) {
        this.data.add(Objects.requireNonNull(element, "data element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DsDataBlock#data() data} list.
     * @param elements An iterable of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("data")
    public final Builder data(Iterable<? extends DsDataPoint> elements) {
      this.data.clear();
      return addAllData(elements);
    }

    /**
     * Adds elements to {@link DsDataBlock#data() data} list.
     * @param elements An iterable of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllData(Iterable<? extends DsDataPoint> elements) {
      for (DsDataPoint element : elements) {
        this.data.add(Objects.requireNonNull(element, "data element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableDsDataBlock ImmutableDsDataBlock}.
     * @return An immutable instance of DsDataBlock
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDsDataBlock build() {
      return new ImmutableDsDataBlock(summary, icon, createUnmodifiableList(true, data));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
