package ch.rasc.darksky.model;

import ch.rasc.darksky.converter.DsAlertSeverityDeserializer;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DsAlert}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDsAlert.builder()}.
 */
@Generated(from = "DsAlert", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableDsAlert implements DsAlert {
  private final String description;
  private final long expires;
  private final List<String> regions;
  private final DsAlertSeverity severity;
  private final long time;
  private final String title;
  private final String uri;

  private ImmutableDsAlert(
      String description,
      long expires,
      List<String> regions,
      DsAlertSeverity severity,
      long time,
      String title,
      String uri) {
    this.description = description;
    this.expires = expires;
    this.regions = regions;
    this.severity = severity;
    this.time = time;
    this.title = title;
    this.uri = uri;
  }

  /**
   * A detailed description of the alert.
   */
  @JsonProperty("description")
  @Override
  public String description() {
    return description;
  }

  /**
   * The UNIX time at which the alert will expire.
   */
  @JsonProperty("expires")
  @Override
  public long expires() {
    return expires;
  }

  /**
   * A list of <code>String</code> representing the names of the regions covered by this
   * weather alert.
   */
  @JsonProperty("regions")
  @Override
  public List<String> regions() {
    return regions;
  }

  /**
   * The severity of the weather alert. Will take one of the following values:
   * {@link DsAlertSeverity#ADVISORY} (an individual should be aware of potentially
   * severe weather), {@link DsAlertSeverity#WATCH} (an individual should prepare for
   * potentially severe weather), or {@link DsAlertSeverity#WARNING} (an individual
   * should take immediate action to protect themselves and others from potentially
   * severe weather).
   */
  @JsonProperty("severity")
  @JsonDeserialize(using = DsAlertSeverityDeserializer.class)
  @Override
  public DsAlertSeverity severity() {
    return severity;
  }

  /**
   * The UNIX time at which the alert was issued.
   */
  @JsonProperty("time")
  @Override
  public long time() {
    return time;
  }

  /**
   * A brief description of the alert.
   */
  @JsonProperty("title")
  @Override
  public String title() {
    return title;
  }

  /**
   * An HTTP(S) URI that one may refer to for detailed information about the alert.
   */
  @JsonProperty("uri")
  @Override
  public String uri() {
    return uri;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsAlert#description() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsAlert withDescription(String value) {
    String newValue = Objects.requireNonNull(value, "description");
    if (this.description.equals(newValue)) return this;
    return new ImmutableDsAlert(newValue, this.expires, this.regions, this.severity, this.time, this.title, this.uri);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsAlert#expires() expires} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for expires
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsAlert withExpires(long value) {
    if (this.expires == value) return this;
    return new ImmutableDsAlert(this.description, value, this.regions, this.severity, this.time, this.title, this.uri);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DsAlert#regions() regions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDsAlert withRegions(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableDsAlert(this.description, this.expires, newValue, this.severity, this.time, this.title, this.uri);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DsAlert#regions() regions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of regions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDsAlert withRegions(Iterable<String> elements) {
    if (this.regions == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableDsAlert(this.description, this.expires, newValue, this.severity, this.time, this.title, this.uri);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsAlert#severity() severity} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for severity
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsAlert withSeverity(DsAlertSeverity value) {
    if (this.severity == value) return this;
    DsAlertSeverity newValue = Objects.requireNonNull(value, "severity");
    if (this.severity.equals(newValue)) return this;
    return new ImmutableDsAlert(this.description, this.expires, this.regions, newValue, this.time, this.title, this.uri);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsAlert#time() time} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for time
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsAlert withTime(long value) {
    if (this.time == value) return this;
    return new ImmutableDsAlert(this.description, this.expires, this.regions, this.severity, value, this.title, this.uri);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsAlert#title() title} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for title
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsAlert withTitle(String value) {
    String newValue = Objects.requireNonNull(value, "title");
    if (this.title.equals(newValue)) return this;
    return new ImmutableDsAlert(this.description, this.expires, this.regions, this.severity, this.time, newValue, this.uri);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsAlert#uri() uri} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for uri
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsAlert withUri(String value) {
    String newValue = Objects.requireNonNull(value, "uri");
    if (this.uri.equals(newValue)) return this;
    return new ImmutableDsAlert(this.description, this.expires, this.regions, this.severity, this.time, this.title, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDsAlert} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDsAlert
        && equalTo((ImmutableDsAlert) another);
  }

  private boolean equalTo(ImmutableDsAlert another) {
    return description.equals(another.description)
        && expires == another.expires
        && regions.equals(another.regions)
        && severity.equals(another.severity)
        && time == another.time
        && title.equals(another.title)
        && uri.equals(another.uri);
  }

  /**
   * Computes a hash code from attributes: {@code description}, {@code expires}, {@code regions}, {@code severity}, {@code time}, {@code title}, {@code uri}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + description.hashCode();
    h += (h << 5) + Long.hashCode(expires);
    h += (h << 5) + regions.hashCode();
    h += (h << 5) + severity.hashCode();
    h += (h << 5) + Long.hashCode(time);
    h += (h << 5) + title.hashCode();
    h += (h << 5) + uri.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DsAlert} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DsAlert{"
        + "description=" + description
        + ", expires=" + expires
        + ", regions=" + regions
        + ", severity=" + severity
        + ", time=" + time
        + ", title=" + title
        + ", uri=" + uri
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DsAlert", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DsAlert {
    @Nullable String description;
    long expires;
    boolean expiresIsSet;
    @Nullable List<String> regions = Collections.emptyList();
    @Nullable DsAlertSeverity severity;
    long time;
    boolean timeIsSet;
    @Nullable String title;
    @Nullable String uri;
    @JsonProperty("description")
    public void setDescription(String description) {
      this.description = description;
    }
    @JsonProperty("expires")
    public void setExpires(long expires) {
      this.expires = expires;
      this.expiresIsSet = true;
    }
    @JsonProperty("regions")
    public void setRegions(List<String> regions) {
      this.regions = regions;
    }
    @JsonProperty("severity")
    @JsonDeserialize(using = DsAlertSeverityDeserializer.class)
    public void setSeverity(DsAlertSeverity severity) {
      this.severity = severity;
    }
    @JsonProperty("time")
    public void setTime(long time) {
      this.time = time;
      this.timeIsSet = true;
    }
    @JsonProperty("title")
    public void setTitle(String title) {
      this.title = title;
    }
    @JsonProperty("uri")
    public void setUri(String uri) {
      this.uri = uri;
    }
    @Override
    public String description() { throw new UnsupportedOperationException(); }
    @Override
    public long expires() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> regions() { throw new UnsupportedOperationException(); }
    @Override
    public DsAlertSeverity severity() { throw new UnsupportedOperationException(); }
    @Override
    public long time() { throw new UnsupportedOperationException(); }
    @Override
    public String title() { throw new UnsupportedOperationException(); }
    @Override
    public String uri() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDsAlert fromJson(Json json) {
    ImmutableDsAlert.Builder builder = ImmutableDsAlert.builder();
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.expiresIsSet) {
      builder.expires(json.expires);
    }
    if (json.regions != null) {
      builder.addAllRegions(json.regions);
    }
    if (json.severity != null) {
      builder.severity(json.severity);
    }
    if (json.timeIsSet) {
      builder.time(json.time);
    }
    if (json.title != null) {
      builder.title(json.title);
    }
    if (json.uri != null) {
      builder.uri(json.uri);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DsAlert} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DsAlert instance
   */
  public static ImmutableDsAlert copyOf(DsAlert instance) {
    if (instance instanceof ImmutableDsAlert) {
      return (ImmutableDsAlert) instance;
    }
    return ImmutableDsAlert.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDsAlert ImmutableDsAlert}.
   * <pre>
   * ImmutableDsAlert.builder()
   *    .description(String) // required {@link DsAlert#description() description}
   *    .expires(long) // required {@link DsAlert#expires() expires}
   *    .addRegions|addAllRegions(String) // {@link DsAlert#regions() regions} elements
   *    .severity(ch.rasc.darksky.model.DsAlertSeverity) // required {@link DsAlert#severity() severity}
   *    .time(long) // required {@link DsAlert#time() time}
   *    .title(String) // required {@link DsAlert#title() title}
   *    .uri(String) // required {@link DsAlert#uri() uri}
   *    .build();
   * </pre>
   * @return A new ImmutableDsAlert builder
   */
  public static ImmutableDsAlert.Builder builder() {
    return new ImmutableDsAlert.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDsAlert ImmutableDsAlert}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DsAlert", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_DESCRIPTION = 0x1L;
    private static final long INIT_BIT_EXPIRES = 0x2L;
    private static final long INIT_BIT_SEVERITY = 0x4L;
    private static final long INIT_BIT_TIME = 0x8L;
    private static final long INIT_BIT_TITLE = 0x10L;
    private static final long INIT_BIT_URI = 0x20L;
    private long initBits = 0x3fL;

    private @Nullable String description;
    private long expires;
    private List<String> regions = new ArrayList<String>();
    private @Nullable DsAlertSeverity severity;
    private long time;
    private @Nullable String title;
    private @Nullable String uri;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DsAlert} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DsAlert instance) {
      Objects.requireNonNull(instance, "instance");
      description(instance.description());
      expires(instance.expires());
      addAllRegions(instance.regions());
      severity(instance.severity());
      time(instance.time());
      title(instance.title());
      uri(instance.uri());
      return this;
    }

    /**
     * Initializes the value for the {@link DsAlert#description() description} attribute.
     * @param description The value for description 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      initBits &= ~INIT_BIT_DESCRIPTION;
      return this;
    }

    /**
     * Initializes the value for the {@link DsAlert#expires() expires} attribute.
     * @param expires The value for expires 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("expires")
    public final Builder expires(long expires) {
      this.expires = expires;
      initBits &= ~INIT_BIT_EXPIRES;
      return this;
    }

    /**
     * Adds one element to {@link DsAlert#regions() regions} list.
     * @param element A regions element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addRegions(String element) {
      this.regions.add(Objects.requireNonNull(element, "regions element"));
      return this;
    }

    /**
     * Adds elements to {@link DsAlert#regions() regions} list.
     * @param elements An array of regions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addRegions(String... elements) {
      for (String element : elements) {
        this.regions.add(Objects.requireNonNull(element, "regions element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DsAlert#regions() regions} list.
     * @param elements An iterable of regions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("regions")
    public final Builder regions(Iterable<String> elements) {
      this.regions.clear();
      return addAllRegions(elements);
    }

    /**
     * Adds elements to {@link DsAlert#regions() regions} list.
     * @param elements An iterable of regions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllRegions(Iterable<String> elements) {
      for (String element : elements) {
        this.regions.add(Objects.requireNonNull(element, "regions element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DsAlert#severity() severity} attribute.
     * @param severity The value for severity 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("severity")
    @JsonDeserialize(using = DsAlertSeverityDeserializer.class)
    public final Builder severity(DsAlertSeverity severity) {
      this.severity = Objects.requireNonNull(severity, "severity");
      initBits &= ~INIT_BIT_SEVERITY;
      return this;
    }

    /**
     * Initializes the value for the {@link DsAlert#time() time} attribute.
     * @param time The value for time 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("time")
    public final Builder time(long time) {
      this.time = time;
      initBits &= ~INIT_BIT_TIME;
      return this;
    }

    /**
     * Initializes the value for the {@link DsAlert#title() title} attribute.
     * @param title The value for title 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("title")
    public final Builder title(String title) {
      this.title = Objects.requireNonNull(title, "title");
      initBits &= ~INIT_BIT_TITLE;
      return this;
    }

    /**
     * Initializes the value for the {@link DsAlert#uri() uri} attribute.
     * @param uri The value for uri 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("uri")
    public final Builder uri(String uri) {
      this.uri = Objects.requireNonNull(uri, "uri");
      initBits &= ~INIT_BIT_URI;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDsAlert ImmutableDsAlert}.
     * @return An immutable instance of DsAlert
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDsAlert build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDsAlert(description, expires, createUnmodifiableList(true, regions), severity, time, title, uri);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DESCRIPTION) != 0) attributes.add("description");
      if ((initBits & INIT_BIT_EXPIRES) != 0) attributes.add("expires");
      if ((initBits & INIT_BIT_SEVERITY) != 0) attributes.add("severity");
      if ((initBits & INIT_BIT_TIME) != 0) attributes.add("time");
      if ((initBits & INIT_BIT_TITLE) != 0) attributes.add("title");
      if ((initBits & INIT_BIT_URI) != 0) attributes.add("uri");
      return "Cannot build DsAlert, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
