/**
 * Copyright 2016-2020 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ch.rasc.darksky.model;

public enum DsLanguage {

	/** Arabic */
	AR,

	/** Azerbaijani */
	AZ,

	/** Belarusian */
	BE,

	/** Bulgarian */
	BG,

	/** Bengali */
	BN,

	/** Bosnian */
	BS,

	/** Catalan */
	CA,

	/** Czech */
	CS,

	/** Danish */
	DA,

	/** German */
	DE,

	/** Greek */
	EL,

	/** English (default) */
	EN,

	/** Esperanto */
	EO,

	/** Spanish */
	ES,

	/** Estonian */
	ET,

	/** Finnish */
	FI,

	/** French */
	FR,

	/** Hebrew */
	HE,

	/** Hindi */
	HI,

	/** Croatian */
	HR,

	/** Hungarian */
	HU,

	/** Indonesian */
	ID,

	/** Icelandic */
	IS,

	/** Italian */
	IT,

	/** Georgian */
	KA,

	/** Kannada */
	KN,

	/** Korean */
	KO,

	/** Cornish */
	KW,

	/** Latvian */
	LV,

	/** Malayam */
	ML,

	/** Marathi */
	MR,

	/** Norwegian Bokmål */
	NB,

	/** Dutch */
	NL,

	/** Norwegian Bokmål (alias for {@link #NB}) */
	NO,

	/** Punjabi */
	PA,

	/** Polish */
	PL,

	/** Portuguese */
	PT,

	/** Romanian */
	RO,

	/** Russian */
	RU,

	/** Slovak */
	SK,

	/** Slovenian */
	SL,

	/** Serbian */
	SR,

	/** Swedish */
	SV,

	/** Tamil */
	TA,

	/** Telugu */
	TE,

	/** Tetum */
	TET,

	/** Turkish */
	TR,

	/** Ukrainian */
	UK,

	/** Urdu */
	UR,

	/** Igpay Atinlay */
	X_PIG_LATIN,

	/** simplified Chinese */
	ZH,

	/** traditional Chinese */
	ZH_TW
}
