/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.darksky.model;

import ch.rasc.darksky.model.DsBlock;
import ch.rasc.darksky.model.DsForecastRequest;
import ch.rasc.darksky.model.DsLanguage;
import ch.rasc.darksky.model.DsUnit;
import ch.rasc.darksky.model.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

final class ImmutableDsForecastRequest
implements DsForecastRequest {
    private final String latitude;
    private final String longitude;
    @Nullable
    private final Boolean extendHourly;
    @Nullable
    private final DsLanguage language;
    @Nullable
    private final DsUnit unit;
    private final Set<DsBlock> excludeBlocks;
    private final Set<DsBlock> includeBlocks;

    private ImmutableDsForecastRequest(String latitude, String longitude, @Nullable Boolean extendHourly, @Nullable DsLanguage language, @Nullable DsUnit unit, Set<DsBlock> excludeBlocks, Set<DsBlock> includeBlocks) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.extendHourly = extendHourly;
        this.language = language;
        this.unit = unit;
        this.excludeBlocks = excludeBlocks;
        this.includeBlocks = includeBlocks;
    }

    @Override
    public String latitude() {
        return this.latitude;
    }

    @Override
    public String longitude() {
        return this.longitude;
    }

    @Override
    @Nullable
    public Boolean extendHourly() {
        return this.extendHourly;
    }

    @Override
    @Nullable
    public DsLanguage language() {
        return this.language;
    }

    @Override
    @Nullable
    public DsUnit unit() {
        return this.unit;
    }

    @Override
    public Set<DsBlock> excludeBlocks() {
        return this.excludeBlocks;
    }

    @Override
    public Set<DsBlock> includeBlocks() {
        return this.includeBlocks;
    }

    public final ImmutableDsForecastRequest withLatitude(String value) {
        if (this.latitude.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "latitude");
        return new ImmutableDsForecastRequest(newValue, this.longitude, this.extendHourly, this.language, this.unit, this.excludeBlocks, this.includeBlocks);
    }

    public final ImmutableDsForecastRequest withLongitude(String value) {
        if (this.longitude.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "longitude");
        return new ImmutableDsForecastRequest(this.latitude, newValue, this.extendHourly, this.language, this.unit, this.excludeBlocks, this.includeBlocks);
    }

    public final ImmutableDsForecastRequest withExtendHourly(@Nullable Boolean value) {
        if (Objects.equals(this.extendHourly, value)) {
            return this;
        }
        return new ImmutableDsForecastRequest(this.latitude, this.longitude, value, this.language, this.unit, this.excludeBlocks, this.includeBlocks);
    }

    public final ImmutableDsForecastRequest withLanguage(@Nullable DsLanguage value) {
        if (this.language == value) {
            return this;
        }
        return new ImmutableDsForecastRequest(this.latitude, this.longitude, this.extendHourly, value, this.unit, this.excludeBlocks, this.includeBlocks);
    }

    public final ImmutableDsForecastRequest withUnit(@Nullable DsUnit value) {
        if (this.unit == value) {
            return this;
        }
        return new ImmutableDsForecastRequest(this.latitude, this.longitude, this.extendHourly, this.language, value, this.excludeBlocks, this.includeBlocks);
    }

    public final ImmutableDsForecastRequest withExcludeBlocks(DsBlock ... elements) {
        Set<DsBlock> newValue = ImmutableDsForecastRequest.createUnmodifiableEnumSet(Arrays.asList(elements));
        return new ImmutableDsForecastRequest(this.latitude, this.longitude, this.extendHourly, this.language, this.unit, newValue, this.includeBlocks);
    }

    public final ImmutableDsForecastRequest withExcludeBlocks(Iterable<DsBlock> elements) {
        if (this.excludeBlocks == elements) {
            return this;
        }
        Set<DsBlock> newValue = ImmutableDsForecastRequest.createUnmodifiableEnumSet(elements);
        return new ImmutableDsForecastRequest(this.latitude, this.longitude, this.extendHourly, this.language, this.unit, newValue, this.includeBlocks);
    }

    public final ImmutableDsForecastRequest withIncludeBlocks(DsBlock ... elements) {
        Set<DsBlock> newValue = ImmutableDsForecastRequest.createUnmodifiableEnumSet(Arrays.asList(elements));
        return new ImmutableDsForecastRequest(this.latitude, this.longitude, this.extendHourly, this.language, this.unit, this.excludeBlocks, newValue);
    }

    public final ImmutableDsForecastRequest withIncludeBlocks(Iterable<DsBlock> elements) {
        if (this.includeBlocks == elements) {
            return this;
        }
        Set<DsBlock> newValue = ImmutableDsForecastRequest.createUnmodifiableEnumSet(elements);
        return new ImmutableDsForecastRequest(this.latitude, this.longitude, this.extendHourly, this.language, this.unit, this.excludeBlocks, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDsForecastRequest && this.equalTo((ImmutableDsForecastRequest)another);
    }

    private boolean equalTo(ImmutableDsForecastRequest another) {
        return this.latitude.equals(another.latitude) && this.longitude.equals(another.longitude) && Objects.equals(this.extendHourly, another.extendHourly) && Objects.equals((Object)this.language, (Object)another.language) && Objects.equals((Object)this.unit, (Object)another.unit) && this.excludeBlocks.equals(another.excludeBlocks) && this.includeBlocks.equals(another.includeBlocks);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.latitude.hashCode();
        h = h * 17 + this.longitude.hashCode();
        h = h * 17 + Objects.hashCode(this.extendHourly);
        h = h * 17 + Objects.hashCode((Object)this.language);
        h = h * 17 + Objects.hashCode((Object)this.unit);
        h = h * 17 + this.excludeBlocks.hashCode();
        h = h * 17 + this.includeBlocks.hashCode();
        return h;
    }

    public String toString() {
        return "DsForecastRequest{latitude=" + this.latitude + ", longitude=" + this.longitude + ", extendHourly=" + this.extendHourly + ", language=" + (Object)((Object)this.language) + ", unit=" + (Object)((Object)this.unit) + ", excludeBlocks=" + this.excludeBlocks + ", includeBlocks=" + this.includeBlocks + "}";
    }

    public static ImmutableDsForecastRequest copyOf(DsForecastRequest instance) {
        if (instance instanceof ImmutableDsForecastRequest) {
            return (ImmutableDsForecastRequest)instance;
        }
        return new DsForecastRequest.Builder().from(instance).build();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T extends Enum<T>> Set<T> createUnmodifiableEnumSet(Iterable<T> iterable) {
        if (iterable instanceof EnumSet) {
            return Collections.unmodifiableSet(EnumSet.copyOf((EnumSet)iterable));
        }
        List<T> list = ImmutableDsForecastRequest.createSafeList(iterable, true, false);
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        return Collections.unmodifiableSet(EnumSet.copyOf(list));
    }

    static class Builder {
        private static final long INIT_BIT_LATITUDE = 1L;
        private static final long INIT_BIT_LONGITUDE = 2L;
        private long initBits = 3L;
        private String latitude;
        private String longitude;
        private Boolean extendHourly;
        private DsLanguage language;
        private DsUnit unit;
        private EnumSet<DsBlock> excludeBlocks = EnumSet.noneOf(DsBlock.class);
        private EnumSet<DsBlock> includeBlocks = EnumSet.noneOf(DsBlock.class);

        Builder() {
            if (!(this instanceof DsForecastRequest.Builder)) {
                throw new UnsupportedOperationException("Use: new DsForecastRequest.Builder()");
            }
        }

        public final DsForecastRequest.Builder from(DsForecastRequest instance) {
            DsUnit unitValue;
            DsLanguage languageValue;
            Objects.requireNonNull(instance, "instance");
            this.latitude(instance.latitude());
            this.longitude(instance.longitude());
            Boolean extendHourlyValue = instance.extendHourly();
            if (extendHourlyValue != null) {
                this.extendHourly(extendHourlyValue);
            }
            if ((languageValue = instance.language()) != null) {
                this.language(languageValue);
            }
            if ((unitValue = instance.unit()) != null) {
                this.unit(unitValue);
            }
            this.addAllExcludeBlocks(instance.excludeBlocks());
            this.addAllIncludeBlocks(instance.includeBlocks());
            return (DsForecastRequest.Builder)this;
        }

        public final DsForecastRequest.Builder latitude(String latitude) {
            this.latitude = Objects.requireNonNull(latitude, "latitude");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (DsForecastRequest.Builder)this;
        }

        public final DsForecastRequest.Builder longitude(String longitude) {
            this.longitude = Objects.requireNonNull(longitude, "longitude");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (DsForecastRequest.Builder)this;
        }

        public final DsForecastRequest.Builder extendHourly(@Nullable Boolean extendHourly) {
            this.extendHourly = extendHourly;
            return (DsForecastRequest.Builder)this;
        }

        public final DsForecastRequest.Builder language(@Nullable DsLanguage language) {
            this.language = language;
            return (DsForecastRequest.Builder)this;
        }

        public final DsForecastRequest.Builder unit(@Nullable DsUnit unit) {
            this.unit = unit;
            return (DsForecastRequest.Builder)this;
        }

        public final DsForecastRequest.Builder excludeBlock(DsBlock element) {
            this.excludeBlocks.add(Objects.requireNonNull(element, "excludeBlocks element"));
            return (DsForecastRequest.Builder)this;
        }

        public final DsForecastRequest.Builder excludeBlock(DsBlock ... elements) {
            for (DsBlock element : elements) {
                this.excludeBlocks.add(Objects.requireNonNull(element, "excludeBlocks element"));
            }
            return (DsForecastRequest.Builder)this;
        }

        public final DsForecastRequest.Builder excludeBlocks(Iterable<DsBlock> elements) {
            this.excludeBlocks.clear();
            return this.addAllExcludeBlocks(elements);
        }

        public final DsForecastRequest.Builder addAllExcludeBlocks(Iterable<DsBlock> elements) {
            for (DsBlock element : elements) {
                this.excludeBlocks.add(Objects.requireNonNull(element, "excludeBlocks element"));
            }
            return (DsForecastRequest.Builder)this;
        }

        public final DsForecastRequest.Builder includeBlock(DsBlock element) {
            this.includeBlocks.add(Objects.requireNonNull(element, "includeBlocks element"));
            return (DsForecastRequest.Builder)this;
        }

        public final DsForecastRequest.Builder includeBlock(DsBlock ... elements) {
            for (DsBlock element : elements) {
                this.includeBlocks.add(Objects.requireNonNull(element, "includeBlocks element"));
            }
            return (DsForecastRequest.Builder)this;
        }

        public final DsForecastRequest.Builder includeBlocks(Iterable<DsBlock> elements) {
            this.includeBlocks.clear();
            return this.addAllIncludeBlocks(elements);
        }

        public final DsForecastRequest.Builder addAllIncludeBlocks(Iterable<DsBlock> elements) {
            for (DsBlock element : elements) {
                this.includeBlocks.add(Objects.requireNonNull(element, "includeBlocks element"));
            }
            return (DsForecastRequest.Builder)this;
        }

        public ImmutableDsForecastRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDsForecastRequest(this.latitude, this.longitude, this.extendHourly, this.language, this.unit, ImmutableDsForecastRequest.createUnmodifiableEnumSet(this.excludeBlocks), ImmutableDsForecastRequest.createUnmodifiableEnumSet(this.includeBlocks));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("latitude");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("longitude");
            }
            return "Cannot build DsForecastRequest, some of required attributes are not set " + attributes;
        }
    }
}

