/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.darksky.model;

import ch.rasc.darksky.converter.DsUnitDeserializer;
import ch.rasc.darksky.model.DsFlag;
import ch.rasc.darksky.model.DsUnit;
import ch.rasc.darksky.model.Nullable;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class ImmutableDsFlag
implements DsFlag {
    @Nullable
    private final Object darkskyUnavailable;
    @Nullable
    private final String metnoLicense;
    private final List<String> sources;
    @Nullable
    private final DsUnit units;

    private ImmutableDsFlag(@Nullable Object darkskyUnavailable, @Nullable String metnoLicense, List<String> sources, @Nullable DsUnit units) {
        this.darkskyUnavailable = darkskyUnavailable;
        this.metnoLicense = metnoLicense;
        this.sources = sources;
        this.units = units;
    }

    @Override
    @JsonProperty(value="darksky-unavailable")
    @Nullable
    public Object darkskyUnavailable() {
        return this.darkskyUnavailable;
    }

    @Override
    @JsonProperty(value="metno-license")
    @Nullable
    public String metnoLicense() {
        return this.metnoLicense;
    }

    @Override
    @JsonProperty(value="sources")
    public List<String> sources() {
        return this.sources;
    }

    @Override
    @JsonProperty(value="units")
    @JsonDeserialize(using=DsUnitDeserializer.class)
    @Nullable
    public DsUnit units() {
        return this.units;
    }

    public final ImmutableDsFlag withDarkskyUnavailable(@Nullable Object value) {
        if (this.darkskyUnavailable == value) {
            return this;
        }
        return new ImmutableDsFlag(value, this.metnoLicense, this.sources, this.units);
    }

    public final ImmutableDsFlag withMetnoLicense(@Nullable String value) {
        if (Objects.equals(this.metnoLicense, value)) {
            return this;
        }
        return new ImmutableDsFlag(this.darkskyUnavailable, value, this.sources, this.units);
    }

    public final ImmutableDsFlag withSources(String ... elements) {
        List<String> newValue = ImmutableDsFlag.createUnmodifiableList(false, ImmutableDsFlag.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDsFlag(this.darkskyUnavailable, this.metnoLicense, newValue, this.units);
    }

    public final ImmutableDsFlag withSources(Iterable<String> elements) {
        if (this.sources == elements) {
            return this;
        }
        List<String> newValue = ImmutableDsFlag.createUnmodifiableList(false, ImmutableDsFlag.createSafeList(elements, true, false));
        return new ImmutableDsFlag(this.darkskyUnavailable, this.metnoLicense, newValue, this.units);
    }

    public final ImmutableDsFlag withUnits(@Nullable DsUnit value) {
        if (this.units == value) {
            return this;
        }
        return new ImmutableDsFlag(this.darkskyUnavailable, this.metnoLicense, this.sources, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDsFlag && this.equalTo((ImmutableDsFlag)another);
    }

    private boolean equalTo(ImmutableDsFlag another) {
        return Objects.equals(this.darkskyUnavailable, another.darkskyUnavailable) && Objects.equals(this.metnoLicense, another.metnoLicense) && this.sources.equals(another.sources) && Objects.equals((Object)this.units, (Object)another.units);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.darkskyUnavailable);
        h = h * 17 + Objects.hashCode(this.metnoLicense);
        h = h * 17 + this.sources.hashCode();
        h = h * 17 + Objects.hashCode((Object)this.units);
        return h;
    }

    public String toString() {
        return "DsFlag{darkskyUnavailable=" + this.darkskyUnavailable + ", metnoLicense=" + this.metnoLicense + ", sources=" + this.sources + ", units=" + (Object)((Object)this.units) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDsFlag fromJson(Json json) {
        Builder builder = ImmutableDsFlag.builder();
        if (json.darkskyUnavailable != null) {
            builder.darkskyUnavailable(json.darkskyUnavailable);
        }
        if (json.metnoLicense != null) {
            builder.metnoLicense(json.metnoLicense);
        }
        if (json.sources != null) {
            builder.addAllSources(json.sources);
        }
        if (json.units != null) {
            builder.units(json.units);
        }
        return builder.build();
    }

    public static ImmutableDsFlag copyOf(DsFlag instance) {
        if (instance instanceof ImmutableDsFlag) {
            return (ImmutableDsFlag)instance;
        }
        return ImmutableDsFlag.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private Object darkskyUnavailable;
        private String metnoLicense;
        private List<String> sources = new ArrayList<String>();
        private DsUnit units;

        private Builder() {
        }

        public final Builder from(DsFlag instance) {
            String metnoLicenseValue;
            Objects.requireNonNull(instance, "instance");
            Object darkskyUnavailableValue = instance.darkskyUnavailable();
            if (darkskyUnavailableValue != null) {
                this.darkskyUnavailable(darkskyUnavailableValue);
            }
            if ((metnoLicenseValue = instance.metnoLicense()) != null) {
                this.metnoLicense(metnoLicenseValue);
            }
            this.addAllSources(instance.sources());
            DsUnit unitsValue = instance.units();
            if (unitsValue != null) {
                this.units(unitsValue);
            }
            return this;
        }

        @JsonProperty(value="darksky-unavailable")
        public final Builder darkskyUnavailable(@Nullable Object darkskyUnavailable) {
            this.darkskyUnavailable = darkskyUnavailable;
            return this;
        }

        @JsonProperty(value="metno-license")
        public final Builder metnoLicense(@Nullable String metnoLicense) {
            this.metnoLicense = metnoLicense;
            return this;
        }

        public final Builder addSources(String element) {
            this.sources.add(Objects.requireNonNull(element, "sources element"));
            return this;
        }

        public final Builder addSources(String ... elements) {
            for (String element : elements) {
                this.sources.add(Objects.requireNonNull(element, "sources element"));
            }
            return this;
        }

        @JsonProperty(value="sources")
        public final Builder sources(Iterable<String> elements) {
            this.sources.clear();
            return this.addAllSources(elements);
        }

        public final Builder addAllSources(Iterable<String> elements) {
            for (String element : elements) {
                this.sources.add(Objects.requireNonNull(element, "sources element"));
            }
            return this;
        }

        @JsonProperty(value="units")
        public final Builder units(@Nullable DsUnit units) {
            this.units = units;
            return this;
        }

        public ImmutableDsFlag build() {
            return new ImmutableDsFlag(this.darkskyUnavailable, this.metnoLicense, ImmutableDsFlag.createUnmodifiableList(true, this.sources), this.units);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements DsFlag {
        Object darkskyUnavailable;
        String metnoLicense;
        List<String> sources = Collections.emptyList();
        DsUnit units;

        Json() {
        }

        @JsonProperty(value="darksky-unavailable")
        public void setDarkskyUnavailable(@Nullable Object darkskyUnavailable) {
            this.darkskyUnavailable = darkskyUnavailable;
        }

        @JsonProperty(value="metno-license")
        public void setMetnoLicense(@Nullable String metnoLicense) {
            this.metnoLicense = metnoLicense;
        }

        @JsonProperty(value="sources")
        public void setSources(List<String> sources) {
            this.sources = sources;
        }

        @JsonProperty(value="units")
        @JsonDeserialize(using=DsUnitDeserializer.class)
        public void setUnits(@Nullable DsUnit units) {
            this.units = units;
        }

        @Override
        public Object darkskyUnavailable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String metnoLicense() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> sources() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DsUnit units() {
            throw new UnsupportedOperationException();
        }
    }
}

