/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.darksky.model;

import ch.rasc.darksky.converter.DsIconDeserializer;
import ch.rasc.darksky.converter.DsPrecipTypeDeserializer;
import ch.rasc.darksky.model.DsDataPoint;
import ch.rasc.darksky.model.DsIcon;
import ch.rasc.darksky.model.DsPrecipType;
import ch.rasc.darksky.model.Nullable;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class ImmutableDsDataPoint
extends DsDataPoint {
    @Nullable
    private final BigDecimal apparentTemperature;
    @Nullable
    private final BigDecimal apparentTemperatureMax;
    @Nullable
    private final Long apparentTemperatureMaxTime;
    @Nullable
    private final BigDecimal apparentTemperatureMin;
    @Nullable
    private final Long apparentTemperatureMinTime;
    @Nullable
    private final BigDecimal cloudCover;
    @Nullable
    private final BigDecimal dewPoint;
    @Nullable
    private final BigDecimal humidity;
    @Nullable
    private final DsIcon icon;
    @Nullable
    private final BigDecimal moonPhase;
    @Nullable
    private final BigDecimal nearestStormBearing;
    @Nullable
    private final BigDecimal nearestStormDistance;
    @Nullable
    private final BigDecimal ozone;
    @Nullable
    private final BigDecimal precipAccumulation;
    @Nullable
    private final BigDecimal precipIntensity;
    @Nullable
    private final BigDecimal precipIntensityMax;
    @Nullable
    private final Long precipIntensityMaxTime;
    @Nullable
    private final BigDecimal precipProbability;
    @Nullable
    private final DsPrecipType precipType;
    @Nullable
    private final BigDecimal pressure;
    @Nullable
    private final String summary;
    @Nullable
    private final Long sunriseTime;
    @Nullable
    private final Long sunsetTime;
    @Nullable
    private final BigDecimal temperature;
    @Nullable
    private final BigDecimal temperatureMax;
    @Nullable
    private final Long temperatureMaxTime;
    @Nullable
    private final BigDecimal temperatureMin;
    @Nullable
    private final Long temperatureMinTime;
    private final long time;
    @Nullable
    private final BigDecimal visibility;
    @Nullable
    private final BigDecimal windBearing;
    @Nullable
    private final BigDecimal windSpeed;

    private ImmutableDsDataPoint(@Nullable BigDecimal apparentTemperature, @Nullable BigDecimal apparentTemperatureMax, @Nullable Long apparentTemperatureMaxTime, @Nullable BigDecimal apparentTemperatureMin, @Nullable Long apparentTemperatureMinTime, @Nullable BigDecimal cloudCover, @Nullable BigDecimal dewPoint, @Nullable BigDecimal humidity, @Nullable DsIcon icon, @Nullable BigDecimal moonPhase, @Nullable BigDecimal nearestStormBearing, @Nullable BigDecimal nearestStormDistance, @Nullable BigDecimal ozone, @Nullable BigDecimal precipAccumulation, @Nullable BigDecimal precipIntensity, @Nullable BigDecimal precipIntensityMax, @Nullable Long precipIntensityMaxTime, @Nullable BigDecimal precipProbability, @Nullable DsPrecipType precipType, @Nullable BigDecimal pressure, @Nullable String summary, @Nullable Long sunriseTime, @Nullable Long sunsetTime, @Nullable BigDecimal temperature, @Nullable BigDecimal temperatureMax, @Nullable Long temperatureMaxTime, @Nullable BigDecimal temperatureMin, @Nullable Long temperatureMinTime, long time, @Nullable BigDecimal visibility, @Nullable BigDecimal windBearing, @Nullable BigDecimal windSpeed) {
        this.apparentTemperature = apparentTemperature;
        this.apparentTemperatureMax = apparentTemperatureMax;
        this.apparentTemperatureMaxTime = apparentTemperatureMaxTime;
        this.apparentTemperatureMin = apparentTemperatureMin;
        this.apparentTemperatureMinTime = apparentTemperatureMinTime;
        this.cloudCover = cloudCover;
        this.dewPoint = dewPoint;
        this.humidity = humidity;
        this.icon = icon;
        this.moonPhase = moonPhase;
        this.nearestStormBearing = nearestStormBearing;
        this.nearestStormDistance = nearestStormDistance;
        this.ozone = ozone;
        this.precipAccumulation = precipAccumulation;
        this.precipIntensity = precipIntensity;
        this.precipIntensityMax = precipIntensityMax;
        this.precipIntensityMaxTime = precipIntensityMaxTime;
        this.precipProbability = precipProbability;
        this.precipType = precipType;
        this.pressure = pressure;
        this.summary = summary;
        this.sunriseTime = sunriseTime;
        this.sunsetTime = sunsetTime;
        this.temperature = temperature;
        this.temperatureMax = temperatureMax;
        this.temperatureMaxTime = temperatureMaxTime;
        this.temperatureMin = temperatureMin;
        this.temperatureMinTime = temperatureMinTime;
        this.time = time;
        this.visibility = visibility;
        this.windBearing = windBearing;
        this.windSpeed = windSpeed;
    }

    @Override
    @JsonProperty(value="apparentTemperature")
    @Nullable
    public BigDecimal apparentTemperature() {
        return this.apparentTemperature;
    }

    @Override
    @JsonProperty(value="apparentTemperatureMax")
    @Nullable
    public BigDecimal apparentTemperatureMax() {
        return this.apparentTemperatureMax;
    }

    @Override
    @JsonProperty(value="apparentTemperatureMaxTime")
    @Nullable
    public Long apparentTemperatureMaxTime() {
        return this.apparentTemperatureMaxTime;
    }

    @Override
    @JsonProperty(value="apparentTemperatureMin")
    @Nullable
    public BigDecimal apparentTemperatureMin() {
        return this.apparentTemperatureMin;
    }

    @Override
    @JsonProperty(value="apparentTemperatureMinTime")
    @Nullable
    public Long apparentTemperatureMinTime() {
        return this.apparentTemperatureMinTime;
    }

    @Override
    @JsonProperty(value="cloudCover")
    @Nullable
    public BigDecimal cloudCover() {
        return this.cloudCover;
    }

    @Override
    @JsonProperty(value="dewPoint")
    @Nullable
    public BigDecimal dewPoint() {
        return this.dewPoint;
    }

    @Override
    @JsonProperty(value="humidity")
    @Nullable
    public BigDecimal humidity() {
        return this.humidity;
    }

    @Override
    @JsonProperty(value="icon")
    @JsonDeserialize(using=DsIconDeserializer.class)
    @Nullable
    public DsIcon icon() {
        return this.icon;
    }

    @Override
    @JsonProperty(value="moonPhase")
    @Nullable
    public BigDecimal moonPhase() {
        return this.moonPhase;
    }

    @Override
    @JsonProperty(value="nearestStormBearing")
    @Nullable
    public BigDecimal nearestStormBearing() {
        return this.nearestStormBearing;
    }

    @Override
    @JsonProperty(value="nearestStormDistance")
    @Nullable
    public BigDecimal nearestStormDistance() {
        return this.nearestStormDistance;
    }

    @Override
    @JsonProperty(value="ozone")
    @Nullable
    public BigDecimal ozone() {
        return this.ozone;
    }

    @Override
    @JsonProperty(value="precipAccumulation")
    @Nullable
    public BigDecimal precipAccumulation() {
        return this.precipAccumulation;
    }

    @Override
    @JsonProperty(value="precipIntensity")
    @Nullable
    public BigDecimal precipIntensity() {
        return this.precipIntensity;
    }

    @Override
    @JsonProperty(value="precipIntensityMax")
    @Nullable
    public BigDecimal precipIntensityMax() {
        return this.precipIntensityMax;
    }

    @Override
    @JsonProperty(value="precipIntensityMaxTime")
    @Nullable
    public Long precipIntensityMaxTime() {
        return this.precipIntensityMaxTime;
    }

    @Override
    @JsonProperty(value="precipProbability")
    @Nullable
    public BigDecimal precipProbability() {
        return this.precipProbability;
    }

    @Override
    @JsonProperty(value="precipType")
    @JsonDeserialize(using=DsPrecipTypeDeserializer.class)
    @Nullable
    public DsPrecipType precipType() {
        return this.precipType;
    }

    @Override
    @JsonProperty(value="pressure")
    @Nullable
    public BigDecimal pressure() {
        return this.pressure;
    }

    @Override
    @JsonProperty(value="summary")
    @Nullable
    public String summary() {
        return this.summary;
    }

    @Override
    @JsonProperty(value="sunriseTime")
    @Nullable
    public Long sunriseTime() {
        return this.sunriseTime;
    }

    @Override
    @JsonProperty(value="sunsetTime")
    @Nullable
    public Long sunsetTime() {
        return this.sunsetTime;
    }

    @Override
    @JsonProperty(value="temperature")
    @Nullable
    public BigDecimal temperature() {
        return this.temperature;
    }

    @Override
    @JsonProperty(value="temperatureMax")
    @Nullable
    public BigDecimal temperatureMax() {
        return this.temperatureMax;
    }

    @Override
    @JsonProperty(value="temperatureMaxTime")
    @Nullable
    public Long temperatureMaxTime() {
        return this.temperatureMaxTime;
    }

    @Override
    @JsonProperty(value="temperatureMin")
    @Nullable
    public BigDecimal temperatureMin() {
        return this.temperatureMin;
    }

    @Override
    @JsonProperty(value="temperatureMinTime")
    @Nullable
    public Long temperatureMinTime() {
        return this.temperatureMinTime;
    }

    @Override
    @JsonProperty(value="time")
    public long time() {
        return this.time;
    }

    @Override
    @JsonProperty(value="visibility")
    @Nullable
    public BigDecimal visibility() {
        return this.visibility;
    }

    @Override
    @JsonProperty(value="windBearing")
    @Nullable
    public BigDecimal windBearing() {
        return this.windBearing;
    }

    @Override
    @JsonProperty(value="windSpeed")
    @Nullable
    public BigDecimal windSpeed() {
        return this.windSpeed;
    }

    public final ImmutableDsDataPoint withApparentTemperature(@Nullable BigDecimal value) {
        if (this.apparentTemperature == value) {
            return this;
        }
        return new ImmutableDsDataPoint(value, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.cloudCover, this.dewPoint, this.humidity, this.icon, this.moonPhase, this.nearestStormBearing, this.nearestStormDistance, this.ozone, this.precipAccumulation, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.pressure, this.summary, this.sunriseTime, this.sunsetTime, this.temperature, this.temperatureMax, this.temperatureMaxTime, this.temperatureMin, this.temperatureMinTime, this.time, this.visibility, this.windBearing, this.windSpeed);
    }

    public final ImmutableDsDataPoint withApparentTemperatureMax(@Nullable BigDecimal value) {
        if (this.apparentTemperatureMax == value) {
            return this;
        }
        return new ImmutableDsDataPoint(this.apparentTemperature, value, this.apparentTemperatureMaxTime, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.cloudCover, this.dewPoint, this.humidity, this.icon, this.moonPhase, this.nearestStormBearing, this.nearestStormDistance, this.ozone, this.precipAccumulation, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.pressure, this.summary, this.sunriseTime, this.sunsetTime, this.temperature, this.temperatureMax, this.temperatureMaxTime, this.temperatureMin, this.temperatureMinTime, this.time, this.visibility, this.windBearing, this.windSpeed);
    }

    public final ImmutableDsDataPoint withApparentTemperatureMaxTime(@Nullable Long value) {
        if (Objects.equals(this.apparentTemperatureMaxTime, value)) {
            return this;
        }
        return new ImmutableDsDataPoint(this.apparentTemperature, this.apparentTemperatureMax, value, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.cloudCover, this.dewPoint, this.humidity, this.icon, this.moonPhase, this.nearestStormBearing, this.nearestStormDistance, this.ozone, this.precipAccumulation, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.pressure, this.summary, this.sunriseTime, this.sunsetTime, this.temperature, this.temperatureMax, this.temperatureMaxTime, this.temperatureMin, this.temperatureMinTime, this.time, this.visibility, this.windBearing, this.windSpeed);
    }

    public final ImmutableDsDataPoint withApparentTemperatureMin(@Nullable BigDecimal value) {
        if (this.apparentTemperatureMin == value) {
            return this;
        }
        return new ImmutableDsDataPoint(this.apparentTemperature, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, value, this.apparentTemperatureMinTime, this.cloudCover, this.dewPoint, this.humidity, this.icon, this.moonPhase, this.nearestStormBearing, this.nearestStormDistance, this.ozone, this.precipAccumulation, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.pressure, this.summary, this.sunriseTime, this.sunsetTime, this.temperature, this.temperatureMax, this.temperatureMaxTime, this.temperatureMin, this.temperatureMinTime, this.time, this.visibility, this.windBearing, this.windSpeed);
    }

    public final ImmutableDsDataPoint withApparentTemperatureMinTime(@Nullable Long value) {
        if (Objects.equals(this.apparentTemperatureMinTime, value)) {
            return this;
        }
        return new ImmutableDsDataPoint(this.apparentTemperature, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.apparentTemperatureMin, value, this.cloudCover, this.dewPoint, this.humidity, this.icon, this.moonPhase, this.nearestStormBearing, this.nearestStormDistance, this.ozone, this.precipAccumulation, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.pressure, this.summary, this.sunriseTime, this.sunsetTime, this.temperature, this.temperatureMax, this.temperatureMaxTime, this.temperatureMin, this.temperatureMinTime, this.time, this.visibility, this.windBearing, this.windSpeed);
    }

    public final ImmutableDsDataPoint withCloudCover(@Nullable BigDecimal value) {
        if (this.cloudCover == value) {
            return this;
        }
        return new ImmutableDsDataPoint(this.apparentTemperature, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.apparentTemperatureMin, this.apparentTemperatureMinTime, value, this.dewPoint, this.humidity, this.icon, this.moonPhase, this.nearestStormBearing, this.nearestStormDistance, this.ozone, this.precipAccumulation, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.pressure, this.summary, this.sunriseTime, this.sunsetTime, this.temperature, this.temperatureMax, this.temperatureMaxTime, this.temperatureMin, this.temperatureMinTime, this.time, this.visibility, this.windBearing, this.windSpeed);
    }

    public final ImmutableDsDataPoint withDewPoint(@Nullable BigDecimal value) {
        if (this.dewPoint == value) {
            return this;
        }
        return new ImmutableDsDataPoint(this.apparentTemperature, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.cloudCover, value, this.humidity, this.icon, this.moonPhase, this.nearestStormBearing, this.nearestStormDistance, this.ozone, this.precipAccumulation, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.pressure, this.summary, this.sunriseTime, this.sunsetTime, this.temperature, this.temperatureMax, this.temperatureMaxTime, this.temperatureMin, this.temperatureMinTime, this.time, this.visibility, this.windBearing, this.windSpeed);
    }

    public final ImmutableDsDataPoint withHumidity(@Nullable BigDecimal value) {
        if (this.humidity == value) {
            return this;
        }
        return new ImmutableDsDataPoint(this.apparentTemperature, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.cloudCover, this.dewPoint, value, this.icon, this.moonPhase, this.nearestStormBearing, this.nearestStormDistance, this.ozone, this.precipAccumulation, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.pressure, this.summary, this.sunriseTime, this.sunsetTime, this.temperature, this.temperatureMax, this.temperatureMaxTime, this.temperatureMin, this.temperatureMinTime, this.time, this.visibility, this.windBearing, this.windSpeed);
    }

    public final ImmutableDsDataPoint withIcon(@Nullable DsIcon value) {
        if (this.icon == value) {
            return this;
        }
        return new ImmutableDsDataPoint(this.apparentTemperature, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.cloudCover, this.dewPoint, this.humidity, value, this.moonPhase, this.nearestStormBearing, this.nearestStormDistance, this.ozone, this.precipAccumulation, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.pressure, this.summary, this.sunriseTime, this.sunsetTime, this.temperature, this.temperatureMax, this.temperatureMaxTime, this.temperatureMin, this.temperatureMinTime, this.time, this.visibility, this.windBearing, this.windSpeed);
    }

    public final ImmutableDsDataPoint withMoonPhase(@Nullable BigDecimal value) {
        if (this.moonPhase == value) {
            return this;
        }
        return new ImmutableDsDataPoint(this.apparentTemperature, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.cloudCover, this.dewPoint, this.humidity, this.icon, value, this.nearestStormBearing, this.nearestStormDistance, this.ozone, this.precipAccumulation, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.pressure, this.summary, this.sunriseTime, this.sunsetTime, this.temperature, this.temperatureMax, this.temperatureMaxTime, this.temperatureMin, this.temperatureMinTime, this.time, this.visibility, this.windBearing, this.windSpeed);
    }

    public final ImmutableDsDataPoint withNearestStormBearing(@Nullable BigDecimal value) {
        if (this.nearestStormBearing == value) {
            return this;
        }
        return new ImmutableDsDataPoint(this.apparentTemperature, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.cloudCover, this.dewPoint, this.humidity, this.icon, this.moonPhase, value, this.nearestStormDistance, this.ozone, this.precipAccumulation, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.pressure, this.summary, this.sunriseTime, this.sunsetTime, this.temperature, this.temperatureMax, this.temperatureMaxTime, this.temperatureMin, this.temperatureMinTime, this.time, this.visibility, this.windBearing, this.windSpeed);
    }

    public final ImmutableDsDataPoint withNearestStormDistance(@Nullable BigDecimal value) {
        if (this.nearestStormDistance == value) {
            return this;
        }
        return new ImmutableDsDataPoint(this.apparentTemperature, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.cloudCover, this.dewPoint, this.humidity, this.icon, this.moonPhase, this.nearestStormBearing, value, this.ozone, this.precipAccumulation, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.pressure, this.summary, this.sunriseTime, this.sunsetTime, this.temperature, this.temperatureMax, this.temperatureMaxTime, this.temperatureMin, this.temperatureMinTime, this.time, this.visibility, this.windBearing, this.windSpeed);
    }

    public final ImmutableDsDataPoint withOzone(@Nullable BigDecimal value) {
        if (this.ozone == value) {
            return this;
        }
        return new ImmutableDsDataPoint(this.apparentTemperature, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.cloudCover, this.dewPoint, this.humidity, this.icon, this.moonPhase, this.nearestStormBearing, this.nearestStormDistance, value, this.precipAccumulation, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.pressure, this.summary, this.sunriseTime, this.sunsetTime, this.temperature, this.temperatureMax, this.temperatureMaxTime, this.temperatureMin, this.temperatureMinTime, this.time, this.visibility, this.windBearing, this.windSpeed);
    }

    public final ImmutableDsDataPoint withPrecipAccumulation(@Nullable BigDecimal value) {
        if (this.precipAccumulation == value) {
            return this;
        }
        return new ImmutableDsDataPoint(this.apparentTemperature, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.cloudCover, this.dewPoint, this.humidity, this.icon, this.moonPhase, this.nearestStormBearing, this.nearestStormDistance, this.ozone, value, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.pressure, this.summary, this.sunriseTime, this.sunsetTime, this.temperature, this.temperatureMax, this.temperatureMaxTime, this.temperatureMin, this.temperatureMinTime, this.time, this.visibility, this.windBearing, this.windSpeed);
    }

    public final ImmutableDsDataPoint withPrecipIntensity(@Nullable BigDecimal value) {
        if (this.precipIntensity == value) {
            return this;
        }
        return new ImmutableDsDataPoint(this.apparentTemperature, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.cloudCover, this.dewPoint, this.humidity, this.icon, this.moonPhase, this.nearestStormBearing, this.nearestStormDistance, this.ozone, this.precipAccumulation, value, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.pressure, this.summary, this.sunriseTime, this.sunsetTime, this.temperature, this.temperatureMax, this.temperatureMaxTime, this.temperatureMin, this.temperatureMinTime, this.time, this.visibility, this.windBearing, this.windSpeed);
    }

    public final ImmutableDsDataPoint withPrecipIntensityMax(@Nullable BigDecimal value) {
        if (this.precipIntensityMax == value) {
            return this;
        }
        return new ImmutableDsDataPoint(this.apparentTemperature, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.cloudCover, this.dewPoint, this.humidity, this.icon, this.moonPhase, this.nearestStormBearing, this.nearestStormDistance, this.ozone, this.precipAccumulation, this.precipIntensity, value, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.pressure, this.summary, this.sunriseTime, this.sunsetTime, this.temperature, this.temperatureMax, this.temperatureMaxTime, this.temperatureMin, this.temperatureMinTime, this.time, this.visibility, this.windBearing, this.windSpeed);
    }

    public final ImmutableDsDataPoint withPrecipIntensityMaxTime(@Nullable Long value) {
        if (Objects.equals(this.precipIntensityMaxTime, value)) {
            return this;
        }
        return new ImmutableDsDataPoint(this.apparentTemperature, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.cloudCover, this.dewPoint, this.humidity, this.icon, this.moonPhase, this.nearestStormBearing, this.nearestStormDistance, this.ozone, this.precipAccumulation, this.precipIntensity, this.precipIntensityMax, value, this.precipProbability, this.precipType, this.pressure, this.summary, this.sunriseTime, this.sunsetTime, this.temperature, this.temperatureMax, this.temperatureMaxTime, this.temperatureMin, this.temperatureMinTime, this.time, this.visibility, this.windBearing, this.windSpeed);
    }

    public final ImmutableDsDataPoint withPrecipProbability(@Nullable BigDecimal value) {
        if (this.precipProbability == value) {
            return this;
        }
        return new ImmutableDsDataPoint(this.apparentTemperature, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.cloudCover, this.dewPoint, this.humidity, this.icon, this.moonPhase, this.nearestStormBearing, this.nearestStormDistance, this.ozone, this.precipAccumulation, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, value, this.precipType, this.pressure, this.summary, this.sunriseTime, this.sunsetTime, this.temperature, this.temperatureMax, this.temperatureMaxTime, this.temperatureMin, this.temperatureMinTime, this.time, this.visibility, this.windBearing, this.windSpeed);
    }

    public final ImmutableDsDataPoint withPrecipType(@Nullable DsPrecipType value) {
        if (this.precipType == value) {
            return this;
        }
        return new ImmutableDsDataPoint(this.apparentTemperature, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.cloudCover, this.dewPoint, this.humidity, this.icon, this.moonPhase, this.nearestStormBearing, this.nearestStormDistance, this.ozone, this.precipAccumulation, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, value, this.pressure, this.summary, this.sunriseTime, this.sunsetTime, this.temperature, this.temperatureMax, this.temperatureMaxTime, this.temperatureMin, this.temperatureMinTime, this.time, this.visibility, this.windBearing, this.windSpeed);
    }

    public final ImmutableDsDataPoint withPressure(@Nullable BigDecimal value) {
        if (this.pressure == value) {
            return this;
        }
        return new ImmutableDsDataPoint(this.apparentTemperature, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.cloudCover, this.dewPoint, this.humidity, this.icon, this.moonPhase, this.nearestStormBearing, this.nearestStormDistance, this.ozone, this.precipAccumulation, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, value, this.summary, this.sunriseTime, this.sunsetTime, this.temperature, this.temperatureMax, this.temperatureMaxTime, this.temperatureMin, this.temperatureMinTime, this.time, this.visibility, this.windBearing, this.windSpeed);
    }

    public final ImmutableDsDataPoint withSummary(@Nullable String value) {
        if (Objects.equals(this.summary, value)) {
            return this;
        }
        return new ImmutableDsDataPoint(this.apparentTemperature, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.cloudCover, this.dewPoint, this.humidity, this.icon, this.moonPhase, this.nearestStormBearing, this.nearestStormDistance, this.ozone, this.precipAccumulation, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.pressure, value, this.sunriseTime, this.sunsetTime, this.temperature, this.temperatureMax, this.temperatureMaxTime, this.temperatureMin, this.temperatureMinTime, this.time, this.visibility, this.windBearing, this.windSpeed);
    }

    public final ImmutableDsDataPoint withSunriseTime(@Nullable Long value) {
        if (Objects.equals(this.sunriseTime, value)) {
            return this;
        }
        return new ImmutableDsDataPoint(this.apparentTemperature, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.cloudCover, this.dewPoint, this.humidity, this.icon, this.moonPhase, this.nearestStormBearing, this.nearestStormDistance, this.ozone, this.precipAccumulation, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.pressure, this.summary, value, this.sunsetTime, this.temperature, this.temperatureMax, this.temperatureMaxTime, this.temperatureMin, this.temperatureMinTime, this.time, this.visibility, this.windBearing, this.windSpeed);
    }

    public final ImmutableDsDataPoint withSunsetTime(@Nullable Long value) {
        if (Objects.equals(this.sunsetTime, value)) {
            return this;
        }
        return new ImmutableDsDataPoint(this.apparentTemperature, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.cloudCover, this.dewPoint, this.humidity, this.icon, this.moonPhase, this.nearestStormBearing, this.nearestStormDistance, this.ozone, this.precipAccumulation, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.pressure, this.summary, this.sunriseTime, value, this.temperature, this.temperatureMax, this.temperatureMaxTime, this.temperatureMin, this.temperatureMinTime, this.time, this.visibility, this.windBearing, this.windSpeed);
    }

    public final ImmutableDsDataPoint withTemperature(@Nullable BigDecimal value) {
        if (this.temperature == value) {
            return this;
        }
        return new ImmutableDsDataPoint(this.apparentTemperature, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.cloudCover, this.dewPoint, this.humidity, this.icon, this.moonPhase, this.nearestStormBearing, this.nearestStormDistance, this.ozone, this.precipAccumulation, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.pressure, this.summary, this.sunriseTime, this.sunsetTime, value, this.temperatureMax, this.temperatureMaxTime, this.temperatureMin, this.temperatureMinTime, this.time, this.visibility, this.windBearing, this.windSpeed);
    }

    public final ImmutableDsDataPoint withTemperatureMax(@Nullable BigDecimal value) {
        if (this.temperatureMax == value) {
            return this;
        }
        return new ImmutableDsDataPoint(this.apparentTemperature, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.cloudCover, this.dewPoint, this.humidity, this.icon, this.moonPhase, this.nearestStormBearing, this.nearestStormDistance, this.ozone, this.precipAccumulation, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.pressure, this.summary, this.sunriseTime, this.sunsetTime, this.temperature, value, this.temperatureMaxTime, this.temperatureMin, this.temperatureMinTime, this.time, this.visibility, this.windBearing, this.windSpeed);
    }

    public final ImmutableDsDataPoint withTemperatureMaxTime(@Nullable Long value) {
        if (Objects.equals(this.temperatureMaxTime, value)) {
            return this;
        }
        return new ImmutableDsDataPoint(this.apparentTemperature, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.cloudCover, this.dewPoint, this.humidity, this.icon, this.moonPhase, this.nearestStormBearing, this.nearestStormDistance, this.ozone, this.precipAccumulation, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.pressure, this.summary, this.sunriseTime, this.sunsetTime, this.temperature, this.temperatureMax, value, this.temperatureMin, this.temperatureMinTime, this.time, this.visibility, this.windBearing, this.windSpeed);
    }

    public final ImmutableDsDataPoint withTemperatureMin(@Nullable BigDecimal value) {
        if (this.temperatureMin == value) {
            return this;
        }
        return new ImmutableDsDataPoint(this.apparentTemperature, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.cloudCover, this.dewPoint, this.humidity, this.icon, this.moonPhase, this.nearestStormBearing, this.nearestStormDistance, this.ozone, this.precipAccumulation, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.pressure, this.summary, this.sunriseTime, this.sunsetTime, this.temperature, this.temperatureMax, this.temperatureMaxTime, value, this.temperatureMinTime, this.time, this.visibility, this.windBearing, this.windSpeed);
    }

    public final ImmutableDsDataPoint withTemperatureMinTime(@Nullable Long value) {
        if (Objects.equals(this.temperatureMinTime, value)) {
            return this;
        }
        return new ImmutableDsDataPoint(this.apparentTemperature, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.cloudCover, this.dewPoint, this.humidity, this.icon, this.moonPhase, this.nearestStormBearing, this.nearestStormDistance, this.ozone, this.precipAccumulation, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.pressure, this.summary, this.sunriseTime, this.sunsetTime, this.temperature, this.temperatureMax, this.temperatureMaxTime, this.temperatureMin, value, this.time, this.visibility, this.windBearing, this.windSpeed);
    }

    public final ImmutableDsDataPoint withTime(long value) {
        if (this.time == value) {
            return this;
        }
        return new ImmutableDsDataPoint(this.apparentTemperature, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.cloudCover, this.dewPoint, this.humidity, this.icon, this.moonPhase, this.nearestStormBearing, this.nearestStormDistance, this.ozone, this.precipAccumulation, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.pressure, this.summary, this.sunriseTime, this.sunsetTime, this.temperature, this.temperatureMax, this.temperatureMaxTime, this.temperatureMin, this.temperatureMinTime, value, this.visibility, this.windBearing, this.windSpeed);
    }

    public final ImmutableDsDataPoint withVisibility(@Nullable BigDecimal value) {
        if (this.visibility == value) {
            return this;
        }
        return new ImmutableDsDataPoint(this.apparentTemperature, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.cloudCover, this.dewPoint, this.humidity, this.icon, this.moonPhase, this.nearestStormBearing, this.nearestStormDistance, this.ozone, this.precipAccumulation, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.pressure, this.summary, this.sunriseTime, this.sunsetTime, this.temperature, this.temperatureMax, this.temperatureMaxTime, this.temperatureMin, this.temperatureMinTime, this.time, value, this.windBearing, this.windSpeed);
    }

    public final ImmutableDsDataPoint withWindBearing(@Nullable BigDecimal value) {
        if (this.windBearing == value) {
            return this;
        }
        return new ImmutableDsDataPoint(this.apparentTemperature, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.cloudCover, this.dewPoint, this.humidity, this.icon, this.moonPhase, this.nearestStormBearing, this.nearestStormDistance, this.ozone, this.precipAccumulation, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.pressure, this.summary, this.sunriseTime, this.sunsetTime, this.temperature, this.temperatureMax, this.temperatureMaxTime, this.temperatureMin, this.temperatureMinTime, this.time, this.visibility, value, this.windSpeed);
    }

    public final ImmutableDsDataPoint withWindSpeed(@Nullable BigDecimal value) {
        if (this.windSpeed == value) {
            return this;
        }
        return new ImmutableDsDataPoint(this.apparentTemperature, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.cloudCover, this.dewPoint, this.humidity, this.icon, this.moonPhase, this.nearestStormBearing, this.nearestStormDistance, this.ozone, this.precipAccumulation, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.pressure, this.summary, this.sunriseTime, this.sunsetTime, this.temperature, this.temperatureMax, this.temperatureMaxTime, this.temperatureMin, this.temperatureMinTime, this.time, this.visibility, this.windBearing, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDsDataPoint && this.equalTo((ImmutableDsDataPoint)another);
    }

    private boolean equalTo(ImmutableDsDataPoint another) {
        return Objects.equals(this.apparentTemperature, another.apparentTemperature) && Objects.equals(this.apparentTemperatureMax, another.apparentTemperatureMax) && Objects.equals(this.apparentTemperatureMaxTime, another.apparentTemperatureMaxTime) && Objects.equals(this.apparentTemperatureMin, another.apparentTemperatureMin) && Objects.equals(this.apparentTemperatureMinTime, another.apparentTemperatureMinTime) && Objects.equals(this.cloudCover, another.cloudCover) && Objects.equals(this.dewPoint, another.dewPoint) && Objects.equals(this.humidity, another.humidity) && Objects.equals((Object)this.icon, (Object)another.icon) && Objects.equals(this.moonPhase, another.moonPhase) && Objects.equals(this.nearestStormBearing, another.nearestStormBearing) && Objects.equals(this.nearestStormDistance, another.nearestStormDistance) && Objects.equals(this.ozone, another.ozone) && Objects.equals(this.precipAccumulation, another.precipAccumulation) && Objects.equals(this.precipIntensity, another.precipIntensity) && Objects.equals(this.precipIntensityMax, another.precipIntensityMax) && Objects.equals(this.precipIntensityMaxTime, another.precipIntensityMaxTime) && Objects.equals(this.precipProbability, another.precipProbability) && Objects.equals((Object)this.precipType, (Object)another.precipType) && Objects.equals(this.pressure, another.pressure) && Objects.equals(this.summary, another.summary) && Objects.equals(this.sunriseTime, another.sunriseTime) && Objects.equals(this.sunsetTime, another.sunsetTime) && Objects.equals(this.temperature, another.temperature) && Objects.equals(this.temperatureMax, another.temperatureMax) && Objects.equals(this.temperatureMaxTime, another.temperatureMaxTime) && Objects.equals(this.temperatureMin, another.temperatureMin) && Objects.equals(this.temperatureMinTime, another.temperatureMinTime) && this.time == another.time && Objects.equals(this.visibility, another.visibility) && Objects.equals(this.windBearing, another.windBearing) && Objects.equals(this.windSpeed, another.windSpeed);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.apparentTemperature);
        h = h * 17 + Objects.hashCode(this.apparentTemperatureMax);
        h = h * 17 + Objects.hashCode(this.apparentTemperatureMaxTime);
        h = h * 17 + Objects.hashCode(this.apparentTemperatureMin);
        h = h * 17 + Objects.hashCode(this.apparentTemperatureMinTime);
        h = h * 17 + Objects.hashCode(this.cloudCover);
        h = h * 17 + Objects.hashCode(this.dewPoint);
        h = h * 17 + Objects.hashCode(this.humidity);
        h = h * 17 + Objects.hashCode((Object)this.icon);
        h = h * 17 + Objects.hashCode(this.moonPhase);
        h = h * 17 + Objects.hashCode(this.nearestStormBearing);
        h = h * 17 + Objects.hashCode(this.nearestStormDistance);
        h = h * 17 + Objects.hashCode(this.ozone);
        h = h * 17 + Objects.hashCode(this.precipAccumulation);
        h = h * 17 + Objects.hashCode(this.precipIntensity);
        h = h * 17 + Objects.hashCode(this.precipIntensityMax);
        h = h * 17 + Objects.hashCode(this.precipIntensityMaxTime);
        h = h * 17 + Objects.hashCode(this.precipProbability);
        h = h * 17 + Objects.hashCode((Object)this.precipType);
        h = h * 17 + Objects.hashCode(this.pressure);
        h = h * 17 + Objects.hashCode(this.summary);
        h = h * 17 + Objects.hashCode(this.sunriseTime);
        h = h * 17 + Objects.hashCode(this.sunsetTime);
        h = h * 17 + Objects.hashCode(this.temperature);
        h = h * 17 + Objects.hashCode(this.temperatureMax);
        h = h * 17 + Objects.hashCode(this.temperatureMaxTime);
        h = h * 17 + Objects.hashCode(this.temperatureMin);
        h = h * 17 + Objects.hashCode(this.temperatureMinTime);
        h = h * 17 + Long.hashCode(this.time);
        h = h * 17 + Objects.hashCode(this.visibility);
        h = h * 17 + Objects.hashCode(this.windBearing);
        h = h * 17 + Objects.hashCode(this.windSpeed);
        return h;
    }

    public String toString() {
        return "DsDataPoint{apparentTemperature=" + this.apparentTemperature + ", apparentTemperatureMax=" + this.apparentTemperatureMax + ", apparentTemperatureMaxTime=" + this.apparentTemperatureMaxTime + ", apparentTemperatureMin=" + this.apparentTemperatureMin + ", apparentTemperatureMinTime=" + this.apparentTemperatureMinTime + ", cloudCover=" + this.cloudCover + ", dewPoint=" + this.dewPoint + ", humidity=" + this.humidity + ", icon=" + (Object)((Object)this.icon) + ", moonPhase=" + this.moonPhase + ", nearestStormBearing=" + this.nearestStormBearing + ", nearestStormDistance=" + this.nearestStormDistance + ", ozone=" + this.ozone + ", precipAccumulation=" + this.precipAccumulation + ", precipIntensity=" + this.precipIntensity + ", precipIntensityMax=" + this.precipIntensityMax + ", precipIntensityMaxTime=" + this.precipIntensityMaxTime + ", precipProbability=" + this.precipProbability + ", precipType=" + (Object)((Object)this.precipType) + ", pressure=" + this.pressure + ", summary=" + this.summary + ", sunriseTime=" + this.sunriseTime + ", sunsetTime=" + this.sunsetTime + ", temperature=" + this.temperature + ", temperatureMax=" + this.temperatureMax + ", temperatureMaxTime=" + this.temperatureMaxTime + ", temperatureMin=" + this.temperatureMin + ", temperatureMinTime=" + this.temperatureMinTime + ", time=" + this.time + ", visibility=" + this.visibility + ", windBearing=" + this.windBearing + ", windSpeed=" + this.windSpeed + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDsDataPoint fromJson(Json json) {
        Builder builder = ImmutableDsDataPoint.builder();
        if (json.apparentTemperature != null) {
            builder.apparentTemperature(json.apparentTemperature);
        }
        if (json.apparentTemperatureMax != null) {
            builder.apparentTemperatureMax(json.apparentTemperatureMax);
        }
        if (json.apparentTemperatureMaxTime != null) {
            builder.apparentTemperatureMaxTime(json.apparentTemperatureMaxTime);
        }
        if (json.apparentTemperatureMin != null) {
            builder.apparentTemperatureMin(json.apparentTemperatureMin);
        }
        if (json.apparentTemperatureMinTime != null) {
            builder.apparentTemperatureMinTime(json.apparentTemperatureMinTime);
        }
        if (json.cloudCover != null) {
            builder.cloudCover(json.cloudCover);
        }
        if (json.dewPoint != null) {
            builder.dewPoint(json.dewPoint);
        }
        if (json.humidity != null) {
            builder.humidity(json.humidity);
        }
        if (json.icon != null) {
            builder.icon(json.icon);
        }
        if (json.moonPhase != null) {
            builder.moonPhase(json.moonPhase);
        }
        if (json.nearestStormBearing != null) {
            builder.nearestStormBearing(json.nearestStormBearing);
        }
        if (json.nearestStormDistance != null) {
            builder.nearestStormDistance(json.nearestStormDistance);
        }
        if (json.ozone != null) {
            builder.ozone(json.ozone);
        }
        if (json.precipAccumulation != null) {
            builder.precipAccumulation(json.precipAccumulation);
        }
        if (json.precipIntensity != null) {
            builder.precipIntensity(json.precipIntensity);
        }
        if (json.precipIntensityMax != null) {
            builder.precipIntensityMax(json.precipIntensityMax);
        }
        if (json.precipIntensityMaxTime != null) {
            builder.precipIntensityMaxTime(json.precipIntensityMaxTime);
        }
        if (json.precipProbability != null) {
            builder.precipProbability(json.precipProbability);
        }
        if (json.precipType != null) {
            builder.precipType(json.precipType);
        }
        if (json.pressure != null) {
            builder.pressure(json.pressure);
        }
        if (json.summary != null) {
            builder.summary(json.summary);
        }
        if (json.sunriseTime != null) {
            builder.sunriseTime(json.sunriseTime);
        }
        if (json.sunsetTime != null) {
            builder.sunsetTime(json.sunsetTime);
        }
        if (json.temperature != null) {
            builder.temperature(json.temperature);
        }
        if (json.temperatureMax != null) {
            builder.temperatureMax(json.temperatureMax);
        }
        if (json.temperatureMaxTime != null) {
            builder.temperatureMaxTime(json.temperatureMaxTime);
        }
        if (json.temperatureMin != null) {
            builder.temperatureMin(json.temperatureMin);
        }
        if (json.temperatureMinTime != null) {
            builder.temperatureMinTime(json.temperatureMinTime);
        }
        if (json.timeIsSet) {
            builder.time(json.time);
        }
        if (json.visibility != null) {
            builder.visibility(json.visibility);
        }
        if (json.windBearing != null) {
            builder.windBearing(json.windBearing);
        }
        if (json.windSpeed != null) {
            builder.windSpeed(json.windSpeed);
        }
        return builder.build();
    }

    public static ImmutableDsDataPoint copyOf(DsDataPoint instance) {
        if (instance instanceof ImmutableDsDataPoint) {
            return (ImmutableDsDataPoint)instance;
        }
        return ImmutableDsDataPoint.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TIME = 1L;
        private long initBits = 1L;
        private BigDecimal apparentTemperature;
        private BigDecimal apparentTemperatureMax;
        private Long apparentTemperatureMaxTime;
        private BigDecimal apparentTemperatureMin;
        private Long apparentTemperatureMinTime;
        private BigDecimal cloudCover;
        private BigDecimal dewPoint;
        private BigDecimal humidity;
        private DsIcon icon;
        private BigDecimal moonPhase;
        private BigDecimal nearestStormBearing;
        private BigDecimal nearestStormDistance;
        private BigDecimal ozone;
        private BigDecimal precipAccumulation;
        private BigDecimal precipIntensity;
        private BigDecimal precipIntensityMax;
        private Long precipIntensityMaxTime;
        private BigDecimal precipProbability;
        private DsPrecipType precipType;
        private BigDecimal pressure;
        private String summary;
        private Long sunriseTime;
        private Long sunsetTime;
        private BigDecimal temperature;
        private BigDecimal temperatureMax;
        private Long temperatureMaxTime;
        private BigDecimal temperatureMin;
        private Long temperatureMinTime;
        private long time;
        private BigDecimal visibility;
        private BigDecimal windBearing;
        private BigDecimal windSpeed;

        private Builder() {
        }

        public final Builder from(DsDataPoint instance) {
            BigDecimal windSpeedValue;
            BigDecimal windBearingValue;
            Long temperatureMinTimeValue;
            BigDecimal temperatureMinValue;
            Long temperatureMaxTimeValue;
            BigDecimal temperatureMaxValue;
            BigDecimal temperatureValue;
            Long sunsetTimeValue;
            Long sunriseTimeValue;
            String summaryValue;
            BigDecimal pressureValue;
            DsPrecipType precipTypeValue;
            BigDecimal precipProbabilityValue;
            Long precipIntensityMaxTimeValue;
            BigDecimal precipIntensityMaxValue;
            BigDecimal precipIntensityValue;
            BigDecimal precipAccumulationValue;
            BigDecimal ozoneValue;
            BigDecimal nearestStormDistanceValue;
            BigDecimal nearestStormBearingValue;
            BigDecimal moonPhaseValue;
            DsIcon iconValue;
            BigDecimal humidityValue;
            BigDecimal dewPointValue;
            BigDecimal cloudCoverValue;
            Long apparentTemperatureMinTimeValue;
            BigDecimal apparentTemperatureMinValue;
            Long apparentTemperatureMaxTimeValue;
            BigDecimal apparentTemperatureMaxValue;
            Objects.requireNonNull(instance, "instance");
            BigDecimal apparentTemperatureValue = instance.apparentTemperature();
            if (apparentTemperatureValue != null) {
                this.apparentTemperature(apparentTemperatureValue);
            }
            if ((apparentTemperatureMaxValue = instance.apparentTemperatureMax()) != null) {
                this.apparentTemperatureMax(apparentTemperatureMaxValue);
            }
            if ((apparentTemperatureMaxTimeValue = instance.apparentTemperatureMaxTime()) != null) {
                this.apparentTemperatureMaxTime(apparentTemperatureMaxTimeValue);
            }
            if ((apparentTemperatureMinValue = instance.apparentTemperatureMin()) != null) {
                this.apparentTemperatureMin(apparentTemperatureMinValue);
            }
            if ((apparentTemperatureMinTimeValue = instance.apparentTemperatureMinTime()) != null) {
                this.apparentTemperatureMinTime(apparentTemperatureMinTimeValue);
            }
            if ((cloudCoverValue = instance.cloudCover()) != null) {
                this.cloudCover(cloudCoverValue);
            }
            if ((dewPointValue = instance.dewPoint()) != null) {
                this.dewPoint(dewPointValue);
            }
            if ((humidityValue = instance.humidity()) != null) {
                this.humidity(humidityValue);
            }
            if ((iconValue = instance.icon()) != null) {
                this.icon(iconValue);
            }
            if ((moonPhaseValue = instance.moonPhase()) != null) {
                this.moonPhase(moonPhaseValue);
            }
            if ((nearestStormBearingValue = instance.nearestStormBearing()) != null) {
                this.nearestStormBearing(nearestStormBearingValue);
            }
            if ((nearestStormDistanceValue = instance.nearestStormDistance()) != null) {
                this.nearestStormDistance(nearestStormDistanceValue);
            }
            if ((ozoneValue = instance.ozone()) != null) {
                this.ozone(ozoneValue);
            }
            if ((precipAccumulationValue = instance.precipAccumulation()) != null) {
                this.precipAccumulation(precipAccumulationValue);
            }
            if ((precipIntensityValue = instance.precipIntensity()) != null) {
                this.precipIntensity(precipIntensityValue);
            }
            if ((precipIntensityMaxValue = instance.precipIntensityMax()) != null) {
                this.precipIntensityMax(precipIntensityMaxValue);
            }
            if ((precipIntensityMaxTimeValue = instance.precipIntensityMaxTime()) != null) {
                this.precipIntensityMaxTime(precipIntensityMaxTimeValue);
            }
            if ((precipProbabilityValue = instance.precipProbability()) != null) {
                this.precipProbability(precipProbabilityValue);
            }
            if ((precipTypeValue = instance.precipType()) != null) {
                this.precipType(precipTypeValue);
            }
            if ((pressureValue = instance.pressure()) != null) {
                this.pressure(pressureValue);
            }
            if ((summaryValue = instance.summary()) != null) {
                this.summary(summaryValue);
            }
            if ((sunriseTimeValue = instance.sunriseTime()) != null) {
                this.sunriseTime(sunriseTimeValue);
            }
            if ((sunsetTimeValue = instance.sunsetTime()) != null) {
                this.sunsetTime(sunsetTimeValue);
            }
            if ((temperatureValue = instance.temperature()) != null) {
                this.temperature(temperatureValue);
            }
            if ((temperatureMaxValue = instance.temperatureMax()) != null) {
                this.temperatureMax(temperatureMaxValue);
            }
            if ((temperatureMaxTimeValue = instance.temperatureMaxTime()) != null) {
                this.temperatureMaxTime(temperatureMaxTimeValue);
            }
            if ((temperatureMinValue = instance.temperatureMin()) != null) {
                this.temperatureMin(temperatureMinValue);
            }
            if ((temperatureMinTimeValue = instance.temperatureMinTime()) != null) {
                this.temperatureMinTime(temperatureMinTimeValue);
            }
            this.time(instance.time());
            BigDecimal visibilityValue = instance.visibility();
            if (visibilityValue != null) {
                this.visibility(visibilityValue);
            }
            if ((windBearingValue = instance.windBearing()) != null) {
                this.windBearing(windBearingValue);
            }
            if ((windSpeedValue = instance.windSpeed()) != null) {
                this.windSpeed(windSpeedValue);
            }
            return this;
        }

        @JsonProperty(value="apparentTemperature")
        public final Builder apparentTemperature(@Nullable BigDecimal apparentTemperature) {
            this.apparentTemperature = apparentTemperature;
            return this;
        }

        @JsonProperty(value="apparentTemperatureMax")
        public final Builder apparentTemperatureMax(@Nullable BigDecimal apparentTemperatureMax) {
            this.apparentTemperatureMax = apparentTemperatureMax;
            return this;
        }

        @JsonProperty(value="apparentTemperatureMaxTime")
        public final Builder apparentTemperatureMaxTime(@Nullable Long apparentTemperatureMaxTime) {
            this.apparentTemperatureMaxTime = apparentTemperatureMaxTime;
            return this;
        }

        @JsonProperty(value="apparentTemperatureMin")
        public final Builder apparentTemperatureMin(@Nullable BigDecimal apparentTemperatureMin) {
            this.apparentTemperatureMin = apparentTemperatureMin;
            return this;
        }

        @JsonProperty(value="apparentTemperatureMinTime")
        public final Builder apparentTemperatureMinTime(@Nullable Long apparentTemperatureMinTime) {
            this.apparentTemperatureMinTime = apparentTemperatureMinTime;
            return this;
        }

        @JsonProperty(value="cloudCover")
        public final Builder cloudCover(@Nullable BigDecimal cloudCover) {
            this.cloudCover = cloudCover;
            return this;
        }

        @JsonProperty(value="dewPoint")
        public final Builder dewPoint(@Nullable BigDecimal dewPoint) {
            this.dewPoint = dewPoint;
            return this;
        }

        @JsonProperty(value="humidity")
        public final Builder humidity(@Nullable BigDecimal humidity) {
            this.humidity = humidity;
            return this;
        }

        @JsonProperty(value="icon")
        public final Builder icon(@Nullable DsIcon icon) {
            this.icon = icon;
            return this;
        }

        @JsonProperty(value="moonPhase")
        public final Builder moonPhase(@Nullable BigDecimal moonPhase) {
            this.moonPhase = moonPhase;
            return this;
        }

        @JsonProperty(value="nearestStormBearing")
        public final Builder nearestStormBearing(@Nullable BigDecimal nearestStormBearing) {
            this.nearestStormBearing = nearestStormBearing;
            return this;
        }

        @JsonProperty(value="nearestStormDistance")
        public final Builder nearestStormDistance(@Nullable BigDecimal nearestStormDistance) {
            this.nearestStormDistance = nearestStormDistance;
            return this;
        }

        @JsonProperty(value="ozone")
        public final Builder ozone(@Nullable BigDecimal ozone) {
            this.ozone = ozone;
            return this;
        }

        @JsonProperty(value="precipAccumulation")
        public final Builder precipAccumulation(@Nullable BigDecimal precipAccumulation) {
            this.precipAccumulation = precipAccumulation;
            return this;
        }

        @JsonProperty(value="precipIntensity")
        public final Builder precipIntensity(@Nullable BigDecimal precipIntensity) {
            this.precipIntensity = precipIntensity;
            return this;
        }

        @JsonProperty(value="precipIntensityMax")
        public final Builder precipIntensityMax(@Nullable BigDecimal precipIntensityMax) {
            this.precipIntensityMax = precipIntensityMax;
            return this;
        }

        @JsonProperty(value="precipIntensityMaxTime")
        public final Builder precipIntensityMaxTime(@Nullable Long precipIntensityMaxTime) {
            this.precipIntensityMaxTime = precipIntensityMaxTime;
            return this;
        }

        @JsonProperty(value="precipProbability")
        public final Builder precipProbability(@Nullable BigDecimal precipProbability) {
            this.precipProbability = precipProbability;
            return this;
        }

        @JsonProperty(value="precipType")
        public final Builder precipType(@Nullable DsPrecipType precipType) {
            this.precipType = precipType;
            return this;
        }

        @JsonProperty(value="pressure")
        public final Builder pressure(@Nullable BigDecimal pressure) {
            this.pressure = pressure;
            return this;
        }

        @JsonProperty(value="summary")
        public final Builder summary(@Nullable String summary) {
            this.summary = summary;
            return this;
        }

        @JsonProperty(value="sunriseTime")
        public final Builder sunriseTime(@Nullable Long sunriseTime) {
            this.sunriseTime = sunriseTime;
            return this;
        }

        @JsonProperty(value="sunsetTime")
        public final Builder sunsetTime(@Nullable Long sunsetTime) {
            this.sunsetTime = sunsetTime;
            return this;
        }

        @JsonProperty(value="temperature")
        public final Builder temperature(@Nullable BigDecimal temperature) {
            this.temperature = temperature;
            return this;
        }

        @JsonProperty(value="temperatureMax")
        public final Builder temperatureMax(@Nullable BigDecimal temperatureMax) {
            this.temperatureMax = temperatureMax;
            return this;
        }

        @JsonProperty(value="temperatureMaxTime")
        public final Builder temperatureMaxTime(@Nullable Long temperatureMaxTime) {
            this.temperatureMaxTime = temperatureMaxTime;
            return this;
        }

        @JsonProperty(value="temperatureMin")
        public final Builder temperatureMin(@Nullable BigDecimal temperatureMin) {
            this.temperatureMin = temperatureMin;
            return this;
        }

        @JsonProperty(value="temperatureMinTime")
        public final Builder temperatureMinTime(@Nullable Long temperatureMinTime) {
            this.temperatureMinTime = temperatureMinTime;
            return this;
        }

        @JsonProperty(value="time")
        public final Builder time(long time) {
            this.time = time;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="visibility")
        public final Builder visibility(@Nullable BigDecimal visibility) {
            this.visibility = visibility;
            return this;
        }

        @JsonProperty(value="windBearing")
        public final Builder windBearing(@Nullable BigDecimal windBearing) {
            this.windBearing = windBearing;
            return this;
        }

        @JsonProperty(value="windSpeed")
        public final Builder windSpeed(@Nullable BigDecimal windSpeed) {
            this.windSpeed = windSpeed;
            return this;
        }

        public ImmutableDsDataPoint build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDsDataPoint(this.apparentTemperature, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.cloudCover, this.dewPoint, this.humidity, this.icon, this.moonPhase, this.nearestStormBearing, this.nearestStormDistance, this.ozone, this.precipAccumulation, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.pressure, this.summary, this.sunriseTime, this.sunsetTime, this.temperature, this.temperatureMax, this.temperatureMaxTime, this.temperatureMin, this.temperatureMinTime, this.time, this.visibility, this.windBearing, this.windSpeed);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("time");
            }
            return "Cannot build DsDataPoint, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends DsDataPoint {
        BigDecimal apparentTemperature;
        BigDecimal apparentTemperatureMax;
        Long apparentTemperatureMaxTime;
        BigDecimal apparentTemperatureMin;
        Long apparentTemperatureMinTime;
        BigDecimal cloudCover;
        BigDecimal dewPoint;
        BigDecimal humidity;
        DsIcon icon;
        BigDecimal moonPhase;
        BigDecimal nearestStormBearing;
        BigDecimal nearestStormDistance;
        BigDecimal ozone;
        BigDecimal precipAccumulation;
        BigDecimal precipIntensity;
        BigDecimal precipIntensityMax;
        Long precipIntensityMaxTime;
        BigDecimal precipProbability;
        DsPrecipType precipType;
        BigDecimal pressure;
        String summary;
        Long sunriseTime;
        Long sunsetTime;
        BigDecimal temperature;
        BigDecimal temperatureMax;
        Long temperatureMaxTime;
        BigDecimal temperatureMin;
        Long temperatureMinTime;
        long time;
        boolean timeIsSet;
        BigDecimal visibility;
        BigDecimal windBearing;
        BigDecimal windSpeed;

        Json() {
        }

        @JsonProperty(value="apparentTemperature")
        public void setApparentTemperature(@Nullable BigDecimal apparentTemperature) {
            this.apparentTemperature = apparentTemperature;
        }

        @JsonProperty(value="apparentTemperatureMax")
        public void setApparentTemperatureMax(@Nullable BigDecimal apparentTemperatureMax) {
            this.apparentTemperatureMax = apparentTemperatureMax;
        }

        @JsonProperty(value="apparentTemperatureMaxTime")
        public void setApparentTemperatureMaxTime(@Nullable Long apparentTemperatureMaxTime) {
            this.apparentTemperatureMaxTime = apparentTemperatureMaxTime;
        }

        @JsonProperty(value="apparentTemperatureMin")
        public void setApparentTemperatureMin(@Nullable BigDecimal apparentTemperatureMin) {
            this.apparentTemperatureMin = apparentTemperatureMin;
        }

        @JsonProperty(value="apparentTemperatureMinTime")
        public void setApparentTemperatureMinTime(@Nullable Long apparentTemperatureMinTime) {
            this.apparentTemperatureMinTime = apparentTemperatureMinTime;
        }

        @JsonProperty(value="cloudCover")
        public void setCloudCover(@Nullable BigDecimal cloudCover) {
            this.cloudCover = cloudCover;
        }

        @JsonProperty(value="dewPoint")
        public void setDewPoint(@Nullable BigDecimal dewPoint) {
            this.dewPoint = dewPoint;
        }

        @JsonProperty(value="humidity")
        public void setHumidity(@Nullable BigDecimal humidity) {
            this.humidity = humidity;
        }

        @JsonProperty(value="icon")
        @JsonDeserialize(using=DsIconDeserializer.class)
        public void setIcon(@Nullable DsIcon icon) {
            this.icon = icon;
        }

        @JsonProperty(value="moonPhase")
        public void setMoonPhase(@Nullable BigDecimal moonPhase) {
            this.moonPhase = moonPhase;
        }

        @JsonProperty(value="nearestStormBearing")
        public void setNearestStormBearing(@Nullable BigDecimal nearestStormBearing) {
            this.nearestStormBearing = nearestStormBearing;
        }

        @JsonProperty(value="nearestStormDistance")
        public void setNearestStormDistance(@Nullable BigDecimal nearestStormDistance) {
            this.nearestStormDistance = nearestStormDistance;
        }

        @JsonProperty(value="ozone")
        public void setOzone(@Nullable BigDecimal ozone) {
            this.ozone = ozone;
        }

        @JsonProperty(value="precipAccumulation")
        public void setPrecipAccumulation(@Nullable BigDecimal precipAccumulation) {
            this.precipAccumulation = precipAccumulation;
        }

        @JsonProperty(value="precipIntensity")
        public void setPrecipIntensity(@Nullable BigDecimal precipIntensity) {
            this.precipIntensity = precipIntensity;
        }

        @JsonProperty(value="precipIntensityMax")
        public void setPrecipIntensityMax(@Nullable BigDecimal precipIntensityMax) {
            this.precipIntensityMax = precipIntensityMax;
        }

        @JsonProperty(value="precipIntensityMaxTime")
        public void setPrecipIntensityMaxTime(@Nullable Long precipIntensityMaxTime) {
            this.precipIntensityMaxTime = precipIntensityMaxTime;
        }

        @JsonProperty(value="precipProbability")
        public void setPrecipProbability(@Nullable BigDecimal precipProbability) {
            this.precipProbability = precipProbability;
        }

        @JsonProperty(value="precipType")
        @JsonDeserialize(using=DsPrecipTypeDeserializer.class)
        public void setPrecipType(@Nullable DsPrecipType precipType) {
            this.precipType = precipType;
        }

        @JsonProperty(value="pressure")
        public void setPressure(@Nullable BigDecimal pressure) {
            this.pressure = pressure;
        }

        @JsonProperty(value="summary")
        public void setSummary(@Nullable String summary) {
            this.summary = summary;
        }

        @JsonProperty(value="sunriseTime")
        public void setSunriseTime(@Nullable Long sunriseTime) {
            this.sunriseTime = sunriseTime;
        }

        @JsonProperty(value="sunsetTime")
        public void setSunsetTime(@Nullable Long sunsetTime) {
            this.sunsetTime = sunsetTime;
        }

        @JsonProperty(value="temperature")
        public void setTemperature(@Nullable BigDecimal temperature) {
            this.temperature = temperature;
        }

        @JsonProperty(value="temperatureMax")
        public void setTemperatureMax(@Nullable BigDecimal temperatureMax) {
            this.temperatureMax = temperatureMax;
        }

        @JsonProperty(value="temperatureMaxTime")
        public void setTemperatureMaxTime(@Nullable Long temperatureMaxTime) {
            this.temperatureMaxTime = temperatureMaxTime;
        }

        @JsonProperty(value="temperatureMin")
        public void setTemperatureMin(@Nullable BigDecimal temperatureMin) {
            this.temperatureMin = temperatureMin;
        }

        @JsonProperty(value="temperatureMinTime")
        public void setTemperatureMinTime(@Nullable Long temperatureMinTime) {
            this.temperatureMinTime = temperatureMinTime;
        }

        @JsonProperty(value="time")
        public void setTime(long time) {
            this.time = time;
            this.timeIsSet = true;
        }

        @JsonProperty(value="visibility")
        public void setVisibility(@Nullable BigDecimal visibility) {
            this.visibility = visibility;
        }

        @JsonProperty(value="windBearing")
        public void setWindBearing(@Nullable BigDecimal windBearing) {
            this.windBearing = windBearing;
        }

        @JsonProperty(value="windSpeed")
        public void setWindSpeed(@Nullable BigDecimal windSpeed) {
            this.windSpeed = windSpeed;
        }

        @Override
        public BigDecimal apparentTemperature() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal apparentTemperatureMax() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long apparentTemperatureMaxTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal apparentTemperatureMin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long apparentTemperatureMinTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal cloudCover() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal dewPoint() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal humidity() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DsIcon icon() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal moonPhase() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal nearestStormBearing() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal nearestStormDistance() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal ozone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal precipAccumulation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal precipIntensity() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal precipIntensityMax() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long precipIntensityMaxTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal precipProbability() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DsPrecipType precipType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal pressure() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String summary() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long sunriseTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long sunsetTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal temperature() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal temperatureMax() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long temperatureMaxTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal temperatureMin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long temperatureMinTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long time() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal visibility() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal windBearing() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal windSpeed() {
            throw new UnsupportedOperationException();
        }
    }
}

