package ch.rasc.darksky.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link DsTimeMachineRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new DsTimeMachineRequest.Builder()}.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "DsTimeMachineRequest"})
final class ImmutableDsTimeMachineRequest implements DsTimeMachineRequest {
  private final String latitude;
  private final String longitude;
  private final long time;
  private final @Nullable DsLanguage language;
  private final @Nullable DsUnit unit;
  private final Set<DsBlock> excludeBlocks;
  private final Set<DsBlock> includeBlocks;

  private ImmutableDsTimeMachineRequest(
      String latitude,
      String longitude,
      long time,
      @Nullable DsLanguage language,
      @Nullable DsUnit unit,
      Set<DsBlock> excludeBlocks,
      Set<DsBlock> includeBlocks) {
    this.latitude = latitude;
    this.longitude = longitude;
    this.time = time;
    this.language = language;
    this.unit = unit;
    this.excludeBlocks = excludeBlocks;
    this.includeBlocks = includeBlocks;
  }

  /**
   * @return The value of the {@code latitude} attribute
   */
  @Override
  public String latitude() {
    return latitude;
  }

  /**
   * @return The value of the {@code longitude} attribute
   */
  @Override
  public String longitude() {
    return longitude;
  }

  /**
   * @return The value of the {@code time} attribute
   */
  @Override
  public long time() {
    return time;
  }

  /**
   * @return The value of the {@code language} attribute
   */
  @Override
  public @Nullable DsLanguage language() {
    return language;
  }

  /**
   * @return The value of the {@code unit} attribute
   */
  @Override
  public @Nullable DsUnit unit() {
    return unit;
  }

  /**
   * @return The value of the {@code excludeBlocks} attribute
   */
  @Override
  public Set<DsBlock> excludeBlocks() {
    return excludeBlocks;
  }

  /**
   * @return The value of the {@code includeBlocks} attribute
   */
  @Override
  public Set<DsBlock> includeBlocks() {
    return includeBlocks;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsTimeMachineRequest#latitude() latitude} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for latitude
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsTimeMachineRequest withLatitude(String value) {
    if (this.latitude.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "latitude");
    return new ImmutableDsTimeMachineRequest(
        newValue,
        this.longitude,
        this.time,
        this.language,
        this.unit,
        this.excludeBlocks,
        this.includeBlocks);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsTimeMachineRequest#longitude() longitude} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for longitude
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsTimeMachineRequest withLongitude(String value) {
    if (this.longitude.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "longitude");
    return new ImmutableDsTimeMachineRequest(
        this.latitude,
        newValue,
        this.time,
        this.language,
        this.unit,
        this.excludeBlocks,
        this.includeBlocks);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsTimeMachineRequest#time() time} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for time
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsTimeMachineRequest withTime(long value) {
    if (this.time == value) return this;
    return new ImmutableDsTimeMachineRequest(
        this.latitude,
        this.longitude,
        value,
        this.language,
        this.unit,
        this.excludeBlocks,
        this.includeBlocks);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsTimeMachineRequest#language() language} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for language (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsTimeMachineRequest withLanguage(@Nullable DsLanguage value) {
    if (this.language == value) return this;
    return new ImmutableDsTimeMachineRequest(
        this.latitude,
        this.longitude,
        this.time,
        value,
        this.unit,
        this.excludeBlocks,
        this.includeBlocks);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsTimeMachineRequest#unit() unit} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for unit (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsTimeMachineRequest withUnit(@Nullable DsUnit value) {
    if (this.unit == value) return this;
    return new ImmutableDsTimeMachineRequest(
        this.latitude,
        this.longitude,
        this.time,
        this.language,
        value,
        this.excludeBlocks,
        this.includeBlocks);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DsTimeMachineRequest#excludeBlocks() excludeBlocks}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDsTimeMachineRequest withExcludeBlocks(DsBlock... elements) {
    Set<DsBlock> newValue = createUnmodifiableEnumSet(Arrays.asList(elements));
    return new ImmutableDsTimeMachineRequest(
        this.latitude,
        this.longitude,
        this.time,
        this.language,
        this.unit,
        newValue,
        this.includeBlocks);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DsTimeMachineRequest#excludeBlocks() excludeBlocks}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of excludeBlocks elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDsTimeMachineRequest withExcludeBlocks(Iterable<DsBlock> elements) {
    if (this.excludeBlocks == elements) return this;
    Set<DsBlock> newValue = createUnmodifiableEnumSet(elements);
    return new ImmutableDsTimeMachineRequest(
        this.latitude,
        this.longitude,
        this.time,
        this.language,
        this.unit,
        newValue,
        this.includeBlocks);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DsTimeMachineRequest#includeBlocks() includeBlocks}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDsTimeMachineRequest withIncludeBlocks(DsBlock... elements) {
    Set<DsBlock> newValue = createUnmodifiableEnumSet(Arrays.asList(elements));
    return new ImmutableDsTimeMachineRequest(
        this.latitude,
        this.longitude,
        this.time,
        this.language,
        this.unit,
        this.excludeBlocks,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DsTimeMachineRequest#includeBlocks() includeBlocks}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of includeBlocks elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDsTimeMachineRequest withIncludeBlocks(Iterable<DsBlock> elements) {
    if (this.includeBlocks == elements) return this;
    Set<DsBlock> newValue = createUnmodifiableEnumSet(elements);
    return new ImmutableDsTimeMachineRequest(
        this.latitude,
        this.longitude,
        this.time,
        this.language,
        this.unit,
        this.excludeBlocks,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDsTimeMachineRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDsTimeMachineRequest
        && equalTo((ImmutableDsTimeMachineRequest) another);
  }

  private boolean equalTo(ImmutableDsTimeMachineRequest another) {
    return latitude.equals(another.latitude)
        && longitude.equals(another.longitude)
        && time == another.time
        && Objects.equals(language, another.language)
        && Objects.equals(unit, another.unit)
        && excludeBlocks.equals(another.excludeBlocks)
        && includeBlocks.equals(another.includeBlocks);
  }

  /**
   * Computes a hash code from attributes: {@code latitude}, {@code longitude}, {@code time}, {@code language}, {@code unit}, {@code excludeBlocks}, {@code includeBlocks}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + latitude.hashCode();
    h = h * 17 + longitude.hashCode();
    h = h * 17 + Long.hashCode(time);
    h = h * 17 + Objects.hashCode(language);
    h = h * 17 + Objects.hashCode(unit);
    h = h * 17 + excludeBlocks.hashCode();
    h = h * 17 + includeBlocks.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DsTimeMachineRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DsTimeMachineRequest{"
        + "latitude=" + latitude
        + ", longitude=" + longitude
        + ", time=" + time
        + ", language=" + language
        + ", unit=" + unit
        + ", excludeBlocks=" + excludeBlocks
        + ", includeBlocks=" + includeBlocks
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link DsTimeMachineRequest} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DsTimeMachineRequest instance
   */
  public static ImmutableDsTimeMachineRequest copyOf(DsTimeMachineRequest instance) {
    if (instance instanceof ImmutableDsTimeMachineRequest) {
      return (ImmutableDsTimeMachineRequest) instance;
    }
    return new DsTimeMachineRequest.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableDsTimeMachineRequest ImmutableDsTimeMachineRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static class Builder {
    private static final long INIT_BIT_LATITUDE = 0x1L;
    private static final long INIT_BIT_LONGITUDE = 0x2L;
    private static final long INIT_BIT_TIME = 0x4L;
    private long initBits = 0x7L;

    private String latitude;
    private String longitude;
    private long time;
    private DsLanguage language;
    private DsUnit unit;
    private EnumSet<DsBlock> excludeBlocks = EnumSet.noneOf(DsBlock.class);
    private EnumSet<DsBlock> includeBlocks = EnumSet.noneOf(DsBlock.class);

    /**
     * Creates a builder for {@link ImmutableDsTimeMachineRequest ImmutableDsTimeMachineRequest} instances.
     */
    Builder() {
      if (!(this instanceof DsTimeMachineRequest.Builder)) {
        throw new UnsupportedOperationException("Use: new DsTimeMachineRequest.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code DsTimeMachineRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final DsTimeMachineRequest.Builder from(DsTimeMachineRequest instance) {
      Objects.requireNonNull(instance, "instance");
      latitude(instance.latitude());
      longitude(instance.longitude());
      time(instance.time());
      @Nullable DsLanguage languageValue = instance.language();
      if (languageValue != null) {
        language(languageValue);
      }
      @Nullable DsUnit unitValue = instance.unit();
      if (unitValue != null) {
        unit(unitValue);
      }
      addAllExcludeBlocks(instance.excludeBlocks());
      addAllIncludeBlocks(instance.includeBlocks());
      return (DsTimeMachineRequest.Builder) this;
    }

    /**
     * Initializes the value for the {@link DsTimeMachineRequest#latitude() latitude} attribute.
     * @param latitude The value for latitude 
     * @return {@code this} builder for use in a chained invocation
     */
    public final DsTimeMachineRequest.Builder latitude(String latitude) {
      this.latitude = Objects.requireNonNull(latitude, "latitude");
      initBits &= ~INIT_BIT_LATITUDE;
      return (DsTimeMachineRequest.Builder) this;
    }

    /**
     * Initializes the value for the {@link DsTimeMachineRequest#longitude() longitude} attribute.
     * @param longitude The value for longitude 
     * @return {@code this} builder for use in a chained invocation
     */
    public final DsTimeMachineRequest.Builder longitude(String longitude) {
      this.longitude = Objects.requireNonNull(longitude, "longitude");
      initBits &= ~INIT_BIT_LONGITUDE;
      return (DsTimeMachineRequest.Builder) this;
    }

    /**
     * Initializes the value for the {@link DsTimeMachineRequest#time() time} attribute.
     * @param time The value for time 
     * @return {@code this} builder for use in a chained invocation
     */
    public final DsTimeMachineRequest.Builder time(long time) {
      this.time = time;
      initBits &= ~INIT_BIT_TIME;
      return (DsTimeMachineRequest.Builder) this;
    }

    /**
     * Initializes the value for the {@link DsTimeMachineRequest#language() language} attribute.
     * @param language The value for language (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final DsTimeMachineRequest.Builder language(@Nullable DsLanguage language) {
      this.language = language;
      return (DsTimeMachineRequest.Builder) this;
    }

    /**
     * Initializes the value for the {@link DsTimeMachineRequest#unit() unit} attribute.
     * @param unit The value for unit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final DsTimeMachineRequest.Builder unit(@Nullable DsUnit unit) {
      this.unit = unit;
      return (DsTimeMachineRequest.Builder) this;
    }

    /**
     * Adds one element to {@link DsTimeMachineRequest#excludeBlocks() excludeBlocks} set.
     * @param element A excludeBlocks element
     * @return {@code this} builder for use in a chained invocation
     */
    public final DsTimeMachineRequest.Builder excludeBlock(DsBlock element) {
      this.excludeBlocks.add(Objects.requireNonNull(element, "excludeBlocks element"));
      return (DsTimeMachineRequest.Builder) this;
    }

    /**
     * Adds elements to {@link DsTimeMachineRequest#excludeBlocks() excludeBlocks} set.
     * @param elements An array of excludeBlocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final DsTimeMachineRequest.Builder excludeBlock(DsBlock... elements) {
      for (DsBlock element : elements) {
        this.excludeBlocks.add(Objects.requireNonNull(element, "excludeBlocks element"));
      }
      return (DsTimeMachineRequest.Builder) this;
    }

    /**
     * Sets or replaces all elements for {@link DsTimeMachineRequest#excludeBlocks() excludeBlocks} set.
     * @param elements An iterable of excludeBlocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final DsTimeMachineRequest.Builder excludeBlocks(Iterable<DsBlock> elements) {
      this.excludeBlocks.clear();
      return addAllExcludeBlocks(elements);
    }

    /**
     * Adds elements to {@link DsTimeMachineRequest#excludeBlocks() excludeBlocks} set.
     * @param elements An iterable of excludeBlocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final DsTimeMachineRequest.Builder addAllExcludeBlocks(Iterable<DsBlock> elements) {
      for (DsBlock element : elements) {
        this.excludeBlocks.add(Objects.requireNonNull(element, "excludeBlocks element"));
      }
      return (DsTimeMachineRequest.Builder) this;
    }

    /**
     * Adds one element to {@link DsTimeMachineRequest#includeBlocks() includeBlocks} set.
     * @param element A includeBlocks element
     * @return {@code this} builder for use in a chained invocation
     */
    public final DsTimeMachineRequest.Builder includeBlock(DsBlock element) {
      this.includeBlocks.add(Objects.requireNonNull(element, "includeBlocks element"));
      return (DsTimeMachineRequest.Builder) this;
    }

    /**
     * Adds elements to {@link DsTimeMachineRequest#includeBlocks() includeBlocks} set.
     * @param elements An array of includeBlocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final DsTimeMachineRequest.Builder includeBlock(DsBlock... elements) {
      for (DsBlock element : elements) {
        this.includeBlocks.add(Objects.requireNonNull(element, "includeBlocks element"));
      }
      return (DsTimeMachineRequest.Builder) this;
    }

    /**
     * Sets or replaces all elements for {@link DsTimeMachineRequest#includeBlocks() includeBlocks} set.
     * @param elements An iterable of includeBlocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final DsTimeMachineRequest.Builder includeBlocks(Iterable<DsBlock> elements) {
      this.includeBlocks.clear();
      return addAllIncludeBlocks(elements);
    }

    /**
     * Adds elements to {@link DsTimeMachineRequest#includeBlocks() includeBlocks} set.
     * @param elements An iterable of includeBlocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final DsTimeMachineRequest.Builder addAllIncludeBlocks(Iterable<DsBlock> elements) {
      for (DsBlock element : elements) {
        this.includeBlocks.add(Objects.requireNonNull(element, "includeBlocks element"));
      }
      return (DsTimeMachineRequest.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableDsTimeMachineRequest ImmutableDsTimeMachineRequest}.
     * @return An immutable instance of DsTimeMachineRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDsTimeMachineRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDsTimeMachineRequest(
          latitude,
          longitude,
          time,
          language,
          unit,
          createUnmodifiableEnumSet(excludeBlocks),
          createUnmodifiableEnumSet(includeBlocks));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_LATITUDE) != 0) attributes.add("latitude");
      if ((initBits & INIT_BIT_LONGITUDE) != 0) attributes.add("longitude");
      if ((initBits & INIT_BIT_TIME) != 0) attributes.add("time");
      return "Cannot build DsTimeMachineRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T extends Enum<T>> Set<T> createUnmodifiableEnumSet(Iterable<T> iterable) {
    if (iterable instanceof EnumSet<?>) {
      return Collections.unmodifiableSet(EnumSet.copyOf((EnumSet<T>) iterable));
    }
    List<T> list = createSafeList(iterable, true, false);
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default: return Collections.unmodifiableSet(EnumSet.copyOf(list));
    }
  }
}
