/**
 * Copyright 2016-2016 Ralph Schaer <ralphschaer@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ch.rasc.darksky.model;

public enum DsLanguage {

	/** Arabic */
	AR,

	/** Azerbaijani */
	AZ,

	/** Belarusian */
	BE,

	/** Bosnian */
	BS,

	/** Czech */
	CS,

	/** German */
	DE,

	/** Greek */
	EL,

	/** English, which is the default */
	EN,

	/** Spanish */
	ES,

	/** French */
	FR,

	/** Croatian */
	HR,

	/** Hungarian */
	HU,

	/** Indonesian */
	ID,

	/** Italian */
	IT,

	/** Icelandic */
	IS,

	/** Cornish */
	KW,

	/** Norwegian Bokmål */
	NB,

	/** Dutch */
	NL,

	/** Polish */
	PL,

	/** Portuguese */
	PT,

	/** Russian */
	RU,

	/** Slovak */
	SK,

	/** Serbian */
	SR,

	/** Swedish */
	SV,

	/** Tetum */
	TET,

	/** Turkish */
	TR,

	/** Ukrainian */
	UK,

	/** Igpay Atinlay */
	X_PIG_LATIN,

	/** simplified Chinese */
	ZH,

	/** traditional Chinese */
	ZH_TW
}
