package ch.rasc.darksky.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link DsResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDsResponse.builder()}.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "DsResponse"})
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableDsResponse implements DsResponse {
  private final BigDecimal latitude;
  private final BigDecimal longitude;
  private final String timezone;
  private final int offset;
  private final @Nullable DsDataPoint currently;
  private final @Nullable DsDataBlock minutely;
  private final @Nullable DsDataBlock hourly;
  private final @Nullable DsDataBlock daily;
  private final List<DsAlert> alerts;
  private final @Nullable DsFlag flags;

  private ImmutableDsResponse(
      BigDecimal latitude,
      BigDecimal longitude,
      String timezone,
      int offset,
      @Nullable DsDataPoint currently,
      @Nullable DsDataBlock minutely,
      @Nullable DsDataBlock hourly,
      @Nullable DsDataBlock daily,
      List<DsAlert> alerts,
      @Nullable DsFlag flags) {
    this.latitude = latitude;
    this.longitude = longitude;
    this.timezone = timezone;
    this.offset = offset;
    this.currently = currently;
    this.minutely = minutely;
    this.hourly = hourly;
    this.daily = daily;
    this.alerts = alerts;
    this.flags = flags;
  }

  /**
   * The requested latitude.
   */
  @JsonProperty("latitude")
  @Override
  public BigDecimal latitude() {
    return latitude;
  }

  /**
   * The requested longitude.
   */
  @JsonProperty("longitude")
  @Override
  public BigDecimal longitude() {
    return longitude;
  }

  /**
   * The IANA timezone name for the requested location. This is used for the
   * {@link DsDataPoint#summary()} text and for determining when {@link #hourly()} and
   * {@link #daily()} data block objects begin.
   */
  @JsonProperty("timezone")
  @Override
  public String timezone() {
    return timezone;
  }

  /**
   * The current timezone offset in hours. (Use of this property will almost certainly
   * result in Daylight Saving Time bugs. Please use timezone, instead.)
   */
  @JsonProperty("offset")
  @Override
  public int offset() {
    return offset;
  }

  /**
   * An instance of {@link DsDataPoint} containing the current weather conditions at the
   * requested location.
   */
  @JsonProperty("currently")
  @Override
  public @Nullable DsDataPoint currently() {
    return currently;
  }

  /**
   * An instance of {@link DsDataPoint} containing the weather conditions
   * minute-by-minute for the next hour.
   */
  @JsonProperty("minutely")
  @Override
  public @Nullable DsDataBlock minutely() {
    return minutely;
  }

  /**
   * An instance of {@link DsDataPoint} containing the weather conditions hour-by-hour
   * for the next two days.
   */
  @JsonProperty("hourly")
  @Override
  public @Nullable DsDataBlock hourly() {
    return hourly;
  }

  /**
   * An instance of {@link DsDataPoint} containing the weather conditions day-by-day for
   * the next week.
   */
  @JsonProperty("daily")
  @Override
  public @Nullable DsDataBlock daily() {
    return daily;
  }

  /**
   * A collection of {@link DsAlert} instances, which, if present, contains any severe
   * weather alerts, issued by a governmental weather authority, pertinent to the
   * requested location.
   */
  @JsonProperty("alerts")
  @Override
  public List<DsAlert> alerts() {
    return alerts;
  }

  /**
   * An instance of {@link DsFlag} containing miscellaneous metadata about the request.
   */
  @JsonProperty("flags")
  @Override
  public @Nullable DsFlag flags() {
    return flags;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsResponse#latitude() latitude} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for latitude
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsResponse withLatitude(BigDecimal value) {
    if (this.latitude == value) return this;
    BigDecimal newValue = Objects.requireNonNull(value, "latitude");
    return new ImmutableDsResponse(
        newValue,
        this.longitude,
        this.timezone,
        this.offset,
        this.currently,
        this.minutely,
        this.hourly,
        this.daily,
        this.alerts,
        this.flags);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsResponse#longitude() longitude} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for longitude
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsResponse withLongitude(BigDecimal value) {
    if (this.longitude == value) return this;
    BigDecimal newValue = Objects.requireNonNull(value, "longitude");
    return new ImmutableDsResponse(
        this.latitude,
        newValue,
        this.timezone,
        this.offset,
        this.currently,
        this.minutely,
        this.hourly,
        this.daily,
        this.alerts,
        this.flags);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsResponse#timezone() timezone} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for timezone
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsResponse withTimezone(String value) {
    if (this.timezone.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "timezone");
    return new ImmutableDsResponse(
        this.latitude,
        this.longitude,
        newValue,
        this.offset,
        this.currently,
        this.minutely,
        this.hourly,
        this.daily,
        this.alerts,
        this.flags);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsResponse#offset() offset} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for offset
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsResponse withOffset(int value) {
    if (this.offset == value) return this;
    return new ImmutableDsResponse(
        this.latitude,
        this.longitude,
        this.timezone,
        value,
        this.currently,
        this.minutely,
        this.hourly,
        this.daily,
        this.alerts,
        this.flags);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsResponse#currently() currently} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for currently (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsResponse withCurrently(@Nullable DsDataPoint value) {
    if (this.currently == value) return this;
    return new ImmutableDsResponse(
        this.latitude,
        this.longitude,
        this.timezone,
        this.offset,
        value,
        this.minutely,
        this.hourly,
        this.daily,
        this.alerts,
        this.flags);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsResponse#minutely() minutely} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for minutely (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsResponse withMinutely(@Nullable DsDataBlock value) {
    if (this.minutely == value) return this;
    return new ImmutableDsResponse(
        this.latitude,
        this.longitude,
        this.timezone,
        this.offset,
        this.currently,
        value,
        this.hourly,
        this.daily,
        this.alerts,
        this.flags);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsResponse#hourly() hourly} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hourly (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsResponse withHourly(@Nullable DsDataBlock value) {
    if (this.hourly == value) return this;
    return new ImmutableDsResponse(
        this.latitude,
        this.longitude,
        this.timezone,
        this.offset,
        this.currently,
        this.minutely,
        value,
        this.daily,
        this.alerts,
        this.flags);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsResponse#daily() daily} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for daily (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsResponse withDaily(@Nullable DsDataBlock value) {
    if (this.daily == value) return this;
    return new ImmutableDsResponse(
        this.latitude,
        this.longitude,
        this.timezone,
        this.offset,
        this.currently,
        this.minutely,
        this.hourly,
        value,
        this.alerts,
        this.flags);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DsResponse#alerts() alerts}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDsResponse withAlerts(DsAlert... elements) {
    List<DsAlert> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableDsResponse(
        this.latitude,
        this.longitude,
        this.timezone,
        this.offset,
        this.currently,
        this.minutely,
        this.hourly,
        this.daily,
        newValue,
        this.flags);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DsResponse#alerts() alerts}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of alerts elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDsResponse withAlerts(Iterable<? extends DsAlert> elements) {
    if (this.alerts == elements) return this;
    List<DsAlert> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableDsResponse(
        this.latitude,
        this.longitude,
        this.timezone,
        this.offset,
        this.currently,
        this.minutely,
        this.hourly,
        this.daily,
        newValue,
        this.flags);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DsResponse#flags() flags} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for flags (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDsResponse withFlags(@Nullable DsFlag value) {
    if (this.flags == value) return this;
    return new ImmutableDsResponse(
        this.latitude,
        this.longitude,
        this.timezone,
        this.offset,
        this.currently,
        this.minutely,
        this.hourly,
        this.daily,
        this.alerts,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDsResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDsResponse
        && equalTo((ImmutableDsResponse) another);
  }

  private boolean equalTo(ImmutableDsResponse another) {
    return latitude.equals(another.latitude)
        && longitude.equals(another.longitude)
        && timezone.equals(another.timezone)
        && offset == another.offset
        && Objects.equals(currently, another.currently)
        && Objects.equals(minutely, another.minutely)
        && Objects.equals(hourly, another.hourly)
        && Objects.equals(daily, another.daily)
        && alerts.equals(another.alerts)
        && Objects.equals(flags, another.flags);
  }

  /**
   * Computes a hash code from attributes: {@code latitude}, {@code longitude}, {@code timezone}, {@code offset}, {@code currently}, {@code minutely}, {@code hourly}, {@code daily}, {@code alerts}, {@code flags}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + latitude.hashCode();
    h = h * 17 + longitude.hashCode();
    h = h * 17 + timezone.hashCode();
    h = h * 17 + offset;
    h = h * 17 + Objects.hashCode(currently);
    h = h * 17 + Objects.hashCode(minutely);
    h = h * 17 + Objects.hashCode(hourly);
    h = h * 17 + Objects.hashCode(daily);
    h = h * 17 + alerts.hashCode();
    h = h * 17 + Objects.hashCode(flags);
    return h;
  }

  /**
   * Prints the immutable value {@code DsResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DsResponse{"
        + "latitude=" + latitude
        + ", longitude=" + longitude
        + ", timezone=" + timezone
        + ", offset=" + offset
        + ", currently=" + currently
        + ", minutely=" + minutely
        + ", hourly=" + hourly
        + ", daily=" + daily
        + ", alerts=" + alerts
        + ", flags=" + flags
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DsResponse {
    BigDecimal latitude;
    BigDecimal longitude;
    String timezone;
    int offset;
    boolean offsetIsSet;
    DsDataPoint currently;
    DsDataBlock minutely;
    DsDataBlock hourly;
    DsDataBlock daily;
    List<DsAlert> alerts = Collections.emptyList();
    DsFlag flags;
    @JsonProperty("latitude")
    public void setLatitude(BigDecimal latitude) {
      this.latitude = latitude;
    }
    @JsonProperty("longitude")
    public void setLongitude(BigDecimal longitude) {
      this.longitude = longitude;
    }
    @JsonProperty("timezone")
    public void setTimezone(String timezone) {
      this.timezone = timezone;
    }
    @JsonProperty("offset")
    public void setOffset(int offset) {
      this.offset = offset;
      this.offsetIsSet = true;
    }
    @JsonProperty("currently")
    public void setCurrently(@Nullable DsDataPoint currently) {
      this.currently = currently;
    }
    @JsonProperty("minutely")
    public void setMinutely(@Nullable DsDataBlock minutely) {
      this.minutely = minutely;
    }
    @JsonProperty("hourly")
    public void setHourly(@Nullable DsDataBlock hourly) {
      this.hourly = hourly;
    }
    @JsonProperty("daily")
    public void setDaily(@Nullable DsDataBlock daily) {
      this.daily = daily;
    }
    @JsonProperty("alerts")
    public void setAlerts(List<DsAlert> alerts) {
      this.alerts = alerts;
    }
    @JsonProperty("flags")
    public void setFlags(@Nullable DsFlag flags) {
      this.flags = flags;
    }
    @Override
    public BigDecimal latitude() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal longitude() { throw new UnsupportedOperationException(); }
    @Override
    public String timezone() { throw new UnsupportedOperationException(); }
    @Override
    public int offset() { throw new UnsupportedOperationException(); }
    @Override
    public DsDataPoint currently() { throw new UnsupportedOperationException(); }
    @Override
    public DsDataBlock minutely() { throw new UnsupportedOperationException(); }
    @Override
    public DsDataBlock hourly() { throw new UnsupportedOperationException(); }
    @Override
    public DsDataBlock daily() { throw new UnsupportedOperationException(); }
    @Override
    public List<DsAlert> alerts() { throw new UnsupportedOperationException(); }
    @Override
    public DsFlag flags() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDsResponse fromJson(Json json) {
    ImmutableDsResponse.Builder builder = ImmutableDsResponse.builder();
    if (json.latitude != null) {
      builder.latitude(json.latitude);
    }
    if (json.longitude != null) {
      builder.longitude(json.longitude);
    }
    if (json.timezone != null) {
      builder.timezone(json.timezone);
    }
    if (json.offsetIsSet) {
      builder.offset(json.offset);
    }
    if (json.currently != null) {
      builder.currently(json.currently);
    }
    if (json.minutely != null) {
      builder.minutely(json.minutely);
    }
    if (json.hourly != null) {
      builder.hourly(json.hourly);
    }
    if (json.daily != null) {
      builder.daily(json.daily);
    }
    if (json.alerts != null) {
      builder.addAllAlerts(json.alerts);
    }
    if (json.flags != null) {
      builder.flags(json.flags);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DsResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DsResponse instance
   */
  public static ImmutableDsResponse copyOf(DsResponse instance) {
    if (instance instanceof ImmutableDsResponse) {
      return (ImmutableDsResponse) instance;
    }
    return ImmutableDsResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDsResponse ImmutableDsResponse}.
   * @return A new ImmutableDsResponse builder
   */
  public static ImmutableDsResponse.Builder builder() {
    return new ImmutableDsResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDsResponse ImmutableDsResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_LATITUDE = 0x1L;
    private static final long INIT_BIT_LONGITUDE = 0x2L;
    private static final long INIT_BIT_TIMEZONE = 0x4L;
    private static final long INIT_BIT_OFFSET = 0x8L;
    private long initBits = 0xfL;

    private BigDecimal latitude;
    private BigDecimal longitude;
    private String timezone;
    private int offset;
    private DsDataPoint currently;
    private DsDataBlock minutely;
    private DsDataBlock hourly;
    private DsDataBlock daily;
    private List<DsAlert> alerts = new ArrayList<DsAlert>();
    private DsFlag flags;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DsResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DsResponse instance) {
      Objects.requireNonNull(instance, "instance");
      latitude(instance.latitude());
      longitude(instance.longitude());
      timezone(instance.timezone());
      offset(instance.offset());
      @Nullable DsDataPoint currentlyValue = instance.currently();
      if (currentlyValue != null) {
        currently(currentlyValue);
      }
      @Nullable DsDataBlock minutelyValue = instance.minutely();
      if (minutelyValue != null) {
        minutely(minutelyValue);
      }
      @Nullable DsDataBlock hourlyValue = instance.hourly();
      if (hourlyValue != null) {
        hourly(hourlyValue);
      }
      @Nullable DsDataBlock dailyValue = instance.daily();
      if (dailyValue != null) {
        daily(dailyValue);
      }
      addAllAlerts(instance.alerts());
      @Nullable DsFlag flagsValue = instance.flags();
      if (flagsValue != null) {
        flags(flagsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DsResponse#latitude() latitude} attribute.
     * @param latitude The value for latitude 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("latitude")
    public final Builder latitude(BigDecimal latitude) {
      this.latitude = Objects.requireNonNull(latitude, "latitude");
      initBits &= ~INIT_BIT_LATITUDE;
      return this;
    }

    /**
     * Initializes the value for the {@link DsResponse#longitude() longitude} attribute.
     * @param longitude The value for longitude 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("longitude")
    public final Builder longitude(BigDecimal longitude) {
      this.longitude = Objects.requireNonNull(longitude, "longitude");
      initBits &= ~INIT_BIT_LONGITUDE;
      return this;
    }

    /**
     * Initializes the value for the {@link DsResponse#timezone() timezone} attribute.
     * @param timezone The value for timezone 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("timezone")
    public final Builder timezone(String timezone) {
      this.timezone = Objects.requireNonNull(timezone, "timezone");
      initBits &= ~INIT_BIT_TIMEZONE;
      return this;
    }

    /**
     * Initializes the value for the {@link DsResponse#offset() offset} attribute.
     * @param offset The value for offset 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("offset")
    public final Builder offset(int offset) {
      this.offset = offset;
      initBits &= ~INIT_BIT_OFFSET;
      return this;
    }

    /**
     * Initializes the value for the {@link DsResponse#currently() currently} attribute.
     * @param currently The value for currently (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("currently")
    public final Builder currently(@Nullable DsDataPoint currently) {
      this.currently = currently;
      return this;
    }

    /**
     * Initializes the value for the {@link DsResponse#minutely() minutely} attribute.
     * @param minutely The value for minutely (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("minutely")
    public final Builder minutely(@Nullable DsDataBlock minutely) {
      this.minutely = minutely;
      return this;
    }

    /**
     * Initializes the value for the {@link DsResponse#hourly() hourly} attribute.
     * @param hourly The value for hourly (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("hourly")
    public final Builder hourly(@Nullable DsDataBlock hourly) {
      this.hourly = hourly;
      return this;
    }

    /**
     * Initializes the value for the {@link DsResponse#daily() daily} attribute.
     * @param daily The value for daily (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("daily")
    public final Builder daily(@Nullable DsDataBlock daily) {
      this.daily = daily;
      return this;
    }

    /**
     * Adds one element to {@link DsResponse#alerts() alerts} list.
     * @param element A alerts element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAlerts(DsAlert element) {
      this.alerts.add(Objects.requireNonNull(element, "alerts element"));
      return this;
    }

    /**
     * Adds elements to {@link DsResponse#alerts() alerts} list.
     * @param elements An array of alerts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAlerts(DsAlert... elements) {
      for (DsAlert element : elements) {
        this.alerts.add(Objects.requireNonNull(element, "alerts element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link DsResponse#alerts() alerts} list.
     * @param elements An iterable of alerts elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("alerts")
    public final Builder alerts(Iterable<? extends DsAlert> elements) {
      this.alerts.clear();
      return addAllAlerts(elements);
    }

    /**
     * Adds elements to {@link DsResponse#alerts() alerts} list.
     * @param elements An iterable of alerts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAlerts(Iterable<? extends DsAlert> elements) {
      for (DsAlert element : elements) {
        this.alerts.add(Objects.requireNonNull(element, "alerts element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DsResponse#flags() flags} attribute.
     * @param flags The value for flags (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("flags")
    public final Builder flags(@Nullable DsFlag flags) {
      this.flags = flags;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDsResponse ImmutableDsResponse}.
     * @return An immutable instance of DsResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDsResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDsResponse(
          latitude,
          longitude,
          timezone,
          offset,
          currently,
          minutely,
          hourly,
          daily,
          createUnmodifiableList(true, alerts),
          flags);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_LATITUDE) != 0) attributes.add("latitude");
      if ((initBits & INIT_BIT_LONGITUDE) != 0) attributes.add("longitude");
      if ((initBits & INIT_BIT_TIMEZONE) != 0) attributes.add("timezone");
      if ((initBits & INIT_BIT_OFFSET) != 0) attributes.add("offset");
      return "Cannot build DsResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
