/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.constgen;

import ch.rasc.constgen.CodeGenerator;
import com.google.auto.service.AutoService;
import java.io.Writer;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"org.springframework.data.mongodb.core.mapping.Document", "org.mongodb.morphia.annotations.Entity", "ch.rasc.bsoncodec.annotation.BsonDocument"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@AutoService(value=Processor.class)
public class ConstAnnotationProcessor
extends AbstractProcessor {
    private static final boolean ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS = false;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Running " + this.getClass().getSimpleName());
        if (roundEnv.processingOver() || annotations.size() == 0) {
            return false;
        }
        if (roundEnv.getRootElements() == null || roundEnv.getRootElements().isEmpty()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "No sources to process");
            return false;
        }
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(typeElement);
            boolean bsoncodecProject = typeElement.getQualifiedName().contentEquals("ch.rasc.bsoncodec.annotation.BsonDocument");
            for (Element element : elements) {
                try {
                    TypeElement typeElement2 = (TypeElement)element;
                    CodeGenerator codeGen = new CodeGenerator(typeElement2, this.processingEnv.getElementUtils(), bsoncodecProject);
                    JavaFileObject jfo = this.processingEnv.getFiler().createSourceFile(codeGen.getPackageName() + "." + codeGen.getClassName(), new Element[0]);
                    Writer writer = jfo.openWriter();
                    Throwable throwable = null;
                    try {
                        codeGen.generate(writer);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (writer == null) continue;
                        if (throwable != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        writer.close();
                    }
                }
                catch (Exception e) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
                }
            }
        }
        return false;
    }
}

