/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.constgen;

import ch.rasc.constgen.Constant;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;

public class CodeGenerator {
    private final TypeElement typeElement;
    private String packageName;
    private String className;
    private final Elements elements;
    private final boolean bsoncodecProject;

    public CodeGenerator(TypeElement typeElement, Elements elements, boolean bsoncodecProject) {
        this.typeElement = typeElement;
        this.packageName = elements.getPackageOf(typeElement).getQualifiedName().toString();
        this.className = "C" + typeElement.getSimpleName();
        this.elements = elements;
        this.bsoncodecProject = bsoncodecProject;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void generate(Appendable appendable) throws IOException {
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)this.className);
        classBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        for (Constant constant : this.collectFields()) {
            FieldSpec fieldSpec = FieldSpec.builder(String.class, (String)constant.getName(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC}).initializer("$S", new Object[]{constant.getValue()}).build();
            classBuilder.addField(fieldSpec);
        }
        JavaFile javaFile = JavaFile.builder((String)this.packageName, (TypeSpec)classBuilder.build()).build();
        javaFile.writeTo(appendable);
    }

    private List<Constant> collectFields() {
        ArrayList<Constant> fields = new ArrayList<Constant>();
        for (Element element : this.typeElement.getEnclosedElements()) {
            VariableElement varEl;
            if (element.getKind() != ElementKind.FIELD || this.isTransient(varEl = (VariableElement)element) || CodeGenerator.isStatic(varEl)) continue;
            String value = this.getValue(varEl);
            fields.add(new Constant(element.getSimpleName().toString(), value));
        }
        Collections.sort(fields);
        return fields;
    }

    private static boolean isStatic(VariableElement el) {
        return el.getModifiers().contains((Object)Modifier.STATIC);
    }

    private boolean isTransient(VariableElement el) {
        for (AnnotationMirror annotationMirror : this.elements.getAllAnnotationMirrors(el)) {
            Name qualifiedName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!qualifiedName.contentEquals("org.springframework.data.annotation.Transient") && !qualifiedName.contentEquals("org.mongodb.morphia.annotations.Transient") && !qualifiedName.contentEquals("ch.rasc.bsoncodec.annotation.Transient")) continue;
            return true;
        }
        return false;
    }

    private String getValue(VariableElement el) {
        String alternateValue = null;
        for (AnnotationMirror annotationMirror : this.elements.getAllAnnotationMirrors(el)) {
            Name qualifiedName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (qualifiedName.contentEquals("org.springframework.data.mongodb.core.mapping.Field") || qualifiedName.contentEquals("org.mongodb.morphia.annotations.Property") || qualifiedName.contentEquals("ch.rasc.bsoncodec.annotation.Field")) {
                alternateValue = annotationMirror.getElementValues().entrySet().stream().filter(e -> ((ExecutableElement)e.getKey()).getSimpleName().toString().equals("value")).map(e -> (String)((AnnotationValue)e.getValue()).getValue()).filter(s -> !".".equals(s) && !"".equals(s.trim())).findAny().orElse(null);
                continue;
            }
            if (!qualifiedName.contentEquals("ch.rasc.bsoncodec.annotation.Id")) continue;
            alternateValue = "_id";
        }
        if (alternateValue == null) {
            String simpleName = el.getSimpleName().toString();
            if (this.bsoncodecProject && "id".equals(simpleName)) {
                return "_id";
            }
            return simpleName;
        }
        return alternateValue;
    }
}

