/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.bsoncodec.time;

import java.time.Period;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class PeriodDocumentCodec
implements Codec<Period> {
    private final String yearsKey;
    private final String monthsKey;
    private final String daysKey;

    public PeriodDocumentCodec() {
        this.yearsKey = "years";
        this.monthsKey = "months";
        this.daysKey = "days";
    }

    public PeriodDocumentCodec(String yearsKey, String monthsKey, String daysKey) {
        this.yearsKey = yearsKey;
        this.monthsKey = monthsKey;
        this.daysKey = daysKey;
    }

    public Class<Period> getEncoderClass() {
        return Period.class;
    }

    public void encode(BsonWriter writer, Period value, EncoderContext encoderContext) {
        writer.writeStartDocument();
        writer.writeInt32(this.yearsKey, value.getYears());
        writer.writeInt32(this.monthsKey, value.getMonths());
        writer.writeInt32(this.daysKey, value.getDays());
        writer.writeEndDocument();
    }

    public Period decode(BsonReader reader, DecoderContext decoderContext) {
        reader.readStartDocument();
        Period period = Period.of(reader.readInt32(this.yearsKey), reader.readInt32(this.monthsKey), reader.readInt32(this.daysKey));
        reader.readEndDocument();
        return period;
    }
}

