/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.bsoncodec.time;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class LocalDateDateCodec
implements Codec<LocalDate> {
    public Class<LocalDate> getEncoderClass() {
        return LocalDate.class;
    }

    public void encode(BsonWriter writer, LocalDate value, EncoderContext encoderContext) {
        writer.writeDateTime(value.atStartOfDay().atZone(ZoneOffset.UTC).toInstant().toEpochMilli());
    }

    public LocalDate decode(BsonReader reader, DecoderContext decoderContext) {
        Instant instant = Instant.ofEpochMilli(reader.readDateTime());
        return LocalDateTime.ofInstant(instant, ZoneOffset.UTC).toLocalDate();
    }
}

