/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.bsoncodec.net;

import java.net.MalformedURLException;
import java.net.URL;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class URLStringCodec
implements Codec<URL> {
    public Class<URL> getEncoderClass() {
        return URL.class;
    }

    public void encode(BsonWriter writer, URL value, EncoderContext encoderContext) {
        writer.writeString(value.toString());
    }

    public URL decode(BsonReader reader, DecoderContext decoderContext) {
        String urlString = reader.readString();
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new BsonInvalidOperationException(String.format("Cannot create URL from string '%s'", urlString));
        }
    }
}

