/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.bsoncodec.net;

import java.net.URI;
import java.net.URISyntaxException;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class URIStringCodec
implements Codec<URI> {
    public Class<URI> getEncoderClass() {
        return URI.class;
    }

    public void encode(BsonWriter writer, URI value, EncoderContext encoderContext) {
        writer.writeString(value.toString());
    }

    public URI decode(BsonReader reader, DecoderContext decoderContext) {
        String uriString = reader.readString();
        try {
            return new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new BsonInvalidOperationException(String.format("Cannot create URI from string '%s'", uriString));
        }
    }
}

