/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.bsoncodec.money;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.MonetaryAmount;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class MonetaryAmountDocumentCodec
implements Codec<MonetaryAmount> {
    private final String currencyKey;
    private final String unscaledKey;
    private final String scaleKey;
    private final int scaleThreshold;

    public MonetaryAmountDocumentCodec() {
        this("currency", "unscaled", "scale", 18);
    }

    public MonetaryAmountDocumentCodec(String currencyKey, String unscaledKey, String scaleKey) {
        this(currencyKey, unscaledKey, scaleKey, 18);
    }

    public MonetaryAmountDocumentCodec(String currencyKey, String unscaledKey, String scaleKey, int scaleThreshold) {
        this.currencyKey = currencyKey;
        this.unscaledKey = unscaledKey;
        this.scaleKey = scaleKey;
        this.scaleThreshold = scaleThreshold;
    }

    public Class<MonetaryAmount> getEncoderClass() {
        return MonetaryAmount.class;
    }

    public void encode(BsonWriter writer, MonetaryAmount value, EncoderContext encoderContext) {
        writer.writeStartDocument();
        BigDecimal number = (BigDecimal)value.getNumber().numberValue(BigDecimal.class);
        if (number.scale() > this.scaleThreshold) {
            number = number.setScale(this.scaleThreshold, 4);
        }
        writer.writeString(this.currencyKey, value.getCurrency().getCurrencyCode());
        writer.writeInt64(this.unscaledKey, number.unscaledValue().longValue());
        writer.writeInt32(this.scaleKey, number.scale());
        writer.writeEndDocument();
    }

    public MonetaryAmount decode(BsonReader reader, DecoderContext decoderContext) {
        reader.readStartDocument();
        CurrencyUnit currency = Monetary.getCurrency((String)reader.readString(this.currencyKey), (String[])new String[0]);
        BigDecimal number = new BigDecimal(BigInteger.valueOf(reader.readInt64(this.unscaledKey)), reader.readInt32(this.scaleKey));
        reader.readEndDocument();
        return Monetary.getDefaultAmountFactory().setNumber((Number)number).setCurrency(currency).create();
    }
}

