/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.bsoncodec.math;

import java.math.BigInteger;
import java.util.Arrays;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class BigIntegerStringCodec
implements Codec<BigInteger> {
    private static final char[] SIGNS = new char[]{'-', '+', '+'};
    private final Integer zeroPadding;

    public BigIntegerStringCodec() {
        this(null);
    }

    public BigIntegerStringCodec(Integer zeroPadding) {
        this.zeroPadding = zeroPadding;
    }

    public Class<BigInteger> getEncoderClass() {
        return BigInteger.class;
    }

    public void encode(BsonWriter writer, BigInteger value, EncoderContext encoderContext) {
        if (this.zeroPadding == null) {
            writer.writeString(value.toString());
        } else {
            writer.writeString(this.formatBigInteger(value));
        }
    }

    public BigInteger decode(BsonReader reader, DecoderContext decoderContext) {
        return new BigInteger(reader.readString());
    }

    private String formatBigInteger(BigInteger bd) {
        char[] result = new char[this.zeroPadding.intValue()];
        Arrays.fill(result, '0');
        result[0] = SIGNS[bd.signum() + 1];
        String s = bd.toString();
        if (s.startsWith("-")) {
            s = s.substring(1);
        }
        char[] source = s.toCharArray();
        System.arraycopy(source, 0, result, result.length - source.length, source.length);
        return new String(result);
    }
}

