/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.bsoncodec.lang;

import org.bson.BsonInvalidOperationException;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class ClassStringCodec
implements Codec<Class> {
    public Class<Class> getEncoderClass() {
        return Class.class;
    }

    public void encode(BsonWriter writer, Class value, EncoderContext encoderContext) {
        writer.writeString(value.getName());
    }

    public Class decode(BsonReader reader, DecoderContext decoderContext) {
        String className = reader.readString();
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new BsonInvalidOperationException(String.format("Cannot create class from string '%s'", className));
        }
    }
}

