/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.bsoncodec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.bson.BsonBinary;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class SerializeCodec
implements Codec<Serializable> {
    private final boolean compress;

    public SerializeCodec() {
        this(false);
    }

    public SerializeCodec(boolean compress) {
        this.compress = compress;
    }

    public Class<Serializable> getEncoderClass() {
        return Serializable.class;
    }

    public void encode(BsonWriter writer, Serializable value, EncoderContext encoderContext) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStream os = baos;
        ObjectOutputStream oos = null;
        try {
            if (this.compress) {
                os = new GZIPOutputStream(os);
            }
            oos = new ObjectOutputStream(os);
            oos.writeObject(value);
            oos.flush();
        }
        catch (IOException e) {
            throw new BsonInvalidOperationException(e.getMessage());
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
            try {
                os.close();
            }
            catch (IOException iOException) {}
        }
        writer.writeBinaryData(new BsonBinary(baos.toByteArray()));
    }

    public Serializable decode(BsonReader reader, DecoderContext decoderContext) {
        BsonBinary bsonBinary = reader.readBinaryData();
        ByteArrayInputStream bais = new ByteArrayInputStream(bsonBinary.getData());
        InputStream is = bais;
        try {
            if (this.compress) {
                is = new GZIPInputStream(is);
            }
            ObjectInputStream ois = new ObjectInputStream(is);
            Serializable serializable = (Serializable)ois.readObject();
            return serializable;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new BsonInvalidOperationException(e.getMessage());
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }
}

