/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.bsoncodec.util;

import java.util.Locale;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class LocaleDocumentCodec
implements Codec<Locale> {
    private final String languageKey;
    private final String countryKey;
    private final String variantKey;

    public LocaleDocumentCodec() {
        this("language", "country", "variant");
    }

    public LocaleDocumentCodec(String languageKey, String countryKey, String variantKey) {
        this.languageKey = languageKey;
        this.countryKey = countryKey;
        this.variantKey = variantKey;
    }

    public Class<Locale> getEncoderClass() {
        return Locale.class;
    }

    public void encode(BsonWriter writer, Locale value, EncoderContext encoderContext) {
        writer.writeStartDocument();
        writer.writeString(this.languageKey, value.getLanguage());
        if (!value.getCountry().isEmpty()) {
            writer.writeString(this.countryKey, value.getCountry());
            if (!value.getVariant().isEmpty()) {
                writer.writeString(this.variantKey, value.getVariant());
            }
        }
        writer.writeEndDocument();
    }

    public Locale decode(BsonReader reader, DecoderContext decoderContext) {
        reader.readStartDocument();
        String language = reader.readString(this.languageKey);
        String country = "";
        String variant = "";
        if (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            reader.readName();
            country = reader.readString();
            if (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                reader.readName();
                variant = reader.readString();
            }
        }
        reader.readEndDocument();
        return new Locale(language, country, variant);
    }
}

