/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.bsoncodec.money;

import java.math.BigDecimal;
import java.util.Arrays;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.MonetaryAmount;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class MonetaryAmountDocument2Codec
implements Codec<MonetaryAmount> {
    private static final char[] SIGNS = new char[]{'-', '+', '+'};
    private final String currencyKey;
    private final String numberKey;
    private final Integer zeroPadding;

    public MonetaryAmountDocument2Codec() {
        this(null);
    }

    public MonetaryAmountDocument2Codec(Integer zeroPadding) {
        this("currency", "number", zeroPadding);
    }

    public MonetaryAmountDocument2Codec(String currencyKey, String numberKey) {
        this(currencyKey, numberKey, null);
    }

    public MonetaryAmountDocument2Codec(String currencyKey, String numberKey, Integer zeroPadding) {
        this.currencyKey = currencyKey;
        this.numberKey = numberKey;
        this.zeroPadding = zeroPadding;
    }

    public Class<MonetaryAmount> getEncoderClass() {
        return MonetaryAmount.class;
    }

    public void encode(BsonWriter writer, MonetaryAmount value, EncoderContext encoderContext) {
        writer.writeStartDocument();
        writer.writeString(this.currencyKey, value.getCurrency().getCurrencyCode());
        BigDecimal number = (BigDecimal)value.getNumber().numberValue(BigDecimal.class);
        if (this.zeroPadding == null) {
            writer.writeString(this.numberKey, number.toString());
        } else {
            writer.writeString(this.numberKey, this.formatBigDecimal(number));
        }
        writer.writeEndDocument();
    }

    public MonetaryAmount decode(BsonReader reader, DecoderContext decoderContext) {
        reader.readStartDocument();
        CurrencyUnit currency = Monetary.getCurrency((String)reader.readString(this.currencyKey), (String[])new String[0]);
        BigDecimal number = new BigDecimal(reader.readString(this.numberKey));
        reader.readEndDocument();
        return Monetary.getDefaultAmountFactory().setNumber((Number)number).setCurrency(currency).create();
    }

    private String formatBigDecimal(BigDecimal bd) {
        char[] result = new char[this.zeroPadding.intValue()];
        Arrays.fill(result, '0');
        result[0] = SIGNS[bd.signum() + 1];
        String s = bd.toString();
        if (s.startsWith("-")) {
            s = s.substring(1);
        }
        char[] source = s.toCharArray();
        System.arraycopy(source, 0, result, result.length - source.length, source.length);
        return new String(result);
    }
}

