/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.bsoncodec.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class BigDecimalStringCodec
implements Codec<BigDecimal> {
    private static final char[] SIGNS = new char[]{'-', '+', '+'};
    private final Integer zeroPadding;
    private final Integer scale;

    public BigDecimalStringCodec() {
        this(null, null);
    }

    public BigDecimalStringCodec(Integer zeroPadding) {
        this(zeroPadding, null);
    }

    public BigDecimalStringCodec(Integer zeroPadding, Integer scale) {
        this.zeroPadding = zeroPadding;
        this.scale = scale;
    }

    public Class<BigDecimal> getEncoderClass() {
        return BigDecimal.class;
    }

    public void encode(BsonWriter writer, BigDecimal value, EncoderContext encoderContext) {
        if (this.zeroPadding == null) {
            writer.writeString(value.toString());
        } else {
            writer.writeString(this.formatBigDecimal(value));
        }
    }

    public BigDecimal decode(BsonReader reader, DecoderContext decoderContext) {
        if (this.scale == null) {
            return new BigDecimal(reader.readString());
        }
        return new BigDecimal(new BigInteger(reader.readString()), this.scale);
    }

    private String formatBigDecimal(BigDecimal bd) {
        char[] result = new char[this.zeroPadding.intValue()];
        Arrays.fill(result, '0');
        result[0] = SIGNS[bd.signum() + 1];
        String s = this.scale == null ? bd.toString() : bd.unscaledValue().toString();
        if (s.startsWith("-")) {
            s = s.substring(1);
        }
        char[] source = s.toCharArray();
        System.arraycopy(source, 0, result, result.length - source.length, source.length);
        return new String(result);
    }
}

