/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.bsoncodec.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class BigDecimalDocumentCodec
implements Codec<BigDecimal> {
    private final String unscaledKey;
    private final String scaleKey;
    private final int scaleThreshold;

    public BigDecimalDocumentCodec() {
        this("unscaled", "scale", 18);
    }

    public BigDecimalDocumentCodec(String unscaledKey, String scaleKey) {
        this(unscaledKey, scaleKey, 18);
    }

    public BigDecimalDocumentCodec(String unscaledKey, String scaleKey, int scaleThreshold) {
        this.unscaledKey = unscaledKey;
        this.scaleKey = scaleKey;
        this.scaleThreshold = scaleThreshold;
    }

    public Class<BigDecimal> getEncoderClass() {
        return BigDecimal.class;
    }

    public void encode(BsonWriter writer, BigDecimal value, EncoderContext encoderContext) {
        writer.writeStartDocument();
        BigDecimal val = value;
        if (val.scale() > this.scaleThreshold) {
            val = value.setScale(this.scaleThreshold, 4);
        }
        writer.writeInt64(this.unscaledKey, val.unscaledValue().longValue());
        writer.writeInt32(this.scaleKey, val.scale());
        writer.writeEndDocument();
    }

    public BigDecimal decode(BsonReader reader, DecoderContext decoderContext) {
        reader.readStartDocument();
        BigDecimal value = new BigDecimal(BigInteger.valueOf(reader.readInt64(this.unscaledKey)), reader.readInt32(this.scaleKey));
        reader.readEndDocument();
        return value;
    }
}

