/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.bsoncodec.model;

import ch.rasc.bsoncodec.model.InstanceField;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
public final class ImmutableInstanceField
extends InstanceField {
    private final TypeName type;
    private final String name;
    @Nullable
    private final TypeName codecForClass;
    private final boolean customCodec;

    private ImmutableInstanceField(Builder builder) {
        this.type = builder.type;
        this.name = builder.name;
        this.codecForClass = builder.codecForClass;
        this.customCodec = builder.customCodecIsSet() ? builder.customCodec : super.customCodec();
    }

    private ImmutableInstanceField(TypeName type, String name, @Nullable TypeName codecForClass, boolean customCodec) {
        this.type = type;
        this.name = name;
        this.codecForClass = codecForClass;
        this.customCodec = customCodec;
    }

    @Override
    public TypeName type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    @Nullable
    public TypeName codecForClass() {
        return this.codecForClass;
    }

    @Override
    public boolean customCodec() {
        return this.customCodec;
    }

    public final ImmutableInstanceField withType(TypeName value) {
        if (this.type == value) {
            return this;
        }
        TypeName newValue = Objects.requireNonNull(value, "type");
        return new ImmutableInstanceField(newValue, this.name, this.codecForClass, this.customCodec);
    }

    public final ImmutableInstanceField withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "name");
        return new ImmutableInstanceField(this.type, newValue, this.codecForClass, this.customCodec);
    }

    public final ImmutableInstanceField withCodecForClass(@Nullable TypeName value) {
        if (this.codecForClass == value) {
            return this;
        }
        return new ImmutableInstanceField(this.type, this.name, value, this.customCodec);
    }

    public final ImmutableInstanceField withCustomCodec(boolean value) {
        if (this.customCodec == value) {
            return this;
        }
        return new ImmutableInstanceField(this.type, this.name, this.codecForClass, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInstanceField && this.equalTo((ImmutableInstanceField)another);
    }

    private boolean equalTo(ImmutableInstanceField another) {
        return this.type.equals((Object)another.type) && this.name.equals(another.name) && Objects.equals(this.codecForClass, another.codecForClass) && this.customCodec == another.customCodec;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.codecForClass);
        h += (h << 5) + Booleans.hashCode((boolean)this.customCodec);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"InstanceField").omitNullValues().add("type", (Object)this.type).add("name", (Object)this.name).add("codecForClass", (Object)this.codecForClass).add("customCodec", this.customCodec).toString();
    }

    public static ImmutableInstanceField copyOf(InstanceField instance) {
        if (instance instanceof ImmutableInstanceField) {
            return (ImmutableInstanceField)instance;
        }
        return ImmutableInstanceField.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long OPT_BIT_CUSTOM_CODEC = 1L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private TypeName type;
        @Nullable
        private String name;
        @Nullable
        private TypeName codecForClass;
        private boolean customCodec;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(InstanceField instance) {
            Objects.requireNonNull(instance, "instance");
            this.type(instance.type());
            this.name(instance.name());
            TypeName codecForClassValue = instance.codecForClass();
            if (codecForClassValue != null) {
                this.codecForClass(codecForClassValue);
            }
            this.customCodec(instance.customCodec());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(TypeName type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder codecForClass(@Nullable TypeName codecForClass) {
            this.codecForClass = codecForClass;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder customCodec(boolean customCodec) {
            this.customCodec = customCodec;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableInstanceField build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInstanceField(this);
        }

        private boolean customCodecIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build InstanceField, some of required attributes are not set " + attributes;
        }
    }
}

