/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.bsoncodec.codegen.delegate;

import ch.rasc.bsoncodec.Util;
import ch.rasc.bsoncodec.codegen.CodeGeneratorContext;
import ch.rasc.bsoncodec.codegen.delegate.CodeGeneratorDelegate;
import com.squareup.javapoet.MethodSpec;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.lang.model.type.TypeMirror;

public class CoreClassesDelegate
implements CodeGeneratorDelegate {
    @Override
    public void addEncodeStatements(TypeMirror type, CodeGeneratorContext ctx) {
        MethodSpec.Builder builder = ctx.builder();
        if (Util.isSameType(type, String.class)) {
            builder.addStatement("writer.writeString($L)", new Object[]{ctx.getter()});
        } else if (Util.isSameType(type, Date.class)) {
            builder.addStatement("writer.writeDateTime($L.getTime())", new Object[]{ctx.getter()});
        } else if (Util.isSameType(type, AtomicBoolean.class)) {
            builder.addStatement("writer.writeBoolean($L.get())", new Object[]{ctx.getter()});
        } else if (Util.isSameType(type, AtomicInteger.class)) {
            builder.addStatement("writer.writeInt32($L.intValue())", new Object[]{ctx.getter()});
        } else if (Util.isSameType(type, AtomicLong.class)) {
            builder.addStatement("writer.writeInt64($L.longValue())", new Object[]{ctx.getter()});
        }
    }

    @Override
    public void addDecodeStatements(TypeMirror type, CodeGeneratorContext ctx) {
        MethodSpec.Builder builder = ctx.builder();
        if (Util.isSameType(type, String.class)) {
            builder.addStatement(ctx.setter("reader.readString()"), new Object[0]);
        } else if (Util.isSameType(type, Date.class)) {
            builder.addStatement(ctx.setter("new $T(reader.readDateTime())"), new Object[]{Date.class});
        } else if (Util.isSameType(type, AtomicBoolean.class)) {
            builder.addStatement(ctx.setter("new $T(reader.readBoolean())"), new Object[]{AtomicBoolean.class});
        } else if (Util.isSameType(type, AtomicInteger.class)) {
            builder.addStatement(ctx.setter("new $T(reader.readInt32())"), new Object[]{AtomicInteger.class});
        } else if (Util.isSameType(type, AtomicLong.class)) {
            builder.addStatement(ctx.setter("new $T(reader.readInt64())"), new Object[]{AtomicLong.class});
        }
    }

    @Override
    public boolean accepts(TypeMirror type) {
        return Util.isAnyType(type, String.class, Date.class, AtomicBoolean.class, AtomicInteger.class, AtomicLong.class);
    }
}

