/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.bsoncodec;

import ch.rasc.bsoncodec.AnnotationHierarchyUtil;
import ch.rasc.bsoncodec.CodecCodeGenerator;
import ch.rasc.bsoncodec.ProviderCodeGenerator;
import ch.rasc.bsoncodec.Util;
import ch.rasc.bsoncodec.annotation.BsonDocument;
import ch.rasc.bsoncodec.model.ImmutableCodecInfo;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedOptions(value={"generateCodecProvider"})
public class CodecAnnotationProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        String option = this.processingEnv.getOptions().get("generateCodecProvider");
        boolean generateCodecProvider = true;
        if (option != null && !option.trim().isEmpty()) {
            generateCodecProvider = Boolean.valueOf(option);
        }
        if (roundEnv.processingOver() || annotations.size() == 0) {
            return false;
        }
        if (roundEnv.getRootElements() == null || roundEnv.getRootElements().isEmpty()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "No sources to process");
            return false;
        }
        Util.elementUtils = this.processingEnv.getElementUtils();
        Util.typeUtils = this.processingEnv.getTypeUtils();
        Util.messager = this.processingEnv.getMessager();
        HashMap<String, List> codecInfosPerProvider = new HashMap<String, List>();
        AnnotationHierarchyUtil hierarchyUtil = new AnnotationHierarchyUtil(this.processingEnv.getTypeUtils());
        Set<TypeElement> triggeringAnnotations = hierarchyUtil.filterTriggeringAnnotations(annotations, this.processingEnv.getElementUtils().getTypeElement(BsonDocument.class.getCanonicalName()));
        for (TypeElement typeElement : triggeringAnnotations) {
            Set elements = roundEnv.getElementsAnnotatedWith(typeElement).stream().filter(el -> el.getKind() == ElementKind.CLASS && !el.getModifiers().contains((Object)Modifier.ABSTRACT)).collect(Collectors.toSet());
            for (Element element : elements) {
                try {
                    TypeElement typeElement2 = (TypeElement)element;
                    CodecCodeGenerator codeGen = new CodecCodeGenerator(typeElement2);
                    JavaFileObject jfo = this.processingEnv.getFiler().createSourceFile(codeGen.getFullyQualifiedName(), new Element[0]);
                    try (Writer writer = jfo.openWriter();){
                        codeGen.generate(writer);
                    }
                    String providerClassName = codeGen.getProviderClassName();
                    codecInfosPerProvider.computeIfAbsent(providerClassName, key -> new ArrayList()).add(ImmutableCodecInfo.of(typeElement2, (TypeName)ClassName.get((String)codeGen.getPackageName(), (String)codeGen.getClassName(), (String[])new String[0]), codeGen.getInstanceFields().stream().filter(i -> !i.isRegistryCodec() && !i.isRegistry()).sorted().collect(Collectors.toCollection(LinkedHashSet::new)), codeGen.getInstanceFields().stream().filter(i -> i.isRegistryCodec() || i.isRegistry()).findFirst().isPresent()));
                }
                catch (Exception e) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
                }
            }
        }
        if (generateCodecProvider) {
            try {
                for (Map.Entry entry : codecInfosPerProvider.entrySet()) {
                    ProviderCodeGenerator codeGenerator = new ProviderCodeGenerator((String)entry.getKey(), (List)entry.getValue());
                    JavaFileObject jfo = this.processingEnv.getFiler().createSourceFile(codeGenerator.getFullyQualifiedName(), new Element[0]);
                    Writer writer = jfo.openWriter();
                    Throwable throwable = null;
                    try {
                        codeGenerator.generate(writer);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (writer == null) continue;
                        if (throwable != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        writer.close();
                    }
                }
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            }
        }
        return false;
    }
}

