/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.bsoncodec.codegen.delegate;

import ch.rasc.bsoncodec.Util;
import ch.rasc.bsoncodec.codegen.CodeGeneratorContext;
import ch.rasc.bsoncodec.codegen.delegate.CodeGeneratorDelegate;
import com.squareup.javapoet.MethodSpec;
import javax.lang.model.type.TypeMirror;
import org.bson.BsonInvalidOperationException;

public class PrimitiveWrapperDelegate
implements CodeGeneratorDelegate {
    @Override
    public void addEncodeStatements(TypeMirror type, CodeGeneratorContext ctx) {
        MethodSpec.Builder builder = ctx.builder();
        if (Util.isSameType(type, Boolean.class)) {
            builder.addStatement("writer.writeBoolean($L.booleanValue())", new Object[]{ctx.getter()});
        } else if (Util.isSameType(type, Byte.class)) {
            builder.addStatement("writer.writeInt32($L.intValue())", new Object[]{ctx.getter()});
        } else if (Util.isSameType(type, Short.class)) {
            builder.addStatement("writer.writeInt32($L.intValue())", new Object[]{ctx.getter()});
        } else if (Util.isSameType(type, Integer.class)) {
            builder.addStatement("writer.writeInt32($L.intValue())", new Object[]{ctx.getter()});
        } else if (Util.isSameType(type, Long.class)) {
            builder.addStatement("writer.writeInt64($L.longValue())", new Object[]{ctx.getter()});
        } else if (Util.isSameType(type, Character.class)) {
            builder.addStatement("writer.writeString($L.toString())", new Object[]{ctx.getter()});
        } else if (Util.isSameType(type, Float.class)) {
            builder.addStatement("writer.writeDouble($L.doubleValue())", new Object[]{ctx.getter()});
        } else if (Util.isSameType(type, Double.class)) {
            builder.addStatement("writer.writeDouble($L.doubleValue())", new Object[]{ctx.getter()});
        }
    }

    @Override
    public void addDecodeStatements(TypeMirror type, CodeGeneratorContext ctx) {
        MethodSpec.Builder builder = ctx.builder();
        if (Util.isSameType(type, Boolean.class)) {
            builder.addStatement(ctx.setter("$T.valueOf(reader.readBoolean())"), new Object[]{Boolean.class});
        } else if (Util.isSameType(type, Byte.class)) {
            builder.addStatement(ctx.setter("$T.valueOf((byte)reader.readInt32())"), new Object[]{Byte.class});
        } else if (Util.isSameType(type, Short.class)) {
            builder.addStatement(ctx.setter("$T.valueOf((short)reader.readInt32())"), new Object[]{Short.class});
        } else if (Util.isSameType(type, Integer.class)) {
            builder.addStatement(ctx.setter("$T.valueOf(reader.readInt32())"), new Object[]{Integer.class});
        } else if (Util.isSameType(type, Long.class)) {
            builder.addStatement(ctx.setter("$T.valueOf(reader.readInt64())"), new Object[]{Long.class});
        } else if (Util.isSameType(type, Character.class)) {
            builder.addStatement("String string = reader.readString()", new Object[0]);
            builder.beginControlFlow("if (string.length() != 1)", new Object[0]);
            builder.addStatement("throw new $T(String.format(\"Attempting to builder the string '%s' to a character, but its length is not equal to one\", string))", new Object[]{BsonInvalidOperationException.class});
            builder.endControlFlow();
            builder.addStatement(ctx.setter("$T.valueOf(string.charAt(0))"), new Object[]{Character.class});
        } else if (Util.isSameType(type, Float.class)) {
            builder.addStatement(ctx.setter("$T.valueOf((float)reader.readDouble())"), new Object[]{Float.class});
        } else if (Util.isSameType(type, Double.class)) {
            builder.addStatement(ctx.setter("$T.valueOf(reader.readDouble())"), new Object[]{Double.class});
        }
    }

    @Override
    public boolean accepts(TypeMirror type) {
        return Util.isAnyType(type, Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Character.class, Float.class, Double.class);
    }
}

