/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.bsoncodec.codegen;

import ch.rasc.bsoncodec.model.FieldModel;
import ch.rasc.bsoncodec.model.InstanceField;
import com.squareup.javapoet.MethodSpec;
import java.util.Set;

public class CodeGeneratorContext {
    private final FieldModel field;
    private final MethodSpec.Builder builder;
    private final Set<InstanceField> instanceFields;
    private final String getter;
    private final String setter;
    private final char loopVar;

    public CodeGeneratorContext(FieldModel field, MethodSpec.Builder builder, Set<InstanceField> instanceFields, String getter, String setter) {
        this.field = field;
        this.builder = builder;
        this.instanceFields = instanceFields;
        this.getter = getter;
        this.setter = setter;
        this.loopVar = (char)97;
    }

    public CodeGeneratorContext(CodeGeneratorContext parent, String getter, String setter) {
        this.field = parent.field;
        this.builder = parent.builder;
        this.instanceFields = parent.instanceFields;
        this.getter = getter;
        this.setter = setter;
        this.loopVar = (char)(parent.loopVar + '\u0001');
    }

    protected FieldModel field() {
        return this.field;
    }

    public MethodSpec.Builder builder() {
        return this.builder;
    }

    public Set<InstanceField> instanceFields() {
        return this.instanceFields;
    }

    public String getter() {
        return this.getter;
    }

    public String setter(String code) {
        return String.format(this.setter, code);
    }

    public char getLoopVar() {
        return this.loopVar;
    }

    public CodeGeneratorContext createEncodeChildContext(String get) {
        return new CodeGeneratorContext(this, get, null);
    }

    public CodeGeneratorContext createDecodeChildContext(String set) {
        return new CodeGeneratorContext(this, null, set);
    }
}

