package ch.rasc.bsoncodec.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.squareup.javapoet.TypeName;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link InstanceField}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableInstanceField.builder()}.
 */
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "InstanceField"})
@Immutable
@CheckReturnValue
public final class ImmutableInstanceField extends InstanceField {
  private final TypeName type;
  private final String name;
  private final @Nullable TypeName codecForClass;
  private final boolean customCodec;

  private ImmutableInstanceField(ImmutableInstanceField.Builder builder) {
    this.type = builder.type;
    this.name = builder.name;
    this.codecForClass = builder.codecForClass;
    this.customCodec = builder.customCodecIsSet()
        ? builder.customCodec
        : super.customCodec();
  }

  private ImmutableInstanceField(
      TypeName type,
      String name,
      @Nullable TypeName codecForClass,
      boolean customCodec) {
    this.type = type;
    this.name = name;
    this.codecForClass = codecForClass;
    this.customCodec = customCodec;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public TypeName type() {
    return type;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code codecForClass} attribute
   */
  @Override
  public @Nullable TypeName codecForClass() {
    return codecForClass;
  }

  /**
   * @return The value of the {@code customCodec} attribute
   */
  @Override
  public boolean customCodec() {
    return customCodec;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InstanceField#type() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInstanceField withType(TypeName value) {
    if (this.type == value) return this;
    TypeName newValue = Objects.requireNonNull(value, "type");
    return new ImmutableInstanceField(newValue, this.name, this.codecForClass, this.customCodec);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InstanceField#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInstanceField withName(String value) {
    if (this.name.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "name");
    return new ImmutableInstanceField(this.type, newValue, this.codecForClass, this.customCodec);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InstanceField#codecForClass() codecForClass} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for codecForClass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInstanceField withCodecForClass(@Nullable TypeName value) {
    if (this.codecForClass == value) return this;
    return new ImmutableInstanceField(this.type, this.name, value, this.customCodec);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InstanceField#customCodec() customCodec} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for customCodec
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInstanceField withCustomCodec(boolean value) {
    if (this.customCodec == value) return this;
    return new ImmutableInstanceField(this.type, this.name, this.codecForClass, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableInstanceField} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableInstanceField
        && equalTo((ImmutableInstanceField) another);
  }

  private boolean equalTo(ImmutableInstanceField another) {
    return type.equals(another.type)
        && name.equals(another.name)
        && Objects.equals(codecForClass, another.codecForClass)
        && customCodec == another.customCodec;
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code name}, {@code codecForClass}, {@code customCodec}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + type.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(codecForClass);
    h += (h << 5) + Booleans.hashCode(customCodec);
    return h;
  }

  /**
   * Prints the immutable value {@code InstanceField} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("InstanceField")
        .omitNullValues()
        .add("type", type)
        .add("name", name)
        .add("codecForClass", codecForClass)
        .add("customCodec", customCodec)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link InstanceField} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable InstanceField instance
   */
  public static ImmutableInstanceField copyOf(InstanceField instance) {
    if (instance instanceof ImmutableInstanceField) {
      return (ImmutableInstanceField) instance;
    }
    return ImmutableInstanceField.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableInstanceField ImmutableInstanceField}.
   * @return A new ImmutableInstanceField builder
   */
  public static ImmutableInstanceField.Builder builder() {
    return new ImmutableInstanceField.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableInstanceField ImmutableInstanceField}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long OPT_BIT_CUSTOM_CODEC = 0x1L;
    private long initBits = 0x3L;
    private long optBits;

    private @Nullable TypeName type;
    private @Nullable String name;
    private @Nullable TypeName codecForClass;
    private boolean customCodec;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code InstanceField} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(InstanceField instance) {
      Objects.requireNonNull(instance, "instance");
      type(instance.type());
      name(instance.name());
      @Nullable TypeName codecForClassValue = instance.codecForClass();
      if (codecForClassValue != null) {
        codecForClass(codecForClassValue);
      }
      customCodec(instance.customCodec());
      return this;
    }

    /**
     * Initializes the value for the {@link InstanceField#type() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder type(TypeName type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link InstanceField#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link InstanceField#codecForClass() codecForClass} attribute.
     * @param codecForClass The value for codecForClass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder codecForClass(@Nullable TypeName codecForClass) {
      this.codecForClass = codecForClass;
      return this;
    }

    /**
     * Initializes the value for the {@link InstanceField#customCodec() customCodec} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link InstanceField#customCodec() customCodec}.</em>
     * @param customCodec The value for customCodec 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder customCodec(boolean customCodec) {
      this.customCodec = customCodec;
      optBits |= OPT_BIT_CUSTOM_CODEC;
      return this;
    }

    /**
     * Builds a new {@link ImmutableInstanceField ImmutableInstanceField}.
     * @return An immutable instance of InstanceField
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableInstanceField build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableInstanceField(this);
    }

    private boolean customCodecIsSet() {
      return (optBits & OPT_BIT_CUSTOM_CODEC) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build InstanceField, some of required attributes are not set " + attributes;
    }
  }
}
