/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.bsoncodec.codegen.delegate;

import ch.rasc.bsoncodec.codegen.CodeGeneratorContext;
import ch.rasc.bsoncodec.codegen.delegate.CodeGeneratorDelegate;
import com.squareup.javapoet.MethodSpec;
import javax.lang.model.type.TypeMirror;
import org.bson.BsonInvalidOperationException;

public class PrimitiveDelegate
implements CodeGeneratorDelegate {
    @Override
    public void addEncodeStatements(TypeMirror type, CodeGeneratorContext ctx) {
        MethodSpec.Builder builder = ctx.builder();
        switch (type.getKind()) {
            case BOOLEAN: {
                builder.addStatement("writer.writeBoolean($L)", new Object[]{ctx.getter()});
                break;
            }
            case BYTE: {
                builder.addStatement("writer.writeInt32($L)", new Object[]{ctx.getter()});
                break;
            }
            case SHORT: {
                builder.addStatement("writer.writeInt32($L)", new Object[]{ctx.getter()});
                break;
            }
            case INT: {
                builder.addStatement("writer.writeInt32($L)", new Object[]{ctx.getter()});
                break;
            }
            case LONG: {
                builder.addStatement("writer.writeInt64($L)", new Object[]{ctx.getter()});
                break;
            }
            case CHAR: {
                builder.addStatement("writer.writeString($T.valueOf($L))", new Object[]{String.class, ctx.getter()});
                break;
            }
            case FLOAT: {
                builder.addStatement("writer.writeDouble($L)", new Object[]{ctx.getter()});
                break;
            }
            case DOUBLE: {
                builder.addStatement("writer.writeDouble($L)", new Object[]{ctx.getter()});
                break;
            }
        }
    }

    @Override
    public void addDecodeStatements(TypeMirror type, CodeGeneratorContext ctx) {
        MethodSpec.Builder builder = ctx.builder();
        switch (type.getKind()) {
            case BOOLEAN: {
                builder.addStatement(ctx.setter("reader.readBoolean()"), new Object[0]);
                break;
            }
            case BYTE: {
                builder.addStatement(ctx.setter("(byte)reader.readInt32()"), new Object[0]);
                break;
            }
            case SHORT: {
                builder.addStatement(ctx.setter("(short)reader.readInt32()"), new Object[0]);
                break;
            }
            case INT: {
                builder.addStatement(ctx.setter("reader.readInt32()"), new Object[0]);
                break;
            }
            case LONG: {
                builder.addStatement(ctx.setter("reader.readInt64()"), new Object[0]);
                break;
            }
            case CHAR: {
                builder.addStatement("String string = reader.readString()", new Object[0]);
                builder.beginControlFlow("if (string.length() != 1)", new Object[0]);
                builder.addStatement("throw new $T(String.format(\"Attempting to builder the string '%s' to a character, but its length is not equal to one\", string))", new Object[]{BsonInvalidOperationException.class});
                builder.endControlFlow();
                builder.addStatement(ctx.setter("string.charAt(0)"), new Object[0]);
                break;
            }
            case FLOAT: {
                builder.addStatement(ctx.setter("(float)reader.readDouble()"), new Object[0]);
                break;
            }
            case DOUBLE: {
                builder.addStatement(ctx.setter("reader.readDouble()"), new Object[0]);
                break;
            }
        }
    }

    @Override
    public void addSetNullStatements(TypeMirror type, CodeGeneratorContext ctx) {
        MethodSpec.Builder builder = ctx.builder();
        switch (type.getKind()) {
            case BOOLEAN: {
                builder.addStatement(ctx.setter("false"), new Object[0]);
                break;
            }
            case BYTE: {
                builder.addStatement(ctx.setter("(byte)0"), new Object[0]);
                break;
            }
            case SHORT: {
                builder.addStatement(ctx.setter("(short)0"), new Object[0]);
                break;
            }
            case INT: {
                builder.addStatement(ctx.setter("0"), new Object[0]);
                break;
            }
            case LONG: {
                builder.addStatement(ctx.setter("0L"), new Object[0]);
                break;
            }
            case CHAR: {
                builder.addStatement(ctx.setter("$T.MIN_VALUE"), new Object[]{Character.class});
                break;
            }
            case FLOAT: {
                builder.addStatement(ctx.setter("0.0f"), new Object[0]);
                break;
            }
            case DOUBLE: {
                builder.addStatement(ctx.setter("0.0d"), new Object[0]);
                break;
            }
        }
    }

    @Override
    public boolean accepts(TypeMirror type) {
        return type.getKind().isPrimitive();
    }
}

