/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.bsoncodec.codegen;

import ch.rasc.bsoncodec.codegen.CodeGeneratorContext;
import ch.rasc.bsoncodec.codegen.CompoundCodeGen;
import ch.rasc.bsoncodec.codegen.delegate.CodeGeneratorDelegate;
import ch.rasc.bsoncodec.codegen.delegate.CoreClassesDelegate;
import ch.rasc.bsoncodec.codegen.delegate.Decimal128Delegate;
import ch.rasc.bsoncodec.codegen.delegate.DefaultDelegate;
import ch.rasc.bsoncodec.codegen.delegate.EnumDelegate;
import ch.rasc.bsoncodec.codegen.delegate.ObjectIdDelegate;
import ch.rasc.bsoncodec.codegen.delegate.PrimitiveDelegate;
import ch.rasc.bsoncodec.codegen.delegate.PrimitiveWrapperDelegate;
import ch.rasc.bsoncodec.model.FieldModel;
import ch.rasc.bsoncodec.model.IdModel;
import com.squareup.javapoet.MethodSpec;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.type.TypeMirror;
import org.bson.BsonType;

public class ScalarCodeGen
extends CompoundCodeGen {
    private static final List<CodeGeneratorDelegate> delegates = Arrays.asList(new PrimitiveDelegate(), new PrimitiveWrapperDelegate(), new CoreClassesDelegate(), new Decimal128Delegate(), new EnumDelegate(), new ObjectIdDelegate());
    private final CodeGeneratorDelegate delegate;

    public static CodeGeneratorDelegate getDelegate(TypeMirror type) {
        return delegates.stream().filter(d -> d.accepts(type)).findFirst().orElse(new DefaultDelegate());
    }

    public static ScalarCodeGen create(CompoundCodeGen parent, TypeMirror type) {
        return ScalarCodeGen.create(parent, type, ScalarCodeGen.getDelegate(type));
    }

    public static ScalarCodeGen create(CompoundCodeGen parent, TypeMirror type, CodeGeneratorDelegate delegate) {
        return new ScalarCodeGen(parent, type, delegate);
    }

    private ScalarCodeGen(CompoundCodeGen parent, TypeMirror type, CodeGeneratorDelegate delegate) {
        super(parent, type);
        this.delegate = delegate;
    }

    @Override
    public void addEncodeStatements(CodeGeneratorContext ctx) {
        FieldModel field = ctx.field();
        MethodSpec.Builder builder = ctx.builder();
        if (!this.hasParent()) {
            IdModel idModel;
            if (!field.disableEncodeNullCheck()) {
                builder.beginControlFlow("if ($L != null)", new Object[]{ctx.getter()});
            }
            if ((idModel = field.idModel()) != null && idModel.generatorName() != null) {
                builder.beginControlFlow("if ($L == null)", new Object[]{ctx.getter()}).addStatement(ctx.setter("($T)this.$N.generate()"), new Object[]{this.getType(), idModel.generatorName()}).endControlFlow();
            }
            builder.addStatement("writer.writeName($S)", new Object[]{field.name()});
        }
        this.delegate.addEncodeStatements(this.getType(), ctx);
        if (!this.hasParent() && !field.disableEncodeNullCheck()) {
            if (field.storeNullValue()) {
                builder.nextControlFlow("else", new Object[0]).addStatement("writer.writeNull($S)", new Object[]{field.name()});
            }
            builder.endControlFlow();
        }
    }

    @Override
    public void addDecodeStatements(CodeGeneratorContext ctx) {
        FieldModel field = ctx.field();
        if (!this.hasParent() && !field.disableDecodeNullCheck()) {
            ctx.builder().beginControlFlow("if (bsonType != $T.NULL)", new Object[]{BsonType.class});
        }
        this.delegate.addDecodeStatements(this.getType(), ctx);
        if (!this.hasParent() && !field.disableDecodeNullCheck()) {
            ctx.builder().nextControlFlow("else", new Object[0]).addStatement("reader.readNull()", new Object[0]);
            if (!ctx.field().disableSetNullStatement()) {
                this.delegate.addSetNullStatements(this.getType(), ctx);
            }
            ctx.builder().endControlFlow();
        }
    }
}

