/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.bsoncodec.codegen;

import ch.rasc.bsoncodec.Util;
import ch.rasc.bsoncodec.codegen.CodeGeneratorContext;
import ch.rasc.bsoncodec.codegen.CompoundCodeGen;
import ch.rasc.bsoncodec.model.FieldModel;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.TreeMap;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.bson.BsonType;

public class MapCodeGen
extends CompoundCodeGen {
    private TypeMirror implementationType;
    private final TypeMirror keyType;
    private static Set<String> permitNullCollections = new HashSet<String>();

    public MapCodeGen(CompoundCodeGen parent, TypeMirror type, TypeMirror keyType) {
        super(parent, type);
        this.keyType = keyType;
    }

    public void setImplementationType(TypeMirror implementationType) {
        this.implementationType = implementationType;
    }

    protected TypeName getImplementationType() {
        if (this.implementationType == null) {
            if (((DeclaredType)this.getType()).asElement().getKind() == ElementKind.INTERFACE) {
                return ClassName.get(LinkedHashMap.class);
            }
            return ClassName.get((TypeElement)((TypeElement)Util.typeUtils.asElement(this.getType())));
        }
        return ClassName.get((TypeElement)((TypeElement)Util.typeUtils.asElement(this.implementationType)));
    }

    @Override
    public void addEncodeStatements(CodeGeneratorContext ctx) {
        FieldModel field = ctx.field();
        MethodSpec.Builder builder = ctx.builder();
        if (!field.disableEncodeNullCheck() && !this.hasParent()) {
            builder.beginControlFlow("if ($L != null)", new Object[]{ctx.getter()});
        }
        if (!field.storeEmptyCollection()) {
            builder.beginControlFlow("if (!$L.isEmpty())", new Object[]{ctx.getter()});
        }
        if (!this.hasParent()) {
            builder.addStatement("writer.writeName($S)", new Object[]{field.name()});
        }
        TypeMirror childType = this.getChildCodeGen().getType();
        builder.addStatement("writer.writeStartDocument()", new Object[0]);
        if (!Util.isSameType(this.keyType, Object.class)) {
            builder.beginControlFlow("for (Map.Entry<$T, $T> $L : $L.entrySet())", new Object[]{this.keyType, childType, Character.valueOf(ctx.getLoopVar()), ctx.getter()});
        } else {
            builder.beginControlFlow("for (Map.Entry $L : (Set<Map.Entry>)$L.entrySet())", new Object[]{Character.valueOf(ctx.getLoopVar()), ctx.getter()});
        }
        if (Util.isSameType(this.keyType, String.class)) {
            builder.addStatement("writer.writeName($L.getKey())", new Object[]{Character.valueOf(ctx.getLoopVar())});
        } else if (Util.isSameType(this.getType(), EnumMap.class)) {
            builder.addStatement("writer.writeName($L.getKey().name())", new Object[]{Character.valueOf(ctx.getLoopVar())});
        } else {
            builder.addStatement("writer.writeName($T.valueOf($L.getKey()))", new Object[]{String.class, Character.valueOf(ctx.getLoopVar())});
        }
        boolean permittNullElements = this.permitNullElements();
        if (!field.disableEncodeNullCheck() && permittNullElements) {
            builder.beginControlFlow("if ($L != null)", new Object[]{ctx.getLoopVar() + ".getValue()"});
        }
        this.getChildCodeGen().addEncodeStatements(ctx.createEncodeChildContext(ctx.getLoopVar() + ".getValue()"));
        if (!field.disableEncodeNullCheck() && permittNullElements) {
            builder.nextControlFlow("else", new Object[0]).addStatement("writer.writeNull()", new Object[0]);
            builder.endControlFlow();
        }
        builder.endControlFlow();
        builder.addStatement("writer.writeEndDocument()", new Object[0]);
        if (!field.storeEmptyCollection()) {
            builder.endControlFlow();
        }
        if (!field.disableEncodeNullCheck() && !this.hasParent()) {
            if (field.storeNullValue()) {
                builder.nextControlFlow("else", new Object[0]).addStatement("writer.writeNull($S)", new Object[]{field.name()});
            }
            builder.endControlFlow();
        }
    }

    @Override
    public void addDecodeStatements(CodeGeneratorContext ctx) {
        FieldModel field = ctx.field();
        MethodSpec.Builder builder = ctx.builder();
        char lv = ctx.getLoopVar();
        if (!field.disableDecodeNullCheck() && !this.hasParent()) {
            builder.beginControlFlow("if (bsonType != $T.NULL)", new Object[]{BsonType.class});
        }
        builder.addStatement("reader.readStartDocument()", new Object[0]);
        if (Util.isSameType(this.getType(), EnumMap.class)) {
            builder.addStatement("$T $L = new $T<>($T.class)", new Object[]{this.getType(), Character.valueOf(lv), EnumMap.class, this.keyType});
        } else {
            builder.addStatement("$T $L = new $T<>()", new Object[]{this.getType(), Character.valueOf(lv), this.getImplementationType()});
        }
        builder.beginControlFlow("while ((bsonType = reader.readBsonType()) != $T.END_OF_DOCUMENT)", new Object[]{BsonType.class});
        if (Util.isSameType(this.keyType, String.class) || Util.isSameType(this.keyType, Object.class)) {
            builder.addStatement("String $LKey = reader.readName()", new Object[]{Character.valueOf(lv)});
        } else {
            builder.addStatement("$T $LKey = $T.valueOf(reader.readName())", new Object[]{this.keyType, Character.valueOf(lv), this.keyType});
        }
        boolean permittNullElements = this.permitNullElements();
        if (permittNullElements) {
            builder.beginControlFlow("if (bsonType != $T.NULL)", new Object[]{BsonType.class});
        }
        CodeGeneratorContext childCtx = ctx.createDecodeChildContext(lv + ".put(" + lv + "Key, %s)");
        this.getChildCodeGen().addDecodeStatements(childCtx);
        if (permittNullElements) {
            builder.nextControlFlow("else", new Object[0]).addStatement("reader.readNull()", new Object[0]);
            builder.addStatement("$L.put($LKey, null)", new Object[]{Character.valueOf(lv), Character.valueOf(lv)});
            builder.endControlFlow();
        }
        builder.endControlFlow();
        builder.addStatement("reader.readEndDocument()", new Object[0]);
        builder.addStatement(ctx.setter("$L"), new Object[]{Character.valueOf(lv)});
        if (!field.disableDecodeNullCheck() && !this.hasParent()) {
            builder.nextControlFlow("else", new Object[0]).addStatement("reader.readNull()", new Object[0]);
            if (!ctx.field().disableSetNullStatement()) {
                this.getChildCodeGen().addSetNullStatements(ctx);
            }
            builder.endControlFlow();
        }
    }

    private boolean permitNullElements() {
        return permitNullCollections.contains(this.getImplementationType().toString());
    }

    static {
        permitNullCollections.addAll(Arrays.asList(HashMap.class.getCanonicalName(), LinkedHashMap.class.getCanonicalName(), TreeMap.class.getCanonicalName(), IdentityHashMap.class.getCanonicalName()));
    }
}

