/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.bsoncodec;

import ch.rasc.bsoncodec.Util;
import ch.rasc.bsoncodec.annotation.BsonDocument;
import ch.rasc.bsoncodec.annotation.Field;
import ch.rasc.bsoncodec.annotation.Id;
import ch.rasc.bsoncodec.annotation.Transient;
import ch.rasc.bsoncodec.codegen.ArrayCodeGen;
import ch.rasc.bsoncodec.codegen.CodeGeneratorContext;
import ch.rasc.bsoncodec.codegen.CollectionCodeGen;
import ch.rasc.bsoncodec.codegen.CompoundCodeGen;
import ch.rasc.bsoncodec.codegen.ConversionObjectIdCodeGen;
import ch.rasc.bsoncodec.codegen.ConversionUUIDCodeGen;
import ch.rasc.bsoncodec.codegen.CustomIdCodecCodeGen;
import ch.rasc.bsoncodec.codegen.MapCodeGen;
import ch.rasc.bsoncodec.codegen.ScalarCodeGen;
import ch.rasc.bsoncodec.codegen.delegate.ByteArrayDelegate;
import ch.rasc.bsoncodec.codegen.delegate.CustomCodecDelegate;
import ch.rasc.bsoncodec.codegen.delegate.UnknownCodecDelegate;
import ch.rasc.bsoncodec.model.FieldModel;
import ch.rasc.bsoncodec.model.IdModel;
import ch.rasc.bsoncodec.model.ImmutableFieldModel;
import ch.rasc.bsoncodec.model.ImmutableIdModel;
import ch.rasc.bsoncodec.model.ImmutableInstanceField;
import ch.rasc.bsoncodec.model.InstanceField;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.SimpleTypeVisitor8;
import org.bson.BSONException;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.assertions.Assertions;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.ObjectIdGenerator;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.types.ObjectId;

public class CodecCodeGenerator {
    private static final String ID_FIELD_NAME = "_id";
    private final TypeElement typeElement;
    private final String packageName;
    private final String className;
    private final ClassName thisType;
    private final Set<InstanceField> instanceFields = new TreeSet<InstanceField>();
    private String providerClassName;
    private boolean ignoreUnknown;
    private static final TypeMirror typeMirrorOfObject = Util.elementUtils.getTypeElement(Object.class.getCanonicalName()).asType();

    public CodecCodeGenerator(TypeElement typeElement) {
        this.typeElement = typeElement;
        this.packageName = Util.elementUtils.getPackageOf(typeElement).getQualifiedName().toString();
        this.className = typeElement.getSimpleName() + "Codec";
        this.thisType = ClassName.get((TypeElement)typeElement);
        this.providerClassName = this.packageName != null && !this.packageName.trim().isEmpty() ? this.packageName + ".PojoCodecProvider" : "PojoCodecProvider";
        this.ignoreUnknown = true;
    }

    public Set<InstanceField> getInstanceFields() {
        return this.instanceFields;
    }

    public String getClassName() {
        return this.className;
    }

    public String getProviderClassName() {
        return this.providerClassName;
    }

    public CharSequence getFullyQualifiedName() {
        if (this.packageName != null && this.packageName.trim().length() > 0) {
            return this.packageName + "." + this.className;
        }
        return this.className;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void generate(Appendable appendable) throws IOException {
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)this.className);
        classBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        ClassName codec = ClassName.get(Codec.class);
        classBuilder.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)codec, (TypeName[])new TypeName[]{this.thisType}));
        List<FieldModel> fieldInfos = this.collectFields();
        this.addEncodeMethod(classBuilder, fieldInfos);
        this.addDecodeMethod(classBuilder, fieldInfos);
        this.addGetEncoderClassMethod(classBuilder);
        this.addInstanceFields(classBuilder);
        this.addConstructor(classBuilder);
        JavaFile javaFile = JavaFile.builder((String)this.packageName, (TypeSpec)classBuilder.build()).build();
        javaFile.writeTo(appendable);
    }

    private void addConstructor(TypeSpec.Builder classBuilder) {
        if (this.instanceFields.isEmpty()) {
            return;
        }
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (this.instanceFields.stream().filter(i -> i.isRegistryCodec() || i.isRegistry()).findAny().isPresent()) {
            constructor.addParameter((TypeName)ClassName.get(CodecRegistry.class), "registry", new Modifier[]{Modifier.FINAL});
        }
        for (InstanceField instanceField : this.instanceFields) {
            if (instanceField.isRegistryCodec()) {
                constructor.addStatement("this.$N = $T.notNull($S, registry.get($T.class))", new Object[]{instanceField.name(), Assertions.class, instanceField.name(), instanceField.codecForClass()});
                continue;
            }
            if (!instanceField.isRegistry()) {
                constructor.addParameter(instanceField.type(), instanceField.name(), new Modifier[]{Modifier.FINAL});
            }
            constructor.addStatement("this.$N = $T.notNull($S, $N)", new Object[]{instanceField.name(), Assertions.class, instanceField.name(), instanceField.name()});
        }
        classBuilder.addMethod(constructor.build());
    }

    private void addInstanceFields(TypeSpec.Builder classBuilder) {
        for (InstanceField instanceField : this.instanceFields) {
            FieldSpec field = instanceField.isRegistryCodec() ? FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Codec.class), (TypeName[])new TypeName[]{instanceField.codecForClass()}), (String)instanceField.name(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build() : FieldSpec.builder((TypeName)instanceField.type(), (String)instanceField.name(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
            classBuilder.addField(field);
        }
    }

    private void addGetEncoderClassMethod(TypeSpec.Builder classBuilder) {
        MethodSpec getEncoderClassMethod = MethodSpec.methodBuilder((String)"getEncoderClass").returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{this.thisType})).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addStatement("return $N.class", new Object[]{this.thisType.simpleName()}).build();
        classBuilder.addMethod(getEncoderClassMethod);
    }

    private void addDecodeMethod(TypeSpec.Builder classBuilder, List<FieldModel> fieldModel) {
        boolean handleNull;
        MethodSpec.Builder decode = MethodSpec.methodBuilder((String)"decode").returns((TypeName)this.thisType).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(BsonReader.class, "reader", new Modifier[0]).addParameter(DecoderContext.class, "decoderContext", new Modifier[0]).addStatement("$T value = new $T()", new Object[]{this.thisType, this.thisType}).addStatement("reader.readStartDocument()", new Object[0]).addStatement("$T bsonType", new Object[]{BsonType.class}).beginControlFlow("while ((bsonType = reader.readBsonType()) != $T.END_OF_DOCUMENT)", new Object[]{BsonType.class}).addStatement("String name = reader.readName()", new Object[0]);
        boolean allDisableSetNullStatement = fieldModel.stream().allMatch(FieldModel::disableSetNullStatement);
        boolean someDecodeNullCheck = fieldModel.stream().filter(f -> !f.disableDecodeNullCheck()).findAny().isPresent();
        boolean bl = handleNull = allDisableSetNullStatement && someDecodeNullCheck;
        if (handleNull) {
            decode.beginControlFlow("if (bsonType != $T.NULL)", new Object[]{BsonType.class});
        }
        decode.beginControlFlow("switch (name)", new Object[0]);
        for (FieldModel field : fieldModel) {
            decode.beginControlFlow("case $S:", new Object[]{field.name()});
            String getter = "value." + field.methodNameGet() + "()";
            String setter = "value." + field.methodNameSet() + "(%s)";
            CodeGeneratorContext ctx = new CodeGeneratorContext(ImmutableFieldModel.copyOf(field).withDisableDecodeNullCheck(handleNull), decode, this.instanceFields, getter, setter);
            field.codeGen().addDecodeStatements(ctx);
            decode.addStatement("break", new Object[0]);
            decode.endControlFlow();
        }
        if (this.ignoreUnknown) {
            decode.addStatement("default:\nreader.skipValue()", new Object[0]).endControlFlow();
        } else {
            decode.addStatement("default:\nthrow new $T(this.getClass().getName() + $S + name + $S)", new Object[]{BSONException.class, " does not contain a matching property for the field '", "'"}).endControlFlow();
        }
        if (handleNull) {
            decode.nextControlFlow("else", new Object[0]).addStatement("reader.readNull()", new Object[0]);
            decode.endControlFlow();
        }
        decode.endControlFlow().addStatement("reader.readEndDocument()", new Object[0]).addStatement("return value", new Object[0]);
        classBuilder.addMethod(decode.build());
    }

    private void addEncodeMethod(TypeSpec.Builder classBuilder, List<FieldModel> fieldModel) {
        MethodSpec.Builder encode = MethodSpec.methodBuilder((String)"encode").returns(TypeName.VOID).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(BsonWriter.class, "writer", new Modifier[0]).addParameter((TypeName)this.thisType, "value", new Modifier[0]).addParameter(EncoderContext.class, "encoderContext", new Modifier[0]).addStatement("writer.writeStartDocument()", new Object[0]);
        for (FieldModel field : fieldModel) {
            String getter = "value." + field.methodNameGet() + "()";
            String setter = "value." + field.methodNameSet() + "(%s)";
            CodeGeneratorContext ctx = new CodeGeneratorContext(field, encode, this.instanceFields, getter, setter);
            field.codeGen().addEncodeStatements(ctx);
        }
        encode.addStatement("writer.writeEndDocument()", new Object[0]);
        classBuilder.addMethod(encode.build());
    }

    private boolean filterEnclosedElements(Element el) {
        return !el.getModifiers().contains((Object)Modifier.STATIC) && el.getKind() == ElementKind.METHOD && !el.getModifiers().contains((Object)Modifier.PRIVATE) || el.getKind() == ElementKind.FIELD && el.getAnnotation(Transient.class) == null;
    }

    private List<FieldModel> collectFields() {
        ArrayList<FieldModel> fields = new ArrayList<FieldModel>();
        BsonDocument bsonDocumentAnnotation = this.typeElement.getAnnotation(BsonDocument.class);
        boolean globalStoreNullValues = false;
        boolean globalStoreEmptyCollections = false;
        if (bsonDocumentAnnotation != null) {
            globalStoreNullValues = bsonDocumentAnnotation.storeNullValues();
            globalStoreEmptyCollections = bsonDocumentAnnotation.storeEmptyCollections();
            String annotationProviderClassName = bsonDocumentAnnotation.codecProviderClassName();
            if (!annotationProviderClassName.trim().isEmpty()) {
                this.providerClassName = annotationProviderClassName;
            }
            this.ignoreUnknown = bsonDocumentAnnotation.ignoreUnknown();
        } else {
            List<? extends AnnotationMirror> allAnnotationMirrors = Util.elementUtils.getAllAnnotationMirrors(this.typeElement);
            for (AnnotationMirror annotationMirror : allAnnotationMirrors) {
                List<? extends AnnotationMirror> allAnnotationMirrors2 = Util.elementUtils.getAllAnnotationMirrors(annotationMirror.getAnnotationType().asElement());
                for (AnnotationMirror annotationMirror2 : allAnnotationMirrors2) {
                    if (!BsonDocument.class.getCanonicalName().equals(annotationMirror2.getAnnotationType().toString())) continue;
                    for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror2.getElementValues().entrySet()) {
                        String cn;
                        if ("storeNullValues".equals(entry.getKey().getSimpleName().toString())) {
                            globalStoreNullValues = (Boolean)entry.getValue().getValue();
                            continue;
                        }
                        if ("storeEmptyCollections".equals(entry.getKey().getSimpleName().toString())) {
                            globalStoreEmptyCollections = (Boolean)entry.getValue().getValue();
                            continue;
                        }
                        if (!"codecProviderClassName".equals(entry.getKey().getSimpleName().toString()) || (cn = (String)entry.getValue().getValue()).trim().isEmpty()) continue;
                        this.providerClassName = cn;
                    }
                }
            }
        }
        TypeElement currentElement = this.typeElement;
        HashSet<String> alreadyConsumed = new HashSet<String>();
        while (currentElement != null) {
            Map map = currentElement.getEnclosedElements().stream().filter(this::filterEnclosedElements).collect(Collectors.groupingBy(Element::getKind, Collectors.toList()));
            HashMap<String, String> getMethods = new HashMap<String, String>();
            HashMap<String, String> setMethods = new HashMap<String, String>();
            for (Element el : map.get((Object)ElementKind.METHOD)) {
                ExecutableElement method = (ExecutableElement)el;
                String methodName = method.getSimpleName().toString();
                List<? extends VariableElement> params = method.getParameters();
                TypeMirror returnType = method.getReturnType();
                if (params.size() == 0) {
                    if (methodName.startsWith("get")) {
                        getMethods.put(Util.uncapitalize(methodName.substring(3)), methodName);
                        continue;
                    }
                    if (!methodName.startsWith("is") || returnType.getKind() != TypeKind.BOOLEAN) continue;
                    getMethods.put(Util.uncapitalize(methodName.substring(2)), methodName);
                    continue;
                }
                if (params.size() != 1 || returnType.getKind() != TypeKind.VOID || !methodName.startsWith("set")) continue;
                setMethods.put(Util.uncapitalize(methodName.substring(3)), methodName);
            }
            Element element = CodecCodeGenerator.lookupId(map.get((Object)ElementKind.FIELD));
            int index = 1;
            for (Element el : map.get((Object)ElementKind.FIELD)) {
                VariableElement varEl = (VariableElement)el;
                String varName = varEl.getSimpleName().toString();
                if (alreadyConsumed.contains(varName)) continue;
                alreadyConsumed.add(varName);
                ImmutableFieldModel.Builder builder = ImmutableFieldModel.builder();
                builder.storeEmptyCollection(globalStoreEmptyCollections);
                builder.storeNullValue(globalStoreNullValues);
                builder.varEl(varEl);
                builder.methodNameSet((String)setMethods.get(varName));
                builder.methodNameGet((String)getMethods.get(varName));
                if (el == element) {
                    this.handleIdElement(builder, varEl);
                } else {
                    this.handleNormalElement(index, builder, varEl);
                }
                fields.add(builder.build());
                ++index;
            }
            TypeMirror superclass = currentElement.getSuperclass();
            if (Util.isSameType(superclass, Object.class)) {
                currentElement = null;
                continue;
            }
            currentElement = (TypeElement)Util.typeUtils.asElement(superclass);
        }
        Collections.sort(fields);
        return fields;
    }

    private void handleNormalElement(int index, ImmutableFieldModel.Builder builder, VariableElement varEl) {
        TypeMirror collImplType = null;
        Field fieldAnnotation = varEl.getAnnotation(Field.class);
        if (fieldAnnotation == null) {
            builder.order(index);
        } else {
            String name = fieldAnnotation.value();
            if (!name.trim().isEmpty()) {
                builder.name(name);
            }
            if (fieldAnnotation.order() != Integer.MAX_VALUE) {
                builder.order(fieldAnnotation.order());
            } else {
                builder.order(index);
            }
            if (fieldAnnotation.fixedArray() > 0) {
                builder.fixedArray(fieldAnnotation.fixedArray());
            }
            ClassName customCodecName = null;
            try {
                customCodecName = ClassName.get(fieldAnnotation.codec());
            }
            catch (MirroredTypeException e) {
                customCodecName = TypeName.get((TypeMirror)e.getTypeMirror());
            }
            if (customCodecName != null && !customCodecName.toString().equals(Field.NullCodec.class.getCanonicalName())) {
                String customCodecVarName = Util.varName(customCodecName.toString());
                builder.customCodecName(customCodecVarName);
                this.instanceFields.add(ImmutableInstanceField.builder().type((TypeName)customCodecName).name(customCodecVarName).customCodec(true).build());
                builder.codeGen(ScalarCodeGen.create(null, varEl.asType(), new CustomCodecDelegate(customCodecVarName)));
                return;
            }
            try {
                collImplType = Util.elementUtils.getTypeElement(fieldAnnotation.collectionImplementationClass().getCanonicalName()).asType();
            }
            catch (MirroredTypeException e) {
                collImplType = e.getTypeMirror();
            }
        }
        CompoundCodeGen acg = CodecCodeGenerator.collectCodeGen(varEl.asType(), null);
        if (acg instanceof CollectionCodeGen && collImplType != null && !collImplType.toString().equals(Field.NullCollection.class.getCanonicalName())) {
            ((CollectionCodeGen)acg).setImplementationType(collImplType);
        }
        builder.codeGen(acg);
    }

    private static CompoundCodeGen collectCodeGen(TypeMirror type, CompoundCodeGen prev) {
        return type.accept(new SimpleTypeVisitor8<CompoundCodeGen, CompoundCodeGen>(){

            @Override
            public CompoundCodeGen visitDeclared(DeclaredType declaredType, CompoundCodeGen parent) {
                if (Util.isCollection(declaredType)) {
                    CollectionCodeGen cg = new CollectionCodeGen(parent, declaredType);
                    List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
                    if (!typeArguments.isEmpty()) {
                        CodecCodeGenerator.collectCodeGen(typeArguments.get(0), cg);
                    } else {
                        ScalarCodeGen.create(cg, typeMirrorOfObject, new UnknownCodecDelegate());
                    }
                    return cg;
                }
                if (Util.isMap(declaredType)) {
                    List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
                    if (typeArguments.size() == 2) {
                        MapCodeGen cg = new MapCodeGen(parent, declaredType, typeArguments.get(0));
                        TypeMirror entryType = typeArguments.get(1);
                        if (Util.isSameType(entryType, Object.class)) {
                            ScalarCodeGen.create(cg, typeMirrorOfObject, new UnknownCodecDelegate());
                        } else {
                            CodecCodeGenerator.collectCodeGen(entryType, cg);
                        }
                        return cg;
                    }
                    MapCodeGen cg = new MapCodeGen(parent, declaredType, typeMirrorOfObject);
                    ScalarCodeGen.create(cg, typeMirrorOfObject, new UnknownCodecDelegate());
                    return cg;
                }
                return ScalarCodeGen.create(parent, declaredType);
            }

            @Override
            public CompoundCodeGen visitPrimitive(PrimitiveType primitiveType, CompoundCodeGen parent) {
                return ScalarCodeGen.create(parent, primitiveType);
            }

            @Override
            public CompoundCodeGen visitArray(ArrayType arrayType, CompoundCodeGen parent) {
                TypeMirror componentType = arrayType.getComponentType();
                if (Util.isByte(componentType)) {
                    return ScalarCodeGen.create(parent, componentType, new ByteArrayDelegate());
                }
                ArrayCodeGen cg = new ArrayCodeGen(parent, arrayType);
                if (Util.isArray(componentType)) {
                    CodecCodeGenerator.collectCodeGen(componentType, cg);
                } else {
                    ScalarCodeGen.create(cg, componentType);
                }
                return cg;
            }

            @Override
            public CompoundCodeGen visitTypeVariable(TypeVariable typeVariable, CompoundCodeGen parent) {
                return (CompoundCodeGen)this.DEFAULT_VALUE;
            }

            @Override
            public CompoundCodeGen visitError(ErrorType errorType, CompoundCodeGen parent) {
                return (CompoundCodeGen)this.DEFAULT_VALUE;
            }

            @Override
            protected CompoundCodeGen defaultAction(TypeMirror typeMirror, CompoundCodeGen parent) {
                throw new UnsupportedOperationException("Unexpected TypeKind " + (Object)((Object)typeMirror.getKind()) + " for " + typeMirror);
            }
        }, prev);
    }

    private void handleIdElement(ImmutableFieldModel.Builder builder, VariableElement varEl) {
        ImmutableIdModel idModel;
        ImmutableIdModel.Builder idModelBuilder = ImmutableIdModel.builder();
        builder.name(ID_FIELD_NAME).order(0);
        Id idAnnotation = varEl.getAnnotation(Id.class);
        boolean idGeneratorSet = false;
        if (idAnnotation != null) {
            ClassName idCodecTypeName = null;
            try {
                idCodecTypeName = ClassName.get(idAnnotation.codec());
            }
            catch (MirroredTypeException e) {
                idCodecTypeName = TypeName.get((TypeMirror)e.getTypeMirror());
            }
            if (idCodecTypeName != null && !idCodecTypeName.toString().equals(Field.NullCodec.class.getCanonicalName())) {
                String idCodecVarName = Util.varName(idCodecTypeName.toString());
                this.instanceFields.add(ImmutableInstanceField.builder().type((TypeName)idCodecTypeName).name(idCodecVarName).build());
                idModelBuilder.codecName(idCodecVarName);
                ImmutableIdModel idModel2 = idModelBuilder.build();
                builder.codeGen(new CustomIdCodecCodeGen());
                builder.idModel(idModel2);
                return;
            }
            ClassName idGeneratorTypeName = null;
            try {
                idGeneratorTypeName = ClassName.get(idAnnotation.generator());
            }
            catch (MirroredTypeException e) {
                idGeneratorTypeName = TypeName.get((TypeMirror)e.getTypeMirror());
            }
            if (Util.isSameType(varEl.asType(), String.class)) {
                idModelBuilder.conversion(idAnnotation.conversion());
            }
            if (idGeneratorTypeName != null && !idGeneratorTypeName.toString().equals(Id.NullIdGenerator.class.getCanonicalName())) {
                String idGeneratorName = Util.varName(idGeneratorTypeName.toString());
                this.instanceFields.add(ImmutableInstanceField.builder().type((TypeName)idGeneratorTypeName).name(idGeneratorName).build());
                idModelBuilder.generatorName(idGeneratorName);
                idGeneratorSet = true;
            } else if (idAnnotation.conversion() == Id.IdConversion.BASE64_OBJECTID || idAnnotation.conversion() == Id.IdConversion.HEX_OBJECTID) {
                String idGeneratorName = "objectIdGenerator";
                this.instanceFields.add(ImmutableInstanceField.builder().type((TypeName)ClassName.get(ObjectIdGenerator.class)).name(idGeneratorName).build());
                idModelBuilder.generatorName(idGeneratorName);
                idGeneratorSet = true;
            }
        }
        if (!idGeneratorSet && CodecCodeGenerator.isObjectId(varEl)) {
            String idGeneratorName = "objectIdGenerator";
            this.instanceFields.add(ImmutableInstanceField.builder().type((TypeName)ClassName.get(ObjectIdGenerator.class)).name(idGeneratorName).build());
            idModelBuilder.generatorName(idGeneratorName);
        }
        if (((IdModel)(idModel = idModelBuilder.build())).conversion() == Id.IdConversion.BASE64_OBJECTID || ((IdModel)idModel).conversion() == Id.IdConversion.HEX_OBJECTID) {
            builder.codeGen(new ConversionObjectIdCodeGen());
        } else if (((IdModel)idModel).conversion() == Id.IdConversion.BASE64_UUID || ((IdModel)idModel).conversion() == Id.IdConversion.HEX_UUID) {
            builder.codeGen(new ConversionUUIDCodeGen());
        } else {
            builder.codeGen(ScalarCodeGen.create(null, varEl.asType()));
        }
        builder.idModel(idModel);
    }

    private static Element lookupId(List<Element> fields) {
        Element objectIdField = null;
        Element uuidField = null;
        Element _idField = null;
        Element idField = null;
        for (Element field : fields) {
            if (field.getAnnotation(Id.class) != null) {
                return field;
            }
            if (CodecCodeGenerator.isObjectId(field)) {
                objectIdField = field;
                continue;
            }
            if (CodecCodeGenerator.isUUID(field)) {
                uuidField = field;
                continue;
            }
            if (field.getSimpleName().contentEquals(ID_FIELD_NAME)) {
                _idField = field;
                continue;
            }
            if (!field.getSimpleName().contentEquals("id")) continue;
            idField = field;
        }
        if (objectIdField != null) {
            return objectIdField;
        }
        if (uuidField != null) {
            return uuidField;
        }
        if (_idField != null) {
            return _idField;
        }
        if (idField != null) {
            return idField;
        }
        return null;
    }

    private static boolean isUUID(Element field) {
        return field.asType().toString().equals(UUID.class.getCanonicalName());
    }

    private static boolean isObjectId(Element field) {
        return field.asType().toString().equals(ObjectId.class.getCanonicalName());
    }
}

