/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.bsoncodec.model;

import ch.rasc.bsoncodec.annotation.Id;
import ch.rasc.bsoncodec.model.IdModel;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableIdModel
extends IdModel {
    @Nullable
    private final String generatorName;
    @Nullable
    private final Id.IdConversion conversion;
    @Nullable
    private final String codecName;

    private ImmutableIdModel(@Nullable String generatorName, @Nullable Id.IdConversion conversion, @Nullable String codecName) {
        this.generatorName = generatorName;
        this.conversion = conversion;
        this.codecName = codecName;
    }

    @Override
    @Nullable
    public String generatorName() {
        return this.generatorName;
    }

    @Override
    @Nullable
    public Id.IdConversion conversion() {
        return this.conversion;
    }

    @Override
    @Nullable
    public String codecName() {
        return this.codecName;
    }

    public final ImmutableIdModel withGeneratorName(@Nullable String value) {
        if (Objects.equal((Object)this.generatorName, (Object)value)) {
            return this;
        }
        return new ImmutableIdModel(value, this.conversion, this.codecName);
    }

    public final ImmutableIdModel withConversion(@Nullable Id.IdConversion value) {
        if (this.conversion == value) {
            return this;
        }
        return new ImmutableIdModel(this.generatorName, value, this.codecName);
    }

    public final ImmutableIdModel withCodecName(@Nullable String value) {
        if (Objects.equal((Object)this.codecName, (Object)value)) {
            return this;
        }
        return new ImmutableIdModel(this.generatorName, this.conversion, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIdModel && this.equalTo((ImmutableIdModel)another);
    }

    private boolean equalTo(ImmutableIdModel another) {
        return Objects.equal((Object)this.generatorName, (Object)another.generatorName) && Objects.equal((Object)((Object)this.conversion), (Object)((Object)another.conversion)) && Objects.equal((Object)this.codecName, (Object)another.codecName);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode((Object[])new Object[]{this.generatorName});
        h = h * 17 + Objects.hashCode((Object[])new Object[]{this.conversion});
        h = h * 17 + Objects.hashCode((Object[])new Object[]{this.codecName});
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"IdModel").omitNullValues().add("generatorName", (Object)this.generatorName).add("conversion", (Object)this.conversion).add("codecName", (Object)this.codecName).toString();
    }

    public static ImmutableIdModel copyOf(IdModel instance) {
        if (instance instanceof ImmutableIdModel) {
            return (ImmutableIdModel)instance;
        }
        return ImmutableIdModel.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String generatorName;
        @Nullable
        private Id.IdConversion conversion;
        @Nullable
        private String codecName;

        private Builder() {
        }

        public final Builder from(IdModel instance) {
            String codecNameValue;
            Id.IdConversion conversionValue;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            String generatorNameValue = instance.generatorName();
            if (generatorNameValue != null) {
                this.generatorName(generatorNameValue);
            }
            if ((conversionValue = instance.conversion()) != null) {
                this.conversion(conversionValue);
            }
            if ((codecNameValue = instance.codecName()) != null) {
                this.codecName(codecNameValue);
            }
            return this;
        }

        public final Builder generatorName(@Nullable String generatorName) {
            this.generatorName = generatorName;
            return this;
        }

        public final Builder conversion(@Nullable Id.IdConversion conversion) {
            this.conversion = conversion;
            return this;
        }

        public final Builder codecName(@Nullable String codecName) {
            this.codecName = codecName;
            return this;
        }

        public ImmutableIdModel build() {
            return new ImmutableIdModel(this.generatorName, this.conversion, this.codecName);
        }
    }
}

