/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.bsoncodec.model;

import ch.rasc.bsoncodec.codegen.CodeGen;
import ch.rasc.bsoncodec.model.FieldModel;
import ch.rasc.bsoncodec.model.IdModel;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.lang.model.element.VariableElement;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableFieldModel
extends FieldModel {
    private final VariableElement varEl;
    private final String name;
    private final int order;
    @Nullable
    private final String customCodecName;
    private final CodeGen codeGen;
    private final boolean storeNullValue;
    private final boolean storeEmptyCollection;
    private final boolean disableEncodeNullCheck;
    private final boolean disableDecodeNullCheck;
    private final boolean disableSetNullStatement;
    private final int fixedArray;
    @Nullable
    private final IdModel idModel;
    private final String methodNameSet;
    private final String methodNameGet;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableFieldModel(Builder builder) {
        this.varEl = builder.varEl;
        this.order = builder.order;
        this.customCodecName = builder.customCodecName;
        this.codeGen = builder.codeGen;
        this.idModel = builder.idModel;
        this.methodNameSet = builder.methodNameSet;
        this.methodNameGet = builder.methodNameGet;
        if (builder.name != null) {
            this.initShim.name(builder.name);
        }
        if (builder.storeNullValueIsSet()) {
            this.initShim.storeNullValue(builder.storeNullValue);
        }
        if (builder.storeEmptyCollectionIsSet()) {
            this.initShim.storeEmptyCollection(builder.storeEmptyCollection);
        }
        if (builder.disableEncodeNullCheckIsSet()) {
            this.initShim.disableEncodeNullCheck(builder.disableEncodeNullCheck);
        }
        if (builder.disableDecodeNullCheckIsSet()) {
            this.initShim.disableDecodeNullCheck(builder.disableDecodeNullCheck);
        }
        if (builder.disableSetNullStatementIsSet()) {
            this.initShim.disableSetNullStatement(builder.disableSetNullStatement);
        }
        if (builder.fixedArrayIsSet()) {
            this.initShim.fixedArray(builder.fixedArray);
        }
        this.name = this.initShim.name();
        this.storeNullValue = this.initShim.storeNullValue();
        this.storeEmptyCollection = this.initShim.storeEmptyCollection();
        this.disableEncodeNullCheck = this.initShim.disableEncodeNullCheck();
        this.disableDecodeNullCheck = this.initShim.disableDecodeNullCheck();
        this.disableSetNullStatement = this.initShim.disableSetNullStatement();
        this.fixedArray = this.initShim.fixedArray();
        this.initShim = null;
    }

    private ImmutableFieldModel(VariableElement varEl, String name, int order, @Nullable String customCodecName, CodeGen codeGen, boolean storeNullValue, boolean storeEmptyCollection, boolean disableEncodeNullCheck, boolean disableDecodeNullCheck, boolean disableSetNullStatement, int fixedArray, @Nullable IdModel idModel, String methodNameSet, String methodNameGet) {
        this.varEl = varEl;
        this.name = name;
        this.order = order;
        this.customCodecName = customCodecName;
        this.codeGen = codeGen;
        this.storeNullValue = storeNullValue;
        this.storeEmptyCollection = storeEmptyCollection;
        this.disableEncodeNullCheck = disableEncodeNullCheck;
        this.disableDecodeNullCheck = disableDecodeNullCheck;
        this.disableSetNullStatement = disableSetNullStatement;
        this.fixedArray = fixedArray;
        this.idModel = idModel;
        this.methodNameSet = methodNameSet;
        this.methodNameGet = methodNameGet;
        this.initShim = null;
    }

    @Override
    public VariableElement varEl() {
        return this.varEl;
    }

    @Override
    public String name() {
        InitShim shim = this.initShim;
        return shim != null ? shim.name() : this.name;
    }

    @Override
    public int order() {
        return this.order;
    }

    @Override
    @Nullable
    public String customCodecName() {
        return this.customCodecName;
    }

    @Override
    public CodeGen codeGen() {
        return this.codeGen;
    }

    @Override
    public boolean storeNullValue() {
        InitShim shim = this.initShim;
        return shim != null ? shim.storeNullValue() : this.storeNullValue;
    }

    @Override
    public boolean storeEmptyCollection() {
        InitShim shim = this.initShim;
        return shim != null ? shim.storeEmptyCollection() : this.storeEmptyCollection;
    }

    @Override
    public boolean disableEncodeNullCheck() {
        InitShim shim = this.initShim;
        return shim != null ? shim.disableEncodeNullCheck() : this.disableEncodeNullCheck;
    }

    @Override
    public boolean disableDecodeNullCheck() {
        InitShim shim = this.initShim;
        return shim != null ? shim.disableDecodeNullCheck() : this.disableDecodeNullCheck;
    }

    @Override
    public boolean disableSetNullStatement() {
        InitShim shim = this.initShim;
        return shim != null ? shim.disableSetNullStatement() : this.disableSetNullStatement;
    }

    @Override
    public int fixedArray() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fixedArray() : this.fixedArray;
    }

    @Override
    @Nullable
    public IdModel idModel() {
        return this.idModel;
    }

    @Override
    public String methodNameSet() {
        return this.methodNameSet;
    }

    @Override
    public String methodNameGet() {
        return this.methodNameGet;
    }

    public final ImmutableFieldModel withVarEl(VariableElement value) {
        if (this.varEl == value) {
            return this;
        }
        VariableElement newValue = (VariableElement)Preconditions.checkNotNull((Object)value, (Object)"varEl");
        return new ImmutableFieldModel(newValue, this.name, this.order, this.customCodecName, this.codeGen, this.storeNullValue, this.storeEmptyCollection, this.disableEncodeNullCheck, this.disableDecodeNullCheck, this.disableSetNullStatement, this.fixedArray, this.idModel, this.methodNameSet, this.methodNameGet);
    }

    public final ImmutableFieldModel withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"name");
        return new ImmutableFieldModel(this.varEl, newValue, this.order, this.customCodecName, this.codeGen, this.storeNullValue, this.storeEmptyCollection, this.disableEncodeNullCheck, this.disableDecodeNullCheck, this.disableSetNullStatement, this.fixedArray, this.idModel, this.methodNameSet, this.methodNameGet);
    }

    public final ImmutableFieldModel withOrder(int value) {
        if (this.order == value) {
            return this;
        }
        return new ImmutableFieldModel(this.varEl, this.name, value, this.customCodecName, this.codeGen, this.storeNullValue, this.storeEmptyCollection, this.disableEncodeNullCheck, this.disableDecodeNullCheck, this.disableSetNullStatement, this.fixedArray, this.idModel, this.methodNameSet, this.methodNameGet);
    }

    public final ImmutableFieldModel withCustomCodecName(@Nullable String value) {
        if (Objects.equal((Object)this.customCodecName, (Object)value)) {
            return this;
        }
        return new ImmutableFieldModel(this.varEl, this.name, this.order, value, this.codeGen, this.storeNullValue, this.storeEmptyCollection, this.disableEncodeNullCheck, this.disableDecodeNullCheck, this.disableSetNullStatement, this.fixedArray, this.idModel, this.methodNameSet, this.methodNameGet);
    }

    public final ImmutableFieldModel withCodeGen(CodeGen value) {
        if (this.codeGen == value) {
            return this;
        }
        CodeGen newValue = (CodeGen)Preconditions.checkNotNull((Object)value, (Object)"codeGen");
        return new ImmutableFieldModel(this.varEl, this.name, this.order, this.customCodecName, newValue, this.storeNullValue, this.storeEmptyCollection, this.disableEncodeNullCheck, this.disableDecodeNullCheck, this.disableSetNullStatement, this.fixedArray, this.idModel, this.methodNameSet, this.methodNameGet);
    }

    public final ImmutableFieldModel withStoreNullValue(boolean value) {
        if (this.storeNullValue == value) {
            return this;
        }
        return new ImmutableFieldModel(this.varEl, this.name, this.order, this.customCodecName, this.codeGen, value, this.storeEmptyCollection, this.disableEncodeNullCheck, this.disableDecodeNullCheck, this.disableSetNullStatement, this.fixedArray, this.idModel, this.methodNameSet, this.methodNameGet);
    }

    public final ImmutableFieldModel withStoreEmptyCollection(boolean value) {
        if (this.storeEmptyCollection == value) {
            return this;
        }
        return new ImmutableFieldModel(this.varEl, this.name, this.order, this.customCodecName, this.codeGen, this.storeNullValue, value, this.disableEncodeNullCheck, this.disableDecodeNullCheck, this.disableSetNullStatement, this.fixedArray, this.idModel, this.methodNameSet, this.methodNameGet);
    }

    public final ImmutableFieldModel withDisableEncodeNullCheck(boolean value) {
        if (this.disableEncodeNullCheck == value) {
            return this;
        }
        return new ImmutableFieldModel(this.varEl, this.name, this.order, this.customCodecName, this.codeGen, this.storeNullValue, this.storeEmptyCollection, value, this.disableDecodeNullCheck, this.disableSetNullStatement, this.fixedArray, this.idModel, this.methodNameSet, this.methodNameGet);
    }

    public final ImmutableFieldModel withDisableDecodeNullCheck(boolean value) {
        if (this.disableDecodeNullCheck == value) {
            return this;
        }
        return new ImmutableFieldModel(this.varEl, this.name, this.order, this.customCodecName, this.codeGen, this.storeNullValue, this.storeEmptyCollection, this.disableEncodeNullCheck, value, this.disableSetNullStatement, this.fixedArray, this.idModel, this.methodNameSet, this.methodNameGet);
    }

    public final ImmutableFieldModel withDisableSetNullStatement(boolean value) {
        if (this.disableSetNullStatement == value) {
            return this;
        }
        return new ImmutableFieldModel(this.varEl, this.name, this.order, this.customCodecName, this.codeGen, this.storeNullValue, this.storeEmptyCollection, this.disableEncodeNullCheck, this.disableDecodeNullCheck, value, this.fixedArray, this.idModel, this.methodNameSet, this.methodNameGet);
    }

    public final ImmutableFieldModel withFixedArray(int value) {
        if (this.fixedArray == value) {
            return this;
        }
        return new ImmutableFieldModel(this.varEl, this.name, this.order, this.customCodecName, this.codeGen, this.storeNullValue, this.storeEmptyCollection, this.disableEncodeNullCheck, this.disableDecodeNullCheck, this.disableSetNullStatement, value, this.idModel, this.methodNameSet, this.methodNameGet);
    }

    public final ImmutableFieldModel withIdModel(@Nullable IdModel value) {
        if (this.idModel == value) {
            return this;
        }
        return new ImmutableFieldModel(this.varEl, this.name, this.order, this.customCodecName, this.codeGen, this.storeNullValue, this.storeEmptyCollection, this.disableEncodeNullCheck, this.disableDecodeNullCheck, this.disableSetNullStatement, this.fixedArray, value, this.methodNameSet, this.methodNameGet);
    }

    public final ImmutableFieldModel withMethodNameSet(String value) {
        if (this.methodNameSet.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"methodNameSet");
        return new ImmutableFieldModel(this.varEl, this.name, this.order, this.customCodecName, this.codeGen, this.storeNullValue, this.storeEmptyCollection, this.disableEncodeNullCheck, this.disableDecodeNullCheck, this.disableSetNullStatement, this.fixedArray, this.idModel, newValue, this.methodNameGet);
    }

    public final ImmutableFieldModel withMethodNameGet(String value) {
        if (this.methodNameGet.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"methodNameGet");
        return new ImmutableFieldModel(this.varEl, this.name, this.order, this.customCodecName, this.codeGen, this.storeNullValue, this.storeEmptyCollection, this.disableEncodeNullCheck, this.disableDecodeNullCheck, this.disableSetNullStatement, this.fixedArray, this.idModel, this.methodNameSet, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFieldModel && this.equalTo((ImmutableFieldModel)another);
    }

    private boolean equalTo(ImmutableFieldModel another) {
        return this.varEl.equals(another.varEl) && this.name.equals(another.name) && this.order == another.order && Objects.equal((Object)this.customCodecName, (Object)another.customCodecName) && this.codeGen.equals(another.codeGen) && this.storeNullValue == another.storeNullValue && this.storeEmptyCollection == another.storeEmptyCollection && this.disableEncodeNullCheck == another.disableEncodeNullCheck && this.disableDecodeNullCheck == another.disableDecodeNullCheck && this.disableSetNullStatement == another.disableSetNullStatement && this.fixedArray == another.fixedArray && Objects.equal((Object)this.idModel, (Object)another.idModel) && this.methodNameSet.equals(another.methodNameSet) && this.methodNameGet.equals(another.methodNameGet);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.varEl.hashCode();
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.order;
        h = h * 17 + Objects.hashCode((Object[])new Object[]{this.customCodecName});
        h = h * 17 + this.codeGen.hashCode();
        h = h * 17 + Booleans.hashCode((boolean)this.storeNullValue);
        h = h * 17 + Booleans.hashCode((boolean)this.storeEmptyCollection);
        h = h * 17 + Booleans.hashCode((boolean)this.disableEncodeNullCheck);
        h = h * 17 + Booleans.hashCode((boolean)this.disableDecodeNullCheck);
        h = h * 17 + Booleans.hashCode((boolean)this.disableSetNullStatement);
        h = h * 17 + this.fixedArray;
        h = h * 17 + Objects.hashCode((Object[])new Object[]{this.idModel});
        h = h * 17 + this.methodNameSet.hashCode();
        h = h * 17 + this.methodNameGet.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FieldModel").omitNullValues().add("varEl", (Object)this.varEl).add("name", (Object)this.name).add("order", this.order).add("customCodecName", (Object)this.customCodecName).add("codeGen", (Object)this.codeGen).add("storeNullValue", this.storeNullValue).add("storeEmptyCollection", this.storeEmptyCollection).add("disableEncodeNullCheck", this.disableEncodeNullCheck).add("disableDecodeNullCheck", this.disableDecodeNullCheck).add("disableSetNullStatement", this.disableSetNullStatement).add("fixedArray", this.fixedArray).add("idModel", (Object)this.idModel).add("methodNameSet", (Object)this.methodNameSet).add("methodNameGet", (Object)this.methodNameGet).toString();
    }

    public static ImmutableFieldModel copyOf(FieldModel instance) {
        if (instance instanceof ImmutableFieldModel) {
            return (ImmutableFieldModel)instance;
        }
        return ImmutableFieldModel.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VAR_EL = 1L;
        private static final long INIT_BIT_ORDER = 2L;
        private static final long INIT_BIT_CODE_GEN = 4L;
        private static final long INIT_BIT_METHOD_NAME_SET = 8L;
        private static final long INIT_BIT_METHOD_NAME_GET = 16L;
        private static final long OPT_BIT_STORE_NULL_VALUE = 1L;
        private static final long OPT_BIT_STORE_EMPTY_COLLECTION = 2L;
        private static final long OPT_BIT_DISABLE_ENCODE_NULL_CHECK = 4L;
        private static final long OPT_BIT_DISABLE_DECODE_NULL_CHECK = 8L;
        private static final long OPT_BIT_DISABLE_SET_NULL_STATEMENT = 16L;
        private static final long OPT_BIT_FIXED_ARRAY = 32L;
        private long initBits = 31L;
        private long optBits;
        @Nullable
        private VariableElement varEl;
        @Nullable
        private String name;
        private int order;
        @Nullable
        private String customCodecName;
        @Nullable
        private CodeGen codeGen;
        private boolean storeNullValue;
        private boolean storeEmptyCollection;
        private boolean disableEncodeNullCheck;
        private boolean disableDecodeNullCheck;
        private boolean disableSetNullStatement;
        private int fixedArray;
        @Nullable
        private IdModel idModel;
        @Nullable
        private String methodNameSet;
        @Nullable
        private String methodNameGet;

        private Builder() {
        }

        public final Builder from(FieldModel instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.varEl(instance.varEl());
            this.name(instance.name());
            this.order(instance.order());
            String customCodecNameValue = instance.customCodecName();
            if (customCodecNameValue != null) {
                this.customCodecName(customCodecNameValue);
            }
            this.codeGen(instance.codeGen());
            this.storeNullValue(instance.storeNullValue());
            this.storeEmptyCollection(instance.storeEmptyCollection());
            this.disableEncodeNullCheck(instance.disableEncodeNullCheck());
            this.disableDecodeNullCheck(instance.disableDecodeNullCheck());
            this.disableSetNullStatement(instance.disableSetNullStatement());
            this.fixedArray(instance.fixedArray());
            IdModel idModelValue = instance.idModel();
            if (idModelValue != null) {
                this.idModel(idModelValue);
            }
            this.methodNameSet(instance.methodNameSet());
            this.methodNameGet(instance.methodNameGet());
            return this;
        }

        public final Builder varEl(VariableElement varEl) {
            this.varEl = (VariableElement)Preconditions.checkNotNull((Object)varEl, (Object)"varEl");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            return this;
        }

        public final Builder order(int order) {
            this.order = order;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder customCodecName(@Nullable String customCodecName) {
            this.customCodecName = customCodecName;
            return this;
        }

        public final Builder codeGen(CodeGen codeGen) {
            this.codeGen = (CodeGen)Preconditions.checkNotNull((Object)codeGen, (Object)"codeGen");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder storeNullValue(boolean storeNullValue) {
            this.storeNullValue = storeNullValue;
            this.optBits |= 1L;
            return this;
        }

        public final Builder storeEmptyCollection(boolean storeEmptyCollection) {
            this.storeEmptyCollection = storeEmptyCollection;
            this.optBits |= 2L;
            return this;
        }

        public final Builder disableEncodeNullCheck(boolean disableEncodeNullCheck) {
            this.disableEncodeNullCheck = disableEncodeNullCheck;
            this.optBits |= 4L;
            return this;
        }

        public final Builder disableDecodeNullCheck(boolean disableDecodeNullCheck) {
            this.disableDecodeNullCheck = disableDecodeNullCheck;
            this.optBits |= 8L;
            return this;
        }

        public final Builder disableSetNullStatement(boolean disableSetNullStatement) {
            this.disableSetNullStatement = disableSetNullStatement;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder fixedArray(int fixedArray) {
            this.fixedArray = fixedArray;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder idModel(@Nullable IdModel idModel) {
            this.idModel = idModel;
            return this;
        }

        public final Builder methodNameSet(String methodNameSet) {
            this.methodNameSet = (String)Preconditions.checkNotNull((Object)methodNameSet, (Object)"methodNameSet");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder methodNameGet(String methodNameGet) {
            this.methodNameGet = (String)Preconditions.checkNotNull((Object)methodNameGet, (Object)"methodNameGet");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableFieldModel build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFieldModel(this);
        }

        private boolean storeNullValueIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean storeEmptyCollectionIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean disableEncodeNullCheckIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean disableDecodeNullCheckIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean disableSetNullStatementIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean fixedArrayIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("varEl");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("order");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("codeGen");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("methodNameSet");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("methodNameGet");
            }
            return "Cannot build FieldModel, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private String name;
        private int nameBuildStage;
        private boolean storeNullValue;
        private int storeNullValueBuildStage;
        private boolean storeEmptyCollection;
        private int storeEmptyCollectionBuildStage;
        private boolean disableEncodeNullCheck;
        private int disableEncodeNullCheckBuildStage;
        private boolean disableDecodeNullCheck;
        private int disableDecodeNullCheckBuildStage;
        private boolean disableSetNullStatement;
        private int disableSetNullStatementBuildStage;
        private int fixedArray;
        private int fixedArrayBuildStage;

        private InitShim() {
        }

        String name() {
            if (this.nameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nameBuildStage == 0) {
                this.nameBuildStage = -1;
                this.name = (String)Preconditions.checkNotNull((Object)ImmutableFieldModel.super.name(), (Object)"name");
                this.nameBuildStage = 1;
            }
            return this.name;
        }

        void name(String name) {
            this.name = name;
            this.nameBuildStage = 1;
        }

        boolean storeNullValue() {
            if (this.storeNullValueBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.storeNullValueBuildStage == 0) {
                this.storeNullValueBuildStage = -1;
                this.storeNullValue = ImmutableFieldModel.super.storeNullValue();
                this.storeNullValueBuildStage = 1;
            }
            return this.storeNullValue;
        }

        void storeNullValue(boolean storeNullValue) {
            this.storeNullValue = storeNullValue;
            this.storeNullValueBuildStage = 1;
        }

        boolean storeEmptyCollection() {
            if (this.storeEmptyCollectionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.storeEmptyCollectionBuildStage == 0) {
                this.storeEmptyCollectionBuildStage = -1;
                this.storeEmptyCollection = ImmutableFieldModel.super.storeEmptyCollection();
                this.storeEmptyCollectionBuildStage = 1;
            }
            return this.storeEmptyCollection;
        }

        void storeEmptyCollection(boolean storeEmptyCollection) {
            this.storeEmptyCollection = storeEmptyCollection;
            this.storeEmptyCollectionBuildStage = 1;
        }

        boolean disableEncodeNullCheck() {
            if (this.disableEncodeNullCheckBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.disableEncodeNullCheckBuildStage == 0) {
                this.disableEncodeNullCheckBuildStage = -1;
                this.disableEncodeNullCheck = ImmutableFieldModel.super.disableEncodeNullCheck();
                this.disableEncodeNullCheckBuildStage = 1;
            }
            return this.disableEncodeNullCheck;
        }

        void disableEncodeNullCheck(boolean disableEncodeNullCheck) {
            this.disableEncodeNullCheck = disableEncodeNullCheck;
            this.disableEncodeNullCheckBuildStage = 1;
        }

        boolean disableDecodeNullCheck() {
            if (this.disableDecodeNullCheckBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.disableDecodeNullCheckBuildStage == 0) {
                this.disableDecodeNullCheckBuildStage = -1;
                this.disableDecodeNullCheck = ImmutableFieldModel.super.disableDecodeNullCheck();
                this.disableDecodeNullCheckBuildStage = 1;
            }
            return this.disableDecodeNullCheck;
        }

        void disableDecodeNullCheck(boolean disableDecodeNullCheck) {
            this.disableDecodeNullCheck = disableDecodeNullCheck;
            this.disableDecodeNullCheckBuildStage = 1;
        }

        boolean disableSetNullStatement() {
            if (this.disableSetNullStatementBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.disableSetNullStatementBuildStage == 0) {
                this.disableSetNullStatementBuildStage = -1;
                this.disableSetNullStatement = ImmutableFieldModel.super.disableSetNullStatement();
                this.disableSetNullStatementBuildStage = 1;
            }
            return this.disableSetNullStatement;
        }

        void disableSetNullStatement(boolean disableSetNullStatement) {
            this.disableSetNullStatement = disableSetNullStatement;
            this.disableSetNullStatementBuildStage = 1;
        }

        int fixedArray() {
            if (this.fixedArrayBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fixedArrayBuildStage == 0) {
                this.fixedArrayBuildStage = -1;
                this.fixedArray = ImmutableFieldModel.super.fixedArray();
                this.fixedArrayBuildStage = 1;
            }
            return this.fixedArray;
        }

        void fixedArray(int fixedArray) {
            this.fixedArray = fixedArray;
            this.fixedArrayBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = Lists.newArrayList();
            if (this.nameBuildStage == -1) {
                attributes.add("name");
            }
            if (this.storeNullValueBuildStage == -1) {
                attributes.add("storeNullValue");
            }
            if (this.storeEmptyCollectionBuildStage == -1) {
                attributes.add("storeEmptyCollection");
            }
            if (this.disableEncodeNullCheckBuildStage == -1) {
                attributes.add("disableEncodeNullCheck");
            }
            if (this.disableDecodeNullCheckBuildStage == -1) {
                attributes.add("disableDecodeNullCheck");
            }
            if (this.disableSetNullStatementBuildStage == -1) {
                attributes.add("disableSetNullStatement");
            }
            if (this.fixedArrayBuildStage == -1) {
                attributes.add("fixedArray");
            }
            return "Cannot build FieldModel, attribute initializers form cycle" + attributes;
        }
    }
}

