/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.bsoncodec.model;

import ch.rasc.bsoncodec.model.InstanceField;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableInstanceField
extends InstanceField {
    private final TypeName type;
    private final String name;
    @Nullable
    private final TypeName codecForClass;
    private final boolean customCodec;

    private ImmutableInstanceField(Builder builder) {
        this.type = builder.type;
        this.name = builder.name;
        this.codecForClass = builder.codecForClass;
        this.customCodec = builder.customCodecIsSet() ? builder.customCodec : super.customCodec();
    }

    private ImmutableInstanceField(TypeName type, String name, @Nullable TypeName codecForClass, boolean customCodec) {
        this.type = type;
        this.name = name;
        this.codecForClass = codecForClass;
        this.customCodec = customCodec;
    }

    @Override
    public TypeName type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    @Nullable
    public TypeName codecForClass() {
        return this.codecForClass;
    }

    @Override
    public boolean customCodec() {
        return this.customCodec;
    }

    public final ImmutableInstanceField withType(TypeName type) {
        if (this.type == type) {
            return this;
        }
        TypeName newValue = (TypeName)Preconditions.checkNotNull((Object)type, (Object)"type");
        return new ImmutableInstanceField(newValue, this.name, this.codecForClass, this.customCodec);
    }

    public final ImmutableInstanceField withName(String name) {
        if (this.name.equals(name)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        return new ImmutableInstanceField(this.type, newValue, this.codecForClass, this.customCodec);
    }

    public final ImmutableInstanceField withCodecForClass(@Nullable TypeName codecForClass) {
        if (this.codecForClass == codecForClass) {
            return this;
        }
        return new ImmutableInstanceField(this.type, this.name, codecForClass, this.customCodec);
    }

    public final ImmutableInstanceField withCustomCodec(boolean customCodec) {
        if (this.customCodec == customCodec) {
            return this;
        }
        return new ImmutableInstanceField(this.type, this.name, this.codecForClass, customCodec);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInstanceField && this.equalTo((ImmutableInstanceField)another);
    }

    private boolean equalTo(ImmutableInstanceField another) {
        return this.type.equals((Object)another.type) && this.name.equals(another.name) && Objects.equal((Object)this.codecForClass, (Object)another.codecForClass) && this.customCodec == another.customCodec;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.name.hashCode();
        h = h * 17 + Objects.hashCode((Object[])new Object[]{this.codecForClass});
        h = h * 17 + Booleans.hashCode((boolean)this.customCodec);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"InstanceField").omitNullValues().add("type", (Object)this.type).add("name", (Object)this.name).add("codecForClass", (Object)this.codecForClass).add("customCodec", this.customCodec).toString();
    }

    public static ImmutableInstanceField copyOf(InstanceField instance) {
        if (instance instanceof ImmutableInstanceField) {
            return (ImmutableInstanceField)instance;
        }
        return ImmutableInstanceField.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long OPT_BIT_CUSTOM_CODEC = 1L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private TypeName type;
        @Nullable
        private String name;
        @Nullable
        private TypeName codecForClass;
        private boolean customCodec;

        private Builder() {
        }

        public final Builder from(InstanceField instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.type(instance.type());
            this.name(instance.name());
            TypeName codecForClassValue = instance.codecForClass();
            if (codecForClassValue != null) {
                this.codecForClass(codecForClassValue);
            }
            this.customCodec(instance.customCodec());
            return this;
        }

        public final Builder type(TypeName type) {
            this.type = (TypeName)Preconditions.checkNotNull((Object)type, (Object)"type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder codecForClass(@Nullable TypeName codecForClass) {
            this.codecForClass = codecForClass;
            return this;
        }

        public final Builder customCodec(boolean customCodec) {
            this.customCodec = customCodec;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableInstanceField build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInstanceField(this);
        }

        private boolean customCodecIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build InstanceField, some of required attributes are not set " + attributes;
        }
    }
}

