/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.bsoncodec.codegen.delegate;

import ch.rasc.bsoncodec.Util;
import ch.rasc.bsoncodec.codegen.CodeGeneratorContext;
import ch.rasc.bsoncodec.codegen.delegate.CodeGeneratorDelegate;
import com.squareup.javapoet.MethodSpec;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.bson.BsonBinary;

public class ByteArrayDelegate
implements CodeGeneratorDelegate {
    @Override
    public void addEncodeStatements(TypeMirror type, CodeGeneratorContext ctx) {
        MethodSpec.Builder builder = ctx.builder();
        if (type.getKind() == TypeKind.BYTE) {
            builder.addStatement("writer.writeBinaryData(new $T($L))", new Object[]{BsonBinary.class, ctx.getter()});
        } else {
            builder.addStatement("$T[] bw = $L", new Object[]{Byte.class, ctx.getter()}).addStatement("byte[] b = new byte[bw.length]", new Object[0]).beginControlFlow("for (int i = 0; i < bw.length; i++)", new Object[0]).addStatement("b[i] = bw[i]", new Object[0]).endControlFlow().addStatement("writer.writeBinaryData(new $T(b))", new Object[]{BsonBinary.class});
        }
    }

    @Override
    public void addDecodeStatements(TypeMirror type, CodeGeneratorContext ctx) {
        MethodSpec.Builder builder = ctx.builder();
        if (type.getKind() == TypeKind.BYTE) {
            builder.addStatement(ctx.setter("reader.readBinaryData().getData()"), new Object[0]);
        } else {
            builder.addStatement("byte[] b = reader.readBinaryData().getData()", new Object[0]).addStatement("$T[] bw = new $T[b.length]", new Object[]{Byte.class, Byte.class}).beginControlFlow("for (int i = 0; i < b.length; i++)", new Object[0]).addStatement("bw[i] = $T.valueOf(b[i])", new Object[]{Byte.class}).endControlFlow().addStatement(ctx.setter("bw"), new Object[0]);
        }
    }

    @Override
    public boolean accepts(TypeMirror type) {
        return Util.isByte(type);
    }
}

