/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.bsoncodec.codegen;

import ch.rasc.bsoncodec.annotation.Id;
import ch.rasc.bsoncodec.codegen.CodeGen;
import ch.rasc.bsoncodec.codegen.CodeGeneratorContext;
import ch.rasc.bsoncodec.model.FieldModel;
import ch.rasc.bsoncodec.model.IdModel;
import ch.rasc.bsoncodec.model.ImmutableInstanceField;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.UUID;
import org.omg.IOP.Codec;

public class ConversionUUIDCodeGen
implements CodeGen {
    @Override
    public void addEncodeStatements(CodeGeneratorContext ctx) {
        FieldModel field = ctx.field();
        IdModel idModel = field.idModel();
        MethodSpec.Builder builder = ctx.builder();
        if (idModel.generatorName() != null) {
            builder.addStatement("$T id", new Object[]{UUID.class}).beginControlFlow("if ($L == null)", new Object[]{ctx.getter()}).addStatement("id = ($T)this.$N.generate()", new Object[]{UUID.class, field.idModel().generatorName()});
            if (idModel.conversion() == Id.IdConversion.HEX_UUID) {
                builder.addStatement(ctx.setter("id.toString()"), new Object[0]);
            } else if (idModel.conversion() == Id.IdConversion.BASE64_UUID) {
                builder.addStatement("$T bb = $T.wrap(new byte[16])", new Object[]{ByteBuffer.class, ByteBuffer.class});
                builder.addStatement("bb.putLong(id.getMostSignificantBits())", new Object[0]);
                builder.addStatement("bb.putLong(id.getLeastSignificantBits())", new Object[0]);
                builder.addStatement(ctx.setter("$T.getUrlEncoder().encodeToString(bb.array())"), new Object[]{Base64.class});
            }
            builder.nextControlFlow("else", new Object[0]);
            if (idModel.conversion() == Id.IdConversion.HEX_UUID) {
                builder.addStatement("id = $T.fromString($L)", new Object[]{UUID.class, ctx.getter()});
            } else if (idModel.conversion() == Id.IdConversion.BASE64_UUID) {
                builder.addStatement("$T bb = $T.wrap($T.getUrlDecoder().decode($L))", new Object[]{ByteBuffer.class, ByteBuffer.class, Base64.class, ctx.getter()});
                builder.addStatement("id = new $T(bb.getLong(), bb.getLong())", new Object[]{UUID.class});
            }
            builder.endControlFlow();
        } else if (idModel.conversion() == Id.IdConversion.HEX_UUID) {
            builder.addStatement("$T id = $T.fromString($L)", new Object[]{UUID.class, UUID.class, ctx.getter()});
        } else if (idModel.conversion() == Id.IdConversion.BASE64_UUID) {
            builder.addStatement("$T bb = $T.wrap($T.getUrlDecoder().decode($L))", new Object[]{ByteBuffer.class, ByteBuffer.class, Base64.class, ctx.getter()});
            builder.addStatement("$T id = new $T(bb.getLong(), bb.getLong())", new Object[]{UUID.class, UUID.class});
        }
        ctx.builder().addStatement("writer.writeName($S)", new Object[]{field.name()}).addStatement("this.uUIDCodec.encode(writer, id, encoderContext)", new Object[0]);
        ctx.instanceFields().add(ImmutableInstanceField.builder().type((TypeName)ClassName.get(Codec.class)).name("uUIDCodec").codecForClass((TypeName)ClassName.get(UUID.class)).build());
    }

    @Override
    public void addDecodeStatements(CodeGeneratorContext ctx) {
        MethodSpec.Builder builder = ctx.builder();
        IdModel idModel = ctx.field().idModel();
        builder.addStatement("$T id = this.uUIDCodec.decode(reader, decoderContext)", new Object[]{UUID.class});
        if (idModel.conversion() == Id.IdConversion.HEX_UUID) {
            builder.addStatement(ctx.setter("id.toString()"), new Object[0]);
        } else if (idModel.conversion() == Id.IdConversion.BASE64_UUID) {
            builder.addStatement("$T bb = $T.wrap(new byte[16])", new Object[]{ByteBuffer.class, ByteBuffer.class});
            builder.addStatement("bb.putLong(id.getMostSignificantBits())", new Object[0]);
            builder.addStatement("bb.putLong(id.getLeastSignificantBits())", new Object[0]);
            builder.addStatement(ctx.setter("$T.getUrlEncoder().encodeToString(bb.array())"), new Object[]{Base64.class});
        }
    }
}

