/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.bsoncodec.codegen;

import ch.rasc.bsoncodec.Util;
import ch.rasc.bsoncodec.codegen.CodeGeneratorContext;
import ch.rasc.bsoncodec.codegen.CompoundCodeGen;
import ch.rasc.bsoncodec.model.FieldModel;
import com.squareup.javapoet.MethodSpec;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.type.TypeMirror;
import org.bson.BsonType;

public class ArrayCodeGen
extends CompoundCodeGen {
    public ArrayCodeGen(CompoundCodeGen parent, TypeMirror type) {
        super(parent, type);
    }

    @Override
    public void addEncodeStatements(CodeGeneratorContext ctx) {
        FieldModel field = ctx.field();
        MethodSpec.Builder builder = ctx.builder();
        if (!field.disableEncodeNullCheck() && !this.hasParent()) {
            builder.beginControlFlow("if ($L != null)", new Object[]{ctx.getter()});
        }
        if (!field.storeEmptyCollection()) {
            builder.beginControlFlow("if ($L.length > 0)", new Object[]{ctx.getter()});
        }
        if (!this.hasParent()) {
            builder.addStatement("writer.writeName($S)", new Object[]{field.name()});
        }
        builder.addStatement("writer.writeStartArray()", new Object[0]).addStatement("$T $LArray = $L", new Object[]{this.getType(), Character.valueOf(ctx.getLoopVar()), ctx.getter()});
        TypeMirror childType = this.getChildCodeGen().getType();
        if (field.fixedArray() > 0 && field.fixedArray() < 16 && (field.disableEncodeNullCheck() || childType.getKind().isPrimitive())) {
            for (int n = 0; n < field.fixedArray(); ++n) {
                this.getChildCodeGen().addEncodeStatements(ctx.createEncodeChildContext(ctx.getLoopVar() + "Array[" + n + "]"));
            }
        } else {
            builder.beginControlFlow("for (int $L = 0; $L < $LArray.length; $L++)", new Object[]{Character.valueOf(ctx.getLoopVar()), Character.valueOf(ctx.getLoopVar()), Character.valueOf(ctx.getLoopVar()), Character.valueOf(ctx.getLoopVar())});
            if (!childType.getKind().isPrimitive() && !field.disableEncodeNullCheck()) {
                builder.beginControlFlow("if ($LArray[$L] != null)", new Object[]{Character.valueOf(ctx.getLoopVar()), Character.valueOf(ctx.getLoopVar())});
            }
            this.getChildCodeGen().addEncodeStatements(ctx.createEncodeChildContext(ctx.getLoopVar() + "Array[" + ctx.getLoopVar() + "]"));
            if (!childType.getKind().isPrimitive() && !field.disableEncodeNullCheck()) {
                builder.nextControlFlow("else", new Object[0]).addStatement("writer.writeNull()", new Object[0]);
                builder.endControlFlow();
            }
            builder.endControlFlow();
        }
        builder.addStatement("writer.writeEndArray()", new Object[0]);
        if (!field.storeEmptyCollection()) {
            builder.endControlFlow();
        }
        if (!field.disableEncodeNullCheck() && !this.hasParent()) {
            if (field.storeNullValue()) {
                builder.nextControlFlow("else", new Object[0]).addStatement("writer.writeNull($S)", new Object[]{field.name()});
            }
            builder.endControlFlow();
        }
    }

    @Override
    public void addDecodeStatements(CodeGeneratorContext ctx) {
        FieldModel field = ctx.field();
        MethodSpec.Builder builder = ctx.builder();
        char lv = ctx.getLoopVar();
        if (!field.disableDecodeNullCheck() && !this.hasParent()) {
            builder.beginControlFlow("if (bsonType != $T.NULL)", new Object[]{BsonType.class});
        }
        builder.addStatement("reader.readStartArray()", new Object[0]);
        TypeMirror childType = this.getChildCodeGen().getType();
        if (field.fixedArray() > 0 && field.fixedArray() < 16 && (field.disableEncodeNullCheck() || childType.getKind().isPrimitive())) {
            builder.addStatement("$T[] $LArray = new $T[$L]", new Object[]{childType, Character.valueOf(lv), childType, field.fixedArray()});
            for (int n = 0; n < field.fixedArray(); ++n) {
                this.getChildCodeGen().addDecodeStatements(ctx.createDecodeChildContext(lv + "Array[" + n + "] = %s"));
            }
            builder.addStatement("reader.readEndArray()", new Object[0]);
            builder.addStatement(ctx.setter("$LArray"), new Object[]{Character.valueOf(lv)});
        } else {
            if (!Util.isArray(childType)) {
                if (field.fixedArray() == 0) {
                    builder.addStatement("int $LCap = 16", new Object[]{Character.valueOf(lv)});
                    builder.addStatement("int $LIx = 0", new Object[]{Character.valueOf(lv)});
                    builder.addStatement("$T[] $LArray = new $T[$LCap]", new Object[]{childType, Character.valueOf(lv), childType, Character.valueOf(lv)});
                } else {
                    builder.addStatement("int $LIx = 0", new Object[]{Character.valueOf(lv)});
                    builder.addStatement("$T[] $LArray = new $T[$L]", new Object[]{childType, Character.valueOf(lv), childType, field.fixedArray()});
                }
            } else {
                builder.addStatement("$T<$T> $LList = new $T<>()", new Object[]{List.class, childType, Character.valueOf(lv), ArrayList.class});
            }
            builder.beginControlFlow("while ((bsonType = reader.readBsonType()) != $T.END_OF_DOCUMENT)", new Object[]{BsonType.class});
            if (!Util.isArray(childType) && field.fixedArray() == 0) {
                builder.beginControlFlow("if ($LIx == $LCap)", new Object[]{Character.valueOf(lv), Character.valueOf(lv)});
                builder.addStatement("$T[] newArray = new $T[$LCap*=2]", new Object[]{childType, childType, Character.valueOf(lv)});
                builder.addStatement("System.arraycopy($LArray, 0, newArray, 0, $LArray.length)", new Object[]{Character.valueOf(lv), Character.valueOf(lv)});
                builder.addStatement("$LArray = newArray", new Object[]{Character.valueOf(lv)});
                builder.endControlFlow();
            }
            if (!field.disableDecodeNullCheck()) {
                builder.beginControlFlow("if (bsonType != $T.NULL)", new Object[]{BsonType.class});
            }
            CodeGeneratorContext childCtx = !Util.isArray(childType) ? ctx.createDecodeChildContext(lv + "Array[" + lv + "Ix] = %s") : ctx.createDecodeChildContext(lv + "List.add(%s)");
            this.getChildCodeGen().addDecodeStatements(childCtx);
            if (!field.disableDecodeNullCheck()) {
                builder.nextControlFlow("else", new Object[0]).addStatement("reader.readNull()", new Object[0]);
                if (!Util.isArray(childType)) {
                    builder.addStatement("$LArray[$LIx] = null", new Object[]{Character.valueOf(lv), Character.valueOf(lv)});
                } else {
                    builder.addStatement(lv + "List.add(null)", new Object[0]);
                }
                builder.endControlFlow();
            }
            if (!Util.isArray(childType)) {
                builder.addStatement("$LIx++", new Object[]{Character.valueOf(lv)});
            }
            builder.endControlFlow();
            builder.addStatement("reader.readEndArray()", new Object[0]);
            if (!Util.isArray(childType)) {
                if (field.fixedArray() == 0) {
                    builder.addStatement("$T[] $LFinalArray = new $T[$LIx]", new Object[]{childType, Character.valueOf(lv), childType, Character.valueOf(lv)});
                    builder.addStatement("System.arraycopy($LArray, 0, $LFinalArray, 0, $LIx)", new Object[]{Character.valueOf(lv), Character.valueOf(lv), Character.valueOf(lv)});
                    builder.addStatement(ctx.setter("$LFinalArray"), new Object[]{Character.valueOf(lv)});
                } else {
                    builder.addStatement(ctx.setter("$LArray"), new Object[]{Character.valueOf(lv)});
                }
            } else {
                builder.addStatement(ctx.setter("$LList.toArray(new $T[]{})"), new Object[]{Character.valueOf(lv), childType});
            }
            if (!field.disableDecodeNullCheck() && !this.hasParent()) {
                builder.nextControlFlow("else", new Object[0]).addStatement("reader.readNull()", new Object[0]);
                if (!ctx.field().disableSetNullStatement()) {
                    this.getChildCodeGen().addSetNullStatements(ctx);
                }
                builder.endControlFlow();
            }
        }
    }
}

