/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.bsoncodec.model;

import ch.rasc.bsoncodec.codegen.CodeGen;
import ch.rasc.bsoncodec.model.FieldModel;
import ch.rasc.bsoncodec.model.IdModel;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.lang.model.element.VariableElement;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableFieldModel
extends FieldModel {
    private final VariableElement varEl;
    private final String name;
    private final int order;
    @Nullable
    private final String customCodecName;
    private final CodeGen codeGen;
    private final boolean storeNullValue;
    private final boolean storeEmptyCollection;
    private final boolean disableEncodeNullCheck;
    private final boolean disableDecodeNullCheck;
    private final boolean disableSetNullStatement;
    @Nullable
    private final IdModel idModel;
    private final String methodNameSet;
    private final String methodNameGet;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile InitShim initShim = new InitShim();

    private ImmutableFieldModel(Builder builder) {
        this.varEl = builder.varEl;
        this.order = builder.order;
        this.customCodecName = builder.customCodecName;
        this.codeGen = builder.codeGen;
        this.idModel = builder.idModel;
        this.methodNameSet = builder.methodNameSet;
        this.methodNameGet = builder.methodNameGet;
        if (builder.name != null) {
            this.initShim.name(builder.name);
        }
        if (builder.storeNullValueIsSet()) {
            this.initShim.storeNullValue(builder.storeNullValue);
        }
        if (builder.storeEmptyCollectionIsSet()) {
            this.initShim.storeEmptyCollection(builder.storeEmptyCollection);
        }
        if (builder.disableEncodeNullCheckIsSet()) {
            this.initShim.disableEncodeNullCheck(builder.disableEncodeNullCheck);
        }
        if (builder.disableDecodeNullCheckIsSet()) {
            this.initShim.disableDecodeNullCheck(builder.disableDecodeNullCheck);
        }
        if (builder.disableSetNullStatementIsSet()) {
            this.initShim.disableSetNullStatement(builder.disableSetNullStatement);
        }
        this.name = this.initShim.name();
        this.storeNullValue = this.initShim.storeNullValue();
        this.storeEmptyCollection = this.initShim.storeEmptyCollection();
        this.disableEncodeNullCheck = this.initShim.disableEncodeNullCheck();
        this.disableDecodeNullCheck = this.initShim.disableDecodeNullCheck();
        this.disableSetNullStatement = this.initShim.disableSetNullStatement();
        this.initShim = null;
    }

    private ImmutableFieldModel(VariableElement varEl, String name, int order, @Nullable String customCodecName, CodeGen codeGen, boolean storeNullValue, boolean storeEmptyCollection, boolean disableEncodeNullCheck, boolean disableDecodeNullCheck, boolean disableSetNullStatement, @Nullable IdModel idModel, String methodNameSet, String methodNameGet) {
        this.varEl = varEl;
        this.name = name;
        this.order = order;
        this.customCodecName = customCodecName;
        this.codeGen = codeGen;
        this.storeNullValue = storeNullValue;
        this.storeEmptyCollection = storeEmptyCollection;
        this.disableEncodeNullCheck = disableEncodeNullCheck;
        this.disableDecodeNullCheck = disableDecodeNullCheck;
        this.disableSetNullStatement = disableSetNullStatement;
        this.idModel = idModel;
        this.methodNameSet = methodNameSet;
        this.methodNameGet = methodNameGet;
        this.initShim.name(name);
        this.initShim.storeNullValue(storeNullValue);
        this.initShim.storeEmptyCollection(storeEmptyCollection);
        this.initShim.disableEncodeNullCheck(disableEncodeNullCheck);
        this.initShim.disableDecodeNullCheck(disableDecodeNullCheck);
        this.initShim.disableSetNullStatement(disableSetNullStatement);
        this.initShim = null;
    }

    @Override
    public VariableElement varEl() {
        return this.varEl;
    }

    @Override
    public String name() {
        return this.initShim != null ? this.initShim.name() : this.name;
    }

    @Override
    public int order() {
        return this.order;
    }

    @Override
    @Nullable
    public String customCodecName() {
        return this.customCodecName;
    }

    @Override
    public CodeGen codeGen() {
        return this.codeGen;
    }

    @Override
    public boolean storeNullValue() {
        return this.initShim != null ? this.initShim.storeNullValue() : this.storeNullValue;
    }

    @Override
    public boolean storeEmptyCollection() {
        return this.initShim != null ? this.initShim.storeEmptyCollection() : this.storeEmptyCollection;
    }

    @Override
    public boolean disableEncodeNullCheck() {
        return this.initShim != null ? this.initShim.disableEncodeNullCheck() : this.disableEncodeNullCheck;
    }

    @Override
    public boolean disableDecodeNullCheck() {
        return this.initShim != null ? this.initShim.disableDecodeNullCheck() : this.disableDecodeNullCheck;
    }

    @Override
    public boolean disableSetNullStatement() {
        return this.initShim != null ? this.initShim.disableSetNullStatement() : this.disableSetNullStatement;
    }

    @Override
    @Nullable
    public IdModel idModel() {
        return this.idModel;
    }

    @Override
    public String methodNameSet() {
        return this.methodNameSet;
    }

    @Override
    public String methodNameGet() {
        return this.methodNameGet;
    }

    public final ImmutableFieldModel withVarEl(VariableElement value) {
        if (this.varEl == value) {
            return this;
        }
        VariableElement newValue = (VariableElement)Preconditions.checkNotNull((Object)value, (Object)"varEl");
        return new ImmutableFieldModel(newValue, this.name, this.order, this.customCodecName, this.codeGen, this.storeNullValue, this.storeEmptyCollection, this.disableEncodeNullCheck, this.disableDecodeNullCheck, this.disableSetNullStatement, this.idModel, this.methodNameSet, this.methodNameGet);
    }

    public final ImmutableFieldModel withName(String value) {
        if (this.name == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"name");
        return new ImmutableFieldModel(this.varEl, newValue, this.order, this.customCodecName, this.codeGen, this.storeNullValue, this.storeEmptyCollection, this.disableEncodeNullCheck, this.disableDecodeNullCheck, this.disableSetNullStatement, this.idModel, this.methodNameSet, this.methodNameGet);
    }

    public final ImmutableFieldModel withOrder(int value) {
        if (this.order == value) {
            return this;
        }
        int newValue = value;
        return new ImmutableFieldModel(this.varEl, this.name, newValue, this.customCodecName, this.codeGen, this.storeNullValue, this.storeEmptyCollection, this.disableEncodeNullCheck, this.disableDecodeNullCheck, this.disableSetNullStatement, this.idModel, this.methodNameSet, this.methodNameGet);
    }

    public final ImmutableFieldModel withCustomCodecName(@Nullable String value) {
        if (this.customCodecName == value) {
            return this;
        }
        String newValue = value;
        return new ImmutableFieldModel(this.varEl, this.name, this.order, newValue, this.codeGen, this.storeNullValue, this.storeEmptyCollection, this.disableEncodeNullCheck, this.disableDecodeNullCheck, this.disableSetNullStatement, this.idModel, this.methodNameSet, this.methodNameGet);
    }

    public final ImmutableFieldModel withCodeGen(CodeGen value) {
        if (this.codeGen == value) {
            return this;
        }
        CodeGen newValue = (CodeGen)Preconditions.checkNotNull((Object)value, (Object)"codeGen");
        return new ImmutableFieldModel(this.varEl, this.name, this.order, this.customCodecName, newValue, this.storeNullValue, this.storeEmptyCollection, this.disableEncodeNullCheck, this.disableDecodeNullCheck, this.disableSetNullStatement, this.idModel, this.methodNameSet, this.methodNameGet);
    }

    public final ImmutableFieldModel withStoreNullValue(boolean value) {
        if (this.storeNullValue == value) {
            return this;
        }
        boolean newValue = value;
        return new ImmutableFieldModel(this.varEl, this.name, this.order, this.customCodecName, this.codeGen, newValue, this.storeEmptyCollection, this.disableEncodeNullCheck, this.disableDecodeNullCheck, this.disableSetNullStatement, this.idModel, this.methodNameSet, this.methodNameGet);
    }

    public final ImmutableFieldModel withStoreEmptyCollection(boolean value) {
        if (this.storeEmptyCollection == value) {
            return this;
        }
        boolean newValue = value;
        return new ImmutableFieldModel(this.varEl, this.name, this.order, this.customCodecName, this.codeGen, this.storeNullValue, newValue, this.disableEncodeNullCheck, this.disableDecodeNullCheck, this.disableSetNullStatement, this.idModel, this.methodNameSet, this.methodNameGet);
    }

    public final ImmutableFieldModel withDisableEncodeNullCheck(boolean value) {
        if (this.disableEncodeNullCheck == value) {
            return this;
        }
        boolean newValue = value;
        return new ImmutableFieldModel(this.varEl, this.name, this.order, this.customCodecName, this.codeGen, this.storeNullValue, this.storeEmptyCollection, newValue, this.disableDecodeNullCheck, this.disableSetNullStatement, this.idModel, this.methodNameSet, this.methodNameGet);
    }

    public final ImmutableFieldModel withDisableDecodeNullCheck(boolean value) {
        if (this.disableDecodeNullCheck == value) {
            return this;
        }
        boolean newValue = value;
        return new ImmutableFieldModel(this.varEl, this.name, this.order, this.customCodecName, this.codeGen, this.storeNullValue, this.storeEmptyCollection, this.disableEncodeNullCheck, newValue, this.disableSetNullStatement, this.idModel, this.methodNameSet, this.methodNameGet);
    }

    public final ImmutableFieldModel withDisableSetNullStatement(boolean value) {
        if (this.disableSetNullStatement == value) {
            return this;
        }
        boolean newValue = value;
        return new ImmutableFieldModel(this.varEl, this.name, this.order, this.customCodecName, this.codeGen, this.storeNullValue, this.storeEmptyCollection, this.disableEncodeNullCheck, this.disableDecodeNullCheck, newValue, this.idModel, this.methodNameSet, this.methodNameGet);
    }

    public final ImmutableFieldModel withIdModel(@Nullable IdModel value) {
        if (this.idModel == value) {
            return this;
        }
        IdModel newValue = value;
        return new ImmutableFieldModel(this.varEl, this.name, this.order, this.customCodecName, this.codeGen, this.storeNullValue, this.storeEmptyCollection, this.disableEncodeNullCheck, this.disableDecodeNullCheck, this.disableSetNullStatement, newValue, this.methodNameSet, this.methodNameGet);
    }

    public final ImmutableFieldModel withMethodNameSet(String value) {
        if (this.methodNameSet == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"methodNameSet");
        return new ImmutableFieldModel(this.varEl, this.name, this.order, this.customCodecName, this.codeGen, this.storeNullValue, this.storeEmptyCollection, this.disableEncodeNullCheck, this.disableDecodeNullCheck, this.disableSetNullStatement, this.idModel, newValue, this.methodNameGet);
    }

    public final ImmutableFieldModel withMethodNameGet(String value) {
        if (this.methodNameGet == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"methodNameGet");
        return new ImmutableFieldModel(this.varEl, this.name, this.order, this.customCodecName, this.codeGen, this.storeNullValue, this.storeEmptyCollection, this.disableEncodeNullCheck, this.disableDecodeNullCheck, this.disableSetNullStatement, this.idModel, this.methodNameSet, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFieldModel && this.equalTo((ImmutableFieldModel)another);
    }

    private boolean equalTo(ImmutableFieldModel another) {
        return this.varEl.equals(another.varEl) && this.name.equals(another.name) && this.order == another.order && Objects.equal((Object)this.customCodecName, (Object)another.customCodecName) && this.codeGen.equals(another.codeGen) && this.storeNullValue == another.storeNullValue && this.storeEmptyCollection == another.storeEmptyCollection && this.disableEncodeNullCheck == another.disableEncodeNullCheck && this.disableDecodeNullCheck == another.disableDecodeNullCheck && this.disableSetNullStatement == another.disableSetNullStatement && Objects.equal((Object)this.idModel, (Object)another.idModel) && this.methodNameSet.equals(another.methodNameSet) && this.methodNameGet.equals(another.methodNameGet);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.varEl.hashCode();
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.order;
        h = h * 17 + Objects.hashCode((Object[])new Object[]{this.customCodecName});
        h = h * 17 + this.codeGen.hashCode();
        h = h * 17 + Booleans.hashCode((boolean)this.storeNullValue);
        h = h * 17 + Booleans.hashCode((boolean)this.storeEmptyCollection);
        h = h * 17 + Booleans.hashCode((boolean)this.disableEncodeNullCheck);
        h = h * 17 + Booleans.hashCode((boolean)this.disableDecodeNullCheck);
        h = h * 17 + Booleans.hashCode((boolean)this.disableSetNullStatement);
        h = h * 17 + Objects.hashCode((Object[])new Object[]{this.idModel});
        h = h * 17 + this.methodNameSet.hashCode();
        h = h * 17 + this.methodNameGet.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FieldModel").add("varEl", (Object)this.varEl).add("name", (Object)this.name).add("order", this.order).add("customCodecName", (Object)this.customCodecName).add("codeGen", (Object)this.codeGen).add("storeNullValue", this.storeNullValue).add("storeEmptyCollection", this.storeEmptyCollection).add("disableEncodeNullCheck", this.disableEncodeNullCheck).add("disableDecodeNullCheck", this.disableDecodeNullCheck).add("disableSetNullStatement", this.disableSetNullStatement).add("idModel", (Object)this.idModel).add("methodNameSet", (Object)this.methodNameSet).add("methodNameGet", (Object)this.methodNameGet).toString();
    }

    public static ImmutableFieldModel copyOf(FieldModel instance) {
        if (instance instanceof ImmutableFieldModel) {
            return (ImmutableFieldModel)instance;
        }
        return ImmutableFieldModel.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VAR_EL = 1L;
        private static final long INIT_BIT_ORDER = 2L;
        private static final long INIT_BIT_CODE_GEN = 4L;
        private static final long INIT_BIT_METHOD_NAME_SET = 8L;
        private static final long INIT_BIT_METHOD_NAME_GET = 16L;
        private static final long OPT_BIT_STORE_NULL_VALUE = 1L;
        private static final long OPT_BIT_STORE_EMPTY_COLLECTION = 2L;
        private static final long OPT_BIT_DISABLE_ENCODE_NULL_CHECK = 4L;
        private static final long OPT_BIT_DISABLE_DECODE_NULL_CHECK = 8L;
        private static final long OPT_BIT_DISABLE_SET_NULL_STATEMENT = 16L;
        private long initBits = 31L;
        private long optBits;
        @Nullable
        private VariableElement varEl;
        @Nullable
        private String name;
        private int order;
        @Nullable
        private String customCodecName;
        @Nullable
        private CodeGen codeGen;
        private boolean storeNullValue;
        private boolean storeEmptyCollection;
        private boolean disableEncodeNullCheck;
        private boolean disableDecodeNullCheck;
        private boolean disableSetNullStatement;
        @Nullable
        private IdModel idModel;
        @Nullable
        private String methodNameSet;
        @Nullable
        private String methodNameGet;

        private Builder() {
        }

        public final Builder from(FieldModel instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.varEl(instance.varEl());
            this.name(instance.name());
            this.order(instance.order());
            String customCodecNameValue = instance.customCodecName();
            if (customCodecNameValue != null) {
                this.customCodecName(customCodecNameValue);
            }
            this.codeGen(instance.codeGen());
            this.storeNullValue(instance.storeNullValue());
            this.storeEmptyCollection(instance.storeEmptyCollection());
            this.disableEncodeNullCheck(instance.disableEncodeNullCheck());
            this.disableDecodeNullCheck(instance.disableDecodeNullCheck());
            this.disableSetNullStatement(instance.disableSetNullStatement());
            IdModel idModelValue = instance.idModel();
            if (idModelValue != null) {
                this.idModel(idModelValue);
            }
            this.methodNameSet(instance.methodNameSet());
            this.methodNameGet(instance.methodNameGet());
            return this;
        }

        public final Builder varEl(VariableElement varEl) {
            this.varEl = (VariableElement)Preconditions.checkNotNull((Object)varEl, (Object)"varEl");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            return this;
        }

        public final Builder order(int order) {
            this.order = order;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder customCodecName(@Nullable String customCodecName) {
            this.customCodecName = customCodecName;
            return this;
        }

        public final Builder codeGen(CodeGen codeGen) {
            this.codeGen = (CodeGen)Preconditions.checkNotNull((Object)codeGen, (Object)"codeGen");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder storeNullValue(boolean storeNullValue) {
            this.storeNullValue = storeNullValue;
            this.optBits |= 1L;
            return this;
        }

        public final Builder storeEmptyCollection(boolean storeEmptyCollection) {
            this.storeEmptyCollection = storeEmptyCollection;
            this.optBits |= 2L;
            return this;
        }

        public final Builder disableEncodeNullCheck(boolean disableEncodeNullCheck) {
            this.disableEncodeNullCheck = disableEncodeNullCheck;
            this.optBits |= 4L;
            return this;
        }

        public final Builder disableDecodeNullCheck(boolean disableDecodeNullCheck) {
            this.disableDecodeNullCheck = disableDecodeNullCheck;
            this.optBits |= 8L;
            return this;
        }

        public final Builder disableSetNullStatement(boolean disableSetNullStatement) {
            this.disableSetNullStatement = disableSetNullStatement;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder idModel(@Nullable IdModel idModel) {
            this.idModel = idModel;
            return this;
        }

        public final Builder methodNameSet(String methodNameSet) {
            this.methodNameSet = (String)Preconditions.checkNotNull((Object)methodNameSet, (Object)"methodNameSet");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder methodNameGet(String methodNameGet) {
            this.methodNameGet = (String)Preconditions.checkNotNull((Object)methodNameGet, (Object)"methodNameGet");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableFieldModel build() throws IllegalStateException {
            this.checkRequiredAttributes();
            return new ImmutableFieldModel(this);
        }

        private boolean storeNullValueIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean storeEmptyCollectionIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean disableEncodeNullCheckIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean disableDecodeNullCheckIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean disableSetNullStatementIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean varElIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean orderIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean codeGenIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean methodNameSetIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean methodNameGetIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private void checkRequiredAttributes() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if (!this.varElIsSet()) {
                attributes.add("varEl");
            }
            if (!this.orderIsSet()) {
                attributes.add("order");
            }
            if (!this.codeGenIsSet()) {
                attributes.add("codeGen");
            }
            if (!this.methodNameSetIsSet()) {
                attributes.add("methodNameSet");
            }
            if (!this.methodNameGetIsSet()) {
                attributes.add("methodNameGet");
            }
            return "Cannot build FieldModel, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private String name;
        private byte nameStage;
        private boolean storeNullValue;
        private byte storeNullValueStage;
        private boolean storeEmptyCollection;
        private byte storeEmptyCollectionStage;
        private boolean disableEncodeNullCheck;
        private byte disableEncodeNullCheckStage;
        private boolean disableDecodeNullCheck;
        private byte disableDecodeNullCheckStage;
        private boolean disableSetNullStatement;
        private byte disableSetNullStatementStage;

        private InitShim() {
        }

        String name() {
            if (this.nameStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nameStage == 0) {
                this.nameStage = (byte)-1;
                this.name = (String)Preconditions.checkNotNull((Object)ImmutableFieldModel.super.name(), (Object)"name");
                this.nameStage = 1;
            }
            return this.name;
        }

        String name(String value) {
            this.name = value;
            this.nameStage = 1;
            return value;
        }

        boolean storeNullValue() {
            if (this.storeNullValueStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.storeNullValueStage == 0) {
                this.storeNullValueStage = (byte)-1;
                this.storeNullValue = ImmutableFieldModel.super.storeNullValue();
                this.storeNullValueStage = 1;
            }
            return this.storeNullValue;
        }

        boolean storeNullValue(boolean value) {
            this.storeNullValue = value;
            this.storeNullValueStage = 1;
            return value;
        }

        boolean storeEmptyCollection() {
            if (this.storeEmptyCollectionStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.storeEmptyCollectionStage == 0) {
                this.storeEmptyCollectionStage = (byte)-1;
                this.storeEmptyCollection = ImmutableFieldModel.super.storeEmptyCollection();
                this.storeEmptyCollectionStage = 1;
            }
            return this.storeEmptyCollection;
        }

        boolean storeEmptyCollection(boolean value) {
            this.storeEmptyCollection = value;
            this.storeEmptyCollectionStage = 1;
            return value;
        }

        boolean disableEncodeNullCheck() {
            if (this.disableEncodeNullCheckStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.disableEncodeNullCheckStage == 0) {
                this.disableEncodeNullCheckStage = (byte)-1;
                this.disableEncodeNullCheck = ImmutableFieldModel.super.disableEncodeNullCheck();
                this.disableEncodeNullCheckStage = 1;
            }
            return this.disableEncodeNullCheck;
        }

        boolean disableEncodeNullCheck(boolean value) {
            this.disableEncodeNullCheck = value;
            this.disableEncodeNullCheckStage = 1;
            return value;
        }

        boolean disableDecodeNullCheck() {
            if (this.disableDecodeNullCheckStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.disableDecodeNullCheckStage == 0) {
                this.disableDecodeNullCheckStage = (byte)-1;
                this.disableDecodeNullCheck = ImmutableFieldModel.super.disableDecodeNullCheck();
                this.disableDecodeNullCheckStage = 1;
            }
            return this.disableDecodeNullCheck;
        }

        boolean disableDecodeNullCheck(boolean value) {
            this.disableDecodeNullCheck = value;
            this.disableDecodeNullCheckStage = 1;
            return value;
        }

        boolean disableSetNullStatement() {
            if (this.disableSetNullStatementStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.disableSetNullStatementStage == 0) {
                this.disableSetNullStatementStage = (byte)-1;
                this.disableSetNullStatement = ImmutableFieldModel.super.disableSetNullStatement();
                this.disableSetNullStatementStage = 1;
            }
            return this.disableSetNullStatement;
        }

        boolean disableSetNullStatement(boolean value) {
            this.disableSetNullStatement = value;
            this.disableSetNullStatementStage = 1;
            return value;
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = Lists.newArrayList();
            if (this.nameStage == -1) {
                attributes.add("name");
            }
            if (this.storeNullValueStage == -1) {
                attributes.add("storeNullValue");
            }
            if (this.storeEmptyCollectionStage == -1) {
                attributes.add("storeEmptyCollection");
            }
            if (this.disableEncodeNullCheckStage == -1) {
                attributes.add("disableEncodeNullCheck");
            }
            if (this.disableDecodeNullCheckStage == -1) {
                attributes.add("disableDecodeNullCheck");
            }
            if (this.disableSetNullStatementStage == -1) {
                attributes.add("disableSetNullStatement");
            }
            return "Cannot build FieldModel, attribute initializers form cycle" + attributes;
        }
    }
}

